var g_postfix = window.location.search;

// JavaScript Document
var MACRO_PIN_OPERATE_VALIDATE = 0;
var MACRO_PIN_OPERATE_DISABLE = 2;
var PUK_REQUIRED_PAGE = 'pukrequired.html';

var g_pinRequired_validatePinSuccess = false;

function main_beforeready() {
    if (g_postfix != null) {
        var length = g_postfix.length;
        var start = g_postfix.indexOf('?');
        g_postfix = g_postfix.substring(start + 1, length) + '.html';
    }else {
        g_postfix = '';
    }

}

main_beforeready();

function initPage() {
    button_enable('pinrequired_button_apply', '0');

    getAjaxData('api/pin/status', function($xml) {
        var pincode_validate_ret = xml2object($xml);
        if (pincode_validate_ret.type == 'response') {
            if (MACRO_PUK_REQUIRED == pincode_validate_ret.response.SimState) {
                gotoPageWithoutHistory(PUK_REQUIRED_PAGE + window.location.search);
            }else if (MACRO_PIN_READY == pincode_validate_ret.response.SimState) {
                gotoPageWithoutHistory(HOME_PAGE_URL + window.location.search);
            }else {
                $('#pinrequired_input_pin').val('');
                $('#pinrequired_input_pin').focus();
                $('#label_SimPINTimes').text(pincode_validate_ret.response.SimPinTimes);
            }
        }
    });
}

function validateInput() {
    $('#pinrequired_error').html('');
    var pincode = $('#pinrequired_input_pin').val();
    var patrn = /^[0-9]{4,8}$/;
    if ('' == pincode) {
        $('#pinrequired_error').html(dialup_hint_pin_code_valid_type).attr('class', 'error_message');
        $('#pinrequired_input_pin').focus();
        $('#pinrequired_input_pin').val('');
        button_enable('pinrequired_button_apply', '0');
        return false;
    }else if (!patrn.exec(pincode)) {
        //showErrorUnderTextbox("pinrequired_error", dialup_hint_pin_code_valid_type);
        $('#pinrequired_error').html(dialup_hint_pin_code_valid_type).attr('class', 'error_message');
        $('#pinrequired_input_pin').focus();
        $('#pinrequired_input_pin').val('');
        button_enable('pinrequired_button_apply', '0');
        return false;
    }else {
        return true;
    }
}

function pinreq_validate_savePin() {
    $('#pinrequired_error').html('');

    if (validateInput())
    {
        var simSavepinStatus = $('#pinrequired_checkbox_savepin').get(0).checked ? 1 : 0;
        var simSavepinPIN = $('#pinrequired_input_pin').val();
        var validate_req = {
            OperateType: '',
            CurrentPin: simSavepinPIN,
            NewPin: '',
            PukCode: ''
        };

        validate_req.OperateType = MACRO_PIN_OPERATE_VALIDATE;

        var savepin_code_req = {
            SimSavepinStatus: simSavepinStatus,
            SimSavepinPIN: simSavepinPIN
        };

        var validate_xml = object2xml('request', validate_req);
        button_enable('pinrequired_button_apply', '0');
        showWaitingDialog(common_waiting, sd_hint_wait_a_few_moments, function() {
            setTimeout(function() {
                if (g_pinRequired_validatePinSuccess)
                {
                    if (!redirectOnCondition())
                    {
                        setTimeout(function() {
                        if (('.html' == g_postfix) || ('' == g_postfix)) {
                            gotoPageWithoutHistory(HOME_PAGE_URL);
                        }else {
                            gotoPageWithoutHistory(g_postfix);
                        }
                        return false;
                    }, 1500);//gotoPageWithoutHistory("home.html");
                    }
                }
                else
                {
                    initPage();
                }
            }, g_feature.dialogdisapear);
        });
        saveAjaxData('api/pin/operate', validate_xml, function($xml) {
            var validate_ret = xml2object($xml);
            if (isAjaxReturnOK(validate_ret))
            {
                g_pinRequired_validatePinSuccess = true;
                log.debug('PINREQUIRED : pin validate success');
                if (validate_req.OperateType == MACRO_PIN_OPERATE_VALIDATE && simSavepinStatus == 1)
                {
                    var savepin_xml = object2xml('request', savepin_code_req);
                    saveAjaxData('api/pin/save-pin', savepin_xml, function($xml) {
                        log.debug('PINREQUIRED : save pin success');
                       });
                }
            }
            else
            {
                closeWaitingDialog();
                showInfoDialog(common_failed);
                setTimeout(function() {
                    initPage();
                }, 500);
            }
        });
    }
}

function pinreq_disablePin(disable_object) {
    var pinreq_disable_xml = object2xml('request', disable_object);
    saveAjaxData('api/pin/operate', pinreq_disable_xml, function($xml) {
        var disable_ret = xml2object($xml);
        if (isAjaxReturnOK(disable_ret)) {
            if (!redirectOnCondition()) {
                showInfoDialog(common_success);
                setTimeout(function() {
                    if (('.html' == g_postfix) || ('' == g_postfix)) {
                        gotoPageWithoutHistory(HOME_PAGE_URL);
                    }else {
                        gotoPageWithoutHistory(g_postfix);
                    }
                    return false;
                }, 1500);
            }
        }else {
            showInfoDialog(common_failed);
            setTimeout(function() {
                initPage();
                return false;
            }, 1500);
        }
    });
}

function pinreq_validatePin(validate_object, savepinStatus) {
    var validate_xml = object2xml('request', validate_object);
    saveAjaxData('api/pin/operate', validate_xml, function($xml) {
        var validate_ret = xml2object($xml);
        if (isAjaxReturnOK(validate_ret)) {
            if (savepinStatus == 1) {
                validate_object.OperateType = MACRO_PIN_OPERATE_DISABLE;
                pinreq_disablePin(validate_object);
            }else {
                if (!redirectOnCondition()) {
                    showInfoDialog(common_success);
                    setTimeout(function() {
                        if (('.html' == g_postfix) || ('' == g_postfix)) {
                            gotoPageWithoutHistory(HOME_PAGE_URL);
                        }else {
                            gotoPageWithoutHistory(g_postfix);
                        }
                        return false;
                    }, 1500);
                }
            }
        }else {
            showInfoDialog(pin_code_validate_failed);
            setTimeout(function() {
                initPage();
                return false;
            }, 1500);
        }
    });
}

function onApply() {
    $.each($('input'), function() {
        $(this).blur();
    });
    if (validateInput()) {
        var simSavepinStatus = $('#pinrequired_checkbox_savepin').get(0).checked ? 1 : 0;
        var simSavepinPIN = $('#pinrequired_input_pin').val();
        var validate_req = {
            OperateType: 0,
            CurrentPin: simSavepinPIN,
            NewPin: '',
            PukCode: ''
        };
        if (0 == g_feature.continue_button) {
            pinreq_validatePin(validate_req, simSavepinStatus);
        }else if (1 == g_feature.continue_button) {
            pinreq_validate_savePin();
        }
    }
}

//check pin code has been validated or not
function checkPinCodeValidated() {
    button_enable('pinrequired_button_apply', '0');

    getAjaxData('api/pin/status', function($xml) {
        var pincode_validate_ret = xml2object($xml);
        if (pincode_validate_ret.type == 'response') {
            if (MACRO_PUK_REQUIRED == pincode_validate_ret.response.SimState) {
                gotoPageWithoutHistory(PUK_REQUIRED_PAGE + window.location.search);
            }else if (MACRO_PIN_READY == pincode_validate_ret.response.SimState) {
                showInfoDialog(pin_has_been_validated);
                setTimeout(function() {
                    if (('.html' == g_postfix) || ('' == g_postfix)) {
                        gotoPageWithoutHistory(HOME_PAGE_URL);
                    }else {
                        gotoPageWithoutHistory(g_postfix);
                    }
                    return false;
                }, 1500);
            }else {
                onApply();
            }
        }else {
            showInfoDialog(pin_code_validate_failed);
            setTimeout(function() {
                initPage();
                return false;
            }, 1500);
        }
    });
}

$(document).ready(function() {

    $('#save_setting').html(dialup_hilink_label_save_pin_code + common_colon);
    $('#pinrequired_input_pin').focus();

    $('#pinrequired_input_pin').bind('keyup change input paste cut keydown', function() {
        if (($(this).val()).length >= 4) {
            button_enable('pinrequired_button_apply', '1');
        }else {
            button_enable('pinrequired_button_apply', '0');
        }
    });
    $('#pinrequired_button_apply').bind('click', function() {
        if (!isButtonEnable('pinrequired_button_apply')) {
            return;
        }
        checkPinCodeValidated();
    });
    if (1 == g_feature.continue_button) {
        $('#link_login').show();
    }
    else
    {
        $('#link_login').hide();
    }

    initPage();
    setLangList();
    showCurrentLanguage();
    $('#link_login').click(function() {
        window.location = HOME_PAGE_URL;
    });
});
