/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.freedesktop.dbus.viewer.DBusEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBusTableModel
extends AbstractTableModel {
    private static final String INTROSPECTABLE = "introspectable?";
    private static final String OWNER = "owner";
    private static final String USER = "user";
    private static final String NAME = "name";
    private static final String PATH = "path";
    final String[] columns = new String[]{"name", "path", "user", "owner", "introspectable?"};
    private List<DBusEntry> entries = new ArrayList<DBusEntry>();

    DBusTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    public void add(DBusEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    public DBusEntry getEntry(int row) {
        return this.entries.get(row);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        String columnName = this.getColumnName(columnIndex);
        if (columnName.equals(NAME)) {
            return String.class;
        }
        if (columnName.equals(PATH)) {
            return String.class;
        }
        if (columnName.equals(USER)) {
            return Object.class;
        }
        if (columnName.equals(OWNER)) {
            return String.class;
        }
        if (columnName.equals(INTROSPECTABLE)) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DBusEntry entry = this.getEntry(rowIndex);
        String columnName = this.getColumnName(columnIndex);
        if (columnName.equals(NAME)) {
            return entry.getName();
        }
        if (columnName.equals(PATH)) {
            return entry.getPath();
        }
        if (columnName.equals(USER)) {
            return entry.getUser();
        }
        if (columnName.equals(OWNER)) {
            return entry.getOwner();
        }
        if (columnName.equals(INTROSPECTABLE)) {
            if (entry.getIntrospectable() != null) {
                return true;
            }
            return false;
        }
        return null;
    }
}

