/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.test.ProfileHandler;
import org.freedesktop.dbus.test.ProfileStruct;
import org.freedesktop.dbus.test.Profiler;
import org.freedesktop.dbus.test.ProfilerInstance;

public class profile {
    public static final int SIGNAL_INNER = 100;
    public static final int SIGNAL_OUTER = 100;
    public static final int PING_INNER = 100;
    public static final int PING_OUTER = 100;
    public static final int BYTES = 2000000;
    public static final int INTROSPECTION_OUTER = 100;
    public static final int INTROSPECTION_INNER = 10;
    public static final int STRUCT_OUTER = 100;
    public static final int STRUCT_INNER = 10;
    public static final int LIST_OUTER = 100;
    public static final int LIST_INNER = 10;
    public static final int LIST_LENGTH = 100;
    public static final int MAP_OUTER = 100;
    public static final int MAP_INNER = 10;
    public static final int MAP_LENGTH = 100;
    public static final int ARRAY_OUTER = 100;
    public static final int ARRAY_INNER = 10;
    public static final int ARRAY_LENGTH = 1000;
    public static final int STRING_ARRAY_OUTER = 10;
    public static final int STRING_ARRAY_INNER = 1;
    public static final int STRING_ARRAY_LENGTH = 20000;

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                System.out.println("You must specify a profile type.");
                System.out.println("Syntax: profile <pings|arrays|introspect|maps|bytes|lists|structs|signals|rate|strings>");
                System.exit(1);
            }
            DBusConnection conn = DBusConnection.getConnection(1);
            conn.requestBusName("org.freedesktop.DBus.java.profiler");
            if ("pings".equals(args[0])) {
                int count = 10000;
                System.out.print("Sending " + count + " pings...");
                DBus.Peer p = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", DBus.Peer.class);
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                int i = 0;
                while (i < 100) {
                    int j = 0;
                    while (j < 100) {
                        l.start();
                        p.Ping();
                        l.stop();
                        ++j;
                    }
                    System.out.print(".");
                    ++i;
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("strings".equals(args[0])) {
                int count = 10;
                System.out.print("Sending array of 20000 strings " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", pi);
                Profiler p = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                String[] v = new String[20000];
                Random r = new Random();
                int i = 0;
                while (i < 20000) {
                    v[i] = "" + r.nextInt();
                    ++i;
                }
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                int i2 = 0;
                while (i2 < 10) {
                    int j = 0;
                    while (j < 1) {
                        l.start();
                        p.stringarray(v);
                        l.stop();
                        ++j;
                    }
                    System.out.print(".");
                    ++i2;
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("arrays".equals(args[0])) {
                int count = 1000;
                System.out.print("Sending array of 1000 ints " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", pi);
                Profiler p = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                int[] v = new int[1000];
                Random r = new Random();
                int i = 0;
                while (i < 1000) {
                    v[i] = r.nextInt();
                    ++i;
                }
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                int i3 = 0;
                while (i3 < 100) {
                    int j = 0;
                    while (j < 10) {
                        l.start();
                        p.array(v);
                        l.stop();
                        ++j;
                    }
                    System.out.print(".");
                    ++i3;
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("maps".equals(args[0])) {
                int count = 1000;
                System.out.print("Sending map of 100 string=>strings " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", pi);
                Profiler p = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                HashMap<String, String> m = new HashMap<String, String>();
                int i = 0;
                while (i < 100) {
                    m.put("" + i, "hello");
                    ++i;
                }
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                int i4 = 0;
                while (i4 < 100) {
                    int j = 0;
                    while (j < 10) {
                        l.start();
                        p.map(m);
                        l.stop();
                        ++j;
                    }
                    System.out.print(".");
                    ++i4;
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("lists".equals(args[0])) {
                int count = 1000;
                System.out.print("Sending list of 100 strings " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", pi);
                Profiler p = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                Vector<String> v = new Vector<String>();
                int i = 0;
                while (i < 100) {
                    v.add("hello " + i);
                    ++i;
                }
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                int i5 = 0;
                while (i5 < 100) {
                    int j = 0;
                    while (j < 10) {
                        l.start();
                        p.list(v);
                        l.stop();
                        ++j;
                    }
                    System.out.print(".");
                    ++i5;
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("structs".equals(args[0])) {
                int count = 1000;
                System.out.print("Sending a struct " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", pi);
                Profiler p = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                ProfileStruct ps = new ProfileStruct("hello", new UInt32(18L), 500L);
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                int i = 0;
                while (i < 100) {
                    int j = 0;
                    while (j < 10) {
                        l.start();
                        p.struct(ps);
                        l.stop();
                        ++j;
                    }
                    System.out.print(".");
                    ++i;
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
            } else if ("introspect".equals(args[0])) {
                int count = 1000;
                System.out.print("Recieving introspection data " + count + " times.");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", pi);
                DBus.Introspectable is = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", DBus.Introspectable.class);
                Log l = new Log(count);
                long t = System.currentTimeMillis();
                String s = null;
                int i = 0;
                while (i < 100) {
                    int j = 0;
                    while (j < 10) {
                        l.start();
                        s = is.Introspect();
                        l.stop();
                        ++j;
                    }
                    System.out.print(".");
                    ++i;
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
                System.out.println("Introspect data: " + s);
            } else if ("bytes".equals(args[0])) {
                System.out.print("Sending 2000000 bytes");
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", pi);
                Profiler p = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                byte[] bs = new byte[2000000];
                int i = 0;
                while (i < 2000000) {
                    bs[i] = (byte)i;
                    ++i;
                }
                long t = System.currentTimeMillis();
                p.bytes(bs);
                System.out.println(" done in " + (System.currentTimeMillis() - t) + "ms.");
            } else if ("rate".equals(args[0])) {
                ProfilerInstance pi = new ProfilerInstance();
                conn.exportObject("/Profiler", pi);
                Profiler p = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", Profiler.class);
                DBus.Peer peer = conn.getRemoteObject("org.freedesktop.DBus.java.profiler", "/Profiler", DBus.Peer.class);
                long start = System.currentTimeMillis();
                int count = 0;
                do {
                    peer.Ping();
                } while (++count < 10000);
                long end = System.currentTimeMillis();
                System.out.println("No payload: " + (long)(count * 1000) / (end - start) + " RT/second");
                int len = 256;
                while (len <= 32768) {
                    byte[] bs = new byte[len];
                    count = 0;
                    start = System.currentTimeMillis();
                    do {
                        p.bytes(bs);
                    } while (++count < 1000);
                    end = System.currentTimeMillis();
                    long ms = end - start;
                    double cps = (long)(count * 1000) / ms;
                    double rate = (double)len * cps / 1048576.0;
                    System.out.println(String.valueOf(len) + " byte array) " + count * len + " bytes in " + ms + "ms (in " + count + " calls / " + (int)cps + " CPS): " + rate + "MB/s");
                    len <<= 1;
                }
                len = 256;
                while (len <= 32768) {
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < len) {
                        sb.append('a');
                        ++i;
                    }
                    String s = sb.toString();
                    end = System.currentTimeMillis() + 500L;
                    count = 0;
                    do {
                        p.string(s);
                    } while (++count < 1000);
                    long ms = end - start;
                    double cps = (long)(count * 1000) / ms;
                    double rate = (double)len * cps / 1048576.0;
                    System.out.println(String.valueOf(len) + " string) " + count * len + " bytes in " + ms + "ms (in " + count + " calls / " + (int)cps + " CPS): " + rate + "MB/s");
                    len <<= 1;
                }
            } else if ("signals".equals(args[0])) {
                int count = 10000;
                System.out.print("Sending " + count + " signals");
                ProfileHandler ph = new ProfileHandler();
                conn.addSigHandler(Profiler.ProfileSignal.class, ph);
                Log l = new Log(count);
                Profiler.ProfileSignal ps = new Profiler.ProfileSignal("/");
                long t = System.currentTimeMillis();
                int i = 0;
                while (i < 100) {
                    int j = 0;
                    while (j < 100) {
                        l.start();
                        conn.sendSignal(ps);
                        l.stop();
                        ++j;
                    }
                    System.out.print(".");
                    ++i;
                }
                t = System.currentTimeMillis() - t;
                System.out.println(" done.");
                System.out.println("min/max/avg (ms): " + l.min() + "/" + l.max() + "/" + l.mean());
                System.out.println("deviation: " + l.stddev());
                System.out.println("Total time: " + t + "ms");
                while (ph.c < count) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } else {
                conn.disconnect();
                System.out.println("Invalid profile ``" + args[0] + "''.");
                System.out.println("Syntax: profile <pings|arrays|introspect|maps|bytes|lists|structs|signals>");
                System.exit(1);
            }
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static class Log {
        private long last;
        private int[] deltas;
        private int current = 0;

        public Log(int size) {
            this.deltas = new int[size];
        }

        public void start() {
            this.last = System.currentTimeMillis();
        }

        public void stop() {
            this.deltas[this.current] = (int)(System.currentTimeMillis() - this.last);
            ++this.current;
        }

        public double mean() {
            if (this.current == 0) {
                return 0.0;
            }
            long sum = 0L;
            int i = 0;
            while (i < this.current) {
                sum += (long)this.deltas[i];
                ++i;
            }
            return sum /= (long)this.current;
        }

        public long min() {
            int m = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.current) {
                if (this.deltas[i] < m) {
                    m = this.deltas[i];
                }
                ++i;
            }
            return m;
        }

        public long max() {
            int m = 0;
            int i = 0;
            while (i < this.current) {
                if (this.deltas[i] > m) {
                    m = this.deltas[i];
                }
                ++i;
            }
            return m;
        }

        public double stddev() {
            double mean = this.mean();
            double sum = 0.0;
            int i = 0;
            while (i < this.current) {
                sum += ((double)this.deltas[i] - mean) * ((double)this.deltas[i] - mean);
                ++i;
            }
            return Math.sqrt(sum / (double)(this.current - 1));
        }
    }
}

