/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.unix.USOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freedesktop.dbus.Message;

public class MessageWriter {
    private OutputStream out;
    private boolean isunix;

    public MessageWriter(OutputStream out) {
        this.out = out;
        this.isunix = false;
        try {
            if (out instanceof USOutputStream) {
                this.isunix = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void writeMessage(Message m) throws IOException {
        if (m == null) {
            return;
        }
        if (m.getWireData() == null) {
            return;
        }
        if (this.isunix) {
            ((USOutputStream)this.out).write(m.getWireData());
        } else {
            byte[][] byArray = m.getWireData();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] buf = byArray[n2];
                if (buf == null) break;
                this.out.write(buf);
                ++n2;
            }
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

