/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSerializable;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.Position;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.DBusStructType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marshalling {
    private static Map<Type, String[]> typeCache = new HashMap<Type, String[]>();
    private static StringBuffer[] out = new StringBuffer[10];

    public static String getDBusType(Type[] c) throws DBusException {
        StringBuffer sb = new StringBuffer();
        Type[] typeArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            String[] stringArray = Marshalling.getDBusType(t);
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String s = stringArray[n4];
                sb.append(s);
                ++n4;
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String[] getDBusType(Type c) throws DBusException {
        String[] cached = typeCache.get(c);
        if (cached != null) {
            return cached;
        }
        cached = Marshalling.getDBusType(c, false);
        typeCache.put(c, cached);
        return cached;
    }

    public static String[] getDBusType(Type c, boolean basic) throws DBusException {
        return Marshalling.recursiveGetDBusType(c, basic, 0);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static String[] recursiveGetDBusType(Type c, boolean basic, int level) throws DBusException {
        block96: {
            block97: {
                block95: {
                    if (Marshalling.out.length <= level) {
                        newout = new StringBuffer[Marshalling.out.length];
                        System.arraycopy(Marshalling.out, 0, newout, 0, Marshalling.out.length);
                        Marshalling.out = newout;
                    }
                    if (Marshalling.out[level] == null) {
                        Marshalling.out[level] = new StringBuffer();
                    } else {
                        Marshalling.out[level].delete(0, Marshalling.out[level].length());
                    }
                    if (basic && !(c instanceof Class)) {
                        throw new DBusException(c + Gettext._(" is not a basic type"));
                    }
                    if (!(c instanceof TypeVariable)) break block95;
                    Marshalling.out[level].append('v');
                    break block96;
                }
                if (!(c instanceof GenericArrayType)) break block97;
                Marshalling.out[level].append('a');
                s = Marshalling.recursiveGetDBusType(((GenericArrayType)c).getGenericComponentType(), false, level + 1);
                if (s.length != 1) {
                    throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                }
                Marshalling.out[level].append(s[0]);
                break block96;
            }
            if (c instanceof Class && DBusSerializable.class.isAssignableFrom((Class)c) || c instanceof ParameterizedType && DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)c).getRawType())) {
                newtypes = null;
                if (c instanceof Class) {
                    var7_4 = ((Class)c).getDeclaredMethods();
                    var6_9 = var7_4.length;
                    var5_14 = 0;
                    while (var5_14 < var6_9) {
                        m = var7_4[var5_14];
                        if (m.getName().equals("deserialize")) {
                            newtypes = m.getGenericParameterTypes();
                        }
                        ++var5_14;
                    }
                } else {
                    var7_4 = ((Class)((ParameterizedType)c).getRawType()).getDeclaredMethods();
                    var6_9 = var7_4.length;
                    var5_14 = 0;
                    while (var5_14 < var6_9) {
                        m = var7_4[var5_14];
                        if (m.getName().equals("deserialize")) {
                            newtypes = m.getGenericParameterTypes();
                        }
                        ++var5_14;
                    }
                }
                if (newtypes == null) {
                    throw new DBusException(Gettext._("Serializable classes must implement a deserialize method"));
                }
                sigs = new String[newtypes.length];
                j = 0;
                while (j < sigs.length) {
                    ss = Marshalling.recursiveGetDBusType(newtypes[j], false, level + 1);
                    if (1 != ss.length) {
                        throw new DBusException(Gettext._("Serializable classes must serialize to native DBus types"));
                    }
                    sigs[j] = ss[0];
                    ++j;
                }
                return sigs;
            }
            if (!(c instanceof ParameterizedType)) ** GOTO lbl134
            p = (ParameterizedType)c;
            if (p.getRawType().equals(Map.class)) {
                Marshalling.out[level].append("a{");
                t = p.getActualTypeArguments();
                try {
                    s = Marshalling.recursiveGetDBusType(t[0], true, level + 1);
                    if (s.length != 1) {
                        throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                    }
                    Marshalling.out[level].append(s[0]);
                    s = Marshalling.recursiveGetDBusType(t[1], false, level + 1);
                    if (s.length != 1) {
                        throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                    }
                    Marshalling.out[level].append(s[0]);
                }
                catch (ArrayIndexOutOfBoundsException AIOOBe) {
                    throw new DBusException(Gettext._("Map must have 2 parameters"));
                }
                Marshalling.out[level].append('}');
            } else if (List.class.isAssignableFrom((Class)p.getRawType())) {
                var7_5 = p.getActualTypeArguments();
                ss = var7_5.length;
                AIOOBe = 0;
                while (AIOOBe < ss) {
                    t = var7_5[AIOOBe];
                    if (Type.class.equals((Object)t)) {
                        Marshalling.out[level].append('g');
                    } else {
                        s = Marshalling.recursiveGetDBusType(t, false, level + 1);
                        if (s.length != 1) {
                            throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                        }
                        Marshalling.out[level].append('a');
                        Marshalling.out[level].append(s[0]);
                    }
                    ++AIOOBe;
                }
            } else if (p.getRawType().equals(Variant.class)) {
                Marshalling.out[level].append('v');
            } else if (DBusInterface.class.isAssignableFrom((Class)p.getRawType())) {
                Marshalling.out[level].append('o');
            } else {
                if (Tuple.class.isAssignableFrom((Class)p.getRawType())) {
                    ts = p.getActualTypeArguments();
                    vs = new Vector<String>();
                    var9_29 = ts;
                    s = ts.length;
                    var7_6 = 0;
                    while (var7_6 < s) {
                        t = var9_29[var7_6];
                        var13_37 = Marshalling.recursiveGetDBusType(t, false, level + 1);
                        var12_36 = var13_37.length;
                        var11_34 = 0;
                        while (var11_34 < var12_36) {
                            s = var13_37[var11_34];
                            vs.add(s);
                            ++var11_34;
                        }
                        ++var7_6;
                    }
                    return vs.toArray(new String[0]);
                }
                throw new DBusException(String.valueOf(Gettext._("Exporting non-exportable parameterized type ")) + c);
lbl134:
                // 1 sources

                if (c.equals(Byte.class)) {
                    Marshalling.out[level].append('y');
                } else if (c.equals(Byte.TYPE)) {
                    Marshalling.out[level].append('y');
                } else if (c.equals(Boolean.class)) {
                    Marshalling.out[level].append('b');
                } else if (c.equals(Boolean.TYPE)) {
                    Marshalling.out[level].append('b');
                } else if (c.equals(Short.class)) {
                    Marshalling.out[level].append('n');
                } else if (c.equals(Short.TYPE)) {
                    Marshalling.out[level].append('n');
                } else if (c.equals(UInt16.class)) {
                    Marshalling.out[level].append('q');
                } else if (c.equals(Integer.class)) {
                    Marshalling.out[level].append('i');
                } else if (c.equals(Integer.TYPE)) {
                    Marshalling.out[level].append('i');
                } else if (c.equals(UInt32.class)) {
                    Marshalling.out[level].append('u');
                } else if (c.equals(Long.class)) {
                    Marshalling.out[level].append('x');
                } else if (c.equals(Long.TYPE)) {
                    Marshalling.out[level].append('x');
                } else if (c.equals(UInt64.class)) {
                    Marshalling.out[level].append('t');
                } else if (c.equals(Double.class)) {
                    Marshalling.out[level].append('d');
                } else if (c.equals(Double.TYPE)) {
                    Marshalling.out[level].append('d');
                } else if (c.equals(Float.class) && AbstractConnection.FLOAT_SUPPORT) {
                    Marshalling.out[level].append('f');
                } else if (c.equals(Float.class)) {
                    Marshalling.out[level].append('d');
                } else if (c.equals(Float.TYPE) && AbstractConnection.FLOAT_SUPPORT) {
                    Marshalling.out[level].append('f');
                } else if (c.equals(Float.TYPE)) {
                    Marshalling.out[level].append('d');
                } else if (c.equals(String.class)) {
                    Marshalling.out[level].append('s');
                } else if (c.equals(Variant.class)) {
                    Marshalling.out[level].append('v');
                } else if (c instanceof Class && DBusInterface.class.isAssignableFrom((Class)c)) {
                    Marshalling.out[level].append('o');
                } else if (c instanceof Class && Path.class.equals((Object)((Class)c))) {
                    Marshalling.out[level].append('o');
                } else if (c instanceof Class && ObjectPath.class.equals((Object)((Class)c))) {
                    Marshalling.out[level].append('o');
                } else if (c instanceof Class && ((Class)c).isArray()) {
                    if (Type.class.equals(((Class)c).getComponentType())) {
                        Marshalling.out[level].append('g');
                    } else {
                        Marshalling.out[level].append('a');
                        s = Marshalling.recursiveGetDBusType(((Class)c).getComponentType(), false, level + 1);
                        if (s.length != 1) {
                            throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                        }
                        Marshalling.out[level].append(s[0]);
                    }
                } else if (c instanceof Class && Struct.class.isAssignableFrom((Class)c)) {
                    Marshalling.out[level].append('(');
                    ts = Container.getTypeCache(c);
                    if (ts == null) {
                        fs = ((Class)c).getDeclaredFields();
                        ts = new Type[fs.length];
                        s /* !! */  = fs;
                        var7_7 = fs.length;
                        var6_13 = 0;
                        while (var6_13 < var7_7) {
                            f = s /* !! */ [var6_13];
                            p = f.getAnnotation(Position.class);
                            if (p != null) {
                                ts[p.value()] = f.getGenericType();
                            }
                            ++var6_13;
                        }
                        Container.putTypeCache(c, ts);
                    }
                    var7_8 = ts;
                    var6_13 = ts.length;
                    var5_20 = 0;
                    while (var5_20 < var6_13) {
                        t = var7_8[var5_20];
                        if (t != null) {
                            var11_35 = Marshalling.recursiveGetDBusType(t, false, level + 1);
                            var10_33 = var11_35.length;
                            var9_31 = 0;
                            while (var9_31 < var10_33) {
                                s /* !! */  = var11_35[var9_31];
                                Marshalling.out[level].append((String)s /* !! */ );
                                ++var9_31;
                            }
                        }
                        ++var5_20;
                    }
                    Marshalling.out[level].append(')');
                } else {
                    throw new DBusException(String.valueOf(Gettext._("Exporting non-exportable type ")) + c);
                }
            }
        }
        return new String[]{Marshalling.out[level].toString()};
    }

    public static int getJavaType(String dbus, List<Type> rv, int limit) throws DBusException {
        if (dbus == null || "".equals(dbus) || limit == 0) {
            return 0;
        }
        try {
            int i = 0;
            while (i < dbus.length() && (-1 == limit || limit > rv.size())) {
                switch (dbus.charAt(i)) {
                    case '(': {
                        int j = i + 1;
                        int c = 1;
                        while (c > 0) {
                            if (')' == dbus.charAt(j)) {
                                --c;
                            } else if ('(' == dbus.charAt(j)) {
                                ++c;
                            }
                            ++j;
                        }
                        Vector<Type> contained = new Vector();
                        int c2 = Marshalling.getJavaType(dbus.substring(i + 1, j - 1), contained, -1);
                        rv.add(new DBusStructType(contained.toArray(new Type[0])));
                        i = j;
                        break;
                    }
                    case 'a': {
                        int c2;
                        Vector<Type> contained;
                        if ('{' == dbus.charAt(i + 1)) {
                            contained = new Vector();
                            c2 = Marshalling.getJavaType(dbus.substring(i + 2), contained, 2);
                            rv.add(new DBusMapType(contained.get(0), contained.get(1)));
                            i += c2 + 2;
                            break;
                        }
                        contained = new Vector();
                        c2 = Marshalling.getJavaType(dbus.substring(i + 1), contained, 1);
                        rv.add(new DBusListType(contained.get(0)));
                        i += c2;
                        break;
                    }
                    case 'v': {
                        rv.add((Type)((Object)Variant.class));
                        break;
                    }
                    case 'b': {
                        rv.add((Type)((Object)Boolean.class));
                        break;
                    }
                    case 'n': {
                        rv.add((Type)((Object)Short.class));
                        break;
                    }
                    case 'y': {
                        rv.add((Type)((Object)Byte.class));
                        break;
                    }
                    case 'o': {
                        rv.add((Type)((Object)DBusInterface.class));
                        break;
                    }
                    case 'q': {
                        rv.add((Type)((Object)UInt16.class));
                        break;
                    }
                    case 'i': {
                        rv.add((Type)((Object)Integer.class));
                        break;
                    }
                    case 'u': {
                        rv.add((Type)((Object)UInt32.class));
                        break;
                    }
                    case 'x': {
                        rv.add((Type)((Object)Long.class));
                        break;
                    }
                    case 't': {
                        rv.add((Type)((Object)UInt64.class));
                        break;
                    }
                    case 'd': {
                        rv.add((Type)((Object)Double.class));
                        break;
                    }
                    case 'f': {
                        rv.add((Type)((Object)Float.class));
                        break;
                    }
                    case 's': {
                        rv.add((Type)((Object)String.class));
                        break;
                    }
                    case 'g': {
                        rv.add((Type)((Object)Type[].class));
                        break;
                    }
                    case '{': {
                        rv.add((Type)((Object)Map.Entry.class));
                        Vector<Type> contained = new Vector<Type>();
                        int c2 = Marshalling.getJavaType(dbus.substring(i + 1), contained, 2);
                        i += c2 + 1;
                        break;
                    }
                    default: {
                        throw new DBusException(MessageFormat.format(Gettext._("Failed to parse DBus type signature: {0} ({1})."), dbus, Character.valueOf(dbus.charAt(i))));
                    }
                }
                ++i;
            }
            return i;
        }
        catch (IndexOutOfBoundsException IOOBe) {
            throw new DBusException(String.valueOf(Gettext._("Failed to parse DBus type signature: ")) + dbus);
        }
    }

    public static Object[] convertParameters(Object[] parameters, Type[] types, AbstractConnection conn) throws DBusException {
        if (parameters == null) {
            return null;
        }
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] != null) {
                if (parameters[i] instanceof DBusSerializable) {
                    Method[] methodArray = parameters[i].getClass().getDeclaredMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method m = methodArray[n2];
                        if (m.getName().equals("deserialize")) {
                            Class<?>[] newtypes = m.getParameterTypes();
                            Type[] expand = new Type[types.length + newtypes.length - 1];
                            System.arraycopy(types, 0, expand, 0, i);
                            System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                            System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                            types = expand;
                            Object[] newparams = ((DBusSerializable)parameters[i]).serialize();
                            Object[] exparams = new Object[parameters.length + newparams.length - 1];
                            System.arraycopy(parameters, 0, exparams, 0, i);
                            System.arraycopy(newparams, 0, exparams, i, newparams.length);
                            System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                            parameters = exparams;
                        }
                        ++n2;
                    }
                    --i;
                } else if (parameters[i] instanceof Tuple) {
                    Type[] newtypes = ((ParameterizedType)types[i]).getActualTypeArguments();
                    Type[] expand = new Type[types.length + newtypes.length - 1];
                    System.arraycopy(types, 0, expand, 0, i);
                    System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                    System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                    types = expand;
                    Object[] newparams = ((Tuple)parameters[i]).getParameters();
                    Object[] exparams = new Object[parameters.length + newparams.length - 1];
                    System.arraycopy(parameters, 0, exparams, 0, i);
                    System.arraycopy(newparams, 0, exparams, i, newparams.length);
                    System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                    parameters = exparams;
                    --i;
                } else if (types[i] instanceof TypeVariable && !(parameters[i] instanceof Variant)) {
                    parameters[i] = new Variant<Object>(parameters[i]);
                } else if (parameters[i] instanceof DBusInterface) {
                    parameters[i] = conn.getExportedObject((DBusInterface)parameters[i]);
                }
            }
            ++i;
        }
        return parameters;
    }

    static Object deSerializeParameter(Object parameter, Type type, AbstractConnection conn) throws Exception {
        Type type2;
        Object[] ts;
        if (parameter == null) {
            return null;
        }
        if (type instanceof TypeVariable && parameter instanceof Variant) {
            parameter = ((Variant)parameter).getValue();
        }
        if (type instanceof Class && ((Class)type).isArray() && ((Class)type).getComponentType().equals(Type.class) && parameter instanceof String) {
            Vector<Type> rv = new Vector<Type>();
            Marshalling.getJavaType((String)parameter, rv, -1);
            parameter = rv.toArray(new Type[0]);
        }
        if (parameter instanceof ObjectPath) {
            parameter = type instanceof Class && DBusInterface.class.isAssignableFrom((Class)type) ? conn.getExportedObject(((ObjectPath)parameter).source, ((ObjectPath)parameter).path) : new Path(((ObjectPath)parameter).path);
        }
        if (parameter instanceof Object[] && type instanceof Class && Struct.class.isAssignableFrom((Class)type)) {
            int n;
            ts = Container.getTypeCache(type);
            if (ts == null) {
                Field[] fs = ((Class)type).getDeclaredFields();
                ts = new Type[fs.length];
                Field[] fieldArray = fs;
                int n2 = fs.length;
                n = 0;
                while (n < n2) {
                    Field f = fieldArray[n];
                    Position p = f.getAnnotation(Position.class);
                    if (p != null) {
                        ts[p.value()] = f.getGenericType();
                    }
                    ++n;
                }
                Container.putTypeCache(type, (Type[])ts);
            }
            parameter = Marshalling.deSerializeParameters(parameter, (Type[])ts, conn);
            Constructor<?>[] constructorArray = ((Class)type).getDeclaredConstructors();
            n = constructorArray.length;
            int f = 0;
            while (f < n) {
                Constructor<?> con = constructorArray[f];
                try {
                    parameter = con.newInstance(parameter);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ++f;
                }
            }
        }
        if (parameter instanceof Object[]) {
            ts = new Type[((Object[])parameter).length];
            Arrays.fill(ts, parameter.getClass().getComponentType());
            parameter = Marshalling.deSerializeParameters(parameter, (Type[])ts, conn);
        }
        if (parameter instanceof List && (type2 = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : (type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : (type instanceof Class && ((Class)type).isArray() ? ((Class)type).getComponentType() : null))) != null) {
            parameter = Marshalling.deSerializeParameters((List)parameter, type2, conn);
        }
        if ((type.equals(Float.class) || type.equals(Float.TYPE)) && !(parameter instanceof Float)) {
            parameter = Float.valueOf(((Number)parameter).floatValue());
        }
        if (parameter instanceof Object[] || parameter instanceof List || parameter.getClass().isArray()) {
            if (type instanceof ParameterizedType) {
                parameter = ArrayFrob.convert(parameter, (Class)((ParameterizedType)type).getRawType());
            } else if (type instanceof GenericArrayType) {
                Type ct = ((GenericArrayType)type).getGenericComponentType();
                Class cc = null;
                if (ct instanceof Class) {
                    cc = (Class)ct;
                }
                if (ct instanceof ParameterizedType) {
                    cc = (Class)((ParameterizedType)ct).getRawType();
                }
                Object o = Array.newInstance(cc, 0);
                parameter = ArrayFrob.convert(parameter, o.getClass());
            } else if (type instanceof Class && ((Class)type).isArray()) {
                Class<?> cc = ((Class)type).getComponentType();
                if ((cc.equals(Float.class) || cc.equals(Float.TYPE)) && parameter instanceof double[]) {
                    double[] tmp1 = (double[])parameter;
                    float[] tmp2 = new float[tmp1.length];
                    int i = 0;
                    while (i < tmp1.length) {
                        tmp2[i] = (float)tmp1[i];
                        ++i;
                    }
                    parameter = tmp2;
                }
                Object o = Array.newInstance(cc, 0);
                parameter = ArrayFrob.convert(parameter, o.getClass());
            }
        }
        return parameter;
    }

    static List<Object> deSerializeParameters(List<Object> parameters, Type type, AbstractConnection conn) throws Exception {
        if (parameters == null) {
            return null;
        }
        int i = 0;
        while (i < parameters.size()) {
            if (parameters.get(i) != null) {
                parameters.set(i, Marshalling.deSerializeParameter(parameters.get(i), type, conn));
            }
            ++i;
        }
        return parameters;
    }

    static Object[] deSerializeParameters(Object[] parameters, Type[] types, AbstractConnection conn) throws Exception {
        if (parameters == null) {
            return null;
        }
        if (types.length == 1 && types[0] instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)types[0]).getRawType())) {
            types = ((ParameterizedType)types[0]).getActualTypeArguments();
        }
        int i = 0;
        while (i < parameters.length) {
            if (i >= types.length) {
                throw new DBusException("Error deserializing message: number of parameters didn't match receiving signature");
            }
            if (parameters[i] != null) {
                if (types[i] instanceof Class && DBusSerializable.class.isAssignableFrom((Class)types[i]) || types[i] instanceof ParameterizedType && DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)types[i]).getRawType())) {
                    Class dsc = types[i] instanceof Class ? (Class)types[i] : (Class)((ParameterizedType)types[i]).getRawType();
                    Method[] methodArray = dsc.getDeclaredMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method m = methodArray[n2];
                        if (m.getName().equals("deserialize")) {
                            Type[] newtypes = m.getGenericParameterTypes();
                            try {
                                Object[] sub = new Object[newtypes.length];
                                System.arraycopy(parameters, i, sub, 0, newtypes.length);
                                sub = Marshalling.deSerializeParameters(sub, newtypes, conn);
                                DBusSerializable sz = (DBusSerializable)dsc.newInstance();
                                m.invoke((Object)sz, sub);
                                Object[] compress = new Object[parameters.length - newtypes.length + 1];
                                System.arraycopy(parameters, 0, compress, 0, i);
                                compress[i] = sz;
                                System.arraycopy(parameters, i + newtypes.length, compress, i + 1, parameters.length - i - newtypes.length);
                                parameters = compress;
                            }
                            catch (ArrayIndexOutOfBoundsException AIOOBe) {
                                throw new DBusException(MessageFormat.format(Gettext._("Not enough elements to create custom object from serialized data ({0} < {1})."), parameters.length - i, newtypes.length));
                            }
                        }
                        ++n2;
                    }
                } else {
                    parameters[i] = Marshalling.deSerializeParameter(parameters[i], types[i], conn);
                }
            }
            ++i;
        }
        return parameters;
    }
}

