/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.HashMap;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBusMatchRule {
    private String type;
    private String iface;
    private String member;
    private String object;
    private String source;
    private static HashMap<String, Class<? extends DBusSignal>> signalTypeMap = new HashMap();

    static Class<? extends DBusSignal> getCachedSignalType(String type) {
        return signalTypeMap.get(type);
    }

    public DBusMatchRule(String type, String iface, String member) {
        this.type = type;
        this.iface = iface;
        this.member = member;
    }

    public DBusMatchRule(DBusExecutionException e) throws DBusException {
        this(e.getClass());
        this.member = null;
        this.type = "error";
    }

    public DBusMatchRule(Message m) {
        this.iface = m.getInterface();
        this.member = m.getName();
        if (m instanceof DBusSignal) {
            this.type = "signal";
        } else if (m instanceof Error) {
            this.type = "error";
            this.member = null;
        } else if (m instanceof MethodCall) {
            this.type = "method_call";
        } else if (m instanceof MethodReturn) {
            this.type = "method_reply";
        }
    }

    public DBusMatchRule(Class<? extends DBusInterface> c, String method) throws DBusException {
        this(c);
        this.member = method;
        this.type = "method_call";
    }

    public DBusMatchRule(Class<? extends Object> c, String source, String object) throws DBusException {
        this(c);
        this.source = source;
        this.object = object;
    }

    public DBusMatchRule(Class<? extends Object> c) throws DBusException {
        if (DBusInterface.class.isAssignableFrom(c)) {
            this.iface = c.getAnnotation(DBusInterfaceName.class) != null ? c.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(c.getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException(Gettext._("DBusInterfaces must be defined in a package."));
            }
            this.member = null;
            this.type = null;
        } else if (DBusSignal.class.isAssignableFrom(c)) {
            if (c.getEnclosingClass() == null) {
                throw new DBusException(Gettext._("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package."));
            }
            this.iface = c.getEnclosingClass().getAnnotation(DBusInterfaceName.class) != null ? c.getEnclosingClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(c.getEnclosingClass().getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException(Gettext._("DBusInterfaces must be defined in a package."));
            }
            this.member = c.isAnnotationPresent(DBusMemberName.class) ? c.getAnnotation(DBusMemberName.class).value() : c.getSimpleName();
            signalTypeMap.put(String.valueOf(this.iface) + '$' + this.member, c);
            this.type = "signal";
        } else if (Error.class.isAssignableFrom(c)) {
            this.iface = c.getAnnotation(DBusInterfaceName.class) != null ? c.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(c.getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException(Gettext._("DBusInterfaces must be defined in a package."));
            }
            this.member = null;
            this.type = "error";
        } else if (DBusExecutionException.class.isAssignableFrom(c)) {
            this.iface = c.getClass().getAnnotation(DBusInterfaceName.class) != null ? c.getClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(c.getClass().getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException(Gettext._("DBusInterfaces must be defined in a package."));
            }
            this.member = null;
            this.type = "error";
        } else {
            throw new DBusException(String.valueOf(Gettext._("Invalid type for match rule: ")) + c);
        }
    }

    public String toString() {
        String s = null;
        if (this.type != null) {
            String string = s = s == null ? "type='" + this.type + "'" : String.valueOf(s) + ",type='" + this.type + "'";
        }
        if (this.member != null) {
            String string = s = s == null ? "member='" + this.member + "'" : String.valueOf(s) + ",member='" + this.member + "'";
        }
        if (this.iface != null) {
            String string = s = s == null ? "interface='" + this.iface + "'" : String.valueOf(s) + ",interface='" + this.iface + "'";
        }
        if (this.source != null) {
            String string = s = s == null ? "sender='" + this.source + "'" : String.valueOf(s) + ",sender='" + this.source + "'";
        }
        if (this.object != null) {
            s = s == null ? "path='" + this.object + "'" : String.valueOf(s) + ",path='" + this.object + "'";
        }
        return s;
    }

    public String getType() {
        return this.type;
    }

    public String getInterface() {
        return this.iface;
    }

    public String getMember() {
        return this.member;
    }

    public String getSource() {
        return this.source;
    }

    public String getObject() {
        return this.object;
    }
}

