/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.utils;

import java.io.PrintStream;

public class Hexdump {
    public static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHex(byte[] buf) {
        return Hexdump.toHex(buf, 0, buf.length);
    }

    public static String toHex(byte[] buf, int ofs, int len) {
        StringBuffer sb = new StringBuffer();
        int j = ofs + len;
        int i = ofs;
        while (i < j) {
            if (i < buf.length) {
                sb.append(hexchars[(buf[i] & 0xF0) >> 4]);
                sb.append(hexchars[buf[i] & 0xF]);
                sb.append(' ');
            } else {
                sb.append(' ');
                sb.append(' ');
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toAscii(byte[] buf) {
        return Hexdump.toAscii(buf, 0, buf.length);
    }

    public static String toAscii(byte[] buf, int ofs, int len) {
        StringBuffer sb = new StringBuffer();
        int j = ofs + len;
        int i = ofs;
        while (i < j) {
            if (i < buf.length) {
                if (20 <= buf[i] && 126 >= buf[i]) {
                    sb.append((char)buf[i]);
                } else {
                    sb.append('.');
                }
            } else {
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public static String format(byte[] buf) {
        return Hexdump.format(buf, 80);
    }

    public static String format(byte[] buf, int width) {
        int bs = (width - 8) / 4;
        int i = 0;
        StringBuffer sb = new StringBuffer();
        do {
            int j = 0;
            while (j < 6) {
                sb.append(hexchars[(i << j * 4 & 0xF00000) >> 20]);
                ++j;
            }
            sb.append('\t');
            sb.append(Hexdump.toHex(buf, i, bs));
            sb.append(' ');
            sb.append(Hexdump.toAscii(buf, i, bs));
            sb.append('\n');
        } while ((i += bs) < buf.length);
        return sb.toString();
    }

    public static void print(byte[] buf) {
        Hexdump.print(buf, System.err);
    }

    public static void print(byte[] buf, int width) {
        Hexdump.print(buf, width, System.err);
    }

    public static void print(byte[] buf, int width, PrintStream out) {
        out.print(Hexdump.format(buf, width));
    }

    public static void print(byte[] buf, PrintStream out) {
        out.print(Hexdump.format(buf));
    }

    public static String toByteArray(byte[] buf) {
        return Hexdump.toByteArray(buf, 0, buf.length);
    }

    public static String toByteArray(byte[] buf, int ofs, int len) {
        StringBuffer sb = new StringBuffer();
        int i = ofs;
        while (i < len && i < buf.length) {
            sb.append('0');
            sb.append('x');
            sb.append(hexchars[(buf[i] & 0xF0) >> 4]);
            sb.append(hexchars[buf[i] & 0xF]);
            if (i + 1 < len && i + 1 < buf.length) {
                sb.append(',');
            }
            ++i;
        }
        return sb.toString();
    }
}

