/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.lang.reflect.Type;
import java.text.Collator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.test.TestException;
import org.freedesktop.dbus.test.TestNewInterface;
import org.freedesktop.dbus.test.TestRemoteInterface;
import org.freedesktop.dbus.test.TestRemoteInterface2;
import org.freedesktop.dbus.test.TestSerializable;
import org.freedesktop.dbus.test.TestSignalInterface;
import org.freedesktop.dbus.test.TestSignalInterface2;
import org.freedesktop.dbus.test.TestStruct;
import org.freedesktop.dbus.test.TestStruct2;
import org.freedesktop.dbus.test.TestStruct3;
import org.freedesktop.dbus.test.TestTuple;
import org.freedesktop.dbus.test.arraysignalhandler;
import org.freedesktop.dbus.test.badarraysignalhandler;
import org.freedesktop.dbus.test.callbackhandler;
import org.freedesktop.dbus.test.disconnecthandler;
import org.freedesktop.dbus.test.objectsignalhandler;
import org.freedesktop.dbus.test.pathsignalhandler;
import org.freedesktop.dbus.test.renamedsignalhandler;
import org.freedesktop.dbus.test.signalhandler;
import org.freedesktop.dbus.test.testclass;

public class test {
    public static boolean done1 = false;
    public static boolean done2 = false;
    public static boolean done3 = false;
    public static boolean done4 = false;
    public static boolean done5 = false;
    public static boolean done6 = false;
    static DBusConnection serverconn = null;
    static DBusConnection clientconn = null;

    public static void fail(String message) {
        System.out.println("Test Failed: " + message);
        System.err.println("Test Failed: " + message);
        if (serverconn != null) {
            serverconn.disconnect();
        }
        if (clientconn != null) {
            clientconn.disconnect();
        }
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            Vector<Integer> li;
            Vector<List<Integer>> lli;
            Collator col;
            TestRemoteInterface tri;
            DBusConnection.PeerSet peers;
            DBus.Introspectable intro;
            testclass tclass;
            signalhandler sigh;
            block55: {
                String[] names;
                System.out.println("Creating Connection");
                serverconn = DBusConnection.getConnection(1);
                clientconn = DBusConnection.getConnection(1);
                serverconn.setWeakReferences(true);
                clientconn.setWeakReferences(true);
                System.out.println("Registering Name");
                serverconn.requestBusName("foo.bar.Test");
                DBus.Peer peer = clientconn.getRemoteObject("foo.bar.Test", "/Test", DBus.Peer.class);
                DBus dbus = clientconn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
                System.out.print("Listening for signals...");
                sigh = new signalhandler();
                renamedsignalhandler rsh = new renamedsignalhandler();
                try {
                    clientconn.addSigHandler(TestSignalInterface.TestSignal.class, sigh);
                    clientconn.addSigHandler(TestSignalInterface2.TestRenamedSignal.class, rsh);
                    clientconn.addSigHandler(DBus.Local.Disconnected.class, new disconnecthandler(clientconn, rsh));
                    String source = dbus.GetNameOwner("foo.bar.Test");
                    clientconn.addSigHandler(TestSignalInterface.TestArraySignal.class, source, peer, new arraysignalhandler());
                    clientconn.addSigHandler(TestSignalInterface.TestObjectSignal.class, new objectsignalhandler());
                    clientconn.addSigHandler(TestSignalInterface.TestPathSignal.class, new pathsignalhandler());
                    badarraysignalhandler bash = new badarraysignalhandler();
                    clientconn.addSigHandler(TestSignalInterface.TestSignal.class, bash);
                    clientconn.removeSigHandler(TestSignalInterface.TestSignal.class, bash);
                    System.out.println("done");
                }
                catch (DBus.Error.MatchRuleInvalid MRI) {
                    test.fail("Failed to add handlers: " + MRI.getMessage());
                }
                catch (DBusException DBe) {
                    test.fail("Failed to add handlers: " + DBe.getMessage());
                }
                System.out.println("Listening for Method Calls");
                tclass = new testclass(serverconn);
                testclass tclass2 = new testclass(serverconn);
                serverconn.exportObject("/Test", tclass);
                serverconn.exportObject("/BadTest", tclass);
                serverconn.exportObject("/BadTest2", tclass2);
                serverconn.addFallback("/FallbackTest", tclass);
                serverconn.unExportObject("/BadTest");
                tclass2 = null;
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.out.println("Sending Signal");
                serverconn.sendSignal(new TestSignalInterface.TestSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
                serverconn.sendSignal(new TestSignalInterface2.TestRenamedSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
                System.out.println("These things are on the bus:");
                String[] stringArray = names = dbus.ListNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    System.out.println("\t" + name);
                    ++n2;
                }
                System.out.println("Getting our introspection data");
                intro = clientconn.getRemoteObject("foo.bar.Test", "/", DBus.Introspectable.class);
                intro = clientconn.getRemoteObject("foo.bar.Test", "/Test", DBus.Introspectable.class);
                String data = intro.Introspect();
                if (data == null || !data.startsWith("<!DOCTYPE")) {
                    test.fail("Introspection data invalid");
                }
                System.out.println("Got Introspection Data: \n" + data);
                peers = serverconn.new DBusConnection.PeerSet();
                peers.add("org.freedesktop.DBus");
                clientconn.requestBusName("test.testclient");
                peers.add("test.testclient");
                clientconn.releaseBusName("test.testclient");
                System.out.println("Pinging ourselves");
                int i = 0;
                while (i < 10) {
                    long then = System.currentTimeMillis();
                    peer.Ping();
                    long now = System.currentTimeMillis();
                    System.out.println("Ping returned in " + (now - then) + "ms.");
                    ++i;
                }
                System.out.println("Calling Method0/1");
                tri = (TestRemoteInterface)clientconn.getPeerRemoteObject("foo.bar.Test", "/Test");
                System.out.println("Got Remote Object: " + tri);
                String rname = tri.getName();
                System.out.println("Got Remote Name: " + rname);
                Path path = new Path("/nonexistantwooooooo");
                Path p = tri.pathrv(path);
                System.out.println(String.valueOf(path.toString()) + " => " + p.toString());
                if (!path.equals(p)) {
                    test.fail("pathrv incorrect");
                }
                Vector<Path> paths = new Vector<Path>();
                paths.add(path);
                List<Path> ps = tri.pathlistrv(paths);
                System.out.println(String.valueOf(((Object)paths).toString()) + " => " + ps.toString());
                if (!paths.equals(ps)) {
                    test.fail("pathlistrv incorrect");
                }
                HashMap<Path, Path> pathm = new HashMap<Path, Path>();
                pathm.put(path, path);
                Map<Path, Path> pm = tri.pathmaprv(pathm);
                System.out.println(String.valueOf(((Object)pathm).toString()) + " => " + pm.toString());
                System.out.println(String.valueOf(pm.containsKey(path)) + " " + pm.get(path) + " " + path.equals(pm.get(path)));
                System.out.println(String.valueOf(pm.containsKey(p)) + " " + pm.get(p) + " " + p.equals(pm.get(p)));
                for (Path q : pm.keySet()) {
                    System.out.println(q);
                    System.out.println(pm.get(q));
                }
                if (!pm.containsKey(path) || !path.equals(pm.get(path))) {
                    test.fail("pathmaprv incorrect");
                }
                serverconn.sendSignal(new TestSignalInterface.TestPathSignal("/Test", path, paths, pathm));
                col = Collator.getInstance();
                col.setDecomposition(2);
                col.setStrength(0);
                if (col.compare("This Is A UTF-8 Name: \ufeb1 !!", rname) != 0) {
                    test.fail("getName return value incorrect");
                }
                System.out.println("sending it to sleep");
                tri.waitawhile();
                System.out.println("testing floats");
                if (17.093f != tri.testfloat(new float[]{17.093f, -23.0f, 0.0f, 31.42f})) {
                    test.fail("testfloat returned the wrong thing");
                }
                System.out.println("Structs of Structs");
                lli = new Vector<List<Integer>>();
                li = new Vector<Integer>();
                li.add(1);
                li.add(2);
                li.add(3);
                lli.add(li);
                lli.add(li);
                lli.add(li);
                TestStruct3 ts3 = new TestStruct3(new TestStruct2(new Vector<String>(), new Variant<Integer>(0)), lli);
                int[][] out = tri.teststructstruct(ts3);
                if (out.length != 3) {
                    test.fail("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out));
                }
                int[][] nArray = out;
                int n3 = out.length;
                int n4 = 0;
                while (n4 < n3) {
                    int[] o = nArray[n4];
                    if (o.length != 3 || o[0] != 1 || o[1] != 2 || o[2] != 3) {
                        test.fail("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out));
                    }
                    ++n4;
                }
                System.out.println("frobnicating");
                Vector<Long> ls = new Vector<Long>();
                ls.add(2L);
                ls.add(5L);
                ls.add(71L);
                HashMap<UInt16, Short> mus = new HashMap<UInt16, Short>();
                mus.put(new UInt16(4), (short)5);
                mus.put(new UInt16(5), (short)6);
                mus.put(new UInt16(6), (short)7);
                HashMap<String, Map<UInt16, Short>> msmus = new HashMap<String, Map<UInt16, Short>>();
                msmus.put("stuff", mus);
                int rint = tri.frobnicate(ls, msmus, 13);
                if (-5 != rint) {
                    test.fail("frobnicate return value incorrect");
                }
                System.out.println("Doing stuff asynchronously with callback");
                clientconn.callWithCallback(tri, "getName", new callbackhandler(), new Object[0]);
                try {
                    System.out.println("Throwing stuff");
                    tri.throwme();
                    test.fail("Method Execution should have failed");
                }
                catch (TestException Te) {
                    System.out.println("Remote Method Failed with: " + Te.getClass().getName() + " " + Te.getMessage());
                    if (Te.getMessage().equals("test")) break block55;
                    test.fail("Error message was not correct");
                }
            }
            Vector<Type> ts = new Vector<Type>();
            Marshalling.getJavaType("ya{si}", ts, -1);
            tri.sig(ts.toArray(new Type[0]));
            tri.newpathtest(new Path("/new/path/test"));
            try {
                System.out.println("Calling Method2");
                tri = clientconn.getRemoteObject("foo.bar.NotATest", "/Moofle", TestRemoteInterface.class);
                System.out.println("Got Remote Name: " + tri.getName());
                test.fail("Method Execution should have failed");
            }
            catch (DBus.Error.ServiceUnknown SU) {
                System.out.println("Remote Method Failed with: " + SU.getClass().getName() + " " + SU.getMessage());
            }
            try {
                System.out.println("Calling Method3");
                tri = clientconn.getRemoteObject("foo.bar.Test", "/Moofle", TestRemoteInterface.class);
                System.out.println("Got Remote Name: " + tri.getName());
                test.fail("Method Execution should have failed");
            }
            catch (DBus.Error.UnknownObject UO) {
                System.out.println("Remote Method Failed with: " + UO.getClass().getName() + " " + UO.getMessage());
            }
            try {
                System.out.println("Calling Method4");
                tri = clientconn.getRemoteObject("foo.bar.Test", "/BadTest", TestRemoteInterface.class);
                System.out.println("Got Remote Name: " + tri.getName());
                test.fail("Method Execution should have failed");
            }
            catch (DBus.Error.UnknownObject UO) {
                System.out.println("Remote Method Failed with: " + UO.getClass().getName() + " " + UO.getMessage());
            }
            try {
                System.out.println("Calling Method5");
                tri = clientconn.getRemoteObject("foo.bar.Test", "/BadTest2", TestRemoteInterface.class);
                System.out.println("Got Remote Name: " + tri.getName());
                test.fail("Method Execution should have failed");
            }
            catch (DBus.Error.UnknownObject UO) {
                System.out.println("Remote Method Failed with: " + UO.getClass().getName() + " " + UO.getMessage());
            }
            System.out.println("Calling Method6");
            tri = clientconn.getRemoteObject("foo.bar.Test", "/FallbackTest/0/1", TestRemoteInterface.class);
            intro = clientconn.getRemoteObject("foo.bar.Test", "/FallbackTest/0/4", DBus.Introspectable.class);
            System.out.println("Got Fallback Name: " + tri.getName());
            System.out.println("Fallback Introspection Data: \n" + intro.Introspect());
            System.out.println("Testing Properties returning Paths");
            DBus.Properties prop = clientconn.getRemoteObject("foo.bar.Test", "/Test", DBus.Properties.class);
            Path prv = (Path)prop.Get("foo.bar", "foo");
            System.out.println("Got path " + prv);
            System.out.println("Calling Method7--9");
            TestRemoteInterface2 tri2 = clientconn.getRemoteObject("foo.bar.Test", "/Test", TestRemoteInterface2.class);
            System.out.print("Calling the other introspect method: ");
            String intro2 = tri2.Introspect();
            System.out.println(intro2);
            if (col.compare("Not XML", intro2) != 0) {
                test.fail("Introspect return value incorrect");
            }
            TestTuple<String, List<Integer>, Boolean> rv = tri2.show(234);
            System.out.println("Show returned: " + rv);
            if (!serverconn.getUniqueName().equals(rv.a) || 1 != ((List)rv.b).size() || 1953 != (Integer)((List)rv.b).get(0) || !((Boolean)rv.c).booleanValue()) {
                test.fail("show return value incorrect (" + (String)rv.a + "," + rv.b + "," + rv.c + ")");
            }
            System.out.println("Doing stuff asynchronously");
            DBusAsyncReply stuffreply = clientconn.callMethodAsync(tri2, "dostuff", new TestStruct("bar", new UInt32(52L), new Variant<Boolean>(new Boolean(true))));
            System.out.println("Checking bools");
            if (tri2.check()) {
                test.fail("bools are broken");
            }
            Vector<String> l = new Vector<String>();
            l.add("hi");
            l.add("hello");
            l.add("hej");
            l.add("hey");
            l.add("aloha");
            System.out.println("Sampling Arrays:");
            List<Integer> is = tri2.sampleArray(l, new Integer[]{1, 5, 7, 9}, new long[]{2L, 6L, 8L, 12L});
            System.out.println("sampleArray returned an array:");
            for (Integer i : is) {
                System.out.println("--" + i);
            }
            if (is.size() != 5 || is.get(0) != -1 || is.get(1) != -5 || is.get(2) != -7 || is.get(3) != -12 || is.get(4) != -18) {
                test.fail("sampleArray return value incorrect");
            }
            System.out.println("Get This");
            if (!tclass.equals(tri2.getThis(tri2))) {
                test.fail("Didn't get the correct this");
            }
            Boolean b = (Boolean)stuffreply.getReply();
            System.out.println("Do stuff replied " + b);
            if (!b.booleanValue()) {
                test.fail("dostuff return value incorrect");
            }
            System.out.print("Sending Array Signal...");
            Vector<TestStruct2> tsl = new Vector<TestStruct2>();
            tsl.add(new TestStruct2(l, new Variant<UInt64>(new UInt64(567L))));
            serverconn.sendSignal(new TestSignalInterface.TestArraySignal("/Test", tsl));
            System.out.println("done");
            System.out.print("testing custom serialization...");
            Vector<Integer> v = new Vector<Integer>();
            v.add(1);
            v.add(2);
            v.add(3);
            TestSerializable<String> s = new TestSerializable<String>(1, "woo", v);
            s = tri2.testSerializable((byte)12, s, 13);
            System.out.print("returned: " + s);
            if (s.getInt() != 1 || !s.getString().equals("woo") || s.getVector().size() != 3 || s.getVector().get(0) != 1 || s.getVector().get(1) != 2 || s.getVector().get(2) != 3) {
                test.fail("Didn't get back the same TestSerializable");
            }
            System.out.println("done");
            System.out.print("testing complex variants...");
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("cow", "moo");
            tri2.complexv(new Variant(m, "a{ss}"));
            System.out.println("done");
            System.out.print("testing recursion...");
            if (col.compare("This Is A UTF-8 Name: \ufeb1 !!", tri2.recursionTest()) != 0) {
                test.fail("recursion test failed");
            }
            System.out.println("done");
            System.out.print("testing method overloading...");
            tri = clientconn.getRemoteObject("foo.bar.Test", "/Test", TestRemoteInterface.class);
            if (1 != tri2.overload("foo")) {
                test.fail("wrong overloaded method called");
            }
            if (2 != tri2.overload((byte)0)) {
                test.fail("wrong overloaded method called");
            }
            if (3 != tri2.overload()) {
                test.fail("wrong overloaded method called");
            }
            if (4 != tri.overload()) {
                test.fail("wrong overloaded method called");
            }
            System.out.println("done");
            System.out.print("reg13291...");
            byte[] as = new byte[10];
            int i = 0;
            while (i < 10) {
                as[i] = (byte)(100 - i);
                ++i;
            }
            tri.reg13291(as, as);
            System.out.println("done");
            System.out.print("Testing nested lists...");
            lli = new Vector();
            li = new Vector();
            li.add(1);
            lli.add(li);
            List<List<Integer>> reti = tri2.checklist(lli);
            if (reti.size() != 1 || reti.get(0).size() != 1 || reti.get(0).get(0) != 1) {
                test.fail("Failed to check nested lists");
            }
            System.out.println("done");
            System.out.print("Testing dynamic object creation...");
            TestNewInterface tni = tri2.getNew();
            System.out.print(String.valueOf(tni.getName()) + " ");
            System.out.println("done");
            serverconn.sendSignal(new TestSignalInterface.TestObjectSignal("/foo/bar/Wibble", tclass));
            Thread.sleep(1000L);
            if (peers.size() != 1) {
                test.fail("peers hasn't been trimmed");
            }
            if (!peers.contains("org.freedesktop.DBus")) {
                test.fail("peers contains the wrong name");
            }
            System.out.println("Checking for outstanding errors");
            DBusExecutionException DBEe = serverconn.getError();
            if (DBEe != null) {
                throw DBEe;
            }
            DBEe = clientconn.getError();
            if (DBEe != null) {
                throw DBEe;
            }
            System.out.println("Disconnecting");
            clientconn.disconnect();
            serverconn.disconnect();
            System.out.println("Trying to do things after disconnection");
            clientconn.removeSigHandler(TestSignalInterface.TestSignal.class, sigh);
            try {
                System.out.println("getName() suceeded and returned: " + tri.getName());
                test.fail("Should not succeed when disconnected");
            }
            catch (NotConnected NC) {
                System.out.println("getName() failed with exception " + NC);
            }
            clientconn = null;
            serverconn = null;
            if (!done1) {
                test.fail("Signal handler 1 failed to be run");
            }
            if (!done2) {
                test.fail("Signal handler 2 failed to be run");
            }
            if (!done3) {
                test.fail("Signal handler 3 failed to be run");
            }
            if (!done4) {
                test.fail("Callback handler failed to be run");
            }
            if (!done5) {
                test.fail("Signal handler R failed to be run");
            }
            if (!done6) {
                test.fail("Disconnect handler failed to be run");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            test.fail("Unexpected Exception Occurred: " + e);
        }
    }
}

