/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.types.DBusMapType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class cross_test_client
implements DBus.Binding.TestClient,
DBusSigHandler<DBus.Binding.TestSignals.Triggered> {
    private DBusConnection conn;
    private static Set<String> passed = new TreeSet<String>();
    private static Map<String, List<String>> failed = new HashMap<String, List<String>>();
    private static cross_test_client ctc;

    static {
        Vector<String> l = new Vector<String>();
        l.add("Signal never arrived");
        failed.put("org.freedesktop.DBus.Binding.TestSignals.Triggered", l);
        l = new Vector();
        l.add("Method never called");
        failed.put("org.freedesktop.DBus.Binding.TestClient.Response", l);
    }

    public cross_test_client(DBusConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public void handle(DBus.Binding.TestSignals.Triggered t) {
        failed.remove("org.freedesktop.DBus.Binding.TestSignals.Triggered");
        if (new UInt64(21389479283L).equals(t.a) && "/Test".equals(t.getPath())) {
            cross_test_client.pass("org.freedesktop.DBus.Binding.TestSignals.Triggered");
        } else if (!new UInt64(21389479283L).equals(t.a)) {
            cross_test_client.fail("org.freedesktop.DBus.Binding.TestSignals.Triggered", "Incorrect signal content; expected 21389479283 got " + t.a);
        } else if (!"/Test".equals(t.getPath())) {
            cross_test_client.fail("org.freedesktop.DBus.Binding.TestSignals.Triggered", "Incorrect signal source object; expected /Test got " + t.getPath());
        }
    }

    @Override
    public void Response(UInt16 a, double b) {
        failed.remove("org.freedesktop.DBus.Binding.TestClient.Response");
        if (a.equals(new UInt16(15)) && b == 12.5) {
            cross_test_client.pass("org.freedesktop.DBus.Binding.TestClient.Response");
        } else {
            cross_test_client.fail("org.freedesktop.DBus.Binding.TestClient.Response", "Incorrect parameters; expected 15, 12.5 got " + a + ", " + b);
        }
    }

    public static void pass(String test4) {
        passed.add(test4.replaceAll("[$]", "."));
    }

    public static void fail(String test4, String reason) {
        List<String> reasons = failed.get(test4 = test4.replaceAll("[$]", "."));
        if (reasons == null) {
            reasons = new Vector<String>();
            failed.put(test4, reasons);
        }
        reasons.add(reason);
    }

    public static void test(Class<? extends DBusInterface> iface, Object proxy, String method, Object rv, Object ... parameters) {
        try {
            Method[] ms = iface.getMethods();
            Method m = null;
            Method[] methodArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                Method t = methodArray[n2];
                if (t.getName().equals(method)) {
                    m = t;
                }
                ++n2;
            }
            Object o = m.invoke(proxy, parameters);
            String msg = "Incorrect return value; sent ( ";
            if (parameters != null) {
                Object[] objectArray = parameters;
                int n3 = parameters.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object po = objectArray[n4];
                    if (po != null) {
                        msg = String.valueOf(msg) + cross_test_client.collapseArray(po) + ",";
                    }
                    ++n4;
                }
            }
            msg = msg.replaceAll(".$", ");");
            msg = String.valueOf(msg) + " expected " + cross_test_client.collapseArray(rv) + " got " + cross_test_client.collapseArray(o);
            if (rv != null && rv.getClass().isArray()) {
                cross_test_client.compareArray(String.valueOf(iface.getName()) + "." + method, rv, o);
            } else if (rv instanceof Map) {
                if (o instanceof Map) {
                    Map a = (Map)o;
                    Map b = (Map)rv;
                    if (a.keySet().size() != b.keySet().size()) {
                        cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, msg);
                    } else {
                        for (Object k : a.keySet()) {
                            if (a.get(k) instanceof List) {
                                if (b.get(k) instanceof List) {
                                    if (cross_test_client.setCompareLists((List)a.get(k), (List)b.get(k))) continue;
                                    cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, msg);
                                    continue;
                                }
                                cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, msg);
                                continue;
                            }
                            if (a.get(k).equals(b.get(k))) continue;
                            cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, msg);
                            return;
                        }
                    }
                    cross_test_client.pass(String.valueOf(iface.getName()) + "." + method);
                } else {
                    cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, msg);
                }
            } else if (o == rv || o != null && o.equals(rv)) {
                cross_test_client.pass(String.valueOf(iface.getName()) + "." + method);
            } else {
                cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, msg);
            }
        }
        catch (DBusExecutionException DBEe) {
            DBEe.printStackTrace();
            cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, "Error occurred during execution: " + DBEe.getClass().getName() + " " + DBEe.getMessage());
        }
        catch (InvocationTargetException ITe) {
            ITe.printStackTrace();
            cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, "Error occurred during execution: " + ITe.getCause().getClass().getName() + " " + ITe.getCause().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            cross_test_client.fail(String.valueOf(iface.getName()) + "." + method, "Error occurred during execution: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static String collapseArray(Object array) {
        if (array == null) {
            return "null";
        }
        if (array.getClass().isArray()) {
            String s = "{ ";
            int i = 0;
            while (i < Array.getLength(array)) {
                s = String.valueOf(s) + cross_test_client.collapseArray(Array.get(array, i)) + ",";
                ++i;
            }
            s = s.replaceAll(".$", " }");
            return s;
        }
        if (array instanceof List) {
            String s = "{ ";
            for (Object o : (List)array) {
                s = String.valueOf(s) + cross_test_client.collapseArray(o) + ",";
            }
            s = s.replaceAll(".$", " }");
            return s;
        }
        if (array instanceof Map) {
            String s = "{ ";
            for (Object o : ((Map)array).keySet()) {
                s = String.valueOf(s) + cross_test_client.collapseArray(o) + " => " + cross_test_client.collapseArray(((Map)array).get(o)) + ",";
            }
            s = s.replaceAll(".$", " }");
            return s;
        }
        return array.toString();
    }

    public static <T> boolean setCompareLists(List<T> a, List<T> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (T v : a) {
            if (b.contains(v)) continue;
            return false;
        }
        return true;
    }

    public static List<Variant<Object>> PrimitizeRecurse(Object a, Type t) {
        Vector<Variant<Object>> vs = new Vector<Variant<Object>>();
        if (t instanceof ParameterizedType) {
            Class c = (Class)((ParameterizedType)t).getRawType();
            if (List.class.isAssignableFrom(c)) {
                Object[] os = a instanceof List ? ((List)a).toArray() : a;
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                int i = 0;
                while (i < Array.getLength(os)) {
                    vs.addAll(cross_test_client.PrimitizeRecurse(Array.get(os, i), ts[0]));
                    ++i;
                }
            } else if (Map.class.isAssignableFrom(c)) {
                Object[] os = ((Map)a).keySet().toArray();
                Object[] ks = ((Map)a).values().toArray();
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                int i = 0;
                while (i < ks.length) {
                    vs.addAll(cross_test_client.PrimitizeRecurse(ks[i], ts[0]));
                    ++i;
                }
                i = 0;
                while (i < os.length) {
                    vs.addAll(cross_test_client.PrimitizeRecurse(os[i], ts[1]));
                    ++i;
                }
            } else if (Struct.class.isAssignableFrom(c)) {
                Object[] os = ((Struct)a).getParameters();
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                int i = 0;
                while (i < os.length) {
                    vs.addAll(cross_test_client.PrimitizeRecurse(os[i], ts[i]));
                    ++i;
                }
            } else if (Variant.class.isAssignableFrom(c)) {
                vs.addAll(cross_test_client.PrimitizeRecurse(((Variant)a).getValue(), ((Variant)a).getType()));
            }
        } else if (Variant.class.isAssignableFrom((Class)t)) {
            vs.addAll(cross_test_client.PrimitizeRecurse(((Variant)a).getValue(), ((Variant)a).getType()));
        } else if (t instanceof Class && ((Class)t).isArray()) {
            Class<?> t2 = ((Class)t).getComponentType();
            int i = 0;
            while (i < Array.getLength(a)) {
                vs.addAll(cross_test_client.PrimitizeRecurse(Array.get(a, i), t2));
                ++i;
            }
        } else {
            vs.add(new Variant<Object>(a));
        }
        return vs;
    }

    public static List<Variant<Object>> Primitize(Variant<Object> a) {
        return cross_test_client.PrimitizeRecurse(a.getValue(), a.getType());
    }

    public static void primitizeTest(DBus.Binding.Tests tests, Object input) {
        Variant<Object> in = new Variant<Object>(input);
        List<Variant<Object>> vs = cross_test_client.Primitize(in);
        try {
            List<Variant<Object>> res = tests.Primitize(in);
            if (cross_test_client.setCompareLists(res, vs)) {
                cross_test_client.pass("org.freedesktop.DBus.Binding.Tests.Primitize");
            } else {
                cross_test_client.fail("org.freedesktop.DBus.Binding.Tests.Primitize", "Wrong Return Value; expected " + cross_test_client.collapseArray(vs) + " got " + cross_test_client.collapseArray(res));
            }
        }
        catch (Exception e) {
            cross_test_client.fail("org.freedesktop.DBus.Binding.Tests.Primitize", "Exception occurred during test: (" + e.getClass().getName() + ") " + e.getMessage());
        }
    }

    public static void doTests(DBus.Peer peer, DBus.Introspectable intro, DBus.Introspectable rootintro, DBus.Binding.Tests tests, DBus.Binding.SingleTests singletests) {
        Random r = new Random();
        cross_test_client.test(DBus.Peer.class, peer, "Ping", null, new Object[0]);
        try {
            if (intro.Introspect().startsWith("<!DOCTYPE")) {
                cross_test_client.pass("org.freedesktop.DBus.Introspectable.Introspect");
            } else {
                cross_test_client.fail("org.freedesktop.DBus.Introspectable.Introspect", "Didn't get valid xml data back when introspecting /Test");
            }
        }
        catch (DBusExecutionException DBEe) {
            cross_test_client.fail("org.freedesktop.DBus.Introspectable.Introspect", "Got exception during introspection on /Test (" + DBEe.getClass().getName() + "): " + DBEe.getMessage());
        }
        try {
            if (rootintro.Introspect().startsWith("<!DOCTYPE")) {
                cross_test_client.pass("org.freedesktop.DBus.Introspectable.Introspect");
            } else {
                cross_test_client.fail("org.freedesktop.DBus.Introspectable.Introspect", "Didn't get valid xml data back when introspecting /");
            }
        }
        catch (DBusExecutionException DBEe) {
            cross_test_client.fail("org.freedesktop.DBus.Introspectable.Introspect", "Got exception during introspection on / (" + DBEe.getClass().getName() + "): " + DBEe.getMessage());
        }
        cross_test_client.test(DBus.Binding.Tests.class, tests, "Identity", new Variant<Integer>(new Integer(1)), new Variant<Integer>(new Integer(1)));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "Identity", new Variant<String>("Hello"), new Variant<String>("Hello"));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityBool", false, false);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityBool", true, true);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "Invert", false, true);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "Invert", true, false);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)0, (byte)0);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)1, (byte)1);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)-1, (byte)-1);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)127, (byte)127);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)-128, (byte)-128);
        int i = r.nextInt();
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityByte", (byte)i, (byte)i);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)0, (short)0);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)1, (short)1);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)-1, (short)-1);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)Short.MAX_VALUE, (short)Short.MAX_VALUE);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)Short.MIN_VALUE, (short)Short.MIN_VALUE);
        i = r.nextInt();
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt16", (short)i, (short)i);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt32", 0, 0);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt32", 1, 1);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt32", -1, -1);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt32", Integer.MAX_VALUE, Integer.MAX_VALUE);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt32", Integer.MIN_VALUE, Integer.MIN_VALUE);
        i = r.nextInt();
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt32", i, i);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt64", 0L, 0L);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt64", 1L, 1L);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt64", -1L, -1L);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt64", Long.MAX_VALUE, Long.MAX_VALUE);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt64", Long.MIN_VALUE, Long.MIN_VALUE);
        i = r.nextInt();
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityInt64", i, i);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(0), new UInt16(0));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(1), new UInt16(1));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(65535), new UInt16(65535));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(0), new UInt16(0));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt16", new UInt16(i % 65535), new UInt16(i % 65535));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32(0L), new UInt32(0L));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32(1L), new UInt32(1L));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32(0xFFFFFFFFL), new UInt32(0xFFFFFFFFL));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32(0L), new UInt32(0L));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt32", new UInt32((long)i % 0xFFFFFFFFL), new UInt32((long)i % 0xFFFFFFFFL));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(0L), new UInt64(0L));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(1L), new UInt64(1L));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(Long.MAX_VALUE), new UInt64(Long.MAX_VALUE));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(UInt64.MAX_BIG_VALUE), new UInt64(UInt64.MAX_BIG_VALUE));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64(0L), new UInt64(0L));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityUInt64", new UInt64((long)i % Long.MAX_VALUE), new UInt64((long)i % Long.MAX_VALUE));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityDouble", 0.0, 0.0);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityDouble", 1.0, 1.0);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityDouble", -1.0, -1.0);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityDouble", Double.MAX_VALUE, Double.MAX_VALUE);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityDouble", Double.MIN_VALUE, Double.MIN_VALUE);
        i = r.nextInt();
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityDouble", i, i);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityString", "", "");
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityString", "The Quick Brown Fox Jumped Over The Lazy Dog", "The Quick Brown Fox Jumped Over The Lazy Dog");
        cross_test_client.test(DBus.Binding.Tests.class, tests, "IdentityString", "\u3072\u3089\u304c\u306a\u30b2\u30fc\u30e0 - \u304b\u306a\u3076\u3093", "\u3072\u3089\u304c\u306a\u30b2\u30fc\u30e0 - \u304b\u306a\u3076\u3093");
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityBoolArray", Boolean.TYPE, null);
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityByteArray", Byte.TYPE, null);
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityInt16Array", Short.TYPE, null);
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityInt32Array", Integer.TYPE, null);
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityInt64Array", Long.TYPE, null);
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityDoubleArray", Double.TYPE, null);
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityArray", Variant.class, new Variant<String>("aoeu"));
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityUInt16Array", UInt16.class, new UInt16(12));
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityUInt32Array", UInt32.class, new UInt32(190L));
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityUInt64Array", UInt64.class, new UInt64(103948L));
        cross_test_client.testArray(DBus.Binding.Tests.class, tests, "IdentityStringArray", String.class, "asdf");
        int[] is = new int[]{};
        cross_test_client.test(DBus.Binding.Tests.class, tests, "Sum", 0L, new Object[]{is});
        r = new Random();
        int len = r.nextInt() % 100 + 15;
        len = (len < 0 ? -len : len) + 15;
        is = new int[len];
        long result = 0L;
        i = 0;
        while (i < len) {
            is[i] = r.nextInt();
            result += (long)is[i];
            ++i;
        }
        cross_test_client.test(DBus.Binding.Tests.class, tests, "Sum", result, new Object[]{is});
        byte[] bs = new byte[]{};
        cross_test_client.test(DBus.Binding.SingleTests.class, singletests, "Sum", new UInt32(0L), new Object[]{bs});
        len = r.nextInt() % 100;
        len = (len < 0 ? -len : len) + 15;
        bs = new byte[len];
        int res = 0;
        i = 0;
        while (i < len) {
            bs[i] = (byte)r.nextInt();
            res += bs[i] < 0 ? bs[i] + 256 : bs[i];
            ++i;
        }
        cross_test_client.test(DBus.Binding.SingleTests.class, singletests, "Sum", new UInt32((long)res % 0x100000000L), new Object[]{bs});
        cross_test_client.test(DBus.Binding.Tests.class, tests, "DeStruct", new DBus.Binding.Triplet<String, UInt32, Short>("hi", new UInt32(12L), new Short(99)), new DBus.Binding.TestStruct("hi", new UInt32(12L), new Short(99)));
        HashMap<String, String> in = new HashMap<String, String>();
        HashMap out = new HashMap();
        cross_test_client.test(DBus.Binding.Tests.class, tests, "InvertMapping", out, in);
        in.put("hi", "there");
        in.put("to", "there");
        in.put("from", "here");
        in.put("in", "out");
        Vector<String> l = new Vector<String>();
        l.add("hi");
        l.add("to");
        out.put("there", l);
        l = new Vector();
        l.add("from");
        out.put("here", l);
        l = new Vector();
        l.add("in");
        out.put("out", l);
        cross_test_client.test(DBus.Binding.Tests.class, tests, "InvertMapping", out, in);
        cross_test_client.primitizeTest(tests, new Integer(1));
        cross_test_client.primitizeTest(tests, new Variant<Variant<Variant<Variant<String>>>>(new Variant<Variant<Variant<String>>>(new Variant<Variant<String>>(new Variant<String>("Hi")))));
        cross_test_client.primitizeTest(tests, new Variant(in, new DBusMapType((Type)((Object)String.class), (Type)((Object)String.class))));
        cross_test_client.test(DBus.Binding.Tests.class, tests, "Trigger", null, "/Test", new UInt64(21389479283L));
        try {
            cross_test_client.ctc.conn.sendSignal(new DBus.Binding.TestClient.Trigger("/Test", new UInt16(15), 12.5));
        }
        catch (DBusException DBe) {
            throw new DBusExecutionException(DBe.getMessage());
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cross_test_client.test(DBus.Binding.Tests.class, tests, "Exit", null, new Object[0]);
    }

    public static void testArray(Class<? extends DBusInterface> iface, Object proxy, String method, Class<? extends Object> arrayType, Object content) {
        Object array = Array.newInstance(arrayType, 0);
        cross_test_client.test(iface, proxy, method, array, array);
        Random r = new Random();
        int l = r.nextInt() % 100;
        array = Array.newInstance(arrayType, (l < 0 ? -l : l) + 15);
        if (content != null) {
            Arrays.fill((Object[])array, content);
        }
        cross_test_client.test(iface, proxy, method, array, array);
    }

    public static void compareArray(String test4, Object a, Object b) {
        if (!a.getClass().equals(b.getClass())) {
            cross_test_client.fail(test4, "Incorrect return type; expected " + a.getClass() + " got " + b.getClass());
            return;
        }
        boolean pass = false;
        if (a instanceof Object[]) {
            pass = Arrays.equals((Object[])a, (Object[])b);
        } else if (a instanceof byte[]) {
            pass = Arrays.equals((byte[])a, (byte[])b);
        } else if (a instanceof boolean[]) {
            pass = Arrays.equals((boolean[])a, (boolean[])b);
        } else if (a instanceof int[]) {
            pass = Arrays.equals((int[])a, (int[])b);
        } else if (a instanceof short[]) {
            pass = Arrays.equals((short[])a, (short[])b);
        } else if (a instanceof long[]) {
            pass = Arrays.equals((long[])a, (long[])b);
        } else if (a instanceof double[]) {
            pass = Arrays.equals((double[])a, (double[])b);
        }
        if (pass) {
            cross_test_client.pass(test4);
        } else {
            String s = "Incorrect return value; expected ";
            s = String.valueOf(s) + cross_test_client.collapseArray(a);
            s = String.valueOf(s) + " got ";
            s = String.valueOf(s) + cross_test_client.collapseArray(b);
            cross_test_client.fail(test4, s);
        }
    }

    public static void main(String[] args) {
        try {
            DBusConnection conn = DBusConnection.getConnection(1);
            ctc = new cross_test_client(conn);
            conn.exportObject("/Test", ctc);
            conn.addSigHandler(DBus.Binding.TestSignals.Triggered.class, ctc);
            DBus.Binding.Tests tests = conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", DBus.Binding.Tests.class);
            DBus.Binding.SingleTests singletests = conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", DBus.Binding.SingleTests.class);
            DBus.Peer peer = conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", DBus.Peer.class);
            DBus.Introspectable intro = conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", DBus.Introspectable.class);
            DBus.Introspectable rootintro = conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/", DBus.Introspectable.class);
            cross_test_client.doTests(peer, intro, rootintro, tests, singletests);
            for (String s : passed) {
                System.out.println(String.valueOf(s) + " pass");
            }
            int i = 1;
            for (String s : failed.keySet()) {
                for (String r : failed.get(s)) {
                    System.out.println(String.valueOf(s) + " fail " + i);
                    System.out.println("report " + i + ": " + r);
                    ++i;
                }
            }
            conn.disconnect();
        }
        catch (DBusException DBe) {
            DBe.printStackTrace();
            System.exit(1);
        }
    }
}

