/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.List;
import java.util.Map;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.test.TestStruct2;

@DBus.Description(value="Test interface containing signals")
public interface TestSignalInterface
extends DBusInterface {

    public static class DeviceAdded
    extends DBusSignal {
        public final String value;
        public final UInt32 number;

        public DeviceAdded(String path, String value, UInt32 number) throws DBusException {
            super(path, value, number);
            this.value = value;
            this.number = number;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @DBus.Description(value="Test signal with arrays")
    public static class TestArraySignal
    extends DBusSignal {
        public final List<TestStruct2> v;

        public TestArraySignal(String path, List<TestStruct2> v) throws DBusException {
            super(path, v);
            this.v = v;
        }
    }

    @DBus.Description(value="Test signal sending an object path")
    @DBusMemberName(value="TestSignalObject")
    public static class TestObjectSignal
    extends DBusSignal {
        public final DBusInterface otherpath;

        public TestObjectSignal(String path, DBusInterface otherpath) throws DBusException {
            super(path, otherpath);
            this.otherpath = otherpath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestPathSignal
    extends DBusSignal {
        public final Path otherpath;
        public final List<Path> pathlist;
        public final Map<Path, Path> pathmap;

        public TestPathSignal(String path, Path otherpath, List<Path> pathlist, Map<Path, Path> pathmap) throws DBusException {
            super(path, otherpath, pathlist, pathmap);
            this.otherpath = otherpath;
            this.pathlist = pathlist;
            this.pathmap = pathmap;
        }
    }

    @DBus.Description(value="Test basic signal")
    public static class TestSignal
    extends DBusSignal {
        public final String value;
        public final UInt32 number;

        public TestSignal(String path, String value, UInt32 number) throws DBusException {
            super(path, value, number);
            this.value = value;
            this.number = number;
        }
    }
}

