/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.Position;

abstract class Container {
    private static Map<Type, Type[]> typecache = new HashMap<Type, Type[]>();
    private Object[] parameters = null;

    static void putTypeCache(Type k, Type[] v) {
        typecache.put(k, v);
    }

    static Type[] getTypeCache(Type k) {
        return typecache.get(k);
    }

    private void setup() {
        Field[] fs = this.getClass().getDeclaredFields();
        Object[] args = new Object[fs.length];
        int diff = 0;
        Field[] fieldArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Position p = f.getAnnotation(Position.class);
            if (p == null) {
                ++diff;
            } else {
                try {
                    args[p.value()] = f.get(this);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        this.parameters = new Object[args.length - diff];
        System.arraycopy(args, 0, this.parameters, 0, this.parameters.length);
    }

    public final Object[] getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.setup();
        return this.parameters;
    }

    public final String toString() {
        String s = String.valueOf(this.getClass().getName()) + "<";
        if (this.parameters == null) {
            this.setup();
        }
        if (this.parameters.length == 0) {
            return String.valueOf(s) + ">";
        }
        Object[] objectArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            s = String.valueOf(s) + o + ", ";
            ++n2;
        }
        return s.replaceAll(", $", ">");
    }

    public final boolean equals(Object other) {
        if (other instanceof Container) {
            Container that = (Container)other;
            if (this.getClass().equals(that.getClass())) {
                return Arrays.equals(this.getParameters(), that.getParameters());
            }
            return false;
        }
        return false;
    }
}

