/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.Gettext;

public class BusAddress {
    private String type;
    private Map<String, String> parameters;

    public BusAddress(String address) throws ParseException {
        if (address == null || "".equals(address)) {
            throw new ParseException(Gettext._("Bus address is blank"), 0);
        }
        String[] ss = address.split(":", 2);
        if (ss.length < 2) {
            throw new ParseException(String.valueOf(Gettext._("Bus address is invalid: ")) + address, 0);
        }
        this.type = ss[0];
        String[] ps = ss[1].split(",");
        this.parameters = new HashMap<String, String>();
        String[] stringArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            String[] kv = p.split("=", 2);
            this.parameters.put(kv[0], kv[1]);
            ++n2;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String toString() {
        return String.valueOf(this.type) + ": " + this.parameters;
    }
}

