/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends FilterInputStream {
    private InputStream in;
    private OutputStream fos;

    public TeeInputStream(InputStream is, OutputStream tos) throws IOException {
        super(is);
        this.in = is;
        this.fos = tos;
    }

    public TeeInputStream(InputStream is, File f, boolean append) throws IOException {
        super(is);
        this.in = is;
        this.fos = new FileOutputStream(f, append);
    }

    public TeeInputStream(InputStream is, File f) throws IOException {
        super(is);
        this.in = is;
        this.fos = new FileOutputStream(f);
    }

    public TeeInputStream(InputStream is, String f, boolean append) throws IOException {
        this(is, new File(f), append);
    }

    public TeeInputStream(InputStream is, String f) throws IOException {
        this(is, new File(f));
    }

    public void close() throws IOException {
        this.in.close();
        this.fos.close();
    }

    public void flush() throws IOException {
        this.fos.flush();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        int i = this.in.read();
        if (-1 != i) {
            this.fos.write(i);
        }
        return i;
    }

    public int read(byte[] b) throws IOException {
        int c = this.in.read(b);
        if (-1 != c) {
            this.fos.write(b, 0, c);
        }
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int c = this.in.read(b, off, len);
        if (-1 != c) {
            this.fos.write(b, off, c);
        }
        return c;
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

