/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

public class ListDBus {
    public static void syntax() {
        System.out.println("Syntax: ListDBus [--version] [-v] [--help] [-h] [--owners] [-o] [--uids] [-u] [--session] [-s] [--system] [-y]");
        System.exit(1);
    }

    public static void version() {
        System.out.println("Java D-Bus Version " + System.getProperty("Version"));
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        String[] names;
        boolean owners = false;
        boolean users = false;
        int connection = 1;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if ("--help".equals(a)) {
                ListDBus.syntax();
            } else if ("-h".equals(a)) {
                ListDBus.syntax();
            } else if ("--version".equals(a)) {
                ListDBus.version();
            } else if ("-v".equals(a)) {
                ListDBus.version();
            } else if ("-u".equals(a)) {
                users = true;
            } else if ("--uids".equals(a)) {
                users = true;
            } else if ("-o".equals(a)) {
                owners = true;
            } else if ("--owners".equals(a)) {
                owners = true;
            } else if ("--session".equals(a)) {
                connection = 1;
            } else if ("-s".equals(a)) {
                connection = 1;
            } else if ("--system".equals(a)) {
                connection = 0;
            } else if ("-y".equals(a)) {
                connection = 0;
            } else {
                ListDBus.syntax();
            }
            ++n2;
        }
        DBusConnection conn = DBusConnection.getConnection(connection);
        DBus dbus = conn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        String[] stringArray2 = names = dbus.ListNames();
        int n3 = names.length;
        int n4 = 0;
        while (n4 < n3) {
            String s = stringArray2[n4];
            if (users) {
                try {
                    System.out.print(dbus.GetConnectionUnixUser(s) + "\t");
                }
                catch (DBusExecutionException DBEe) {
                    System.out.print("\t");
                }
            }
            System.out.print(s);
            if (!s.startsWith(":") && owners) {
                try {
                    System.out.print("\t" + dbus.GetNameOwner(s));
                }
                catch (DBusExecutionException dBusExecutionException) {
                    // empty catch block
                }
            }
            System.out.println();
            ++n4;
        }
        conn.disconnect();
    }
}

