/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.bin.IdentifierMangler;
import org.freedesktop.dbus.bin.IterableNodeList;
import org.freedesktop.dbus.bin.StructStruct;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.types.DBusStructType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateInterface {
    public String comment = "";
    boolean builtin;
    private final PrintStreamFactory factory;

    private static String collapseType(Type t, Set<String> imports, Map<StructStruct, Type[]> structs, boolean container, boolean fullnames) throws DBusException {
        if (t instanceof ParameterizedType) {
            Type[] ts;
            Class c = (Class)((ParameterizedType)t).getRawType();
            if (structs != null && t instanceof DBusStructType) {
                int num = 1;
                String name = "Struct";
                while (structs.get(new StructStruct(String.valueOf(name) + num)) != null) {
                    ++num;
                }
                name = String.valueOf(name) + num;
                structs.put(new StructStruct(name), ((ParameterizedType)t).getActualTypeArguments());
                return name;
            }
            if (imports != null) {
                imports.add(c.getName());
            }
            if (fullnames) {
                return c.getName();
            }
            String s = c.getSimpleName();
            s = String.valueOf(s) + '<';
            Type[] typeArray = ts = ((ParameterizedType)t).getActualTypeArguments();
            int n = ts.length;
            int n2 = 0;
            while (n2 < n) {
                Type st = typeArray[n2];
                s = String.valueOf(s) + CreateInterface.collapseType(st, imports, structs, true, fullnames) + ',';
                ++n2;
            }
            s = s.replaceAll(",$", ">");
            return s;
        }
        if (t instanceof Class) {
            Class c = (Class)t;
            if (c.isArray()) {
                return String.valueOf(CreateInterface.collapseType(c.getComponentType(), imports, structs, container, fullnames)) + "[]";
            }
            Package p = c.getPackage();
            if (imports != null && !"java.lang".equals(p.getName())) {
                imports.add(c.getName());
            }
            if (container) {
                if (fullnames) {
                    return c.getName();
                }
                return c.getSimpleName();
            }
            try {
                Field f = c.getField("TYPE");
                Class d = (Class)f.get(c);
                return d.getSimpleName();
            }
            catch (Exception e) {
                return c.getSimpleName();
            }
        }
        return "";
    }

    private static String getJavaType(String dbus, Set<String> imports, Map<StructStruct, Type[]> structs, boolean container, boolean fullnames) throws DBusException {
        if (dbus == null || "".equals(dbus)) {
            return "";
        }
        Vector<Type> v = new Vector<Type>();
        int c = Marshalling.getJavaType(dbus, v, 1);
        Type t = v.get(0);
        return CreateInterface.collapseType(t, imports, structs, container, fullnames);
    }

    public CreateInterface(PrintStreamFactory factory, boolean builtin) {
        this.factory = factory;
        this.builtin = builtin;
    }

    String parseReturns(Vector<Element> out, Set<String> imports, Map<String, Integer> tuples, Map<StructStruct, Type[]> structs) throws DBusException {
        String[] names = new String[]{"Pair", "Triplet", "Quad", "Quintuple", "Sextuple", "Septuple"};
        String sig = "";
        String name = null;
        switch (out.size()) {
            case 0: {
                sig = String.valueOf(sig) + "void ";
                break;
            }
            case 1: {
                sig = String.valueOf(sig) + CreateInterface.getJavaType(out.get(0).getAttribute("type"), imports, structs, false, false) + " ";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                name = names[out.size() - 2];
            }
            default: {
                if (name == null) {
                    name = "NTuple" + out.size();
                }
                tuples.put(name, out.size());
                sig = String.valueOf(sig) + name + "<";
                for (Element arg : out) {
                    sig = String.valueOf(sig) + CreateInterface.getJavaType(arg.getAttribute("type"), imports, structs, true, false) + ", ";
                }
                sig = sig.replaceAll(", $", "> ");
            }
        }
        return sig;
    }

    String parseMethod(Element meth, Set<String> imports, Map<String, Integer> tuples, Map<StructStruct, Type[]> structs, Set<String> exceptions, Set<String> anns) throws DBusException {
        Vector<Element> in = new Vector<Element>();
        Vector<Element> out = new Vector<Element>();
        if (meth.getAttribute("name") == null || "".equals(meth.getAttribute("name"))) {
            System.err.println(Gettext._("ERROR: Method name was blank, failed"));
            System.exit(1);
        }
        String annotations = "";
        String throwses = null;
        for (Node a : new IterableNodeList(meth.getChildNodes())) {
            if (1 != a.getNodeType()) continue;
            CreateInterface.checkNode(a, "arg", "annotation");
            if ("arg".equals(a.getNodeName())) {
                Element arg = (Element)a;
                if ("out".equals(arg.getAttribute("direction"))) {
                    out.add(arg);
                    continue;
                }
                in.add(arg);
                continue;
            }
            if (!"annotation".equals(a.getNodeName())) continue;
            Element e = (Element)a;
            if (e.getAttribute("name").equals("org.freedesktop.DBus.Method.Error")) {
                throwses = throwses == null ? e.getAttribute("value") : String.valueOf(throwses) + ", " + e.getAttribute("value");
                exceptions.add(e.getAttribute("value"));
                continue;
            }
            annotations = String.valueOf(annotations) + this.parseAnnotation(e, imports, anns);
        }
        String sig = "";
        this.comment = "";
        sig = String.valueOf(sig) + this.parseReturns(out, imports, tuples, structs);
        sig = String.valueOf(sig) + IdentifierMangler.mangle(meth.getAttribute("name")) + "(";
        char defaultname = 'a';
        String params = "";
        for (Element arg : in) {
            String type = CreateInterface.getJavaType(arg.getAttribute("type"), imports, structs, false, false);
            String name = arg.getAttribute("name");
            if (name == null || "".equals(name)) {
                char c = defaultname;
                defaultname = (char)(c + 1);
                name = "" + c;
            }
            params = String.valueOf(params) + type + " " + IdentifierMangler.mangle(name) + ", ";
        }
        return String.valueOf("".equals(this.comment) ? "" : "   /**\n" + this.comment + "   */\n") + annotations + "  public " + sig + params.replaceAll("..$", "") + ")" + (throwses == null ? "" : " throws " + throwses) + ";";
    }

    String parseSignal(Element signal, Set<String> imports, Map<StructStruct, Type[]> structs, Set<String> anns) throws DBusException {
        HashMap<String, String> params = new HashMap<String, String>();
        Vector<String> porder = new Vector<String>();
        char defaultname = 'a';
        imports.add("org.freedesktop.dbus.DBusSignal");
        imports.add("org.freedesktop.dbus.exceptions.DBusException");
        String annotations = "";
        for (Node a : new IterableNodeList(signal.getChildNodes())) {
            if (1 != a.getNodeType()) continue;
            CreateInterface.checkNode(a, "arg", "annotation");
            if ("annotation".equals(a.getNodeName())) {
                annotations = String.valueOf(annotations) + this.parseAnnotation((Element)a, imports, anns);
                continue;
            }
            Element arg = (Element)a;
            String type = CreateInterface.getJavaType(arg.getAttribute("type"), imports, structs, false, false);
            String name = arg.getAttribute("name");
            if (name == null || "".equals(name)) {
                char c = defaultname;
                defaultname = (char)(c + 1);
                name = "" + c;
            }
            params.put(IdentifierMangler.mangle(name), type);
            porder.add(IdentifierMangler.mangle(name));
        }
        String out = "";
        out = String.valueOf(out) + annotations;
        out = String.valueOf(out) + "   public static class " + signal.getAttribute("name");
        out = String.valueOf(out) + " extends DBusSignal\n   {\n";
        for (String name : porder) {
            out = String.valueOf(out) + "      public final " + (String)params.get(name) + " " + name + ";\n";
        }
        out = String.valueOf(out) + "      public " + signal.getAttribute("name") + "(String path";
        for (String name : porder) {
            out = String.valueOf(out) + ", " + (String)params.get(name) + " " + name;
        }
        out = String.valueOf(out) + ") throws DBusException\n      {\n         super(path";
        for (String name : porder) {
            out = String.valueOf(out) + ", " + name;
        }
        out = String.valueOf(out) + ");\n";
        for (String name : porder) {
            out = String.valueOf(out) + "         this." + name + " = " + name + ";\n";
        }
        out = String.valueOf(out) + "      }\n";
        out = String.valueOf(out) + "   }\n";
        return out;
    }

    String parseAnnotation(Element ann, Set<String> imports, Set<String> annotations) {
        String s = "  @" + ann.getAttribute("name").replaceAll(".*\\.([^.]*)$", "$1") + "(";
        if (ann.getAttribute("value") != null && !"".equals(ann.getAttribute("value"))) {
            s = String.valueOf(s) + '\"' + ann.getAttribute("value") + '\"';
        }
        imports.add(ann.getAttribute("name"));
        annotations.add(ann.getAttribute("name"));
        s = String.valueOf(s) + ")\n";
        return s;
    }

    void parseInterface(Element iface, PrintStream out, Map<String, Integer> tuples, Map<StructStruct, Type[]> structs, Set<String> exceptions, Set<String> anns) throws DBusException {
        if (iface.getAttribute("name") == null || "".equals(iface.getAttribute("name"))) {
            System.err.println(Gettext._("ERROR: Interface name was blank, failed"));
            System.exit(1);
        }
        out.println("package " + iface.getAttribute("name").replaceAll("\\.[^.]*$", "") + ";");
        String methods = "";
        String signals = "";
        String annotations = "";
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("org.freedesktop.dbus.DBusInterface");
        for (Node meth : new IterableNodeList(iface.getChildNodes())) {
            if (1 != meth.getNodeType()) continue;
            CreateInterface.checkNode(meth, "method", "signal", "property", "annotation");
            if ("method".equals(meth.getNodeName())) {
                methods = String.valueOf(methods) + this.parseMethod((Element)meth, imports, tuples, structs, exceptions, anns) + "\n";
                continue;
            }
            if ("signal".equals(meth.getNodeName())) {
                signals = String.valueOf(signals) + this.parseSignal((Element)meth, imports, structs, anns);
                continue;
            }
            if ("property".equals(meth.getNodeName())) {
                System.err.println("WARNING: Ignoring property");
                continue;
            }
            if (!"annotation".equals(meth.getNodeName())) continue;
            annotations = String.valueOf(annotations) + this.parseAnnotation((Element)meth, imports, anns);
        }
        if (imports.size() > 0) {
            for (String i : imports) {
                out.println("import " + i + ";");
            }
        }
        out.print(annotations);
        out.print("public interface " + iface.getAttribute("name").replaceAll("^.*\\.([^.]*)$", "$1"));
        out.println(" extends DBusInterface");
        out.println("{");
        out.println(signals);
        out.println(methods);
        out.println("}");
    }

    void createException(String name, String pack, PrintStream out) throws DBusException {
        out.println("package " + pack + ";");
        out.println("import org.freedesktop.dbus.DBusExecutionException;");
        out.print("public class " + name);
        out.println(" extends DBusExecutionException");
        out.println("{");
        out.println("   public " + name + "(String message)");
        out.println("   {");
        out.println("      super(message);");
        out.println("   }");
        out.println("}");
    }

    void createAnnotation(String name, String pack, PrintStream out) throws DBusException {
        out.println("package " + pack + ";");
        out.println("import java.lang.annotation.Retention;");
        out.println("import java.lang.annotation.RetentionPolicy;");
        out.println("@Retention(RetentionPolicy.RUNTIME)");
        out.println("public @interface " + name);
        out.println("{");
        out.println("   String value();");
        out.println("}");
    }

    void createStruct(String name, Type[] type, String pack, PrintStream out, Map<StructStruct, Type[]> existing) throws DBusException, IOException {
        out.println("package " + pack + ";");
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("org.freedesktop.dbus.Position");
        imports.add("org.freedesktop.dbus.Struct");
        Map<StructStruct, Type[]> structs = new HashMap<StructStruct, Type[]>(existing);
        String[] types = new String[type.length];
        int i = 0;
        while (i < type.length) {
            types[i] = CreateInterface.collapseType(type[i], imports, structs, false, false);
            ++i;
        }
        for (String im : imports) {
            out.println("import " + im + ";");
        }
        out.println("public final class " + name + " extends Struct");
        out.println("{");
        i = 0;
        char c = 'a';
        String params = "";
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            out.println("   @Position(" + i++ + ")");
            out.println("   public final " + t + " " + c + ";");
            params = String.valueOf(params) + t + " " + c + ", ";
            c = (char)(c + '\u0001');
            ++n2;
        }
        out.println("  public " + name + "(" + params.replaceAll("..$", "") + ")");
        out.println("  {");
        char d = 'a';
        while (d < c) {
            out.println("   this." + d + " = " + d + ";");
            d = (char)(d + '\u0001');
        }
        out.println("  }");
        out.println("}");
        structs = StructStruct.fillPackages(structs, pack);
        HashMap<StructStruct, Type[]> tocreate = new HashMap<StructStruct, Type[]>(structs);
        for (StructStruct ss : existing.keySet()) {
            tocreate.remove(ss);
        }
        this.createStructs(tocreate, structs);
    }

    void createTuple(String name, int num, String pack, PrintStream out) throws DBusException {
        out.println("package " + pack + ";");
        out.println("import org.freedesktop.dbus.Position;");
        out.println("import org.freedesktop.dbus.Tuple;");
        out.println("/** Just a typed container class */");
        out.print("public final class " + name);
        String types = " <";
        char v = 'A';
        while (v < 65 + num) {
            types = String.valueOf(types) + v + ",";
            v = (char)(v + '\u0001');
        }
        out.print(types.replaceAll(",$", "> "));
        out.println("extends Tuple");
        out.println("{");
        char t = 'A';
        char n = 'a';
        int i = 0;
        while (i < num) {
            out.println("   @Position(" + i + ")");
            out.println("   public final " + t + " " + n + ";");
            ++i;
            t = (char)(t + '\u0001');
            n = (char)(n + '\u0001');
        }
        out.print("   public " + name + "(");
        String sig = "";
        t = 'A';
        n = 'a';
        int i2 = 0;
        while (i2 < num) {
            sig = String.valueOf(sig) + t + " " + n + ", ";
            ++i2;
            t = (char)(t + '\u0001');
            n = (char)(n + '\u0001');
        }
        out.println(sig.replaceAll(", $", ")"));
        out.println("   {");
        char v2 = 'a';
        while (v2 < 97 + num) {
            out.println("      this." + v2 + " = " + v2 + ";");
            v2 = (char)(v2 + '\u0001');
        }
        out.println("   }");
        out.println("}");
    }

    void parseRoot(Element root) throws DBusException, IOException {
        Map<StructStruct, Type[]> structs = new HashMap<StructStruct, Type[]>();
        TreeSet<String> exceptions = new TreeSet<String>();
        TreeSet<String> annotations = new TreeSet<String>();
        for (Node iface : new IterableNodeList(root.getChildNodes())) {
            if (1 != iface.getNodeType()) continue;
            CreateInterface.checkNode(iface, "interface", "node");
            if ("interface".equals(iface.getNodeName())) {
                HashMap<String, Integer> tuples = new HashMap<String, Integer>();
                String name = ((Element)iface).getAttribute("name");
                String file = String.valueOf(name.replaceAll("\\.", "/")) + ".java";
                String path = file.replaceAll("/[^/]*$", "");
                String pack = name.replaceAll("\\.[^.]*$", "");
                if (pack.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
                this.factory.init(file, path);
                this.parseInterface((Element)iface, this.factory.createPrintStream(file), tuples, structs, exceptions, annotations);
                structs = StructStruct.fillPackages(structs, pack);
                this.createTuples(tuples, pack);
                continue;
            }
            if ("node".equals(iface.getNodeName())) {
                this.parseRoot((Element)iface);
                continue;
            }
            System.err.println(String.valueOf(Gettext._("ERROR: Unknown node: ")) + iface.getNodeName());
            System.exit(1);
        }
        this.createStructs(structs, structs);
        this.createExceptions(exceptions);
        this.createAnnotations(annotations);
    }

    private void createAnnotations(Set<String> annotations) throws DBusException, IOException {
        for (String fqn : annotations) {
            String name = fqn.replaceAll("^.*\\.([^.]*)$", "$1");
            String pack = fqn.replaceAll("\\.[^.]*$", "");
            if (pack.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
            String path = pack.replaceAll("\\.", "/");
            String file = String.valueOf(name.replaceAll("\\.", "/")) + ".java";
            this.factory.init(file, path);
            this.createAnnotation(name, pack, this.factory.createPrintStream(path, name));
        }
    }

    private void createExceptions(Set<String> exceptions) throws DBusException, IOException {
        for (String fqn : exceptions) {
            String name = fqn.replaceAll("^.*\\.([^.]*)$", "$1");
            String pack = fqn.replaceAll("\\.[^.]*$", "");
            if (pack.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
            String path = pack.replaceAll("\\.", "/");
            String file = String.valueOf(name.replaceAll("\\.", "/")) + ".java";
            this.factory.init(file, path);
            this.createException(name, pack, this.factory.createPrintStream(path, name));
        }
    }

    private void createStructs(Map<StructStruct, Type[]> structs, Map<StructStruct, Type[]> existing) throws DBusException, IOException {
        for (StructStruct ss : structs.keySet()) {
            String file = String.valueOf(ss.name.replaceAll("\\.", "/")) + ".java";
            String path = ss.pack.replaceAll("\\.", "/");
            this.factory.init(file, path);
            this.createStruct(ss.name, structs.get(ss), ss.pack, this.factory.createPrintStream(path, ss.name), existing);
        }
    }

    private void createTuples(Map<String, Integer> typeMap, String pack) throws DBusException, IOException {
        for (String tname : typeMap.keySet()) {
            this.createTuple(tname, typeMap.get(tname), pack, this.factory.createPrintStream(pack.replaceAll("\\.", "/"), tname));
        }
    }

    static void checkNode(Node n, String ... names) {
        String expected = "";
        String[] stringArray = names;
        int n2 = names.length;
        int n3 = 0;
        while (n3 < n2) {
            String name = stringArray[n3];
            if (name.equals(n.getNodeName())) {
                return;
            }
            expected = String.valueOf(expected) + name + " or ";
            ++n3;
        }
        System.err.println(MessageFormat.format(Gettext._("ERROR: Expected {0}, got {1}, failed."), expected.replaceAll("....$", ""), n.getNodeName()));
        System.exit(1);
    }

    static void printSyntax() {
        CreateInterface.printSyntax(System.err);
    }

    static void printSyntax(PrintStream o) {
        o.println("Syntax: CreateInterface <options> [file | busname object]");
        o.println("        Options: --no-ignore-builtin --system -y --session -s --create-files -f --help -h --version -v");
    }

    public static void version() {
        System.out.println("Java D-Bus Version " + System.getProperty("Version"));
        System.exit(1);
    }

    static Config parseParams(String[] args) {
        Config config = new Config();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if ("--system".equals(p) || "-y".equals(p)) {
                config.bus = 0;
            } else if ("--session".equals(p) || "-s".equals(p)) {
                config.bus = 1;
            } else if ("--no-ignore-builtin".equals(p)) {
                config.builtin = true;
            } else if ("--create-files".equals(p) || "-f".equals(p)) {
                config.fileout = true;
            } else if ("--print-tree".equals(p) || "-p".equals(p)) {
                config.printtree = true;
            } else if ("--help".equals(p) || "-h".equals(p)) {
                CreateInterface.printSyntax(System.out);
                System.exit(0);
            } else if ("--version".equals(p) || "-v".equals(p)) {
                CreateInterface.version();
                System.exit(0);
            } else if (p.startsWith("-")) {
                System.err.println(String.valueOf(Gettext._("ERROR: Unknown option: ")) + p);
                CreateInterface.printSyntax();
                System.exit(1);
            } else if (config.busname == null) {
                config.busname = p;
            } else if (config.object == null) {
                config.object = p;
            } else {
                CreateInterface.printSyntax();
                System.exit(1);
            }
            ++n2;
        }
        if (config.busname == null) {
            CreateInterface.printSyntax();
            System.exit(1);
        } else if (config.object == null) {
            config.datafile = new File(config.busname);
            config.busname = null;
        }
        return config;
    }

    public static void main(String[] args) throws Exception {
        Config config = CreateInterface.parseParams(args);
        Reader introspectdata = null;
        if (config.busname != null) {
            try {
                DBusConnection conn = DBusConnection.getConnection(config.bus);
                DBus.Introspectable in = conn.getRemoteObject(config.busname, config.object, DBus.Introspectable.class);
                String id = in.Introspect();
                if (id == null) {
                    System.err.println(Gettext._("ERROR: Failed to get introspection data"));
                    System.exit(1);
                }
                introspectdata = new StringReader(id);
                conn.disconnect();
            }
            catch (DBusException DBe) {
                System.err.println(String.valueOf(Gettext._("ERROR: Failure in DBus Communications: ")) + DBe.getMessage());
                System.exit(1);
            }
            catch (DBusExecutionException DEe) {
                System.err.println(String.valueOf(Gettext._("ERROR: Failure in DBus Communications: ")) + DEe.getMessage());
                System.exit(1);
            }
        } else if (config.datafile != null) {
            try {
                introspectdata = new InputStreamReader(new FileInputStream(config.datafile));
            }
            catch (FileNotFoundException FNFe) {
                System.err.println(String.valueOf(Gettext._("ERROR: Could not find introspection file: ")) + FNFe.getMessage());
                System.exit(1);
            }
        }
        try {
            PrintStreamFactory factory = config.fileout ? new FileStreamFactory() : new ConsoleStreamFactory();
            CreateInterface createInterface = new CreateInterface(factory, config.builtin);
            createInterface.createInterface(introspectdata);
        }
        catch (DBusException DBe) {
            System.err.println("ERROR: " + DBe.getMessage());
            System.exit(1);
        }
    }

    public void createInterface(Reader introspectdata) throws ParserConfigurationException, SAXException, IOException, DBusException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(introspectdata));
        Element root = document.getDocumentElement();
        CreateInterface.checkNode(root, "node");
        this.parseRoot(root);
    }

    static class Config {
        int bus = 1;
        String busname = null;
        String object = null;
        File datafile = null;
        boolean printtree = false;
        boolean fileout = false;
        boolean builtin = false;

        Config() {
        }
    }

    static class ConsoleStreamFactory
    extends PrintStreamFactory {
        ConsoleStreamFactory() {
        }

        public void init(String file, String path) {
        }

        public PrintStream createPrintStream(String file) throws IOException {
            System.out.println("/* File: " + file + " */");
            return System.out;
        }

        public PrintStream createPrintStream(String path, String tname) throws IOException {
            return super.createPrintStream(path, tname);
        }
    }

    static class FileStreamFactory
    extends PrintStreamFactory {
        FileStreamFactory() {
        }

        public void init(String file, String path) {
            new File(path).mkdirs();
        }

        public PrintStream createPrintStream(String file) throws IOException {
            return new PrintStream(new FileOutputStream(file));
        }
    }

    public static abstract class PrintStreamFactory {
        public abstract void init(String var1, String var2);

        public PrintStream createPrintStream(String path, String tname) throws IOException {
            String file = String.valueOf(path) + "/" + tname + ".java";
            return this.createPrintStream(file);
        }

        public abstract PrintStream createPrintStream(String var1) throws IOException;
    }
}

