/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Vector;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variant<T> {
    private final T o;
    private final Type type;
    private final String sig;

    public Variant(T o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException(Gettext._("Can't wrap Null in a Variant"));
        }
        this.type = o.getClass();
        try {
            String[] ss = Marshalling.getDBusType(o.getClass(), true);
            if (ss.length != 1) {
                throw new IllegalArgumentException(String.valueOf(Gettext._("Can't wrap a multi-valued type in a Variant: ")) + this.type);
            }
            this.sig = ss[0];
        }
        catch (DBusException DBe) {
            throw new IllegalArgumentException(MessageFormat.format(Gettext._("Can't wrap {0} in an unqualified Variant ({1})."), o.getClass(), DBe.getMessage()));
        }
        this.o = o;
    }

    public Variant(T o, Type type) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException(Gettext._("Can't wrap Null in a Variant"));
        }
        this.type = type;
        try {
            String[] ss = Marshalling.getDBusType(type);
            if (ss.length != 1) {
                throw new IllegalArgumentException(String.valueOf(Gettext._("Can't wrap a multi-valued type in a Variant: ")) + type);
            }
            this.sig = ss[0];
        }
        catch (DBusException DBe) {
            throw new IllegalArgumentException(MessageFormat.format(Gettext._("Can't wrap {0} in an unqualified Variant ({1})."), type, DBe.getMessage()));
        }
        this.o = o;
    }

    public Variant(T o, String sig) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException(Gettext._("Can't wrap Null in a Variant"));
        }
        this.sig = sig;
        try {
            Vector<Type> ts = new Vector<Type>();
            Marshalling.getJavaType(sig, ts, 1);
            if (ts.size() != 1) {
                throw new IllegalArgumentException(String.valueOf(Gettext._("Can't wrap multiple or no types in a Variant: ")) + sig);
            }
            this.type = ts.get(0);
        }
        catch (DBusException DBe) {
            throw new IllegalArgumentException(MessageFormat.format(Gettext._("Can't wrap {0} in an unqualified Variant ({1})."), sig, DBe.getMessage()));
        }
        this.o = o;
    }

    public T getValue() {
        return this.o;
    }

    public Type getType() {
        return this.type;
    }

    public String getSig() {
        return this.sig;
    }

    public String toString() {
        return "[" + this.o + "]";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Variant)) {
            return false;
        }
        return this.o.equals(((Variant)other).o);
    }
}

