/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.regex.Pattern;
import org.freedesktop.dbus.ExportedObject;

class ObjectTree {
    private TreeNode root = new TreeNode("");
    public static final Pattern slashpattern = Pattern.compile("/");

    private TreeNode recursiveFind(TreeNode current, String path) {
        if ("/".equals(path)) {
            return current;
        }
        String[] elements = path.split("/", 2);
        if (path.startsWith(current.name)) {
            if (path.equals(current.name)) {
                return current;
            }
            if (current.down == null) {
                return null;
            }
            return this.recursiveFind(current.down, elements[1]);
        }
        if (current.right == null) {
            return null;
        }
        if (current.right.name.compareTo(elements[0]) < 0) {
            return null;
        }
        return this.recursiveFind(current.right, path);
    }

    private TreeNode recursiveAdd(TreeNode current, String path, ExportedObject object, String data) {
        String[] elements = slashpattern.split(path, 2);
        if (path.startsWith(current.name)) {
            if (1 == elements.length || "".equals(elements[1])) {
                current.object = object;
                current.data = data;
            } else {
                if (current.down == null) {
                    String[] el = elements[1].split("/", 2);
                    current.down = new TreeNode(el[0]);
                }
                current.down = this.recursiveAdd(current.down, elements[1], object, data);
            }
        } else if (current.right == null) {
            current.right = new TreeNode(elements[0]);
            current.right = this.recursiveAdd(current.right, path, object, data);
        } else if (current.right.name.compareTo(elements[0]) < 0) {
            TreeNode t = new TreeNode(elements[0]);
            t.right = current.right;
            current.right = t;
            current.right = this.recursiveAdd(current.right, path, object, data);
        } else {
            current.right = this.recursiveAdd(current.right, path, object, data);
        }
        return current;
    }

    public void add(String path, ExportedObject object, String data) {
        this.root = this.recursiveAdd(this.root, path, object, data);
    }

    public void remove(String path) {
        TreeNode t = this.recursiveFind(this.root, path);
        t.object = null;
        t.data = null;
    }

    public String Introspect(String path) {
        TreeNode t = this.recursiveFind(this.root, path);
        if (t == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<node name=\"");
        sb.append(path);
        sb.append("\">\n");
        if (t.data != null) {
            sb.append(t.data);
        }
        t = t.down;
        while (t != null) {
            sb.append("<node name=\"");
            sb.append(t.name);
            sb.append("\"/>\n");
            t = t.right;
        }
        sb.append("</node>");
        return sb.toString();
    }

    private String recursivePrint(TreeNode current) {
        String s = "";
        if (current != null) {
            s = String.valueOf(s) + current.name;
            if (current.object != null) {
                s = String.valueOf(s) + "*";
            }
            if (current.down != null) {
                s = String.valueOf(s) + "/{" + this.recursivePrint(current.down) + "}";
            }
            if (current.right != null) {
                s = String.valueOf(s) + ", " + this.recursivePrint(current.right);
            }
        }
        return s;
    }

    public String toString() {
        return this.recursivePrint(this.root);
    }

    class TreeNode {
        String name;
        ExportedObject object;
        String data;
        TreeNode right;
        TreeNode down;

        public TreeNode(String name) {
            this.name = name;
        }

        public TreeNode(String name, ExportedObject object, String data) {
            this.name = name;
            this.object = object;
            this.data = data;
        }
    }
}

