/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.freedesktop.dbus.Gettext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayFrob {
    static Hashtable<Class<? extends Object>, Class<? extends Object>> primitiveToWrapper = new Hashtable();
    static Hashtable<Class<? extends Object>, Class<? extends Object>> wrapperToPrimitive = new Hashtable();

    static {
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
    }

    ArrayFrob() {
    }

    public static <T> T[] wrap(Object o) throws IllegalArgumentException {
        Class<?> ac = o.getClass();
        if (!ac.isArray()) {
            throw new IllegalArgumentException(Gettext._("Not an array"));
        }
        Class<?> cc = ac.getComponentType();
        Class<? extends Object> ncc = primitiveToWrapper.get(cc);
        if (ncc == null) {
            throw new IllegalArgumentException(Gettext._("Not a primitive type"));
        }
        Object[] ns = (Object[])Array.newInstance(ncc, Array.getLength(o));
        int i = 0;
        while (i < ns.length) {
            ns[i] = Array.get(o, i);
            ++i;
        }
        return ns;
    }

    public static <T> Object unwrap(T[] ns) throws IllegalArgumentException {
        Class<?> ac = ns.getClass();
        Class<?> cc = ac.getComponentType();
        Class<? extends Object> ncc = wrapperToPrimitive.get(cc);
        if (ncc == null) {
            throw new IllegalArgumentException(Gettext._("Not a wrapper type"));
        }
        Object o = Array.newInstance(ncc, ns.length);
        int i = 0;
        while (i < ns.length) {
            Array.set(o, i, ns[i]);
            ++i;
        }
        return o;
    }

    public static <T> List<T> listify(T[] ns) throws IllegalArgumentException {
        return Arrays.asList(ns);
    }

    public static <T> List<T> listify(Object o) throws IllegalArgumentException {
        if (o instanceof Object[]) {
            return ArrayFrob.listify((Object[])o);
        }
        if (!o.getClass().isArray()) {
            throw new IllegalArgumentException(Gettext._("Not an array"));
        }
        ArrayList<Object> l = new ArrayList<Object>(Array.getLength(o));
        int i = 0;
        while (i < Array.getLength(o)) {
            l.add(Array.get(o, i));
            ++i;
        }
        return l;
    }

    public static <T> T[] delist(List<T> l, Class<T> c) throws IllegalArgumentException {
        return l.toArray((Object[])Array.newInstance(c, 0));
    }

    public static <T> Object delistprimitive(List<T> l, Class<T> c) throws IllegalArgumentException {
        Object o = Array.newInstance(c, l.size());
        int i = 0;
        while (i < l.size()) {
            Array.set(o, i, l.get(i));
            ++i;
        }
        return o;
    }

    public static Object convert(Object o, Class<? extends Object> c) throws IllegalArgumentException {
        try {
            if (List.class.equals(c) && o instanceof List) {
                return o;
            }
            if (List.class.equals(c) && o.getClass().isArray()) {
                return ArrayFrob.listify(o);
            }
            if (o.getClass().isArray() && c.isArray() && o.getClass().getComponentType().equals(c.getComponentType())) {
                return o;
            }
            if (o.getClass().isArray() && c.isArray() && o.getClass().getComponentType().isPrimitive()) {
                return ArrayFrob.wrap(o);
            }
            if (o.getClass().isArray() && c.isArray() && c.getComponentType().isPrimitive()) {
                return ArrayFrob.unwrap((Object[])o);
            }
            if (o instanceof List && c.isArray() && c.getComponentType().isPrimitive()) {
                return ArrayFrob.delistprimitive((List)o, c.getComponentType());
            }
            if (o instanceof List && c.isArray()) {
                return ArrayFrob.delist((List)o, c.getComponentType());
            }
            if (o.getClass().isArray() && c.isArray()) {
                return ArrayFrob.type((Object[])o, c.getComponentType());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException(MessageFormat.format(Gettext._("Not An Expected Convertion type from {0} to {1}"), o.getClass(), c));
    }

    public static Object[] type(Object[] old, Class<Object> c) {
        Object[] ns = (Object[])Array.newInstance(c, old.length);
        int i = 0;
        while (i < ns.length) {
            ns[i] = old[i];
            ++i;
        }
        return ns;
    }
}

