/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.debug.Debug;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.freedesktop.DBus;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.CallbackHandler;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.EfficientMap;
import org.freedesktop.dbus.EfficientQueue;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.ObjectTree;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalDBusException;
import org.freedesktop.dbus.exceptions.FatalException;
import org.freedesktop.dbus.exceptions.NotConnected;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnection {
    protected static final int TIMEOUT = 100000;
    private static final int PENDING_MAP_INITIAL_SIZE = 10;
    static final String BUSNAME_REGEX = "^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$";
    static final String CONNID_REGEX = "^:[0-9]*\\.[0-9]*$";
    static final String OBJECT_REGEX = "^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$";
    static final byte THREADCOUNT = 4;
    static final int MAX_ARRAY_LENGTH = 0x4000000;
    static final int MAX_NAME_LENGTH = 255;
    protected Map<String, ExportedObject> exportedObjects = new HashMap<String, ExportedObject>();
    private ObjectTree objectTree;
    private _globalhandler _globalhandlerreference;
    protected Map<DBusInterface, RemoteObject> importedObjects = new HashMap<DBusInterface, RemoteObject>();
    protected Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> handledSignals;
    protected EfficientMap pendingCalls;
    protected Map<MethodCall, CallbackHandler<? extends Object>> pendingCallbacks;
    protected Map<MethodCall, DBusAsyncReply<? extends Object>> pendingCallbackReplys;
    protected LinkedList<Runnable> runnables;
    protected LinkedList<_workerthread> workers;
    protected FallbackContainer fallbackcontainer;
    protected boolean _run;
    EfficientQueue outgoing;
    LinkedList<Error> pendingErrors;
    private static final Map<Thread, DBusCallInfo> infomap = new HashMap<Thread, DBusCallInfo>();
    protected _thread thread;
    protected _sender sender;
    protected Transport transport;
    protected String addr;
    protected boolean weakreferences = false;
    static final Pattern dollar_pattern = Pattern.compile("[$]");
    public static final boolean EXCEPTION_DEBUG;
    static final boolean FLOAT_SUPPORT;
    protected boolean connected = false;

    static {
        FLOAT_SUPPORT = System.getenv("DBUS_JAVA_FLOATS") != null;
        boolean bl = EXCEPTION_DEBUG = System.getenv("DBUS_JAVA_EXCEPTION_DEBUG") != null;
        if (EXCEPTION_DEBUG) {
            Debug.print("Debugging of internal exceptions enabled");
            Debug.setThrowableTraces(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractConnection(String address) throws DBusException {
        this._globalhandlerreference = new _globalhandler();
        Object object = this.exportedObjects;
        synchronized (object) {
            this.exportedObjects.put(null, new ExportedObject(this._globalhandlerreference, this.weakreferences));
        }
        this.handledSignals = new HashMap<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>>();
        this.pendingCalls = new EfficientMap(10);
        this.outgoing = new EfficientQueue(10);
        this.pendingCallbacks = new HashMap<MethodCall, CallbackHandler<? extends Object>>();
        this.pendingCallbackReplys = new HashMap<MethodCall, DBusAsyncReply<? extends Object>>();
        this.pendingErrors = new LinkedList();
        this.runnables = new LinkedList();
        this.workers = new LinkedList();
        this.objectTree = new ObjectTree();
        this.fallbackcontainer = new FallbackContainer();
        object = this.workers;
        synchronized (object) {
            int i = 0;
            while (i < 4) {
                _workerthread t = new _workerthread();
                t.start();
                this.workers.add(t);
                ++i;
            }
        }
        this._run = true;
        this.addr = address;
    }

    protected void listen() {
        this.thread = new _thread();
        this.thread.start();
        this.sender = new _sender();
        this.sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeThreadCount(byte newcount) {
        LinkedList<_workerthread> linkedList = this.workers;
        synchronized (linkedList) {
            if (this.workers.size() > newcount) {
                int n = this.workers.size() - newcount;
                int i = 0;
                while (i < n) {
                    _workerthread t = this.workers.removeFirst();
                    t.halt();
                    ++i;
                }
            } else if (this.workers.size() < newcount) {
                int n = newcount - this.workers.size();
                int i = 0;
                while (i < n) {
                    _workerthread t = new _workerthread();
                    t.start();
                    this.workers.add(t);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunnable(Runnable r) {
        LinkedList<Runnable> linkedList = this.runnables;
        synchronized (linkedList) {
            this.runnables.add(r);
            this.runnables.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getExportedObject(DBusInterface i) throws DBusException {
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            for (String s : this.exportedObjects.keySet()) {
                if (!i.equals(this.exportedObjects.get((Object)s).object.get())) continue;
                return s;
            }
        }
        String s = this.importedObjects.get((Object)i).objectpath;
        if (s != null) {
            return s;
        }
        throw new DBusException("Not an object exported or imported by this connection");
    }

    abstract DBusInterface getExportedObject(String var1, String var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusCallInfo getCallInfo() {
        DBusCallInfo info;
        Map<Thread, DBusCallInfo> map = infomap;
        synchronized (map) {
            info = infomap.get(Thread.currentThread());
        }
        return info;
    }

    public void setWeakReferences(boolean weakreferences) {
        this.weakreferences = weakreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(String objectpath, DBusInterface object) throws DBusException {
        if (objectpath == null || "".equals(objectpath)) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            if (this.exportedObjects.get(objectpath) != null) {
                throw new DBusException("Object already exported");
            }
            ExportedObject eo = new ExportedObject(object, this.weakreferences);
            this.exportedObjects.put(objectpath, eo);
            this.objectTree.add(objectpath, eo, eo.introspectiondata);
        }
    }

    public void addFallback(String objectprefix, DBusInterface object) throws DBusException {
        if (objectprefix == null || "".equals(objectprefix)) {
            throw new DBusException("Must Specify an Object Path");
        }
        if (!objectprefix.matches(OBJECT_REGEX) || objectprefix.length() > 255) {
            throw new DBusException("Invalid object path: " + objectprefix);
        }
        ExportedObject eo = new ExportedObject(object, this.weakreferences);
        this.fallbackcontainer.add(objectprefix, eo);
    }

    public void removeFallback(String objectprefix) {
        this.fallbackcontainer.remove(objectprefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unExportObject(String objectpath) {
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            this.exportedObjects.remove(objectpath);
            this.objectTree.remove(objectpath);
        }
    }

    public void sendSignal(DBusSignal signal) {
        this.queueOutgoing(signal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueOutgoing(Message m) {
        EfficientQueue efficientQueue = this.outgoing;
        synchronized (efficientQueue) {
            if (this.outgoing == null) {
                return;
            }
            this.outgoing.add(m);
            this.outgoing.notifyAll();
        }
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.removeSigHandler(new DBusMatchRule(type), handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        String objectpath = this.importedObjects.get((Object)object).objectpath;
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(type, null, objectpath), handler);
    }

    protected abstract <T extends DBusSignal> void removeSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    public <T extends DBusSignal> void addSigHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        this.addSigHandler(new DBusMatchRule(type), handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        String objectpath = this.importedObjects.get((Object)object).objectpath;
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(type, null, objectpath), handler);
    }

    protected abstract <T extends DBusSignal> void addSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DBusSignal> void addSigHandlerWithoutMatch(Class<? extends DBusSignal> signal, DBusSigHandler<T> handler) throws DBusException {
        DBusMatchRule rule = new DBusMatchRule(signal);
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<DBusSignal>> v = this.handledSignals.get(key);
            if (v == null) {
                v = new Vector();
                v.add(handler);
                this.handledSignals.put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        LinkedList<Runnable> linkedList;
        this.connected = false;
        try {
            this.handleMessage(new DBus.Local.Disconnected("/"));
        }
        catch (Exception exception) {}
        while (this.runnables.size() > 0) {
            linkedList = this.runnables;
            synchronized (linkedList) {
                this.runnables.notifyAll();
            }
        }
        this._run = false;
        linkedList = this.outgoing;
        synchronized (linkedList) {
            this.outgoing.notifyAll();
        }
        try {
            if (this.transport != null) {
                this.transport.disconnect();
                this.transport = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        linkedList = this.workers;
        synchronized (linkedList) {
            for (_workerthread t : this.workers) {
                t.halt();
            }
        }
        linkedList = this.runnables;
        synchronized (linkedList) {
            this.runnables.notifyAll();
        }
    }

    public void finalize() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusExecutionException getError() {
        LinkedList<Error> linkedList = this.pendingErrors;
        synchronized (linkedList) {
            block4: {
                if (this.pendingErrors.size() != 0) break block4;
                return null;
            }
            return this.pendingErrors.removeFirst().getException();
        }
    }

    public <A> void callWithCallback(DBusInterface object, String m, CallbackHandler<A> callback, Object ... parameters) {
        Class[] types = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            types[i] = parameters[i].getClass();
            ++i;
        }
        RemoteObject ro = this.importedObjects.get(object);
        try {
            Method me = ro.iface == null ? object.getClass().getMethod(m, types) : ro.iface.getMethod(m, types);
            RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 2, callback, parameters);
        }
        catch (DBusExecutionException DBEe) {
            throw DBEe;
        }
        catch (Exception e) {
            throw new DBusExecutionException(e.getMessage());
        }
    }

    public DBusAsyncReply callMethodAsync(DBusInterface object, String m, Object ... parameters) {
        Class[] types = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            types[i] = parameters[i].getClass();
            ++i;
        }
        RemoteObject ro = this.importedObjects.get(object);
        try {
            Method me = ro.iface == null ? object.getClass().getMethod(m, types) : ro.iface.getMethod(m, types);
            return (DBusAsyncReply)RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 1, null, parameters);
        }
        catch (DBusExecutionException DBEe) {
            throw DBEe;
        }
        catch (Exception e) {
            throw new DBusExecutionException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodCall m) throws DBusException {
        Map<String, ExportedObject> map;
        ExportedObject eo = null;
        Method meth = null;
        DBusInterface o = null;
        if (m.getInterface() == null || m.getInterface().equals("org.freedesktop.DBus.Peer") || m.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            map = this.exportedObjects;
            synchronized (map) {
                eo = this.exportedObjects.get(null);
            }
            if (eo != null && eo.object.get() == null) {
                this.unExportObject(null);
                eo = null;
            }
            if (eo != null) {
                meth = eo.methods.get(new MethodTuple(m.getName(), m.getSig()));
            }
            if (meth != null) {
                o = new _globalhandler(m.getPath());
            } else {
                eo = null;
            }
        }
        if (o == null) {
            map = this.exportedObjects;
            synchronized (map) {
                eo = this.exportedObjects.get(m.getPath());
            }
            if (eo != null && eo.object.get() == null) {
                this.unExportObject(m.getPath());
                eo = null;
            }
            if (eo == null) {
                eo = this.fallbackcontainer.get(m.getPath());
            }
            if (eo == null) {
                try {
                    this.queueOutgoing(new Error(m, new DBus.Error.UnknownObject(String.valueOf(m.getPath()) + " is not an object provided by this process.")));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
                return;
            }
            meth = eo.methods.get(new MethodTuple(m.getName(), m.getSig()));
            if (meth == null) {
                try {
                    this.queueOutgoing(new Error(m, new DBus.Error.UnknownMethod(MessageFormat.format("The method `{0}.{1}' does not exist on this object.", m.getInterface(), m.getName()))));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
                return;
            }
            o = eo.object.get();
        }
        final Method me = meth;
        final _globalhandler ob = o;
        final boolean noreply = 1 == (m.getFlags() & 1);
        final DBusCallInfo info = new DBusCallInfo(m);
        final AbstractConnection conn = this;
        this.addRunnable(new Runnable(){
            private boolean run = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void run() {
                if (this.run) {
                    return;
                }
                this.run = true;
                try {
                    Type[] ts = me.getGenericParameterTypes();
                    m.setArgs(Marshalling.deSerializeParameters(m.getParameters(), ts, conn));
                }
                catch (Exception e) {
                    try {
                        conn.queueOutgoing(new Error(m, new DBus.Error.UnknownMethod("Failure in de-serializing message: " + e)));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    Object result;
                    Map e = infomap;
                    synchronized (e) {
                        infomap.put(Thread.currentThread(), info);
                    }
                    try {
                        result = me.invoke(ob, m.getParameters());
                    }
                    catch (InvocationTargetException ITe) {
                        throw ITe.getCause();
                    }
                    Map ITe = infomap;
                    synchronized (ITe) {
                        infomap.remove(Thread.currentThread());
                    }
                    if (!noreply) {
                        MethodReturn reply;
                        if (Void.TYPE.equals(me.getReturnType())) {
                            reply = new MethodReturn(m, null, new Object[0]);
                        } else {
                            StringBuffer sb = new StringBuffer();
                            String[] stringArray = Marshalling.getDBusType(me.getGenericReturnType());
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String s = stringArray[n2];
                                sb.append(s);
                                ++n2;
                            }
                            Object[] nr = Marshalling.convertParameters(new Object[]{result}, new Type[]{me.getGenericReturnType()}, conn);
                            reply = new MethodReturn(m, sb.toString(), nr);
                        }
                        conn.queueOutgoing(reply);
                    }
                }
                catch (DBusExecutionException DBEe) {
                    try {
                        conn.queueOutgoing(new Error(m, DBEe));
                    }
                    catch (DBusException dBusException) {}
                }
                catch (Throwable e) {
                    try {
                        conn.queueOutgoing(new Error(m, new DBusExecutionException(MessageFormat.format("Error Executing Method {0}.{1}: {2}", m.getInterface(), m.getName(), e.getMessage()))));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final DBusSignal s) {
        Vector<DBusSigHandler<? extends DBusSignal>> v = new Vector<DBusSigHandler<? extends DBusSignal>>();
        Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<? extends DBusSignal>> vector;
            Vector<DBusSigHandler<? extends DBusSignal>> vector2;
            Vector<DBusSigHandler<? extends DBusSignal>> vector3;
            Vector<DBusSigHandler<? extends DBusSignal>> vector4 = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), null, null));
            if (vector4 != null) {
                v.addAll(vector4);
            }
            if ((vector3 = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), s.getPath(), null))) != null) {
                v.addAll(vector3);
            }
            if ((vector2 = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), null, s.getSource()))) != null) {
                v.addAll(vector2);
            }
            if ((vector = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), s.getPath(), s.getSource()))) != null) {
                v.addAll(vector);
            }
        }
        if (v.size() == 0) {
            return;
        }
        final AbstractConnection conn = this;
        for (final DBusSigHandler dBusSigHandler : v) {
            this.addRunnable(new Runnable(){
                private boolean run = false;

                public synchronized void run() {
                    if (this.run) {
                        return;
                    }
                    this.run = true;
                    try {
                        DBusSignal rs = s instanceof DBusSignal.internalsig || s.getClass().equals(DBusSignal.class) ? s.createReal(conn) : s;
                        dBusSigHandler.handle(rs);
                    }
                    catch (DBusException DBe) {
                        try {
                            conn.queueOutgoing(new Error(s, new DBusExecutionException("Error handling signal " + s.getInterface() + "." + s.getName() + ": " + DBe.getMessage())));
                        }
                        catch (DBusException dBusException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Error err) {
        MethodCall m = null;
        if (this.pendingCalls == null) {
            return;
        }
        Object object = this.pendingCalls;
        synchronized (object) {
            if (this.pendingCalls.contains(err.getReplySerial())) {
                m = this.pendingCalls.remove(err.getReplySerial());
            }
        }
        if (m != null) {
            m.setReply(err);
        } else {
            object = this.pendingErrors;
            synchronized (object) {
                this.pendingErrors.addLast(err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodReturn mr) {
        MethodCall m = null;
        if (this.pendingCalls == null) {
            return;
        }
        EfficientMap efficientMap = this.pendingCalls;
        synchronized (efficientMap) {
            if (this.pendingCalls.contains(mr.getReplySerial())) {
                m = this.pendingCalls.remove(mr.getReplySerial());
            }
        }
        if (m != null) {
            m.setReply(mr);
            mr.setCall(m);
            CallbackHandler<? extends Object> cbh = null;
            DBusAsyncReply<? extends Object> asr = null;
            Map<MethodCall, CallbackHandler<? extends Object>> map = this.pendingCallbacks;
            synchronized (map) {
                cbh = this.pendingCallbacks.remove(m);
                asr = this.pendingCallbackReplys.remove(m);
            }
            if (cbh != null) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                final DBusAsyncReply<? extends Object> fasr = asr;
                this.addRunnable(new Runnable(){
                    private boolean run = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public synchronized void run() {
                        if (this.run) {
                            return;
                        }
                        this.run = true;
                        try {
                            DBusCallInfo info = new DBusCallInfo(mr);
                            Map map = infomap;
                            synchronized (map) {
                                infomap.put(Thread.currentThread(), info);
                            }
                            fcbh.handle(RemoteInvocationHandler.convertRV(mr.getSig(), mr.getParameters(), fasr.getMethod(), fasr.getConnection()));
                            map = infomap;
                            synchronized (map) {
                                infomap.remove(Thread.currentThread());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        } else {
            try {
                this.queueOutgoing(new Error(mr, new DBusExecutionException("Spurious reply. No message with the given serial id was awaiting a reply.")));
            }
            catch (DBusException dBusException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(Message m) {
        block26: {
            try {
                if (!this.connected) {
                    throw new NotConnected("Disconnected");
                }
                if (m instanceof DBusSignal) {
                    ((DBusSignal)m).appendbody(this);
                }
                if (m instanceof MethodCall && (m.getFlags() & 1) == 0) {
                    if (this.pendingCalls == null) {
                        ((MethodCall)m).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected"));
                    } else {
                        EfficientMap efficientMap = this.pendingCalls;
                        synchronized (efficientMap) {
                            this.pendingCalls.put(m.getSerial(), (MethodCall)m);
                        }
                    }
                }
                this.transport.mout.writeMessage(m);
            }
            catch (Exception e) {
                if (m instanceof MethodCall && e instanceof NotConnected) {
                    try {
                        ((MethodCall)m).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected"));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                }
                if (m instanceof MethodCall && e instanceof DBusExecutionException) {
                    try {
                        ((MethodCall)m).setReply(new Error(m, e));
                    }
                    catch (DBusException dBusException) {}
                } else if (m instanceof MethodCall) {
                    try {
                        ((MethodCall)m).setReply(new Error(m, new DBusExecutionException("Message Failed to Send: " + e.getMessage())));
                    }
                    catch (DBusException dBusException) {}
                } else if (m instanceof MethodReturn) {
                    try {
                        this.transport.mout.writeMessage(new Error(m, e));
                    }
                    catch (IOException iOException) {
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                }
                if (!(e instanceof IOException)) break block26;
                this.disconnect();
            }
        }
    }

    private Message readIncoming() throws DBusException {
        if (!this.connected) {
            throw new NotConnected("No transport present");
        }
        Message m = null;
        try {
            m = this.transport.min.readMessage();
        }
        catch (IOException IOe) {
            throw new FatalDBusException(IOe.getMessage());
        }
        return m;
    }

    public BusAddress getAddress() throws ParseException {
        return new BusAddress(this.addr);
    }

    protected class FallbackContainer {
        private Map<String[], ExportedObject> fallbacks = new HashMap<String[], ExportedObject>();

        protected FallbackContainer() {
        }

        public synchronized void add(String path, ExportedObject eo) {
            this.fallbacks.put(path.split("/"), eo);
        }

        public synchronized void remove(String path) {
            this.fallbacks.remove(path.split("/"));
        }

        public synchronized ExportedObject get(String path) {
            int best = 0;
            int i = 0;
            ExportedObject bestobject = null;
            String[] pathel = path.split("/");
            for (String[] fbpath : this.fallbacks.keySet()) {
                i = 0;
                while (i < pathel.length && i < fbpath.length) {
                    if (!pathel[i].equals(fbpath[i])) break;
                    ++i;
                }
                if (i <= 0 || i != fbpath.length || i <= best) continue;
                bestobject = this.fallbacks.get(fbpath);
            }
            return bestobject;
        }
    }

    private class _globalhandler
    implements DBus.Peer,
    DBus.Introspectable {
        private String objectpath;

        public _globalhandler() {
            this.objectpath = null;
        }

        public _globalhandler(String objectpath) {
            this.objectpath = objectpath;
        }

        public boolean isRemote() {
            return false;
        }

        public void Ping() {
        }

        public String Introspect() {
            ExportedObject eo;
            String intro = AbstractConnection.this.objectTree.Introspect(this.objectpath);
            if (intro == null && (eo = AbstractConnection.this.fallbackcontainer.get(this.objectpath)) != null) {
                intro = eo.introspectiondata;
            }
            if (intro == null) {
                throw new DBus.Error.UnknownObject("Introspecting on non-existant object");
            }
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n" + intro;
        }
    }

    private class _sender
    extends Thread {
        public _sender() {
            this.setName("Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Message m = null;
            while (AbstractConnection.this._run) {
                block17: {
                    if (AbstractConnection.this.outgoing != null) {
                        EfficientQueue efficientQueue = AbstractConnection.this.outgoing;
                        synchronized (efficientQueue) {
                            while (true) {
                                while (true) {
                                    if (AbstractConnection.this.outgoing.size() != 0 || !AbstractConnection.this._run) {
                                        if (AbstractConnection.this.outgoing.size() > 0) {
                                            m = AbstractConnection.this.outgoing.remove();
                                        }
                                        break block17;
                                    }
                                    try {
                                        AbstractConnection.this.outgoing.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                if (m != null) {
                    AbstractConnection.this.sendMessage(m);
                }
                m = null;
            }
            if (AbstractConnection.this.outgoing != null) {
                do {
                    EfficientQueue ogq;
                    EfficientQueue efficientQueue = ogq = AbstractConnection.this.outgoing;
                    synchronized (efficientQueue) {
                        AbstractConnection.this.outgoing = null;
                    }
                    m = !ogq.isEmpty() ? ogq.remove() : null;
                    AbstractConnection.this.sendMessage(m);
                } while (m != null);
            }
        }
    }

    protected class _thread
    extends Thread {
        public _thread() {
            this.setName("DBusConnection");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                _thread _thread2;
                Message m = null;
                while (AbstractConnection.this._run) {
                    m = null;
                    try {
                        m = AbstractConnection.this.readIncoming();
                        if (m == null) continue;
                        _thread2 = this;
                        synchronized (_thread2) {
                            this.notifyAll();
                        }
                        if (m instanceof DBusSignal) {
                            AbstractConnection.this.handleMessage((DBusSignal)m);
                        } else if (m instanceof MethodCall) {
                            AbstractConnection.this.handleMessage((MethodCall)m);
                        } else if (m instanceof MethodReturn) {
                            AbstractConnection.this.handleMessage((MethodReturn)m);
                        } else if (m instanceof Error) {
                            AbstractConnection.this.handleMessage((Error)m);
                        }
                        m = null;
                    }
                    catch (Exception e) {
                        if (!(e instanceof FatalException)) continue;
                        AbstractConnection.this.disconnect();
                    }
                }
                _thread2 = this;
                synchronized (_thread2) {
                    this.notifyAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class _workerthread
    extends Thread {
        private boolean _run = true;

        protected _workerthread() {
        }

        public void halt() {
            this._run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (this._run) {
                Runnable r;
                block10: {
                    r = null;
                    LinkedList<Runnable> linkedList = AbstractConnection.this.runnables;
                    synchronized (linkedList) {
                        while (true) {
                            while (true) {
                                if (AbstractConnection.this.runnables.size() != 0 || !this._run) {
                                    if (AbstractConnection.this.runnables.size() > 0) {
                                        r = AbstractConnection.this.runnables.removeFirst();
                                    }
                                    break block10;
                                }
                                try {
                                    AbstractConnection.this.runnables.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                if (r == null) continue;
                r.run();
            }
        }
    }
}

