/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.Hal;

import org.freedesktop.DBus;
import org.freedesktop.Hal.IDBusInterface;
import org.freedesktop.Hal.Manager;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.exceptions.DBusException;
import org.gnome.ScreenSaver;

public class DBusMonitor
implements DBusSigHandler {
    static IDBusInterface dbusInter;

    public void handle(DBusSignal s) {
        if (s instanceof Manager.DeviceAdded) {
            System.out.println("+++++++++++++++device added!!!");
            System.out.println("device info:" + ((Manager.DeviceAdded)s).obj);
            if (((Manager.DeviceAdded)s).obj.toString().indexOf("HUAWEI_Mass_Storage") > -1) {
                System.err.println("~~~~~~~~~~~~huawei device added!!!");
                dbusInter.DeviceAddedManage();
            }
        }
        if (s instanceof Manager.DeviceRemoved) {
            System.out.println("---------------device removed!!!");
            System.out.println("device info:" + ((Manager.DeviceRemoved)s).obj);
            if (((Manager.DeviceRemoved)s).obj.toString().indexOf("HUAWEI_Mass_Storage") > -1) {
                System.err.println("~~~~~~~~~~~~huawei device removed!!!");
                dbusInter.DeviceRemovedManage();
            }
        }
        if (s instanceof Manager.Hibernate) {
            System.out.println("-------------Hibernate");
            dbusInter.HibernateManage();
        }
        if (s instanceof Manager.Suspend) {
            System.out.println("-------------Suspend");
            dbusInter.SuspendManage();
        }
        if (s instanceof Manager.Thaw) {
            System.out.println("-------------Thaw");
            dbusInter.ThawManage();
        }
        if (s instanceof Manager.Resume) {
            System.out.println("-------------Resume");
            dbusInter.ResumeManage();
        }
        if (s instanceof DBus.NameOwnerChanged) {
            System.out.println("---------------NameOwnerChanged!!!");
            System.out.println("info:" + ((DBus.NameOwnerChanged)s).name);
            System.out.println("info:" + ((DBus.NameOwnerChanged)s).old_owner);
            System.out.println("info:" + ((DBus.NameOwnerChanged)s).new_owner);
        }
        if (s instanceof ScreenSaver.SessionIdleChanged) {
            if (((ScreenSaver.SessionIdleChanged)s).isIdle) {
                System.err.println("--------the session is idle--------");
            } else {
                System.err.println("--------the session is not idle--------");
            }
        }
        if (s instanceof ScreenSaver.SessionPowerManagementIdleChanged) {
            if (((ScreenSaver.SessionPowerManagementIdleChanged)s).isIdle) {
                System.err.println("--------the SessionPowerManagement is idle--------");
            } else {
                System.err.println("--------the SessionPowerManagement is not idle--------");
            }
        }
    }

    public static void createMobitor(IDBusInterface inter) {
        dbusInter = inter;
        System.out.println("create connection");
        DBusConnection conn = null;
        try {
            conn = DBusConnection.getConnection(0);
        }
        catch (DBusException e) {
            e.printStackTrace();
        }
        try {
            conn.addSigHandler(Manager.DeviceAdded.class, new DBusMonitor());
            conn.addSigHandler(Manager.DeviceRemoved.class, new DBusMonitor());
            conn.addSigHandler(Manager.Hibernate.class, new DBusMonitor());
            conn.addSigHandler(Manager.Suspend.class, new DBusMonitor());
            conn.addSigHandler(Manager.Thaw.class, new DBusMonitor());
            conn.addSigHandler(Manager.Resume.class, new DBusMonitor());
        }
        catch (DBusException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("create connection");
        DBusConnection connSystem = null;
        DBusConnection connSession = null;
        try {
            connSystem = DBusConnection.getConnection(0);
            connSession = DBusConnection.getConnection(1);
        }
        catch (DBusException e) {
            e.printStackTrace();
        }
        try {
            connSystem.addSigHandler(Manager.DeviceAdded.class, new DBusMonitor());
            connSystem.addSigHandler(Manager.DeviceRemoved.class, new DBusMonitor());
            connSystem.addSigHandler(Manager.Hibernate.class, new DBusMonitor());
            connSystem.addSigHandler(Manager.Suspend.class, new DBusMonitor());
            connSystem.addSigHandler(Manager.Thaw.class, new DBusMonitor());
            connSystem.addSigHandler(Manager.Resume.class, new DBusMonitor());
        }
        catch (DBusException e) {
            e.printStackTrace();
        }
    }
}

