/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.cgi;

import cx.ath.matthew.cgi.CGIErrorHandler;
import cx.ath.matthew.cgi.CGIHeaderSentException;
import cx.ath.matthew.cgi.CGIInvalidContentFormatException;
import cx.ath.matthew.cgi.DefaultErrorHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public abstract class CGI {
    private CGIErrorHandler errorhandler = new DefaultErrorHandler();
    private boolean headers_sent = false;
    private HashMap headers = new HashMap();
    private Vector cookies = new Vector();
    private LinkedList pagedata = new LinkedList();
    private LinkedList rawdata = new LinkedList();

    public CGI() {
        System.loadLibrary("cgi-java");
    }

    private native String getenv(String var1);

    private native Object[] getfullenv(Class var1);

    private native void setenv(String var1, String var2);

    public final void header(String variable, String value) throws CGIHeaderSentException {
        if (this.headers_sent) {
            throw new CGIHeaderSentException();
        }
        this.headers.put(variable, value);
    }

    public final void setcookie(String variable, String value, String path, String domain, Date expires, boolean secure) throws CGIHeaderSentException {
        if (this.headers_sent) {
            throw new CGIHeaderSentException();
        }
        SimpleDateFormat df = new SimpleDateFormat("E, dd-MMM-yyyy HH:mm:ss zzz");
        String cookie = String.valueOf(variable) + "=" + value;
        if (path != null) {
            cookie = String.valueOf(cookie) + "; path=" + path;
        }
        if (domain != null) {
            cookie = String.valueOf(cookie) + "; domain=" + domain;
        }
        if (expires != null) {
            cookie = String.valueOf(cookie) + "; expires=" + df.format(expires);
        }
        if (secure) {
            cookie = String.valueOf(cookie) + "; secure";
        }
        this.cookies.add("Set-Cookie: " + cookie);
    }

    public final void setcookie(String variable, String value) throws CGIHeaderSentException {
        if (this.headers_sent) {
            throw new CGIHeaderSentException();
        }
        this.cookies.add("Set-Cookie: " + variable + "=" + value);
    }

    public final void out(byte[] data) throws CGIInvalidContentFormatException {
        if (this.pagedata.size() > 0) {
            throw new CGIInvalidContentFormatException();
        }
        this.rawdata.add(data);
    }

    public final void out(String data) throws CGIInvalidContentFormatException {
        if (this.rawdata.size() > 0) {
            throw new CGIInvalidContentFormatException();
        }
        this.pagedata.add(data);
    }

    public final OutputStream getOutputStream() throws IOException {
        this.flush();
        return System.out;
    }

    public final void flush() throws IOException {
        Iterator j;
        if (!this.headers_sent) {
            this.headers_sent = true;
            for (String key : this.headers.keySet()) {
                String value = (String)this.headers.get(key);
                System.out.println(String.valueOf(key) + ": " + value);
            }
            Iterator<Object> i = this.cookies.iterator();
            while (i.hasNext()) {
                System.out.println((String)i.next());
            }
            System.out.println();
        }
        if (this.pagedata.size() > 0) {
            j = this.pagedata.iterator();
            while (j.hasNext()) {
                System.out.println((String)j.next());
            }
            this.pagedata.clear();
        } else if (this.rawdata.size() > 0) {
            j = this.rawdata.iterator();
            while (j.hasNext()) {
                System.out.write((byte[])j.next());
            }
            this.pagedata.clear();
        }
        System.out.flush();
    }

    protected final void setErrorHandler(CGIErrorHandler handler) {
        this.errorhandler = handler;
    }

    protected abstract void cgi(Map var1, Map var2, Map var3, Map var4, String[] var5) throws Exception;

    private Object readVariables(String s, char seperator, boolean values) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        Vector<String> varv = new Vector<String>();
        String temp = "";
        String variable = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == seperator) {
                if (temp != null) {
                    temp = temp.trim();
                }
                if (values) {
                    if (variable == null) {
                        variable = temp;
                        temp = "";
                    } else {
                        variable.trim();
                    }
                    if (!variable.equals("")) {
                        Object o = vars.get(variable);
                        if (o == null) {
                            vars.put(variable.trim(), temp);
                        } else if (o instanceof String) {
                            LinkedList<Object> l = new LinkedList<Object>();
                            l.add(o);
                            l.add(temp);
                            vars.put(variable.trim(), l);
                        } else if (o instanceof LinkedList) {
                            ((LinkedList)o).add(temp);
                        }
                    }
                    temp = "";
                } else {
                    varv.add(temp);
                    temp = "";
                }
                variable = null;
            } else if (values && c == '=') {
                variable = temp;
                temp = "";
            } else {
                switch (c) {
                    case '%': {
                        try {
                            char a = s.charAt(++i);
                            char b = s.charAt(++i);
                            int ch = 0;
                            switch (a) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    ch += 16 * (a - 48);
                                    break;
                                }
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    ch += 16 * (a - 97 + 10);
                                    break;
                                }
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': {
                                    ch += 16 * (a - 65 + 10);
                                }
                            }
                            switch (b) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    ch += b - 48;
                                    break;
                                }
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    ch += b - 97 + 10;
                                    break;
                                }
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': {
                                    ch += b - 65 + 10;
                                }
                            }
                            temp = String.valueOf(temp) + (char)ch;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                        break;
                    }
                    case '+': {
                        temp = String.valueOf(temp) + ' ';
                        break;
                    }
                    default: {
                        temp = String.valueOf(temp) + c;
                    }
                }
            }
            ++i;
        }
        if (values) {
            if (variable == null) {
                variable = temp;
                temp = "";
            } else {
                variable.trim();
            }
            if (!variable.equals("")) {
                Object o = vars.get(variable);
                if (o == null) {
                    vars.put(variable.trim(), temp);
                } else if (o instanceof String) {
                    LinkedList<Object> l = new LinkedList<Object>();
                    l.add(o);
                    l.add(temp);
                    vars.put(variable.trim(), l);
                } else if (o instanceof LinkedList) {
                    ((LinkedList)o).add(temp);
                }
            }
            return vars;
        }
        varv.add(temp);
        return varv;
    }

    private Map getPOST() {
        try {
            String s = "";
            while (System.in.available() > 0) {
                s = String.valueOf(s) + (char)System.in.read();
            }
            return (Map)this.readVariables(s, '&', true);
        }
        catch (IOException IOe) {
            try {
                this.out("ERROR: IOException: " + IOe);
            }
            catch (CGIInvalidContentFormatException CGIICFe) {
                System.err.println("ERROR: IOException: " + IOe);
            }
            return new HashMap();
        }
    }

    private Map getCOOKIE() {
        String s = this.getenv("HTTP_COOKIE");
        if (s == null) {
            return new HashMap();
        }
        return (Map)this.readVariables(s, ';', true);
    }

    private Map getGET() {
        String s = this.getenv("QUERY_STRING");
        if (s == null) {
            return new HashMap();
        }
        return (Map)this.readVariables(s, '&', true);
    }

    private Map getENV() {
        HashMap<String, String> m = new HashMap<String, String>();
        String[] env = (String[])this.getfullenv(String.class);
        int i = 0;
        while (i < env.length) {
            if (env[i] != null) {
                String[] e = env[i].split("=");
                if (1 == e.length) {
                    m.put(e[0], "");
                } else {
                    m.put(e[0], e[1]);
                }
            }
            ++i;
        }
        return m;
    }

    private String[] getParams(String args) {
        Vector v = (Vector)this.readVariables(args, ',', false);
        String[] params = new String[v.size()];
        Iterator i = v.iterator();
        int j = 0;
        while (j < params.length) {
            params[j] = (String)i.next();
            ++j;
        }
        return params;
    }

    public final void doCGI(String[] args) {
        Object cgiclass = null;
        try {
            Map POST = this.getPOST();
            Map GET = this.getGET();
            Map ENV = this.getENV();
            Map COOKIE = this.getCOOKIE();
            String[] params = new String[]{};
            if (args.length >= 1) {
                params = this.getParams(args[0]);
            }
            this.headers.put("Content-type", "text/html");
            this.cgi(POST, GET, ENV, COOKIE, params);
            this.flush();
        }
        catch (Exception e) {
            this.errorhandler.print(this.headers_sent, e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.errorhandler.print(this.headers_sent, new Exception(t.toString()));
        }
    }
}

