/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.viewer.DBusEntry;
import org.freedesktop.dbus.viewer.DBusTableModel;
import org.freedesktop.dbus.viewer.IntrospectAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBusViewer {
    private static final Map<String, Integer> CONNECTION_TYPES = new HashMap<String, Integer>();
    private List<DBusConnection> connections;
    private static final String DOC_TYPE = "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">";

    static {
        CONNECTION_TYPES.put("System", 0);
        CONNECTION_TYPES.put("Session", 1);
    }

    public DBusViewer(final Map<String, Integer> connectionTypes) {
        this.connections = new ArrayList<DBusConnection>(connectionTypes.size());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JTabbedPane tabbedPane = new JTabbedPane();
                DBusViewer.this.addTabs(tabbedPane, connectionTypes);
                final JFrame frame = new JFrame("Dbus Viewer");
                frame.setContentPane(tabbedPane);
                frame.setSize(600, 400);
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        frame.dispose();
                        for (DBusConnection connection : DBusViewer.this.connections) {
                            connection.disconnect();
                        }
                        System.exit(0);
                    }
                });
                frame.setVisible(true);
            }
        });
    }

    public static void main(String[] args) {
        new DBusViewer(CONNECTION_TYPES);
    }

    private void addTabs(final JTabbedPane tabbedPane, final Map<String, Integer> connectionTypes) {
        for (String key : connectionTypes.keySet()) {
            JLabel label = new JLabel(String.valueOf(Gettext._("Processing DBus for ")) + key);
            tabbedPane.addTab(key, label);
        }
        Runnable loader = new Runnable(){

            public void run() {
                boolean users = true;
                boolean owners = true;
                for (final String key : connectionTypes.keySet()) {
                    try {
                        DBusConnection conn = DBusConnection.getConnection((Integer)connectionTypes.get(key));
                        DBusViewer.this.connections.add(conn);
                        final DBusTableModel tableModel = DBusViewer.this.listDBusConnection(users, owners, conn);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                int index = tabbedPane.indexOfTab(key);
                                JTable table = new JTable(tableModel);
                                JScrollPane scrollPane = new JScrollPane(table);
                                JPanel tab = new JPanel(new BorderLayout());
                                tab.add((Component)scrollPane, "Center");
                                JPanel southPanel = new JPanel();
                                JButton button = new JButton(new IntrospectAction(table));
                                southPanel.add(button);
                                tab.add((Component)southPanel, "South");
                                tabbedPane.setComponentAt(index, tab);
                            }
                        });
                    }
                    catch (DBusException e) {
                        e.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                int index = tabbedPane.indexOfTab(key);
                                JLabel label = (JLabel)tabbedPane.getComponentAt(index);
                                label.setText(String.valueOf(Gettext._("Could not load Dbus information for ")) + key + ":" + e.getMessage());
                            }
                        });
                    }
                    catch (DBusExecutionException e) {
                        e.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                int index = tabbedPane.indexOfTab(key);
                                JLabel label = (JLabel)tabbedPane.getComponentAt(index);
                                label.setText(String.valueOf(Gettext._("Could not load Dbus information for ")) + key + ":" + e.getMessage());
                            }
                        });
                    }
                }
            }
        };
        Thread thread = new Thread(loader);
        thread.setName("DBus Loader");
        thread.start();
    }

    private DBusTableModel listDBusConnection(boolean users, boolean owners, DBusConnection conn) throws DBusException {
        DBusTableModel model = new DBusTableModel();
        DBus dbus = conn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        String[] names = dbus.ListNames();
        ParsingContext p = new ParsingContext(conn);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            List<Object> results = new ArrayList();
            try {
                p.visitNode(name, "/");
            }
            catch (DBusException dBusException) {
                dBusException.printStackTrace();
            }
            catch (DBusExecutionException dBusExecutionException) {
                dBusExecutionException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            results = p.getResult();
            p.reset();
            if (results.size() > 0) {
                if (users) {
                    try {
                        UInt32 uInt32 = dbus.GetConnectionUnixUser(name);
                        for (DBusEntry dBusEntry : results) {
                            dBusEntry.setUser(uInt32);
                        }
                    }
                    catch (DBusExecutionException dBusExecutionException) {
                        // empty catch block
                    }
                }
                if (!name.startsWith(":") && owners) {
                    try {
                        String string = dbus.GetNameOwner(name);
                        for (DBusEntry dBusEntry : results) {
                            dBusEntry.setOwner(string);
                        }
                    }
                    catch (DBusExecutionException dBusExecutionException) {
                        // empty catch block
                    }
                }
                for (DBusEntry dBusEntry : results) {
                    model.add(dBusEntry);
                }
            }
            ++n2;
        }
        return model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParsingContext {
        private DBusConnection conn;
        private DocumentBuilder builder;
        private List<DBusEntry> result;

        ParsingContext(DBusConnection conn) {
            this.conn = conn;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                this.builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e1) {
                throw new RuntimeException(String.valueOf(Gettext._("Error during parser init: ")) + e1.getMessage(), e1);
            }
            this.reset();
        }

        DBusEntry addEntry(String name, String path) throws DBusException {
            DBusEntry entry = new DBusEntry();
            entry.setName(name);
            entry.setPath(path);
            DBus.Introspectable introspectable = this.conn.getRemoteObject(name, path, DBus.Introspectable.class);
            entry.setIntrospectable(introspectable);
            this.result.add(entry);
            return entry;
        }

        public void visitNode(String name, String path) throws DBusException, SAXException, IOException {
            System.out.println("visit " + name + ":" + path);
            if ("/org/freedesktop/DBus/Local".equals(path)) {
                return;
            }
            DBusEntry e = this.addEntry(name, path);
            String introspectData = e.getIntrospectable().Introspect();
            Document document = this.builder.parse(new InputSource(new StringReader(introspectData.replace(DBusViewer.DOC_TYPE, ""))));
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node nameNode;
                Node node = children.item(i);
                if (1 == node.getNodeType() && "node".equals(node.getNodeName()) && (nameNode = node.getAttributes().getNamedItem("name")) != null) {
                    try {
                        if (path.endsWith("/")) {
                            this.visitNode(name, String.valueOf(path) + nameNode.getNodeValue());
                        } else {
                            this.visitNode(name, String.valueOf(path) + '/' + nameNode.getNodeValue());
                        }
                    }
                    catch (DBusException ex) {
                        ex.printStackTrace();
                    }
                }
                ++i;
            }
        }

        public List<DBusEntry> getResult() {
            return this.result;
        }

        void reset() {
            this.result = new ArrayList<DBusEntry>();
        }
    }
}

