/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.Vector;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageFormatException;

public class MethodCall
extends Message {
    private static long REPLY_WAIT_TIMEOUT = 20000L;
    Message reply = null;

    MethodCall() {
    }

    public MethodCall(String dest, String path, String iface, String member, byte flags, String sig, Object ... args) throws DBusException {
        this(null, dest, path, iface, member, flags, sig, args);
    }

    public MethodCall(String source, String dest, String path, String iface, String member, byte flags, String sig, Object ... args) throws DBusException {
        super((byte)66, (byte)1, flags);
        if (member == null || path == null) {
            throw new MessageFormatException(Gettext._("Must specify destination, path and function name to MethodCalls."));
        }
        this.headers.put((byte)1, path);
        this.headers.put((byte)3, member);
        Vector<Object[]> hargs = new Vector<Object[]>();
        hargs.add(new Object[]{(byte)1, new Object[]{"o", path}});
        if (source != null) {
            this.headers.put((byte)7, source);
            hargs.add(new Object[]{(byte)7, new Object[]{"s", source}});
        }
        if (dest != null) {
            this.headers.put((byte)6, dest);
            hargs.add(new Object[]{(byte)6, new Object[]{"s", dest}});
        }
        if (iface != null) {
            hargs.add(new Object[]{(byte)2, new Object[]{"s", iface}});
            this.headers.put((byte)2, iface);
        }
        hargs.add(new Object[]{(byte)3, new Object[]{"s", member}});
        if (sig != null) {
            hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
            this.headers.put((byte)8, sig);
            this.setArgs(args);
        }
        byte[] blen = new byte[4];
        this.appendBytes(blen);
        this.append("ua(yv)", this.serial, hargs.toArray());
        this.pad((byte)8);
        long c = this.bytecounter;
        if (sig != null) {
            this.append(sig, args);
        }
        this.marshallint(this.bytecounter - c, blen, 0, 4);
    }

    public static void setDefaultTimeout(long timeout) {
        REPLY_WAIT_TIMEOUT = timeout;
    }

    public synchronized boolean hasReply() {
        return this.reply != null;
    }

    public synchronized Message getReply(long timeout) {
        if (this.reply != null) {
            return this.reply;
        }
        try {
            this.wait(timeout);
            return this.reply;
        }
        catch (InterruptedException Ie) {
            return this.reply;
        }
    }

    public synchronized Message getReply() {
        if (this.reply != null) {
            return this.reply;
        }
        try {
            this.wait(REPLY_WAIT_TIMEOUT);
            return this.reply;
        }
        catch (InterruptedException Ie) {
            return this.reply;
        }
    }

    protected synchronized void setReply(Message reply) {
        this.reply = reply;
        this.notifyAll();
    }
}

