/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageProtocolVersionException;
import org.freedesktop.dbus.exceptions.MessageTypeException;

public class MessageReader {
    private InputStream in;
    private byte[] buf = null;
    private byte[] tbuf = null;
    private byte[] header = null;
    private byte[] body = null;
    private int[] len = new int[4];

    public MessageReader(InputStream in) {
        this.in = in;
    }

    public Message readMessage() throws IOException, DBusException {
        Message m;
        int rv;
        if (this.buf == null) {
            this.buf = new byte[12];
            this.len[0] = 0;
        }
        if (this.len[0] < 12) {
            try {
                rv = this.in.read(this.buf, this.len[0], 12 - this.len[0]);
            }
            catch (SocketTimeoutException STe) {
                return null;
            }
            if (-1 == rv) {
                throw new EOFException("Underlying transport returned EOF");
            }
            this.len[0] = this.len[0] + rv;
        }
        if (this.len[0] == 0) {
            return null;
        }
        if (this.len[0] < 12) {
            return null;
        }
        byte endian = this.buf[0];
        byte type = this.buf[1];
        byte protover = this.buf[3];
        if (protover > 1) {
            this.buf = null;
            throw new MessageProtocolVersionException(MessageFormat.format(Gettext._("Protocol version {0} is unsupported"), protover));
        }
        if (this.tbuf == null) {
            this.tbuf = new byte[4];
            this.len[1] = 0;
        }
        if (this.len[1] < 4) {
            try {
                rv = this.in.read(this.tbuf, this.len[1], 4 - this.len[1]);
            }
            catch (SocketTimeoutException STe) {
                return null;
            }
            if (-1 == rv) {
                throw new EOFException(Gettext._("Underlying transport returned EOF"));
            }
            this.len[1] = this.len[1] + rv;
        }
        if (this.len[1] < 4) {
            return null;
        }
        int headerlen = 0;
        if (this.header == null) {
            headerlen = (int)Message.demarshallint(this.tbuf, 0, endian, 4);
            if (headerlen % 8 != 0) {
                headerlen += 8 - headerlen % 8;
            }
        } else {
            headerlen = this.header.length - 8;
        }
        if (this.header == null) {
            this.header = new byte[headerlen + 8];
            System.arraycopy(this.tbuf, 0, this.header, 0, 4);
            this.len[2] = 0;
        }
        if (this.len[2] < headerlen) {
            try {
                rv = this.in.read(this.header, 8 + this.len[2], headerlen - this.len[2]);
            }
            catch (SocketTimeoutException STe) {
                return null;
            }
            if (-1 == rv) {
                throw new EOFException(Gettext._("Underlying transport returned EOF"));
            }
            this.len[2] = this.len[2] + rv;
        }
        if (this.len[2] < headerlen) {
            return null;
        }
        int bodylen = 0;
        if (this.body == null) {
            bodylen = (int)Message.demarshallint(this.buf, 4, endian, 4);
        }
        if (this.body == null) {
            this.body = new byte[bodylen];
            this.len[3] = 0;
        }
        if (this.len[3] < this.body.length) {
            try {
                rv = this.in.read(this.body, this.len[3], this.body.length - this.len[3]);
            }
            catch (SocketTimeoutException STe) {
                return null;
            }
            if (-1 == rv) {
                throw new EOFException(Gettext._("Underlying transport returned EOF"));
            }
            this.len[3] = this.len[3] + rv;
        }
        if (this.len[3] < this.body.length) {
            return null;
        }
        switch (type) {
            case 1: {
                m = new MethodCall();
                break;
            }
            case 2: {
                m = new MethodReturn();
                break;
            }
            case 4: {
                m = new DBusSignal();
                break;
            }
            case 3: {
                m = new Error();
                break;
            }
            default: {
                throw new MessageTypeException(MessageFormat.format(Gettext._("Message type {0} unsupported"), type));
            }
        }
        try {
            m.populate(this.buf, this.header, this.body);
        }
        catch (DBusException DBe) {
            this.buf = null;
            this.tbuf = null;
            this.body = null;
            this.header = null;
            throw DBe;
        }
        catch (RuntimeException Re) {
            this.buf = null;
            this.tbuf = null;
            this.body = null;
            this.header = null;
            throw Re;
        }
        this.buf = null;
        this.tbuf = null;
        this.body = null;
        this.header = null;
        return m;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

