/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.StrongReference;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportedObject {
    Map<MethodTuple, Method> methods;
    Reference<DBusInterface> object;
    String introspectiondata;

    private String getAnnotations(AnnotatedElement c) {
        String ans = "";
        Annotation[] annotationArray = c.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            Class<? extends Annotation> t = a.annotationType();
            String value = "";
            try {
                Method m = t.getMethod("value", new Class[0]);
                value = m.invoke((Object)a, new Object[0]).toString();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ans = String.valueOf(ans) + "  <annotation name=\"" + AbstractConnection.dollar_pattern.matcher(t.getName()).replaceAll(".") + "\" value=\"" + value + "\" />\n";
            ++n2;
        }
        return ans;
    }

    private Map<MethodTuple, Method> getExportedMethods(Class c) throws DBusException {
        if (DBusInterface.class.equals((Object)c)) {
            return new HashMap<MethodTuple, Method>();
        }
        HashMap<MethodTuple, Method> m = new HashMap<MethodTuple, Method>();
        Class<?>[] classArray = c.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            if (DBusInterface.class.equals(i)) {
                if (c.getAnnotation(DBusInterfaceName.class) != null) {
                    String name = c.getAnnotation(DBusInterfaceName.class).value();
                    this.introspectiondata = String.valueOf(this.introspectiondata) + " <interface name=\"" + name + "\">\n";
                    DBusSignal.addInterfaceMap(c.getName(), name);
                } else {
                    if (c.getName().equals(c.getSimpleName())) {
                        throw new DBusException(Gettext._("DBusInterfaces cannot be declared outside a package"));
                    }
                    if (c.getName().length() > 255) {
                        throw new DBusException(String.valueOf(Gettext._("Introspected interface name exceeds 255 characters. Cannot export objects of type ")) + c.getName());
                    }
                    this.introspectiondata = String.valueOf(this.introspectiondata) + " <interface name=\"" + AbstractConnection.dollar_pattern.matcher(c.getName()).replaceAll(".") + "\">\n";
                }
                this.introspectiondata = String.valueOf(this.introspectiondata) + this.getAnnotations(c);
                GenericDeclaration[] genericDeclarationArray = c.getDeclaredMethods();
                int n3 = genericDeclarationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method meth = genericDeclarationArray[n4];
                    if (Modifier.isPublic(meth.getModifiers())) {
                        String ms = "";
                        String name = meth.isAnnotationPresent(DBusMemberName.class) ? meth.getAnnotation(DBusMemberName.class).value() : meth.getName();
                        if (name.length() > 255) {
                            throw new DBusException(String.valueOf(Gettext._("Introspected method name exceeds 255 characters. Cannot export objects with method ")) + name);
                        }
                        this.introspectiondata = String.valueOf(this.introspectiondata) + "  <method name=\"" + name + "\" >\n";
                        this.introspectiondata = String.valueOf(this.introspectiondata) + this.getAnnotations(meth);
                        Object[] objectArray = meth.getExceptionTypes();
                        int n5 = objectArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Class<?> ex = objectArray[n6];
                            if (DBusExecutionException.class.isAssignableFrom(ex)) {
                                this.introspectiondata = String.valueOf(this.introspectiondata) + "   <annotation name=\"org.freedesktop.DBus.Method.Error\" value=\"" + AbstractConnection.dollar_pattern.matcher(ex.getName()).replaceAll(".") + "\" />\n";
                            }
                            ++n6;
                        }
                        objectArray = meth.getGenericParameterTypes();
                        n5 = objectArray.length;
                        n6 = 0;
                        while (n6 < n5) {
                            Type pt = objectArray[n6];
                            String[] stringArray = Marshalling.getDBusType(pt);
                            int n7 = stringArray.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String s = stringArray[n8];
                                this.introspectiondata = String.valueOf(this.introspectiondata) + "   <arg type=\"" + s + "\" direction=\"in\"/>\n";
                                ms = String.valueOf(ms) + s;
                                ++n8;
                            }
                            ++n6;
                        }
                        if (!Void.TYPE.equals(meth.getGenericReturnType())) {
                            if (Tuple.class.isAssignableFrom(meth.getReturnType())) {
                                Type[] ts;
                                ParameterizedType tc = (ParameterizedType)meth.getGenericReturnType();
                                Type[] typeArray = ts = tc.getActualTypeArguments();
                                int n9 = ts.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    Type t = typeArray[n10];
                                    if (t != null) {
                                        String[] stringArray = Marshalling.getDBusType(t);
                                        int n11 = stringArray.length;
                                        int n12 = 0;
                                        while (n12 < n11) {
                                            String s = stringArray[n12];
                                            this.introspectiondata = String.valueOf(this.introspectiondata) + "   <arg type=\"" + s + "\" direction=\"out\"/>\n";
                                            ++n12;
                                        }
                                    }
                                    ++n10;
                                }
                            } else {
                                if (Object[].class.equals((Object)meth.getGenericReturnType())) {
                                    throw new DBusException(Gettext._("Return type of Object[] cannot be introspected properly"));
                                }
                                objectArray = Marshalling.getDBusType(meth.getGenericReturnType());
                                int t = objectArray.length;
                                int ts = 0;
                                while (ts < t) {
                                    Object s = objectArray[ts];
                                    this.introspectiondata = String.valueOf(this.introspectiondata) + "   <arg type=\"" + (String)s + "\" direction=\"out\"/>\n";
                                    ++ts;
                                }
                            }
                        }
                        this.introspectiondata = String.valueOf(this.introspectiondata) + "  </method>\n";
                        m.put(new MethodTuple(name, ms), meth);
                    }
                    ++n4;
                }
                genericDeclarationArray = c.getDeclaredClasses();
                n3 = genericDeclarationArray.length;
                n4 = 0;
                while (n4 < n3) {
                    GenericDeclaration sig = genericDeclarationArray[n4];
                    if (DBusSignal.class.isAssignableFrom((Class<?>)sig)) {
                        String name;
                        if (((Class)sig).isAnnotationPresent(DBusMemberName.class)) {
                            name = ((Class)sig).getAnnotation(DBusMemberName.class).value();
                            DBusSignal.addSignalMap(((Class)sig).getSimpleName(), name);
                        } else {
                            name = ((Class)sig).getSimpleName();
                        }
                        if (name.length() > 255) {
                            throw new DBusException(String.valueOf(Gettext._("Introspected signal name exceeds 255 characters. Cannot export objects with signals of type ")) + name);
                        }
                        this.introspectiondata = String.valueOf(this.introspectiondata) + "  <signal name=\"" + name + "\">\n";
                        Constructor<?> con = ((Class)sig).getConstructors()[0];
                        Type[] ts = con.getGenericParameterTypes();
                        int j = 1;
                        while (j < ts.length) {
                            String[] stringArray = Marshalling.getDBusType(ts[j]);
                            int n13 = stringArray.length;
                            int n14 = 0;
                            while (n14 < n13) {
                                String s = stringArray[n14];
                                this.introspectiondata = String.valueOf(this.introspectiondata) + "   <arg type=\"" + s + "\" direction=\"out\" />\n";
                                ++n14;
                            }
                            ++j;
                        }
                        this.introspectiondata = String.valueOf(this.introspectiondata) + this.getAnnotations(sig);
                        this.introspectiondata = String.valueOf(this.introspectiondata) + "  </signal>\n";
                    }
                    ++n4;
                }
                this.introspectiondata = String.valueOf(this.introspectiondata) + " </interface>\n";
            } else {
                m.putAll(this.getExportedMethods(i));
            }
            ++n2;
        }
        return m;
    }

    public ExportedObject(DBusInterface object, boolean weakreferences) throws DBusException {
        this.object = weakreferences ? new WeakReference<DBusInterface>(object) : new StrongReference<DBusInterface>(object);
        this.introspectiondata = "";
        this.methods = this.getExportedMethods(object.getClass());
        this.introspectiondata = String.valueOf(this.introspectiondata) + " <interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n   <arg type=\"s\" direction=\"out\"/>\n  </method>\n </interface>\n";
        this.introspectiondata = String.valueOf(this.introspectiondata) + " <interface name=\"org.freedesktop.DBus.Peer\">\n  <method name=\"Ping\">\n  </method>\n </interface>\n";
    }
}

