/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBusConnection
extends AbstractConnection {
    public static final int SYSTEM = 0;
    public static final int SESSION = 1;
    public static final String DEFAULT_SYSTEM_BUS_ADDRESS = "unix:path=/var/run/dbus/system_bus_socket";
    private List<String> busnames;
    private static final Map<Object, DBusConnection> conn = new HashMap<Object, DBusConnection>();
    private int _refcount = 0;
    private Object _reflock = new Object();
    private DBus _dbus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusConnection getConnection(String address) throws DBusException {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            DBusConnection c = conn.get(address);
            if (c != null) {
                Object object = c._reflock;
                synchronized (object) {
                    ++c._refcount;
                }
                return c;
            }
            c = new DBusConnection(address);
            conn.put(address, c);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusConnection getConnection(int bustype) throws DBusException {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            DBusConnection c;
            String s = null;
            switch (bustype) {
                case 0: {
                    s = System.getenv("DBUS_SYSTEM_BUS_ADDRESS");
                    if (s != null) break;
                    s = DEFAULT_SYSTEM_BUS_ADDRESS;
                    break;
                }
                case 1: {
                    s = System.getenv("DBUS_SESSION_BUS_ADDRESS");
                    if (s != null) break;
                    throw new DBusException("Cannot Resolve Session Bus Address");
                }
                default: {
                    throw new DBusException("Invalid Bus Type: " + bustype);
                }
            }
            if ((c = conn.get(s)) != null) {
                Object object = c._reflock;
                synchronized (object) {
                    ++c._refcount;
                }
                return c;
            }
            c = new DBusConnection(s);
            conn.put(s, c);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBusConnection(String address) throws DBusException {
        super(address);
        this.busnames = new Vector<String>();
        Object object = this._reflock;
        synchronized (object) {
            this._refcount = 1;
        }
        try {
            this.transport = new Transport(this.addr, 100000);
            this.connected = true;
        }
        catch (IOException IOe) {
            this.disconnect();
            throw new DBusException("Failed to connect to bus " + IOe.getMessage());
        }
        catch (ParseException Pe) {
            this.disconnect();
            throw new DBusException("Failed to connect to bus " + Pe.getMessage());
        }
        this.listen();
        _sighandler h = new _sighandler();
        this.addSigHandlerWithoutMatch(DBus.Local.Disconnected.class, h);
        this.addSigHandlerWithoutMatch(DBus.NameAcquired.class, h);
        this._dbus = this.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        try {
            this.busnames.add(this._dbus.Hello());
        }
        catch (DBusExecutionException DBEe) {
            throw new DBusException(DBEe.getMessage());
        }
    }

    DBusInterface dynamicProxy(String source, String path) throws DBusException {
        try {
            DBus.Introspectable intro = this.getRemoteObject(source, path, DBus.Introspectable.class);
            String data = intro.Introspect();
            String[] tags = data.split("[<>]");
            Vector<String> ifaces = new Vector<String>();
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (tag.startsWith("interface")) {
                    ifaces.add(tag.replaceAll("^interface *name *= *['\"]([^'\"]*)['\"].*$", "$1"));
                }
                ++n2;
            }
            Vector ifcs = new Vector();
            block5: for (String iface : ifaces) {
                int j = 0;
                while (j >= 0) {
                    try {
                        Class<?> ifclass = Class.forName(iface);
                        if (ifcs.contains(ifclass)) continue block5;
                        ifcs.add(ifclass);
                        continue block5;
                    }
                    catch (Exception ifclass) {
                        j = iface.lastIndexOf(".");
                        char[] cs = iface.toCharArray();
                        if (j < 0) continue;
                        cs[j] = 36;
                        iface = String.valueOf(cs);
                    }
                }
            }
            if (ifcs.size() == 0) {
                throw new DBusException("Could not find an interface to cast to");
            }
            RemoteObject ro = new RemoteObject(source, path, null, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(((Class)ifcs.get(0)).getClassLoader(), ifcs.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.importedObjects.put(newi, ro);
            return newi;
        }
        catch (Exception e) {
            throw new DBusException(MessageFormat.format("Failed to create proxy object for {0} exported by {1}. Reason: {2}", path, source, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DBusInterface getExportedObject(String source, String path) throws DBusException {
        ExportedObject o = null;
        Map map = this.exportedObjects;
        synchronized (map) {
            o = (ExportedObject)this.exportedObjects.get(path);
        }
        if (o != null && o.object.get() == null) {
            this.unExportObject(path);
            o = null;
        }
        if (o != null) {
            return o.object.get();
        }
        if (source == null) {
            throw new DBusException("Not an object exported by this connection and no remote specified");
        }
        return this.dynamicProxy(source, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBusName(String busname) throws DBusException {
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || busname.length() > 255) {
            throw new DBusException("Invalid bus name");
        }
        List<String> list = this.busnames;
        synchronized (list) {
            try {
                UInt32 rv = this._dbus.ReleaseName(busname);
            }
            catch (DBusExecutionException DBEe) {
                throw new DBusException(DBEe.getMessage());
            }
            this.busnames.remove(busname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBusName(String busname) throws DBusException {
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") || busname.length() > 255) {
            throw new DBusException("Invalid bus name");
        }
        List<String> list = this.busnames;
        synchronized (list) {
            UInt32 rv;
            try {
                rv = this._dbus.RequestName(busname, new UInt32(6L));
            }
            catch (DBusExecutionException DBEe) {
                throw new DBusException(DBEe.getMessage());
            }
            switch (rv.intValue()) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new DBusException("Failed to register bus name");
                }
                case 3: {
                    throw new DBusException("Failed to register bus name");
                }
                case 4: {
                    break;
                }
            }
            this.busnames.add(busname);
        }
    }

    public String getUniqueName() {
        return this.busnames.get(0);
    }

    public String[] getNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(this.busnames);
        return names.toArray(new String[0]);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String busname, String objectpath, Class<I> type) throws DBusException {
        return this.getPeerRemoteObject(busname, objectpath, type, true);
    }

    public DBusInterface getPeerRemoteObject(String busname, String objectpath) throws DBusException {
        if (busname == null) {
            throw new DBusException("Invalid bus name: null");
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException("Invalid bus name: " + busname);
        }
        String unique = this._dbus.GetNameOwner(busname);
        return this.dynamicProxy(unique, objectpath);
    }

    public DBusInterface getRemoteObject(String busname, String objectpath) throws DBusException {
        if (busname == null) {
            throw new DBusException("Invalid bus name: null");
        }
        if (objectpath == null) {
            throw new DBusException("Invalid object path: null");
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException("Invalid bus name: " + busname);
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        return this.dynamicProxy(busname, objectpath);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String busname, String objectpath, Class<I> type, boolean autostart) throws DBusException {
        if (busname == null) {
            throw new DBusException("Invalid bus name: null");
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException("Invalid bus name: " + busname);
        }
        String unique = this._dbus.GetNameOwner(busname);
        return this.getRemoteObject(unique, objectpath, type, autostart);
    }

    public <I extends DBusInterface> I getRemoteObject(String busname, String objectpath, Class<I> type) throws DBusException {
        return this.getRemoteObject(busname, objectpath, type, true);
    }

    public <I extends DBusInterface> I getRemoteObject(String busname, String objectpath, Class<I> type, boolean autostart) throws DBusException {
        if (busname == null) {
            throw new DBusException("Invalid bus name: null");
        }
        if (objectpath == null) {
            throw new DBusException("Invalid object path: null");
        }
        if (type == null) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (!busname.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$") && !busname.matches("^:[0-9]*\\.[0-9]*$") || busname.length() > 255) {
            throw new DBusException("Invalid bus name: " + busname);
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        if (!DBusInterface.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (type.getName().equals(type.getSimpleName())) {
            throw new DBusException("DBusInterfaces cannot be declared outside a package");
        }
        RemoteObject ro = new RemoteObject(busname, objectpath, type, autostart);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.importedObjects.put(i, ro);
        return (I)i;
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, String source, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException("Invalid bus name: " + source);
        }
        this.removeSigHandler(new DBusMatchRule(type, source, null), handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, String source, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException("Invalid bus name: " + source);
        }
        String objectpath = ((RemoteObject)this.importedObjects.get((Object)object)).objectpath;
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(type, source, objectpath), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector v = (Vector)this.handledSignals.get(key);
            if (v != null) {
                v.remove(handler);
                if (v.size() == 0) {
                    this.handledSignals.remove(key);
                    try {
                        this._dbus.RemoveMatch(rule.toString());
                    }
                    catch (NotConnected NC) {
                    }
                    catch (DBusExecutionException DBEe) {
                        throw new DBusException(DBEe.getMessage());
                    }
                }
            }
        }
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, String source, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException("Invalid bus name: " + source);
        }
        this.addSigHandler(new DBusMatchRule(type, source, null), handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, String source, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (source.matches("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$")) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (!source.matches("^:[0-9]*\\.[0-9]*$") || source.length() > 255) {
            throw new DBusException("Invalid bus name: " + source);
        }
        String objectpath = ((RemoteObject)this.importedObjects.get((Object)object)).objectpath;
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(type, source, objectpath), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void addSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        try {
            this._dbus.AddMatch(rule.toString());
        }
        catch (DBusExecutionException DBEe) {
            throw new DBusException(DBEe.getMessage());
        }
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<T>> v = (Vector<DBusSigHandler<T>>)this.handledSignals.get(key);
            if (v == null) {
                v = new Vector<DBusSigHandler<T>>();
                v.add(handler);
                this.handledSignals.put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Map<Object, DBusConnection> map = conn;
        synchronized (map) {
            Object object = this._reflock;
            synchronized (object) {
                if (--this._refcount == 0) {
                    try {
                        Error err = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected");
                        Object object2 = this.pendingCalls;
                        synchronized (object2) {
                            long[] set;
                            long[] lArray = set = this.pendingCalls.getKeys();
                            int n = set.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MethodCall m;
                                long l = lArray[n2];
                                if (-1L != l && (m = this.pendingCalls.remove(l)) != null) {
                                    m.setReply(err);
                                }
                                ++n2;
                            }
                            this.pendingCalls = null;
                        }
                        object2 = this.pendingErrors;
                        synchronized (object2) {
                            this.pendingErrors.add(err);
                        }
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                    conn.remove(this.addr);
                    super.disconnect();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PeerSet
    implements Set<String>,
    DBusSigHandler<DBus.NameOwnerChanged> {
        private Set<String> addresses = new TreeSet<String>();

        public PeerSet() {
            try {
                DBusConnection.this.addSigHandler(new DBusMatchRule(DBus.NameOwnerChanged.class, null, null), this);
            }
            catch (DBusException DBe) {
            }
        }

        @Override
        public void handle(DBus.NameOwnerChanged noc) {
            if ("".equals(noc.new_owner) && this.addresses.contains(noc.name)) {
                this.remove(noc.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(String address) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.add(address);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends String> addresses) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.addAll(addresses);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Set<String> set = this.addresses;
            synchronized (set) {
                this.addresses.clear();
            }
        }

        @Override
        public boolean contains(Object o) {
            return this.addresses.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> os) {
            return this.addresses.containsAll(os);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof PeerSet) {
                return ((PeerSet)o).addresses.equals(this.addresses);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.addresses.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.addresses.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return this.addresses.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> os) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.removeAll(os);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> os) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.retainAll(os);
            }
        }

        @Override
        public int size() {
            return this.addresses.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Set<String> set = this.addresses;
            synchronized (set) {
                return this.addresses.toArray(a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _sighandler
    implements DBusSigHandler<DBusSignal> {
        private _sighandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(DBusSignal s) {
            if (s instanceof DBus.Local.Disconnected) {
                try {
                    Object object;
                    Error err = new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", "Disconnected");
                    if (DBusConnection.this.pendingCalls != null) {
                        object = DBusConnection.this.pendingCalls;
                        synchronized (object) {
                            long[] set;
                            long[] lArray = set = DBusConnection.this.pendingCalls.getKeys();
                            int n = set.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MethodCall m;
                                long l = lArray[n2];
                                if (-1L != l && (m = DBusConnection.this.pendingCalls.remove(l)) != null) {
                                    m.setReply(err);
                                }
                                ++n2;
                            }
                        }
                    }
                    object = DBusConnection.this.pendingErrors;
                    synchronized (object) {
                        DBusConnection.this.pendingErrors.add(err);
                    }
                }
                catch (DBusException dBusException) {}
            } else if (s instanceof DBus.NameAcquired) {
                DBusConnection.this.busnames.add(((DBus.NameAcquired)s).name);
            }
        }
    }
}

