/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBusAsyncReply<ReturnType> {
    private ReturnType rval = null;
    private DBusExecutionException error = null;
    private MethodCall mc;
    private Method me;
    private AbstractConnection conn;

    public static Collection<DBusAsyncReply<? extends Object>> hasReply(Collection<DBusAsyncReply<? extends Object>> replies) {
        ArrayList<DBusAsyncReply<? extends Object>> c = new ArrayList<DBusAsyncReply<? extends Object>>(replies);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (((DBusAsyncReply)i.next()).hasReply()) continue;
            i.remove();
        }
        return c;
    }

    DBusAsyncReply(MethodCall mc, Method me, AbstractConnection conn) {
        this.mc = mc;
        this.me = me;
        this.conn = conn;
    }

    private synchronized void checkReply() {
        if (this.mc.hasReply()) {
            Message m = this.mc.getReply();
            if (m instanceof Error) {
                this.error = ((Error)m).getException();
            } else if (m instanceof MethodReturn) {
                try {
                    this.rval = RemoteInvocationHandler.convertRV(m.getSig(), m.getParameters(), this.me, this.conn);
                }
                catch (DBusExecutionException DBEe) {
                    this.error = DBEe;
                }
                catch (DBusException DBe) {
                    this.error = new DBusExecutionException(DBe.getMessage());
                }
            }
        }
    }

    public boolean hasReply() {
        if (this.rval != null || this.error != null) {
            return true;
        }
        this.checkReply();
        return this.rval != null || this.error != null;
    }

    public ReturnType getReply() throws DBusExecutionException {
        if (this.rval != null) {
            return this.rval;
        }
        if (this.error != null) {
            throw this.error;
        }
        this.checkReply();
        if (this.rval != null) {
            return this.rval;
        }
        if (this.error != null) {
            throw this.error;
        }
        throw new DBus.Error.NoReply(Gettext._("Async call has not had a reply"));
    }

    public String toString() {
        return String.valueOf(Gettext._("Waiting for: ")) + this.mc;
    }

    Method getMethod() {
        return this.me;
    }

    AbstractConnection getConnection() {
        return this.conn;
    }

    MethodCall getCall() {
        return this.mc;
    }
}

