/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import cx.ath.matthew.io.InOutCopier;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExecOutputStream
extends FilterOutputStream {
    private Process proc;
    private InputStream stdout;
    private OutputStream stdin;
    private InOutCopier copy;

    public ExecOutputStream(OutputStream os, Process p) throws IOException {
        super(os);
        this.proc = p;
        this.stdin = p.getOutputStream();
        this.stdout = p.getInputStream();
        this.copy = new InOutCopier(this.stdout, this.out);
        this.copy.start();
    }

    public ExecOutputStream(OutputStream os, String cmd) throws IOException {
        this(os, Runtime.getRuntime().exec(cmd));
    }

    public ExecOutputStream(OutputStream os, String[] cmd) throws IOException {
        this(os, Runtime.getRuntime().exec(cmd));
    }

    public ExecOutputStream(OutputStream os, String cmd, String[] env) throws IOException {
        this(os, Runtime.getRuntime().exec(cmd, env));
    }

    public ExecOutputStream(OutputStream os, String[] cmd, String[] env) throws IOException {
        this(os, Runtime.getRuntime().exec(cmd, env));
    }

    public void close() throws IOException {
        this.stdin.close();
        try {
            this.proc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.copy.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stdout.close();
        this.out.close();
    }

    public void flush() throws IOException {
        this.stdin.flush();
        this.copy.flush();
        this.out.flush();
    }

    public void write(byte[] b) throws IOException {
        this.stdin.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.stdin.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.stdin.write(b);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

