/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import java.io.OutputStream;
import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPrinter {
    public static void printNode(Node n, OutputStream os) {
        PrintStream p = new PrintStream(os);
        DOMPrinter.printNode(n, p);
    }

    public static void printNode(Node n, PrintStream p) {
        if (n.getNodeValue() != null) {
            p.print(n.getNodeValue());
        } else {
            int i;
            p.print("<" + n.getNodeName());
            if (n.hasAttributes()) {
                NamedNodeMap nnm = n.getAttributes();
                i = 0;
                while (i < nnm.getLength()) {
                    Node attr = nnm.item(i);
                    p.print(" " + attr.getNodeName() + "='" + attr.getNodeValue() + "'");
                    ++i;
                }
            }
            if (n.hasChildNodes()) {
                p.print(">");
                NodeList nl = n.getChildNodes();
                i = 0;
                while (i < nl.getLength()) {
                    DOMPrinter.printNode(nl.item(i), p);
                    ++i;
                }
                p.print("</" + n.getNodeName() + ">");
            } else {
                p.print("/>");
            }
        }
    }

    public static void printDOM(Document d, PrintStream p) {
        DocumentType dt = d.getDoctype();
        if (dt != null) {
            p.print("<!DOCTYPE " + dt.getName());
            String pub = dt.getPublicId();
            String sys = dt.getSystemId();
            if (pub != null) {
                p.print(" PUBLIC \"" + pub + "\" \"" + sys + "\"");
            } else if (sys != null) {
                p.print(" SYSTEM \"" + sys + "\"");
            }
            p.println(">");
        }
        Element e = d.getDocumentElement();
        DOMPrinter.printNode((Node)e, p);
    }

    public static void printDOM(Document d, OutputStream os) {
        PrintStream p = new PrintStream(os);
        DOMPrinter.printDOM(d, p);
    }
}

