/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.debug;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Debug {
    public static final int CRIT = 1;
    public static final int ERR = 2;
    public static final int WARN = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    public static final int VERBOSE = 6;
    public static final boolean debug = false;
    public static PrintStream debugout = System.err;
    private static Properties prop = null;
    private static boolean timing = false;
    private static boolean ttrace = false;
    private static boolean lines = false;
    private static boolean hexdump = false;
    private static long last = 0L;
    private static int balen = 36;
    private static int bawidth = 80;
    private static Class saveclass = null;
    private static Map filterMap = new HashMap();

    public static void setProperties(Properties prop) {
        Debug.prop = prop;
    }

    public static void loadConfig(File f) throws IOException {
        prop = new Properties();
        prop.load(new FileInputStream(f));
    }

    public static boolean debugging(Class c, int loglevel) {
        return false;
    }

    public static boolean debugging(String s, int loglevel) {
        return false;
    }

    public static void setOutput(PrintStream p) throws IOException {
        debugout = p;
    }

    public static void setOutput(String filename) throws IOException {
        debugout = new PrintStream(new FileOutputStream(filename, true));
    }

    public static void setOutput() throws IOException {
        Debug.setOutput("./debug.log");
    }

    public static void print(Object d) {
    }

    public static void print(Object o, Object d) {
    }

    public static void print(Object o, int loglevel, Object d) {
    }

    public static void print(Object o, int loglevel, String s) {
    }

    public static void print(Object o, int loglevel, Throwable t) {
    }

    public static void print(Class c, int loglevel, Throwable t) {
    }

    public static void print(int loglevel, Throwable t) {
    }

    public static void print(int loglevel, byte[] b) {
    }

    public static void print(int loglevel, String s) {
    }

    public static void print(Class c, int loglevel, Object d) {
    }

    public static void print(Class c, int loglevel, String s) {
    }

    private static String[] getTraceElements() {
        String[] data = new String[]{"", "", ""};
        try {
            StackTraceElement[] stes;
            Method m = Thread.class.getMethod("getStackTrace", new Class[0]);
            StackTraceElement[] stackTraceElementArray = stes = (StackTraceElement[])m.invoke((Object)Thread.currentThread(), new Object[0]);
            int n = stes.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                if (!(Debug.class.getName().equals(ste.getClassName()) || Thread.class.getName().equals(ste.getClassName()) || Method.class.getName().equals(ste.getClassName()) || ste.getClassName().startsWith("sun.reflect"))) {
                    data[0] = ste.getClassName();
                    data[1] = ste.getMethodName();
                    if (lines) {
                        data[2] = " " + ste.getFileName() + ":" + ste.getLineNumber();
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (NoSuchMethodException NSMe) {
            if (saveclass != null) {
                data[0] = saveclass.getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return data;
    }

    public static void print(int loglevel, Object o) {
    }

    public static void printMap(Object o, int loglevel, Map m) {
    }

    public static void printMap(Class c, int loglevel, Map m) {
    }

    public static void printMap(Map m) {
        Debug.printMap(5, m);
    }

    public static void printMap(int loglevel, Map m) {
    }

    public static void setThrowableTraces(boolean ttrace) {
        Debug.ttrace = ttrace;
    }

    public static void setTiming(boolean timing) {
        Debug.timing = timing;
    }

    public static void setLineNos(boolean lines) {
        Debug.lines = lines;
    }

    public static void setHexDump(boolean hexdump) {
        Debug.hexdump = hexdump;
    }

    public static void setByteArrayCount(int count) {
        balen = count;
    }

    public static void setByteArrayWidth(int width) {
        bawidth = width;
    }

    public static void addFilterCommand(Class c, FilterCommand f) {
        filterMap.put(c, f);
    }

    private static void _print(Class c, int level, String loc, String extra, String message, String[] lines) {
        FilterCommand f = (FilterCommand)filterMap.get(c);
        if (f == null) {
            debugout.println("[" + loc + "] " + extra + message);
            if (lines != null) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    debugout.println(s);
                    ++n2;
                }
            }
        } else {
            f.filter(debugout, level, loc, extra, message, lines);
        }
    }

    public static interface FilterCommand {
        public void filter(PrintStream var1, int var2, String var3, String var4, String var5, String[] var6);
    }
}

