//Signal status
var MACRO_EVDO_LEVEL_ZERO = "0";
var MACRO_EVDO_LEVEL_ONE = "1";
var MACRO_EVDO_LEVEL_TWO = "2";
var MACRO_EVDO_LEVEL_THREE = "3";
var MACRO_EVDO_LEVEL_FOUR = "4";
var MACRO_EVDO_LEVEL_FIVE = "5";

var LENGHT_OF_INDEX = 8;
var LENGTH_OF_ERRMSG = 35;

var ERROR_WRONG_PASSWORD = '117001';

var SECURITY_MODE_NONE = "NONE";

var DIAD_CONNECT = '1';
var DIAD_DISCONNECT = '0';
var WIFI_STATUS_ON = '1';
var WIFI_STATUS_OFF = '0';

var g_MonitoringStatus = '';
var SECURITY_MODE_OPEN = 'OPEN';
var SECURITY_MODE_WEP = 'WEP';
var SECURITY_MODE_WPA_PSK = 'WPA-PSK';
var SECURITY_MODE_WPA2_PSK = 'WPA2-PSK';
var SECURITY_MODE_WPA_WPA2_PSK = 'WPA/WPA2-PSK';
var SECURITY_MODE_WPA_EAP = 'WPA-EAP';
var SECURITY_MODE_WPA2_EAP = 'WPA2-EAP';
var SECURITY_MODE_WPA_WPA2_EAP = 'WPA/WPA2-EAP';
var SECURITY_MODE_WPA_ENTERPRISE = 'WPA_ENTERPRISE';
var SECURITY_MODE_WPA2_ENTERPRISE = 'WPA2_ENTERPRISE';

var g_wifi_ap_info_list = [];
var g_wifiscanresult = [];
var g_isConnecting = false;
var g_ret = false;
var g_isFind = false;

var WIFI_Not_CONNECTED = '-1';
var WIFI_CONNECTING = '900';
var WIFI_CONNECTED = '901';
var WIFI_DISCONNECTED = '902';
var WIFI_DISCONNECTING = '903';
var WIFI_CONNECT_ERROR = '904';

var G3_PREFER = 0;
var WIFI_PREFER = 2;
var WIFI_SCAN_END = '0';
var WIFI_SCANING = '1';

var WIFI_MODE_AUTO = '0';
var WIFI_MODE_MANUAL = '1';

var g_status_wanpolicy = -1;
var g_WifiConnectionStatus = -1;

var g_ap_info = {
    WifiSsid : null,
    WifiSignal : null,
    WifiAuthMode : null,
    WifiSecMode : null,
    WifiNeedPassword : null,
    WifiConnectStatue : WIFI_Not_CONNECTED
};

var g_handover_setting = {
    Handover : '1'
};

var g_wifiscan = {
    Wifiscan : '0'
};

var g_current_id = null;

var g_isNewProfile = false;
var g_isWrongPassWord = false;
var g_current_index = -1;
var g_getHandover = '';
var g_manualflag = false;
var g_checkSimcard_enable = '';
 
function main_executeBeforeDocumentReady() {
    getConfigData('config/offload/config.xml', function($xml) {
        var config_ret = _xml2feature($xml);
        if ('undefined' != config_ret && null != config_ret)
        {
            g_checkSimcard_enable = (config_ret.enable == '1' ? true : false);
        }
    }, {
        sync: true
    });
    if(g_checkSimcard_enable){
        redirectOnCondition(null, "wifinetworks");
    }
}

main_executeBeforeDocumentReady();

$(document).ready(function() {
	
    $('.wifi_ap').live('click', function(){
        if(WIFI_CONNECTING == G_MonitoringStatus.response.WifiConnectionStatus){
            return;
        }
        g_current_id = this.id;
        var index = getWiFiIndex(g_current_id);
	//g_current_index = getWiFiIndex(g_current_id);
        if(WIFI_CONNECTED != g_wifi_ap_info_list[index].WifiConnectStatue && WIFI_CONNECTING
            != g_wifi_ap_info_list[index].WifiConnectStatue){
            showConnectDialog(index);
        }           
    });    
   
    $('#pop_connect').live('click', function(){ 
        if(!isButtonEnable('pop_connect')) {
            return;
        }
	    if(!g_isWrongPassWord){
	        g_current_index = getWiFiIndex(g_current_id);
	    }
	    if(g_isWrongPassWord || g_wifi_ap_info_list[g_current_index].WifiNeedPassword){
            var WifiAuthSecret = $('#wifi_password').val();
            //g_wifi_ap_info_list[g_current_index].WifiAuthSecret = WifiAuthSecret;          
	        if(checkWifiSecurity(WifiAuthSecret, g_wifi_ap_info_list[g_current_index].WifiSecMode, 'wifi_password')){		               
                setWifi(WifiAuthSecret);                  
	        }			          
	    }
	    else{		    
	        setWifi(''); 
        }
    });
    
    addStatusListener('CheckWiFiConnectStatue()');

    getHandoverSetting();
    addStatusListener('getStatusWanPolicy()');
    //getWiFiAPinfo();

    $('#turnOff_button').live('click', function() {
        if(!isButtonEnable('turnOff_button')) {
            return;
        }
        g_handover_setting.Handover = '0';
        $('#turnOff_button').removeClass('mouse_on');
        button_enable('turnOff_button', '0');
        setHandoverSetting();

    });
    $('#turnOn_button').live('click', function() {
        if(!isButtonEnable('turnOn_button')) {
            return;
        }
        g_handover_setting.Handover = '2';
        $('#turnOn_button').removeClass('mouse_on');
        button_enable('turnOn_button', '0');
        setHandoverSetting();   
    });

    $('#pop_cancel').live('click', function() {
        if(!isButtonEnable('pop_cancel')) {
            return;
        }
        if(g_isNewProfile) {
            removeFromApinfoList(0);
            g_isNewProfile = false;
        }
        g_isWrongPassWord = false;
        promag_cancel();
    });

    $('#pop_authmode').live('change', function() {
        if(SECURITY_MODE_NONE == this.value || SECURITY_MODE_WPA_WPA2_EAP == this.value) {
            $('#password_wrapper').hide();
            $('.addwifi_dialog_table').css({
                height : '160px'
            });
        }
        else {
            $('#password_wrapper').show();
            $('.addwifi_dialog_table').css({
                height : '220px'
            });
        }
    });

    $('#check_wpa_psk').live('click', function() {
        showPassword();
    });

    $('#pop_save').live('click', function() {
        if(!isButtonEnable('pop_save')) {
            return;
        }
        var wifissid = $.trim($('#ssid_input').val());
        var wifiAuthMode = $('#pop_authmode').val();
        var WifiAuthSecret = $('#add_wifi_password').val();
        var index = -1;
        var i = 0;
        if(wifiProfile_validation_checkName(wifissid, WifiAuthSecret, wifiAuthMode)) {
            disconnectConnectedWiFi();
            var wifiProfile = {
                WifiSsid : wifissid,
                WifiAuthMode : '',
                WifiSecMode : wifiAuthMode,
                WifiAuthSecret : WifiAuthSecret
            };
            var g_ap_info = {
                WifiSsid : wifissid,
                WifiSignal : '1',
                WifiAuthMode : null,
                WifiSecMode : wifiAuthMode,
                WifiNeedPassword : false,
                WifiConnectStatue : WIFI_CONNECTING
            };            
            for( i ; i < g_wifi_ap_info_list.length; i++) {
                if(wifissid == g_wifi_ap_info_list[i].WifiSsid && 
                   wifiAuthMode == g_wifi_ap_info_list[i].WifiSecMode) {
                    index = i;
                    break;
                }
            }
            if(-1 != index){
                wifiProfile = {
                    WifiSsid : g_wifi_ap_info_list[index].WifiSsid,
                    WifiAuthMode : g_wifi_ap_info_list[index].WifiAuthMode,
                    WifiSecMode : g_wifi_ap_info_list[index].WifiSecMode,
                    WifiAuthSecret : WifiAuthSecret
                };
                setProfileSetting(wifiProfile,index);
            }else{
                g_isNewProfile = true;
                addToApinfoList(g_ap_info);
                g_current_index = 0;
                setProfileSetting(wifiProfile, 0); 
            }
            $('#wifi_scan').hide();
            $('#wifi_no_ap').hide();
            $('#wifioffload_setting').show();
            promag_cancel();
        }
    });

    $('#wifi_disconnect').live('click', function() {
        if(!isButtonEnable('wifi_disconnect')) {
            return;
        }
        disconnectWiFi(0);
    });


    $('#scan_button').live('click', function() {
        if(!isButtonEnable('scan_button')) {
            return;
        }
        scanWifi();
    });
	
    $('#addWiFI_button').live('click', function() {
        addNewWifi();
    });
	
    $('.dialog_close_btn, .pop_Cancel').live('click', function() {
        if(g_isNewProfile) {
            removeFromApinfoList(0);
            g_isNewProfile = false;
        }
        g_isWrongPassWord = false;
    });

    $('.dialog_close_btn').live('click', function() {
        if(g_isNewProfile) {
            removeFromApinfoList(0);
            g_isNewProfile = false;
        }
    });
});

function setWifi(WifiAuthSecret){
    disconnectConnectedWiFi();
    var wifiProfile = {
        WifiSsid : g_wifi_ap_info_list[g_current_index].WifiSsid,
        WifiAuthMode : g_wifi_ap_info_list[g_current_index].WifiAuthMode,
        WifiSecMode : g_wifi_ap_info_list[g_current_index].WifiSecMode,
        WifiAuthSecret : WifiAuthSecret
    }; 
    g_ret = false;
    g_isWrongPassWord = false;
    setProfileSetting(wifiProfile, g_current_index);
    promag_cancel();
}

function disconnectConnectedWiFi() {
    if(g_wifi_ap_info_list.length > 0) {
        if(WIFI_CONNECTING == g_wifi_ap_info_list[0].WifiConnectStatue || WIFI_CONNECTED == g_wifi_ap_info_list[0].WifiConnectStatue) {
            g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_Not_CONNECTED;
            //disconnectWiFi(0);
        }
    }
}

function promag_cancel() {
    $('#div_wrapper').remove();
    $('.dialog').remove();
    $('.login_dialog').remove();
}

function disconnectWiFi(index) {
    var wifiDial = {
        DialAction : DIAD_DISCONNECT,
        WifiSsid : wifiSsidResolveCannotParseChar(g_wifi_ap_info_list[index].WifiSsid),
        WifiSecMode : g_wifi_ap_info_list[index].WifiSecMode
    };
    var isAddNewAP = false;
    if(WIFI_Not_CONNECTED == g_wifi_ap_info_list[index].WifiConnectStatue) {
        isAddNewAP = true;
    }
    var dial_xml = object2xml('request', wifiDial);
    saveAjaxData('api/wlan/wifidial', dial_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
            log.debug('api/wlan/wifidial ok');
            if(!isAddNewAP) {
                g_wifi_ap_info_list[index].WifiConnectStatue = WIFI_DISCONNECTING;
                moveToTopOfApLsit(g_wifi_ap_info_list[index].WifiSsid,g_wifi_ap_info_list[index].WifiSecMode);
                creatWifiList();
            }
        }
        else {
            log.debug('api/wlan/wifidial error');
        }
    });
}

function connectWiFi(index) {
    var wifiDial = {
        DialAction : DIAD_CONNECT,
        WifiSsid : wifiSsidResolveCannotParseChar(g_wifi_ap_info_list[index].WifiSsid),
        WifiSecMode : g_wifi_ap_info_list[index].WifiSecMode
    };
	var i = 0;
    var dial_xml = object2xml('request', wifiDial);
    saveAjaxData('api/wlan/wifidial', dial_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
        log.debug('api/wlan/wifidial ok');
	    for( i ; i < g_wifi_ap_info_list.length; i++) {
            g_wifi_ap_info_list[i].WifiConnectStatue = WIFI_Not_CONNECTED;
        } 
        moveToTopOfApLsit(g_wifi_ap_info_list[index].WifiSsid,g_wifi_ap_info_list[index].WifiSecMode);
	    g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_CONNECTING;
        creatWifiList();
	    g_current_index = 0;
        }
        else {
            log.debug('api/wlan/wifidial error');
        }
    }, {
        sync : true
    });

    getAjaxData('api/monitoring/status', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            G_MonitoringStatus = ret;
        }
    }, {
        sync : true
    });
}

function setProfileSetting(wifiProfile, index) {
   
    wifiProfile.WifiSsid = wifiSsidResolveCannotParseChar(wifiProfile.WifiSsid);
    var profile_xml = object2xml('request', wifiProfile);
    saveAjaxData('api/wlan/wifiaddprofile', profile_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
            log.debug('api/wlan/wifiaddprofile ok');
            connectWiFi(index);
        }else if(ERROR_SYSTEM_BUSY == ret.error.code){
            showInfoDialog(common_system_busy);
	    $('#wifi_scan').hide();
	    $('#wifi_no_ap').show();
	    button_enable('addWiFI_button', '1');
            button_enable('scan_button', '1');
	}
        else {
            log.debug('api/wlan/wifiaddprofile error');
        }
    });
}

function getWiFiIndex(current_id) {
    var index = current_id.substring(LENGHT_OF_INDEX, current_id.length);
    return parseInt(index, 10);
}

function showPassword() {
    var cbValue = $('#check_wpa_psk').attr('checked');
    var strType = cbValue ? 'text' : 'password';
    var a = $('#wifi_password').attr('type');
    $("<input id='wifi_password' type='" + strType + "' class='input'  value='" + $('#wifi_password').val() + "' />").replaceAll($('#wifi_password'));
}

//Button connection or disconnection click effect
function index_clickTrunOnBtn() {

    scanWifi();
    $('#wifi_switch_button').html(create_button_html(common_turn_off, "turnOff_button"));

}

function index_clickTurnOffBtn() {

    $('#wifi_switch_button').html(create_button_html(common_turn_on, "turnOn_button"));
    $('#wifi_content').hide();
    $('#scan_div').hide();

}

function getStatusWanPolicy(){
    if(g_status_wanpolicy != G_MonitoringStatus.response.WanPolicy && g_manualflag == false){   
        g_handover_setting.Handover = G_MonitoringStatus.response.WanPolicy;
        showWaitingDialog(common_waiting, sd_hint_wait_a_few_moments);
	    g_getHandover = '';
	    g_status_wanpolicy = G_MonitoringStatus.response.WanPolicy;
	    setTimeout( function() {
	        getHandoverSuccessSetting();
	    }, 1500); 
    }
}
function getHandoverSetting() {
    getAjaxData("api/wlan/handover-setting", function($xml) {
        var ret = xml2object($xml);
        if(ret.type == "response") {
            if(WIFI_PREFER == ret.response.Handover) {
	            g_status_wanpolicy = WIFI_PREFER;
                index_clickTrunOnBtn();
            }
            else {
	            g_status_wanpolicy = G3_PREFER;
                index_clickTurnOffBtn();
            }
        }
        else {
            log.error("WiFi network: get api/wlan/handover-setting data error");
        }
    });
}

function setHandoverSetting() {
    var handDover_xml = object2xml('request', g_handover_setting);
    saveAjaxData('api/wlan/handover-setting', handDover_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
            log.debug('api/wlan/handover-setting ok');
	    showWaitingDialog(common_waiting, sd_hint_wait_a_few_moments);
	    g_getHandover = '';
	    g_manualflag = true;
	    setTimeout( function() {
	        getHandoverSuccessSetting();
	    }, 1000); 
        }
        else {
            log.debug('api/wlan/handover-setting error');
	    if(ERROR_SYSTEM_BUSY == ret.error.code){
	        showInfoDialog(common_system_busy);
	    }else{
	        showInfoDialog(common_failed);
	    }           
            if(g_status_wanpolicy == WIFI_PREFER){
                button_enable('turnOff_button',1);
            }else{
                button_enable('turnOn_button',1);
            }
        }
    });
}

function getHandoverSuccessSetting(){
    getAjaxData("api/monitoring/status", function($xml) {
        var gstatus_ret = xml2object($xml);
	if(gstatus_ret.type == "response") {
	    g_MonitoringStatus = gstatus_ret; 
	}
    }, {
        sync: true
    });

    if(WIFI_STATUS_ON == g_MonitoringStatus.response.WifiStatus){
        var handDover_xml = object2xml('request', g_handover_setting);
        saveAjaxData('api/wlan/handover-setting', handDover_xml, function($xml) {
        var ret = xml2object($xml);
        if(ret.type == "error") {
            g_getHandover = ret.error.code;
        }else{
            g_getHandover = '';
        }
        }, {
            sync: true
        });
        if(g_getHandover == ERROR_SYSTEM_BUSY) {
            setTimeout( function() {
                getHandoverSuccessSetting();
            }, 1000);
        }else{
            if(WIFI_PREFER == g_handover_setting.Handover) {
                g_status_wanpolicy = WIFI_PREFER;
                index_clickTrunOnBtn();
            }else{
                g_status_wanpolicy = G3_PREFER;
                index_clickTurnOffBtn();
            }
            closeWaitingDialog();
            g_manualflag = false;
	}
    }else{
        setTimeout( function() {
            getHandoverSuccessSetting();
        }, 1000);
    }		
}


function scanWifi() {
    $('#scan_div').show();
    $('#wifi_scan').show();

    $('#wifi_content').show();
    $('#wifioffload_setting').hide();
    $('#wifi_no_ap').hide();

    button_enable('addWiFI_button', '0');
    button_enable('scan_button', '0');
    var scan_xml = object2xml('request', g_wifiscan);
    saveAjaxData('api/wlan/wifiscan', scan_xml, function($xml) {
        var scan_ret = xml2object($xml);
        if(isAjaxReturnOK(scan_ret)) {
            g_wifi_ap_info_list = [];
            checkWifiScanStatue();
        }else if(ERROR_SYSTEM_BUSY == scan_ret.error.code){
            showInfoDialog(common_system_busy);
	    $('#wifi_scan').hide();
	    $('#wifi_no_ap').show();
	    button_enable('addWiFI_button', '1');
            button_enable('scan_button', '1');
	}
        else {
            log.debug('WiFi network: post api/wlan/wifiscan error');
        }
    });
}

function checkWifiScanStatue() {
    getAjaxData("api/wlan/wifiscan", function($xml) {
        var ret = xml2object($xml);
        if(ret.type == "response") {
            if(WIFI_SCAN_END == ret.response.Wifiscan) {
                getWiFiAPinfo();
            }
            else if(WIFI_SCANING == ret.response.Wifiscan) {
                setTimeout(function() {
                    checkWifiScanStatue();
                }, 1000);
            }
        }
        else {    
            $('#wifi_scan').hide();
            $('#wifi_no_ap').show();
            $('#wifioffload_setting').hide();
            g_wifiscanresult = [];

            button_enable('addWiFI_button', '1');
            button_enable('scan_button', '1');
            log.error("WiFi network: get api/wlan/wifiscan  data error");
        }
    });
}

function getWiFiAPinfo() {
    getAjaxData("api/wlan/wifiscanresult", function($xml) {
        var ret = xml2object($xml);
        if(ret.type == "response") {
            g_wifiscanresult = ret.response.SsidLists.SsidList;
            if($.isArray(g_wifiscanresult) || 
               ((typeof (g_wifiscanresult) != 'undefined') && g_wifiscanresult != null && g_wifiscanresult != '')) {
                setWiFiList();
                CheckWiFiConnectStatue();
                $('#wifi_scan').hide();
                $('#wifi_no_ap').hide();
                $('#wifioffload_setting').show();
            }
            else {
                $('#wifi_scan').hide();
                $('#wifi_no_ap').show();
                $('#wifioffload_setting').hide();
            }
        }
        else {
            $('#wifi_scan').hide();
            $('#wifi_no_ap').show();
            $('#wifioffload_setting').hide();
            g_wifiscanresult = [];

            button_enable('addWiFI_button', '1');
            button_enable('scan_button', '1');
            log.error("WiFi network: get api/wlan/wifiscanresult data error");
        }
    });
}

function CheckWiFiConnectStatue() {
    /* if (G_MonitoringStatus.response.WifiConnectionStatus == WIFI_CONNECTED ||
    G_MonitoringStatus.response.WifiConnectionStatus == WIFI_CONNECTING ||
    G_MonitoringStatus.response.WifiConnectionStatus == WIFI_DISCONNECTING )
    {*/
    //getAjaxData("api/wlan/station-information", function($xml) {
    var ret = G_StationStatus;
    if(ret.type == "response") {
        if(g_wifi_ap_info_list.length > 0) {

            if(ret.response.NetworkName == '' || ret.response.NetworkName == null) {
                g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_Not_CONNECTED;
            }
            else if(G_MonitoringStatus.response.WifiConnectionStatus == WIFI_CONNECTED && g_wifi_ap_info_list[0].WifiSsid == ret.response.NetworkName
			       && g_wifi_ap_info_list[0].WifiSecMode == ret.response.CurrentSecMode) {
                g_wifi_ap_info_list[0].WifiSignal = ret.response.SignalStrength;
            }
            else if(!(ret.response.NetworkName == g_wifi_ap_info_list[0].WifiSsid && g_wifi_ap_info_list[0].WifiSecMode == ret.response.CurrentSecMode)) {
                g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_Not_CONNECTED;
                moveToTopOfApLsit(ret.response.NetworkName,ret.response.CurrentSecMode);
                if(g_isFind && G_MonitoringStatus.response.WifiConnectionStatus == WIFI_CONNECTED) {
                    g_wifi_ap_info_list[0].WifiSignal = ret.response.SignalStrength;
                }
            }
            if(g_isNewProfile && 
                (WIFI_CONNECTING != G_MonitoringStatus.response.WifiConnectionStatus && 
                 WIFI_CONNECTED != G_MonitoringStatus.response.WifiConnectionStatus)) {
                    g_isNewProfile = false;
                    removeFromApinfoList(0);
                    if(g_wifi_ap_info_list.length <= 0) {
                        $('#wifi_no_ap').show();
                        $('#wifioffload_setting').hide();
                    }
            }
        }

        changeWiFiList(ret.response.NetworkName,ret.response.CurrentSecMode);
    }
    else {
        if(ret.type == 'error') {
            if(ERROR_WRONG_PASSWORD == ret.error.code) {
                g_isWrongPassWord = true;
                showPasswrodDiag();
            }
        }
        log.error("WiFi network: get api/wlan/station-information data error");
    }
}

function setWiFiList() {
    g_wifi_ap_info_list = [];
    if($.isArray(g_wifiscanresult)) {
        $.each(g_wifiscanresult, function(i) {
            var ap_info = {
                WifiSsid : g_wifiscanresult[i].WifiSsid,
                WifiSignal : g_wifiscanresult[i].WifiSignal,
                WifiAuthMode : g_wifiscanresult[i].WifiAuthMode,
                WifiSecMode : g_wifiscanresult[i].WifiSecMode,
                WifiNeedPassword : ('1' == g_wifiscanresult[i].WifiNeedPassword ? true : false),
                WifiConnectStatue : WIFI_Not_CONNECTED
            };
            g_wifi_ap_info_list.push(ap_info);
        });
    }
    else {
        var ap_info = {
            WifiSsid : g_wifiscanresult.WifiSsid,
            WifiSignal : g_wifiscanresult.WifiSignal,
            WifiAuthMode : g_wifiscanresult.WifiAuthMode,
            WifiSecMode : g_wifiscanresult.WifiSecMode,
            WifiNeedPassword : ('1' == g_wifiscanresult.WifiNeedPassword ? true : false),
            WifiConnectStatue : WIFI_Not_CONNECTED
        };
        g_wifi_ap_info_list.push(ap_info);
    }

}

function addToApinfoList(ap_info) {
    g_wifi_ap_info_list.unshift(ap_info);
}

function removeFromApinfoList(index) {
    g_wifi_ap_info_list.splice(index, 1);
}

function moveToTopOfApLsit(NetworkName,CurrentSecMode) {
    var i = 0;
    var index = -1;
    for(i; i < g_wifi_ap_info_list.length; i++) {
        if(NetworkName == g_wifi_ap_info_list[i].WifiSsid && 
            CurrentSecMode == g_wifi_ap_info_list[i].WifiSecMode) {
            index = i;
            break;
        }
    }
    if(-1 != index) {
        var wifi_ap_info = g_wifi_ap_info_list.splice(index, 1);
        g_wifi_ap_info_list.unshift(wifi_ap_info[0]);
	g_isFind = true;
    }
}

function changeWiFiList(NetworkName,CurrentSecMode) {
    if(g_wifi_ap_info_list.length > 0) {
        moveToTopOfApLsit(NetworkName,CurrentSecMode);
	if(g_isFind){
	    g_wifi_ap_info_list[0].WifiConnectStatue = G_MonitoringStatus.response.WifiConnectionStatus;
	}else{
	    if(null != NetworkName && '' != NetworkName){
                var apinfo = {
                    WifiSsid : G_StationStatus.response.NetworkName,
                    WifiSignal : G_StationStatus.response.SignalStrength,
                    WifiAuthMode : null,
                    WifiSecMode : G_StationStatus.response.CurrentSecMode,
                    WifiNeedPassword : false,
                    WifiConnectStatue : G_MonitoringStatus.response.WifiConnectionStatus
                };
                addToApinfoList(apinfo);
            }else{
                g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_Not_CONNECTED;
            }
	}
        g_isFind = false;
        creatWifiList();    
    }

}

function creatWifiList() {
    var wifiTableHtml = "";
    var i = 0;
    var wifiSignal = "";

    var isConnecting = false;

    for(i; i < g_wifi_ap_info_list.length; i++) {
        wifiSignal = setWifiSignal(g_wifi_ap_info_list[i].WifiSignal);
        var wifiTrId = "wifi_ap_" + i;
        var wifiSignalId = "wifi_signal_" + i;
        var SecurityMode = "";

        switch(g_wifi_ap_info_list[i].WifiConnectStatue) {
            case WIFI_CONNECTING:
                SecurityMode = dialup_label_connecting;
                break;
            case WIFI_CONNECTED:
                SecurityMode = dialup_label_connected;
                break;

            default:
                if(SECURITY_MODE_NONE == g_wifi_ap_info_list[i].WifiSecMode) {
                    SecurityMode = wlan_label_open;
                }
                else {
                    SecurityMode = wifi_label_Secure_mode.replace('%s', g_wifi_ap_info_list[i].WifiSecMode);
                }
                break;
        }
        
        var signal_photo = '';
        if(g_wifi_ap_info_list[i].WifiSecMode == SECURITY_MODE_NONE) {
            signal_photo = "../res/station_" + wifiSignal + ".gif";
        }
        else {
            signal_photo = "../res/stationkey_" + wifiSignal + ".gif";
        }
        wifiTableHtml += "<tr class='wifi_ap' id='" + wifiTrId + "'>";
        wifiTableHtml += "<td width='240'>";
        wifiTableHtml += "<div class='wifiName'><span>" + replaceSpace(g_wifi_ap_info_list[i].WifiSsid) + "</span></div>";
        wifiTableHtml += "<div>" + SecurityMode + "</div>";
        wifiTableHtml += "</td>";
        wifiTableHtml += "<td><div class='wifi_signal'  style='background: url(" + signal_photo + ") 0 0 no-repeat' ></div>";
        wifiTableHtml += "</td>";
        wifiTableHtml += "</tr>";

    }
    $('.wifioffload_settings').html(wifiTableHtml);

    if(g_wifi_ap_info_list.length > 0 && WIFI_CONNECTING == g_wifi_ap_info_list[0].WifiConnectStatue) {
        g_isConnecting = true;
        $('#scan_button').removeClass('mouse_on');
        button_enable('scan_button', '0');
        $('#addWiFI_button').removeClass('mouse_on');
        button_enable('addWiFI_button', '0');
        button_enable('wifi_connect', '0');

    }
    else {
        g_isConnecting = false;
        button_enable('scan_button', '1');
        button_enable('addWiFI_button', '1');

        button_enable('wifi_connect', '1');
    }
}

function showConnectDialog(index){
    var dialogHtml = '';
    var wifiSecMode = '';
    dialogHtml += "        <div class='addwifi_dialog_table'>";
    dialogHtml += "               <table width='370' border='0' cellpadding='0' cellspacing='0' class='new_profile'>";
    dialogHtml += "               <tr id='ssid_div'>";
    dialogHtml += "                   <td hight='32' colspan='2'><p>" + replaceSpace(g_wifi_ap_info_list[index].WifiSsid) + "</p></td>";
    dialogHtml += '               </tr>';
    dialogHtml += '               </table>';
    dialogHtml += "               <table width='370' border='0' cellpadding='0' cellspacing='0' class='new_profile'>";
    dialogHtml += "               <tr id='authentication_div'>";
    dialogHtml += "                   <td width='130'><p>"+ wlan_label_authentication  + common_colon + "</p></td>";
    if(SECURITY_MODE_NONE == g_wifi_ap_info_list[index].WifiSecMode){
        wifiSecMode = wlan_label_open;
    }else{
        wifiSecMode = g_wifi_ap_info_list[index].WifiSecMode;
    }
    dialogHtml += "                   <td><span>" + wifiSecMode + "</span></td>";
    dialogHtml += '               </tr>';
    if(g_wifi_ap_info_list[index].WifiNeedPassword){
        dialogHtml += "               <tr id='password_wrapper'>";
        dialogHtml += "                   <td width='130'><p>" + common_password + common_colon + "</p></td>";
        dialogHtml += "                   <td><span><input type='password'  class='input' id='wifi_password' /></span></td>";
        dialogHtml += '               </tr>';
    }
    dialogHtml += '               </table>';
    dialogHtml += '        </div>';

    showDialog(common_confirm,dialogHtml,common_connect,'pop_connect',common_cancel,'pop_cancel');
    $('#wifi_password').focus();
    if(g_wifi_ap_info_list[index].WifiNeedPassword){
        $('.addwifi_dialog_table').css({
            height : '140px'
        });
    }else{
        $('.addwifi_dialog_table').css({
            height : '110px'
        });
    }
}

function addNewWifi() {
    if(!isButtonEnable('addWiFI_button')) {
        return;
    }
    showAddWiFiDialog();
}

function showAddWiFiDialog() {
    var dialogHtml = '';

    dialogHtml += "        <div class='addwifi_dialog_table'>";
    dialogHtml += "               <div id='ssid_div'>";
    dialogHtml += '                   <p>' + wlan_label_ssid + common_colon + '</p>';
    dialogHtml += "                   <span><input type='text' class='input' id='ssid_input' maxlength='32'/></span>";
    dialogHtml += '               </div>';
    dialogHtml += "               <div id='authentication_div'>";
    dialogHtml += '               <p>' + wlan_label_authentication + common_colon + '</p>';
    dialogHtml += "                   <span>";
    dialogHtml += "                       <select name='authentication_mode' id='pop_authmode'>";
    dialogHtml += "                        <option value='" + SECURITY_MODE_NONE + "'>" + wlan_label_open + '</option>';
    dialogHtml += "                        <option value='" + SECURITY_MODE_WEP + "'>" + wlan_label_wep + '</option>';
    dialogHtml += "                        <option value='" + SECURITY_MODE_WPA_WPA2_PSK + "'>" + wlan_label_wpa_wpa2_psk + '</option>';
    dialogHtml += '                       </select>';
    dialogHtml += "                   </span>";
    dialogHtml += '               </div>';
    dialogHtml += "               <div id='password_wrapper'>";
    dialogHtml += '                  <p>' + common_password + common_colon + '</p>';
    dialogHtml += "                   <span><input type='password'  class='input' id='add_wifi_password' /></span>";
    dialogHtml += '               </div>';
    dialogHtml += '        </div>';

    showDialog(wifi_label_addwifi_network,dialogHtml,common_save,'pop_save',common_cancel,'pop_cancel');
    $('#password_wrapper').hide();
    $('#ssid_input').focus();
}

function showDialog(common_title,content,button1_text,button1_Id,button2_text,button2_Id){
    $('#div_wrapper').remove();
    $('.login_dialog').remove();

    var dialogHtml = '';
    if($('#div_wrapper').size() < 1) {
        dialogHtml += "<div id='div_wrapper'><iframe   id='ifream_dialog'  src= '' frameborder= '0' style= 'background:#bcbcbc; position:absolute; width:100%; height:100%; z-index:-1; display: block;'> </iframe></div>";
    }
    dialogHtml += "<div class='login_dialog' id='dialog'>";
    dialogHtml += "    <div class='login_dialog_top'></div>";
    dialogHtml += "    <div class='login_dialog_content'>";
    dialogHtml += "        <div class='login_dialog_header'>";
    dialogHtml += "            <span class='dialog_header_left'>" + common_title + '</span>';
    dialogHtml += "            <span class='dialog_header_right'><a class='dialog_close_btn' title='' href='javascript:void(0);'><img src='../res/dialog_close_btn.gif' title='' alt='' /></a></span>";
    dialogHtml += '        </div>';
    dialogHtml += content;
    dialogHtml += "        <div class='login_dialog_table_bottom'>";
    dialogHtml += "              <span class='button_wrapper pop_save' id='"+button1_Id+"'>";
    dialogHtml += "                  <span class='button_left'>";
    dialogHtml += "                      <span class='button_right'>";
    dialogHtml += "                            <span class='button_center'><a href='javascript:void(0);' title=''>" + button1_text + '</a></span>';
    dialogHtml += '                      </span></span></span>';
    dialogHtml += "              <span class='button_wrapper' id='"+button2_Id+"'>";
    dialogHtml += "                  <span class='button_left'>";
    dialogHtml += "                      <span class='button_right'>";
    dialogHtml += "                            <span class='button_center'><a href='javascript:void(0);' title=''>" + button2_text + '</a></span>';
    dialogHtml += '                      </span></span></span>';
    dialogHtml += '        </div>';
    dialogHtml += '    </div>';
    dialogHtml += "    <div class='login_dialog_bottom'></div>";
    dialogHtml += '</div>';

    $('.body_bg').before(dialogHtml);

    reputPosition($('#dialog'), $('#div_wrapper'));
    g_main_displayingPromptStack.push(button1_Id);

    disableTabKey();
}



function wifiProfile_validation_checkName(wifissid, WifiAuthSecret, wifiAuthMode) {
    clearAllErrorLabel();
    var name = $.trim($('#ssid_input').val());
    var errMsg = validateSsid(name);
     
    if(common_ok != errMsg) {
        showErrorUnderTextbox('ssid_input', errMsg);
        $('#ssid_input').focus();
        $('#ssid_input').select();
        return false;
    }
    else if(!checkWifiSecurity(WifiAuthSecret, wifiAuthMode, 'add_wifi_password')) {
        return false;     
    }
    return true;
}

function checkWifiSecurity(WifiAuthSecret, wifiAuthMode, id) {
    var strNetworkKey = WifiAuthSecret;
    var authMethod = wifiAuthMode;
    
    clearAllErrorLabel();
	
    if(SECURITY_MODE_WPA_PSK == authMethod || SECURITY_MODE_WPA2_PSK == authMethod || SECURITY_MODE_WPA_WPA2_PSK == authMethod) {
        return checkWpaPwd(WifiAuthSecret, id);
    }
    else if(SECURITY_MODE_WEP == authMethod) {
        return checkNWepKeyPwd(WifiAuthSecret, id);
    }
    else {
        return true;
    }
}

function checkNWepKeyPwd(password, id) {
    var pwdVal = password;
    var errMsg = null;
    
	
    if(0 == pwdVal.length) {
        errMsg = dialup_hint_password_empty;
    }
    else if(hasSpaceOrTabAtHead(pwdVal)) {
        errMsg = input_cannot_begin_with_space;
    }
    else if(10 == pwdVal.length || 26 == pwdVal.length) {
        if(!isHexString(pwdVal)) {
            errMsg = wlan_hint_64_or_128_bit_key;
        }
        else {
            g_ret = true;
        }
    }
    else if(5 == pwdVal.length || 13 == pwdVal.length) {
        if(!checkInputChar(pwdVal)) {
            errMsg = wlan_hint_wep_key_valid_type;
        }
        else {
            g_ret = true;
        }
    }
    else {
        errMsg = wlan_hint_64_or_128_bit_key;
    }

    if(!g_ret) {
        if(id == 'wifi_password'){
           showErrorUnderTextField(id,errMsg); 
        }else{
           showErrorUnderTextbox(id,errMsg);
        }
        $('#' + id).focus();
        $('#' + id).select();
    }
    return g_ret;
}

function checkWpaPwd(password, id) {
    var pwdVal = password;
    var errMsg = null;
    if(0 == pwdVal.length) {
        errMsg = dialup_hint_password_empty;
    }
    else if(hasSpaceOrTabAtHead(pwdVal)) {
        errMsg = input_cannot_begin_with_space;
    }
    else if(64 == pwdVal.length) {
        if(!isHexString(pwdVal)) {
            errMsg = wlan_hint_wps_psk_valid_type;
        }
        else {
            g_ret = true;
        }
    }
    else if(pwdVal.length >= 8 && pwdVal.length <= 63) {
        if(!checkInputChar(pwdVal)) {
            errMsg = wlan_hint_wps_psk_valid_char;
        }
        else {
            g_ret = true;
        }
    }
    else {
        errMsg = wlan_hint_wps_psk_valid_type;
    }

    if(!g_ret) {
        if(id == 'wifi_password'){
           showErrorUnderTextField(id,errMsg); 
        }else{
           showErrorUnderTextbox(id,errMsg);
        }         
        $('#' + id).focus();
        $('#' + id).select();
    }

    return g_ret;
}

function showErrorUnderTextField(id,errMsg){
    $.each($('.pro_wrong'), function(i) {
        $(this).remove();
    });
    var wrongHtml = "<tr class='pro_wrong'>";
    wrongHtml += '<td>&nbsp;</td>';
    wrongHtml += "<td colspan='2' class='pro_wrong_td' id='temp_wrong'>&nbsp;</td>";
    wrongHtml += '</tr>';
    if(!g_ret){
        $('#'+id).focus();
        $('#password_wrapper').after(wrongHtml);
        $('#temp_wrong').attr('id', 'pro_name_wrong');
        $('#pro_name_wrong').html(errMsg);
	if(errMsg.length > LENGTH_OF_ERRMSG){
	    $('.addwifi_dialog_table').css({
                height : '170px'
            });
	}else{
	    $('.addwifi_dialog_table').css({
                height : '130px'
            });  
	}
    }

}

function showPasswrodDiag() {
   
    var dialogHtml = '';
    var dialogInfo = '';

    if(g_isWrongPassWord) {
        dialogInfo = wifi_label_wrong_passwrod_notice;
    }
    else {
        dialogInfo = wifi_label_passwrod_notice;
    }

    dialogHtml += "        <div class='password_dialog_table'>";
    dialogHtml += "               <table width='370' border='0' cellpadding='0' cellspacing='0' class='new_profile'>";
    dialogHtml += "               <div id='intput_password_wrapper'>";
    dialogHtml += "                  <tr><td width='20'>&nbsp;</td><td><p>" + dialogInfo + "</p></td></tr>";
    dialogHtml += "                   <tr id='password_wrapper'><td width='20'>&nbsp;</td><td><p><span><input type='password'  class='input' id='wifi_password' /></span></p></td></tr>";
    dialogHtml += '               </div>';
    dialogHtml += '               </table>';
    dialogHtml += '        </div>';

    showDialog(wlan_lable_notice,dialogHtml,common_connect,'pop_connect',common_cancel,'pop_cancel');
    $('#wifi_password').focus();

}