// JavaScript Document
/**************************Function for PIN code auto validation page********************************/
var MACRO_SIM_LOCK_ENABLE = '1';
var MACRO_PIN_OPERATE_VALIDATE = 0;
var MACRO_PUK_UNLOCK_OPERATE = 4;
var send_request = {
    OperateType: MACRO_PUK_UNLOCK_OPERATE,
    CurrentPin: '',
    NewPin: '',
    PukCode: ''
};

var simlock_status = {
    SimLockEnable: '',
    SimLockRemainTimes: '',
    pSimLockEnable: '',
    pSimLockRemainTimes: ''
};

var pin_status = {
    SimState: '',
    PinOptState: '',
    SimPinTimes: '',
    SimPukTimes: ''
};

var pinautovalidate_getPinData = {
    SimSavepinStatus: '',
    SimSavepinScid: ''
};

var pinautovalidate_savePinData = {
    SimSavepinStatus: '',
    SimSavepinPIN: ''
};
var remaining_times = 0;

function checkButtonEnable()
{
    if (($('#auto_pincode').val()).length >= 4 || 0 == $('input:checked').val()) {
            button_enable('validate_apply', '1');
    }
    else {
        button_enable('validate_apply', '0');
    }
    if (($('#input_simunlock').val()).length >= 8) {
        button_enable('simrequired_button_apply', '1');
    }
    else {
        button_enable('simrequired_button_apply', '0');
    }
    if (($('#input_puk').val()).length >= 4 && ($('#input_newpin').val()).length >= 4 && ($('#input_confirmPin').val()).length >= 4) {
        button_enable('pukrequired_button_apply', '1');
    }
    else {
        button_enable('pukrequired_button_apply', '0');
    }
}

function updatePinInputEnable(PinOptState)
{
        if (MACRO_PIN_DISABLE == PinOptState)  //Pin operation disabled
        {
            $('#auto_pincode').attr('disabled', 'disabled').val('');
            $("input[name='auto_validation']").attr('disabled', 'disabled');
        }
        else if ($('input:checked').val() == 1)
        {
            $('#auto_pincode').removeAttr('disabled');
            $('#auto_pincode').val('');
            $('#auto_pincode').focus();
        }
        else
        {
            $('#auto_pincode').attr('disabled', 'disabled').val('');
        }
}


function validateEnabled() {
    $('.autovalidate_enable').attr('checked', 'checked');
    $('.current_status').html(dialup_label_auto_validation_enabled);
}

function validateDisabled() {
    $('.autovalidate_disable').attr('checked', 'checked');
    $('.current_status').html(dialup_label_auto_validation_disabled);
}

function validateFormat() {
    if ($('input:checked').val() == 0)
    {
        return true;
    }
    var auto_pincode = $('#auto_pincode').val();
    var patrn = /^[0-9]{4,8}$/;
    if (auto_pincode == '' || auto_pincode == ' ' || auto_pincode == null)
    {
        showErrorUnderTextbox('auto_pincode', dialup_hint_current_pin_empty);
        return false;
    }
    else if (!patrn.exec(auto_pincode))
    {
        showErrorUnderTextbox('auto_pincode', dialup_hint_pin_code_valid_type);
        $(this).val('');
        return false;
    }
    return true;
}

function checkPukRequired()
{
    var pinstatus_ret;
    var simlock_ret;
    getAjaxData('api/pin/status', function($xml) {
        pinstatus_ret = xml2object($xml);
    },
    {
        sync: true
    }
    );

    getAjaxData('api/pin/simlock', function($xml) {
        simlock_ret = xml2object($xml);
    },
    {
        sync: true
    });

   if (pinstatus_ret.type == 'response')
    {
        pin_status.SimState = pinstatus_ret.response.SimState;
        pin_status.PinOptState = pinstatus_ret.response.PinOptState;
        pin_status.SimPinTimes = pinstatus_ret.response.SimPinTimes;
        pin_status.SimPukTimes = pinstatus_ret.response.SimPukTimes;

        if (pin_status.SimState == MACRO_NO_SIM_CARD)
        {
            $('#pincode_simlock_required').hide();
            $('#pincode_puk_required').hide();
            $('#pincode_nocard').show();
            $('.main_content').hide();
        }
        else if (MACRO_PUK_REQUIRED == pin_status.SimState)
        {
            $('#pincode_simlock_required').hide();
            $('#pincode_puk_required').show();
            $('#pincode_nocard').hide();
            $('.main_content').hide();
            if (1 > pin_status.SimPukTimes)
            {
                $('#pincode_puk_required').html(dialup_help_puk_locked);
            }
            else
            {
                $('#input_puk').removeAttr('disabled');
                $('#input_newpin').removeAttr('disabled');
                $('#input_confirmPin').removeAttr('disabled');
                $('#input_puk').val('');
                $('#input_newpin').val('');
                $('#input_confirmPin').val('');
                $('#input_puk').focus();
            }
            $('#remain_times').text(pin_status.SimPukTimes);
        }
        else
        {
            $('#pincode_simlock_required').hide();
            $('#pincode_puk_required').hide();
            $('#pincode_nocard').hide();
            $('.main_content').show();
            $('.remaining_times').html(pin_status.SimPinTimes);
             getAjaxData('api/pin/save-pin', function($xml) {
                var ret = xml2object($xml);
                if (ret.type == 'response')
                {
                    pinautovalidate_getPinData = ret.response;
                    if (pinautovalidate_getPinData.SimSavepinStatus == 1)
                    {
                        validateEnabled();
                    }
                    else
                    {
                        validateDisabled();
                    }
                    updatePinInputEnable(pin_status.PinOptState);
                }
              },
            {
                sync: true
            });
         }
     }

    if (simlock_ret.type == 'response')
        {
            simlock_status.SimLockEnable = simlock_ret.response.SimLockEnable;
            simlock_status.SimLockRemainTimes = simlock_ret.response.SimLockRemainTimes;
            simlock_status.pSimLockEnable = simlock_ret.response.pSimLockEnable;
            simlock_status.pSimLockRemainTimes = simlock_ret.response.pSimLockRemainTimes;
            if (MACRO_SIM_LOCK_ENABLE == simlock_status.SimLockEnable)
            {
                $('#pincode_simlock_required').show();
                $('#pincode_puk_required').hide();
                $('#pincode_nocard').hide();
                $('.main_content').hide();
                $('#label_SimlockTimes').text(simlock_status.SimLockRemainTimes);
                if (1 > parseInt(simlock_status.SimLockRemainTimes, 10))
                {
                    $('#input_simunlock').attr('disabled', 'disabled');
                }
                else
                {
                    $('#input_simunlock').removeAttr('disabled');
                    $('#input_simunlock').val('');
                    $('#input_simunlock').focus();
                }
            }
        }
        else
        {
                log.error('REDIRECT : get api/pin/simlock failed');
        }
}

//Validate format of simlock input
function validateSimlockInput() {
    var pin_val = $('#input_simunlock').val();
    var patrn = /^[0-9]{6,8}$/;
    if (pin_val == '' || pin_val == ' ' || pin_val == null)
    {
        showErrorUnderTextbox('input_simunlock', dialup_hint_password_empty);
        $('#input_simunlock').focus();
        $('#input_simunlock').val('');
        button_enable('simrequired_button_apply', '0');
        return false;
    }
    else if (!patrn.exec(pin_val))
    {
        showErrorUnderTextbox('input_simunlock', dialup_hint_simlock_code_valid_type);
        $('#input_simunlock').focus();
        $('#input_simunlock').val('');
        button_enable('simrequired_button_apply', '0');
        return false;
    }
    else
    {
        return true;
    }
}

function onApplySimlock()
{
    if (!isButtonEnable('simrequired_button_apply'))
    {
        return;
    }
    clearAllErrorLabel();

    if (validateSimlockInput())
    {
        var sim_pin = $('#input_simunlock').val();
        var request = {
            SimLockCode: sim_pin
        };
        var wps_xml = object2xml('request', request);

        button_enable('simrequired_button_apply', '0');

        saveAjaxData('api/pin/verify-simlock', wps_xml, function($xml) {
            var return_ret = xml2object($xml);
            if (isAjaxReturnOK(return_ret))
            {
                log.debug('SIMLOCKREQUIRED : simlock validate success.');
                showInfoDialog(common_success);
                setTimeout(function() {
                refresh();
            }, 1500);
            }
            else
            {
                showInfoDialog(common_failed);
                checkPukRequired();
            }
        });

    }
}

function validatePukInput() {
    clearAllErrorLabel();
    var pukcode = $('#input_puk').val();
    var newpin = $('#input_newpin').val();
    var retypepin = $('#input_confirmPin').val();
    var pukpatrn = /^[0-9]{8}$/;
    var pinpatrn = /^[0-9]{4,8}$/;


    if ('' == pukcode)
    {
        showErrorUnderTextbox('input_puk', dialup_hint_puk_code_empty);
        $('#input_puk').focus();
        $('#input_puk').val('');
        button_enable('pukrequired_button_apply', '0');
        return false;
    }
    else if (!pukpatrn.exec(pukcode))
    {
        showErrorUnderTextbox('input_puk', dialup_hint_puk_code_valid_type);
        $('#input_puk').focus();
        $('#input_puk').val('');
        button_enable('pukrequired_button_apply', '0');
        return false;
    }
    else if ('' == newpin)
    {
        showErrorUnderTextbox('input_newpin', dialup_hint_current_pin_empty);
        $('#input_newpin').focus();
        $('#input_newpin').val('');
        button_enable('pukrequired_button_apply', '0');
        return false;
    }
    else if (!pinpatrn.exec(newpin))
    {
        showErrorUnderTextbox('input_newpin', dialup_hint_pin_code_valid_type);
        $('#input_newpin').focus();
        $('#input_newpin').val('');
        button_enable('pukrequired_button_apply', '0');
        return false;
    }

    else if ('' == retypepin)
    {
        showErrorUnderTextbox('input_confirmPin', dialup_hint_confirm_code_empty);
        $('#input_confirmPin').focus();
        $('#input_confirmPin').val('');
        button_enable('pukrequired_button_apply', '0');
        return false;
    }
    else if (!pinpatrn.exec(retypepin))
    {
        showErrorUnderTextbox('input_confirmPin', dialup_hint_confirm_pin_valid_type);
        $('#input_confirmPin').focus();
        $('#input_confirmPin').val('');
        button_enable('pukrequired_button_apply', '0');
        return false;
    }
    else if (newpin != retypepin)
    {
        showErrorUnderTextbox('input_confirmPin', dialup_hint_confirm_and_new_same);
        $('#input_confirmPin').focus();
        $('#input_confirmPin').val('');
        button_enable('pukrequired_button_apply', '0');
        return false;
    }
    return true;
}

function onApplyPukRequired() {
    if (!isButtonEnable('pukrequired_button_apply'))
    {
        return;
    }
    clearAllErrorLabel();

    if (validatePukInput())
    {
        var pukcode = $('#input_puk').val();
        var newpin = $('#input_newpin').val();
        var retypepin = $('#input_confirmPin').val();

        send_request.PukCode = pukcode;
        send_request.CurrentPin = newpin;
        send_request.NewPin = newpin;

        var unlockpuk_xml = object2xml('request', send_request);
        button_enable('pukrequired_button_apply', '0');

        saveAjaxData('api/pin/operate', unlockpuk_xml, function($xml) {
            var return_ret = xml2object($xml);
            if (isAjaxReturnOK(return_ret))
            {
                log.debug('PUKREQUIRED : puk validate success.');
                showInfoDialog(common_success);
                setTimeout(function() {
                refresh();
            }, 1500);
            }
            else
            {
                showInfoDialog(common_failed);
                 checkPukRequired();
            }
        });
    }
}

function initPage()
{
    checkPukRequired();
    button_enable('validate_apply', '0');
    //init simlock, pinrequired and pukrequired button status
    button_enable('simrequired_button_apply', '0');
    button_enable('pukrequired_button_apply', '0');

    //The button click effect of simlock, pinrequired and pukrequired pages.
    $('#simrequired_button_apply').click(function() {
        onApplySimlock();
    });

    $('#pukrequired_button_apply').click(function() {
        onApplyPukRequired();
    });
}

function onApply()
{
    if (!isButtonEnable('validate_apply'))
    {
        return;
    }
    clearAllErrorLabel();

    if (validateFormat())
    {
        pinautovalidate_savePinData.SimSavepinStatus = $('input:checked').val();
        pinautovalidate_savePinData.SimSavepinPIN = $('#auto_pincode').val();
        var xmlstr = object2xml('request', pinautovalidate_savePinData);
        saveAjaxData('api/pin/save-pin', xmlstr, function($xml) {
            var request_ret = xml2object($xml);
            if (isAjaxReturnOK(request_ret))
            {
                showInfoDialog(common_success);
            }
            else
            {
                showInfoDialog(common_failed);
            }
            setTimeout(function() {
                    initPage();
            }, g_feature.dialogdisapear);
        });
           button_enable('validate_apply', '0');
    }
}

$(document).ready(function() {
    $('#validate_apply').bind('click', onApply);
    $('input[type=radio]').bind('click', updatePinInputEnable);
    $('input').bind('change input paste cut keydown keyup', function() {
        checkButtonEnable();
    });
    initPage();
});
