
var g_cradledialInfo = null;
var g_cradlemacInfo = null;
var g_cradleconnStatus = null;
var g_cradleconnMode = null;
var g_cradlestatusInfo = null;

//Cradle Connection status
var CRADLE_CONNECTING = '900';
var CRADLE_CONNECTED = '901';
var CRADLE_DISCONNECTED = '902';
var CRADLE_DISCONNECTING = '903';
var CRADLE_CONNECTFAILED = '904';
var CRADLE_PPPOENOACCOUNT = '905';
var CRADLE_PPPOEERRORACCOUNT = '906';

var CONNECTIONSTATUS = {
    0: dialup_label_connecting,
    1: dialup_label_connected,
    2: dialup_label_disconnected,
    3: dialup_label_disconnecting,
    4: pbc_label_connect_failed,
    5: pbc_label_connect_failed,
    6: pbc_label_connect_failed
};

var CONNECTIONMODE = {
    0: common_auto,
    1: IDS_ethernet_pppoe_plus_dynamic,
    2: IDS_wan_setting_pppoe,
    3: IDS_wan_setting_dynamicip,
    4: IDS_ethernet_setting_staticip,
    5: IDS_ethernet_settings_mode_lan
};

var COMMONATUO = '0';
var LANONLY = '5';
var g_connectionStatusList = [[CRADLE_CONNECTING, CONNECTIONSTATUS[0]],[CRADLE_CONNECTED, CONNECTIONSTATUS[1]],[CRADLE_DISCONNECTED, CONNECTIONSTATUS[2]],[CRADLE_DISCONNECTING, CONNECTIONSTATUS[3]],
                             [CRADLE_CONNECTFAILED, CONNECTIONSTATUS[4]],[CRADLE_PPPOENOACCOUNT,CONNECTIONSTATUS[5]],[CRADLE_PPPOEERRORACCOUNT,CONNECTIONSTATUS[6]]]; 
var g_connectionModeList = [[0,CONNECTIONMODE[0]],[1,CONNECTIONMODE[1]],[2,CONNECTIONMODE[2]],[3,CONNECTIONMODE[3]],[4,CONNECTIONMODE[4]],[5,CONNECTIONMODE[5]]];

function wanstatus_initPage(){
    getAjaxData('api/cradle/status-info', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            g_cradlestatusInfo = ret.response;
            g_cradleconnStatus = g_cradlestatusInfo.connectstatus;
            g_cradleconnMode = g_cradlestatusInfo.connectionmode;
            g_cradlemacInfo = g_cradlestatusInfo.macaddress;
            
            if (g_cradlestatusInfo.currenttime == null || g_cradlestatusInfo.currenttime == '' ||isNaN(g_cradlestatusInfo.currenttime)){
                g_cradlestatusInfo.currenttime = 0;
            }
            var totalTime = getCurrentTime(g_cradlestatusInfo.currenttime);
            $('#label_duration').text(totalTime);
            
            if (g_cradleconnStatus == null || g_cradleconnStatus == '' || isNaN(g_cradleconnStatus) 
            || g_cradleconnStatus > CRADLE_PPPOEERRORACCOUNT || g_cradleconnStatus < CRADLE_CONNECTING){
                $('#label_conn_status').text(dialup_label_disconnected);
            }else{
                $.each(g_connectionStatusList, function(n, value) {
                if (value[0] == g_cradleconnStatus){
                    $('#label_conn_status').text(value[1]);  
                }
                });
            }
            
            if (g_cradleconnMode == null || g_cradleconnMode == '' ||isNaN(g_cradleconnMode)
            || g_cradleconnMode > LANONLY || g_cradleconnMode < COMMONATUO ){
                $('#connection_mode').text(common_unknown);
            }else{
                $.each(g_connectionModeList, function(n, value) {
                if (value[0] == g_cradleconnMode){
                    $('#connection_mode').text(value[1]);
                }
                });
            }

            if (g_cradlemacInfo == null || g_cradlemacInfo == ''){
                $('#label_mac_address').text(common_unknown);
            }else{
                $('#label_mac_address').text(g_cradlemacInfo);
            }
            
            if (g_cradlestatusInfo.ipaddress == null || g_cradlestatusInfo.ipaddress == ''){
                $('#label_ip_address').text(common_unknown);
            }else{
                $('#label_ip_address').text(g_cradlestatusInfo.ipaddress);
            }
            
            if (g_cradlestatusInfo.netmask == null || g_cradlestatusInfo.netmask == ''){
                $('#label_subnet_mask').text(common_unknown);
            }else{
                $('#label_subnet_mask').text(g_cradlestatusInfo.netmask);
            }
            
            if (g_cradlestatusInfo.gateway == null || g_cradlestatusInfo.gateway == ''){
                $('#label_gateway_address').text(common_unknown);
            }else{
                $('#label_gateway_address').text(g_cradlestatusInfo.gateway);
            }
            
            if (g_cradlestatusInfo.primarydns == null || g_cradlestatusInfo.primarydns == '' ){
                $('#primary_dns_id').text(common_unknown);
            }else{
                $('#primary_dns_id').text(g_cradlestatusInfo.primarydns);
            }
            
            if (g_cradlestatusInfo.secondarydns == null || g_cradlestatusInfo.secondarydns == '' ){
                $('#secondary_dns_id').text(common_unknown);
            }else{
                $('#secondary_dns_id').text(g_cradlestatusInfo.secondarydns);
            }
            
        }
        else{
            $('#label_duration').text(getCurrentTime(0));
            $('#label_conn_status').text(dialup_label_disconnected);
            $('#connection_mode').text(common_unknown);
            $('#label_mac_address').text(common_unknown);
            $('#label_ip_address').text(common_unknown);
            $('#label_subnet_mask').text(common_unknown);
            $('#label_gateway_address').text(common_unknown);
            $('#primary_dns_id').text(common_unknown);
            $('#secondary_dns_id').text(common_unknown);
            showInfoDialog(common_failed);
            log.error("REDIRECT:api/cradle/status-Info file failed");
        }
    }, {
        sync: true
    });
    
    setTimeout(wanstatus_initPage, g_feature.update_interval);
}

//redirectOnCondition(null, 'wanstatus');
/**********************************After loaded (common)************/
$(document).ready(function() {
    wanstatus_initPage();
});
