$(document).ready(function(){
       //setTimeout("flushed()", 1000);
       init_sms();
       flushed();
});

var smsUrl = window.location.href;
smsUrl = smsUrl.substring(0, smsUrl.lastIndexOf("."));
smsUrl = smsUrl.substring(smsUrl.lastIndexOf("/")+1);
var iflag_local_sim = 0;
var ispace_sim = 4;
var SMS_TEXT_MODE_UCS2 =  0;
var SMS_TEXT_MODE_7BIT =  1;
var ASCII_CODE    = 127;
var SMS_UCS2_MAX_SIZE = 268;//70+64+67+67;
var SMS_7BIT_MAX_SIZE = 612;//160+146+153+153;
var SMS_SENT_TYPE = 1;
var SMS_FORWARD_TYPE = "f";
var SMS_REPLY_TYPE = "r";
var g_content = null;
var g_text_mode = SMS_TEXT_MODE_7BIT; 
var g_sms_length = 0;
var g_sms_num = 1;
var g_ucs2_num = 0;
var g_station; 
var GSM_7BIT_NUM = 128;
var SMS_STR_NUM = 620;
var EXTENSION_ASCII = 9;
var isButtonSentDisable = false;
var isButtonBackDisable = false;
var isButtonSaveDisable = false;
var islogoutDisable = false;

var ext_7bit_tab = [
    [20, 0x005E], [40, 0x007B], [41, 0x007D], 
    [47, 0x005C], [60, 0x005B], [61, 0x007E],
    [62, 0x005D], [64, 0x007C], [101, 0x20AC]
];

var ext_7bit_tab_turkish = [
    [13, 0x001D], [20, 0x005E],
    [40, 0x007B], [41, 0x007D], [47, 0x005C], [60, 0x005B],
    [61, 0x007E], [62, 0x005D], [64, 0x007C], [71, 0x011E],
    [73, 0x0130], [83, 0x015E], [99, 0x00E7], [101, 0x20AC],
    [103, 0x011F], [105, 0x0131], [115, 0x015F]
];

var ext_7bit_tab_spanish = [
    [9, 0x00E7],  [20, 0x005E],
    [40, 0x007B], [41, 0x007D], [47, 0x005C], [60, 0x005B],
    [61, 0x007E], [62, 0x005D], [64, 0x007C], [65, 0x00C1],
    [73, 0x00CD], [79, 0x00D3], [85, 0x00DA], [97, 0x00E1],
    [101, 0x20AC], [105, 0x00ED], [111, 0x00F3], [117, 0x00FA]
];

var ext_7bit_tab_Portuguese = [
    [5, 0x00EA], [9, 0x00E7],   [11, 0x00D4],
    [12, 0x00F4], [14, 0x00C1], [15, 0x00E1],[18, 0x03A6],
    [19, 0x0393], [20, 0x005E], [21, 0x03A9], [22, 0x03A0],
    [23, 0x03A8], [24, 0x03A3], [25, 0x0398],
    [31, 0x00CA], [40, 0x007B], [41, 0x007D], [47, 0x005C],
    [60, 0x005B], [61, 0x007E], [62, 0x005D], [64, 0x007C],
    [65, 0x00C0], [73, 0x00CD], [79, 0x00D3], [85, 0x00DA],
    [91, 0x00C3], [92, 0x00D5], [97, 0x00C2], [101, 0x20AC],
    [105, 0x00ED], [111, 0x00F3], [117, 0x00FA], [123, 0x00E3],
    [124, 0x00F5], [127, 0x00E2]
];

var extension_char = 27;
var ENTER_CHAR = 10;
var MESSAGE_SEND_SUCCESS = "OK";
var CR_CHAR = 13;
var sms_index = getParameter("id");
var redirection_page = getParameter("page");
var page_num = getParameter("num");
var sms_type = getParameter("type");
var page_history = getParameter("history");
var readCount = 3;
//var sms_count = '<%'+ sms_full(); '%>';
var arrayGSM_7bit = 
[
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F
];
var arrayGSM_7DefaultTable = 
[
    0x0040, 0x00A3, 0x0024, 0x00A5, 0x00E8, 0x00E9, 0x00F9, 0x00EC, 0x00F2, 0x00C7, 0x000A, 0x00D8, 0x00F8, 0x000D, 0x00C5, 0x00E5,
    0x0394, 0x005F, 0x03A6, 0x0393, 0x039B, 0x03A9, 0x03A0, 0x03A8, 0x03A3, 0x0398, 0x039E, 0x001B, 0x00C6, 0x00E6, 0x00DF, 0x00C9, 
    0x0020, 0x0021, 0x0022, 0x0023, 0x00A4, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
    0x00A1, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x00C4, 0x00D6, 0x00D1, 0x00DC, 0x00A7, 
    0x00BF, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x00E4, 0x00F6, 0x00F1, 0x00FC, 0x00E0
];

var arrayGSM_7ExtTable = 
[
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x000A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005E, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x007B, 0x007D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005C,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005B, 0x007E, 0x005D, 0xFFFF,
    0x007C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x20AC, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
];

/* Turkish National Language Single Shift Table */
var arrayGSM_7TurkishExtTable  =
[
          /* 0       1       2       3      4       5       6       7       8       9       10      11      12      13      14      15 */
    /* 0 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x000A, 0xFFFF, 0xFFFF, 0x001D, 0xFFFF, 0xFFFF,
    /* 1 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    /* 2 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x007B, 0x007D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005C,
    /* 3 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005B, 0x007E, 0x005D, 0xFFFF,
    /* 4 */0x007C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x011E, 0xFFFF, 0x0130, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    /* 5 */0xFFFF, 0xFFFF, 0xFFFF, 0x015E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    /* 6 */0xFFFF, 0xFFFF, 0xFFFF, 0x00E7, 0xFFFF, 0x20AC, 0xFFFF, 0x011F, 0xFFFF, 0x0131, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    /* 7 */0xFFFF, 0xFFFF, 0xFFFF, 0x015F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
];

/* Portuguese National Language Single Shift Table */
var arrayGSM_7PortugueseExtTable =
[
          /* 0       1       2       3      4       5       6       7       8       9       10      11      12      13      14      15 */
    /* 0 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00EA, 0xFFFF, 0xFFFF, 0xFFFF, 0x00E7, 0x000A, 0x00D4, 0x00F4, 0xFFFF, 0x00C1, 0x00E1,
    /* 1 */0xFFFF, 0xFFFF, 0x03A6, 0x0393, 0x005E, 0x03A9, 0x03A0, 0x03A8, 0x03A3, 0x0398, 0xFFFF, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0x00CA,
    /* 2 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x007B, 0x007D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005C,
    /* 3 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005B, 0x007E, 0x005D, 0xFFFF,
    /* 4 */0x007C, 0x00C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00CD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00D3,
    /* 5 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00DA, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00C3, 0x00D5, 0xFFFF, 0xFFFF, 0xFFFF,
    /* 6 */0xFFFF, 0x00C2, 0xFFFF, 0xFFFF, 0xFFFF, 0x20AC, 0xFFFF, 0xFFFF, 0xFFFF, 0x00ED, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00F3,
    /* 7 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00FA, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00E3, 0x00F5, 0xFFFF, 0xFFFF, 0x00E2,
];

/* Spanish National Language Single Shift Table */
var arrayGSM_7SpanishExtTable =
[
          /* 0       1       2       3      4       5       6       7       8       9       10      11      12      13      14      15 */
    /* 0 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00E7, 0x000A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    /* 1 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    /* 2 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x007B, 0x007D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005C,
    /* 3 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005B, 0x007E, 0x005D, 0xFFFF,
    /* 4 */0x007C, 0x00C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00CD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00D3,
    /* 5 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00DA, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    /* 6 */0xFFFF, 0x00E1, 0xFFFF, 0xFFFF, 0xFFFF, 0x20AC, 0xFFFF, 0xFFFF, 0xFFFF, 0x00ED, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00F3,
    /* 7 */0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00FA, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
];

function sms_create(btn_value)
{
    if((sms_count[0] == sms_count[1]) && (sms_count[1] > 0))
    {
        shErr(errInfo7114);
        return;
    }
    with(document.FormSms)
    {
        if(btn_value == "Send")
        {
            document.FormSms.action.value = "Send";
            if(false == send_numbers_check())
            {
                return;
            }
        }
        else if(btn_value == "Save")
        {
            document.FormSms.action.value = "Save";
            if(false == save_numbers_check())
            {
                return;
            }
        }
        if(SMS_TEXT_MODE_UCS2 == g_text_mode)
        {
            sms_content_check(sms_content.value,false);
            if(g_sms_length > SMS_UCS2_MAX_SIZE)
            {
                shErr(errInfo7100); /*The max UCS2 characters of SMS message is 268 */
                sms_content.select();
                return;
            }
        }
        else
        {
            g_text_mode =  SMS_TEXT_MODE_7BIT;
            sms_content_check(sms_content.value,false);
            if(g_sms_length > SMS_7BIT_MAX_SIZE)
            {
                shErr(errInfo7101);/*The max ASCII characters of SMS message is 612 */
                sms_content.select();
                return;
            }
        }
        document.FormSms.sms_text_mode.value = g_text_mode;
        document.FormSms.sms_content_1.value = g_content;
        document.FormSms.sms_num.value = g_sms_num;
        document.FormSms.station.value = g_station;
        document.FormSms.phone_numbers_cgi.value = phone_numbers.value;
    }
    document.FormSms.submit();
}
Date.prototype.Format = function(format)   
{  
    var o = { 
            "M+" : this.getMonth()+1,
            "d+" : this.getDate(),
            "h+" : this.getHours(),
            "m+" : this.getMinutes(),
            "s+" : this.getSeconds()  
        };   
    if(/(y+)/.test(format)) 
    {
        format = format.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
    }

    for(var k in o) 
    {
        if(new RegExp("("+ k +")").test(format))
        {
            format = format.replace(RegExp.$1, RegExp.$1.length==1 ? o[k] : ("00"+ o[k]).substr((""+ o[k]).length));
        }
    }
    return format;
};

function sms_send()
{
    if(isButtonSentDisable)
    {
        return;
    }
    var numbers ;
    with(document.forms[0])
    {
            if((0 == iflag_local_sim)&&(ispace_sim < g_sms_num))
            {
                showErr("sms_hint_sim_card_full"); /*res.res  The sim card has not enough space to send local sms!*/
                return;
            }

            if(false == send_numbers_check())
            {
                return;
            }
        if(SMS_TEXT_MODE_UCS2 == g_text_mode)
        {
            sms_content_check(sms_content.value,false);
            if(g_sms_length > SMS_UCS2_MAX_SIZE)
            {
                showErr("sms_hint_max_ucs2_characters_268"); /*The max UCS2 characters of SMS message is 268 */
                sms_content.select();
                return;
            }
        }
        else
        {
            g_text_mode =  SMS_TEXT_MODE_7BIT;
            sms_content_check(sms_content.value,false);

			if( 0 == FEATURE_SMS_LANG || null == FEATURE_SMS_LANG )
			{
	            if(g_sms_length > SMS_7BIT_MAX_SIZE)
	            {
	                showErr("sms_hint_max_ascii_characters_612");/*The max ASCII characters of SMS message is 612 */
	                sms_content.select();
	                return;
	            }
			}
			else
			{
	            if(g_sms_length > 149*4)
	            {
	                showErr("sms_hint_max_ascii_characters_596");
	                sms_content.select();
	                return;
	            }
			}	
        }
        numbers = phone_numbers.value.split(';');
    }
    var now = new Date().Format("yyyy-MM-dd hh:mm:ss");
    var submitData;
    if("smssdrafts" == page_history)
    {
        submitData = "<Index>"+sms_index+"</Index><Phones>";
    }
    else
    {
        submitData = "<Index>-1</Index><Phones>";
    }
    for(i = 0;i<numbers.length;i++)
    {
        submitData = submitData +  "<Phone>"+$.trim(numbers[i])+"</Phone>";
    }

    set_btn_disabled("btn_send", true);
    set_btn_disabled("btn_save", true);
    set_btn_disabled("button_back", true);
    
    isButtonSentDisable = true;
    isButtonSaveDisable = true;
    isButtonBackDisable = true;
    islogoutDisable = true;
    $('.log_out_left').css({
         background: "url('../res/logout_dis.gif') no-repeat scroll left top transparent"
    });
    
    $('.log_out_center').css({
         background: "url('../res/logout_dis.gif') repeat-x scroll left -97px transparent"
    });
    
    $('.log_out_right').css({
         background: "url('../res/logout_dis.gif') no-repeat scroll right -194px transparent"
    });
    $('#home_div').css({
         background: "url('../res/home_dis.gif')  no-repeat scroll 0% 0%"
    });
    
    $('#sms_content').attr("disabled", "disabled");
    $('#phone_numbers').attr("disabled", "disabled");

    $('#home a').attr("href", "javascript:void(0);");
    g_content = g_content.replace(/&/g,"&amp;");
    g_content = g_content.replace(/</g,"&lt;");
    g_content = g_content.replace(/>/g,"&gt;");
    g_content = g_content.replace(/"/g,"&quot;");
    g_content = g_content.replace(/'/g,"&apos;");
    submitData +=  "</Phones>"
    + "<Sca></Sca>"
    + "<Content>" + g_content + "</Content>"
    + "<Length>" + g_content.length + "</Length>"
    + "<Reserved>" + g_text_mode + "</Reserved>"
    + "<Date>" + now + "</Date>";
    submitData = formatSubmitData(submitData);
    saveAjaxData("api/sms/send-sms", submitData,function(xml){
    ret = xml;
    if(ret.indexOf("<code>") > 0)
    {
    var id = getNode(ret, "code");
    refresh("error.htm?page=smsnew&id="+id);
    }
    else
    {
    setTimeout("get_send_status()", 3000);
    hoardiv();
    }
    });
}

function getParameter(parameterName)
{
    var objUrl = window.location.href;
    var parameters = objUrl.substring(objUrl.indexOf("?") + 1);
    var paramentArray;
    paramentArray = parameters.split("&");
    if (paramentArray.length > 1)
    {
        for (var i = 0; i < paramentArray.length; i++)
        {
            var tempParament = paramentArray[i];
            var tempParamentArray = tempParament.split("=");
            if (tempParamentArray.length > 1)
            {
                if (parameterName == tempParamentArray[0])
                {
                    return tempParamentArray[1];
                }
            }
            else
            {
                return tempParament;
            }
        }
    }
    else
    {
        paramentArray = parameters.split("=");
        if (paramentArray.length > 1)
        {
            if (parameterName == paramentArray[0])
            {
                return paramentArray[1];
            }
        }
        else
        {
            return "";
        }
    }

    return "";
}

function getInboxType(str)
{
    if( "smsinbox" == str )
    {
        return ;
    }
}

function init_sms()
{
    if("" != sms_index)
    {
        $("#button_back").css("display","");
        var nBoxType = getParameter("history");
        if("smssinbox" == nBoxType)
        {
            nBoxType = 1;
        }
        else if("smsssent" == nBoxType)
        {
            nBoxType = 2;
        }
        else if("smssdrafts" == nBoxType)
        {
           nBoxType = 3; 
        }
        else
        {
           nBoxType = 0;
        }
        var message = getDetailContent(sms_index, nBoxType, page_num);
        var phoneNumber = message.Phone;
        var content = message.Content;
        if(SMS_FORWARD_TYPE == sms_type)
        {    
            if(7 == message.SmsType)
            {
                content = sms_label_setting_usesreport + " " + common_success;
            }
            else if(8 == message.SmsType)
            {
                content = sms_label_setting_usesreport + " " + common_failed;
            }
            document.getElementById("sms_content").value = content;
        }
        else if(SMS_REPLY_TYPE == sms_type)
        {
            setTextValue("phone_numbers", phoneNumber);
        }
        else
        {
            setTextValue("phone_numbers", phoneNumber);
            document.getElementById("sms_content").innerHTML =  content;
            document.getElementById("sms_content").value = content;
        }
    }
    
    
}

function back()
{
    if(isButtonBackDisable) {
        return;
    }
    
    document.getElementById("coverUpDiv").style.visibility="hidden";
    if("smss.htm" == page_history)
    {
        refresh(page_history);
    }
    else if("smssdrafts" == page_history)
    {
        refresh(page_history+".htm?num="+page_num);        
    }
    else if("smsssent" == page_history || "smssinbox" == page_history )
    {
        location.replace("smssonlyread.htm?index="+ sms_index + "&num=" + page_num + "&history=" + page_history);
    }
    else
    {
        refresh(page_history+".htm?num="+page_num);        
    }
}


function successThenBack()
{   
    document.getElementById("coverUpDiv").style.visibility="hidden";
    if("smss.htm" == page_history)
    {
        refresh(page_history);
    }
    else
    {
        refresh(page_history+".htm?num="+page_num);
    }
}

function ucs2_number_check(str)
{
    var i;
    var char_i;
    var num_char_i;

    var j;
    var flag; 
    var ucs2_num_temp=0;
    var ext_Table = arrayGSM_7ExtTable;
    
    if (str.length ==0)
    {
      return 0;
    }

    switch( parseInt(FEATURE_SMS_LANG) )
	{
	case 0:
		ext_Table = arrayGSM_7ExtTable;
		break;
	case 1:
		ext_Table = arrayGSM_7TurkishExtTable;
		break;
	case 2:
		ext_Table = arrayGSM_7SpanishExtTable;
		break;
	case 3:
		ext_Table = arrayGSM_7PortugueseExtTable;
		break;
	default:
		break;
	}
    
    for(i=0; i<str.length; i++)
    {
    	flag = 0;
    	char_i = str.charAt(i);
        num_char_i = char_i.charCodeAt();
        for(j = 0; j < GSM_7BIT_NUM; j++)
        {
            if((num_char_i == arrayGSM_7DefaultTable[j])
            || (num_char_i == ext_Table[j])
            )
            {
    		    flag = 1;
    		    break;
            }
        }
        if(0 == flag)
        {
            ucs2_num_temp++;    
        }
    }

    return ucs2_num_temp;
}


function ucs2_number_change(str)
{
  var i=0;
  var cmp_len_min =0;  
  var diff_begin =0;
  var new_end =0;
  var old_end = 0;
  var ucs2_num_tmp=0;
  var new_ucs2_num =0;
  var old_ucs2_num =0;

  if (g_content == null)
  {
    g_ucs2_num =  ucs2_number_check(str);
    return;
  }
  
  if (str==null)
  {
    g_ucs2_num =0;
    return;
  }

  cmp_len_min = Math.min(str.length, g_content.length);
  if (cmp_len_min == 0)
  {
    g_ucs2_num =  ucs2_number_check(str);
    return;
  }    

  for (i=0;i<cmp_len_min;i++)
  {
     var char_i;
     var char_i_code;
     var char_i_old;
     var char_i_code_old;
     
     char_i = str.charAt(i);
     char_i_code = char_i.charCodeAt();

     char_i_old = g_content.charAt(i);
     char_i_code_old = char_i_old.charCodeAt();

    if (char_i_code_old != char_i_code)
    {
      diff_begin = i;
      break;
    }
  }
  
  if (i == cmp_len_min)
  {
    diff_begin = cmp_len_min;
  }
  if (diff_begin == g_content.length)
  {
    if (g_content.length == str.length )
    {
      return;
    }
    else
    {
      ucs2_num_tmp = ucs2_number_check(str.substring(diff_begin,str.length));
      g_ucs2_num = g_ucs2_num + ucs2_num_tmp;    
      return ;
    }
  }
  if (diff_begin == str.length)
  {
    ucs2_num_tmp = ucs2_number_check(g_content.substring(diff_begin,g_content.length));
    g_ucs2_num = g_ucs2_num - ucs2_num_tmp; 
    return ;
  }

  for (i = 0;i< cmp_len_min;i++)
  {
     var char_i;
     var char_i_code;
     var char_i_old;
     var char_i_code_old;
     
     char_i = str.charAt(str.length-1 -i);
     char_i_code = char_i.charCodeAt();

     char_i_old = g_content.charAt(g_content.length-1-i);
     char_i_code_old = char_i_old.charCodeAt();

    if (char_i_code_old != char_i_code)
    {
      new_end = str.length-1-i;
      old_end = g_content.length -1-i;
      break;
    }
  }
  
  if (new_end < diff_begin)
  {
    new_ucs2_num = 0;
  }
  else
  {
    new_ucs2_num = ucs2_number_check(str.substring(diff_begin,new_end +1));
  }

  if (old_end < diff_begin)
  {
    old_ucs2_num = 0;
  }
  else
  {
    old_ucs2_num = ucs2_number_check(g_content.substring(diff_begin,old_end+1));
  }
  g_ucs2_num = g_ucs2_num + (new_ucs2_num -old_ucs2_num );
    
  return ;
}


function sms_content_change(str)
{  
  
  ucs2_number_change(str);

  if (g_ucs2_num >0)
  {
    g_text_mode = SMS_TEXT_MODE_UCS2;
  }
  else
  {
    g_text_mode = SMS_TEXT_MODE_7BIT;
  }
  sms_number_check(str); 
  g_content = str;
  
}


function flushed()
{
    with(document.forms[0])
    {
      sms_content_change(sms_content.value);
    }
    setTimeout("flushed()", 1000);
}


function check_enter_number_in_sms_content(str)
{
    var i;
    var char_i;
    var num_char_i;
    var enter_number = 0;
    
    for(i = 0; i < str.length; i++)
    {
        char_i = str.charAt(i);
        num_char_i = char_i.charCodeAt();
        if( num_char_i == ENTER_CHAR)
        {
            if( i == 0 )
            {
                enter_number++;
            }
            else
            {
                char_i = str.charAt(i - 1);
                num_char_i = char_i.charCodeAt();
                if( num_char_i != CR_CHAR )
                {
                    enter_number++;
                }
            }
        }
    }
    return enter_number;
}

function check_extension_ascii_for_char_number(str)
{
    var i;
    var char_i;
    var char_i_code;
    var k;
    var extension_ascii_num = 0;
    var charLenAtFirstSMSEnd = 1;
	var normal_max_len = 160;
	var long_max_len = 153;
	var ext_tab = ext_7bit_tab;

	switch( parseInt(FEATURE_SMS_LANG) )
	{
	case 0:
		ext_tab = ext_7bit_tab;
		break;
	case 1:
		ext_tab = ext_7bit_tab_turkish;
		break;
	case 2:
		ext_tab = ext_7bit_tab_spanish;
		break;
	case 3:
		ext_tab = ext_7bit_tab_Portuguese;
		break;
	default:
		break;
	}

    if( 0 == FEATURE_SMS_LANG || null == FEATURE_SMS_LANG )
	{
		normal_max_len = 160;
		long_max_len = 153;
	}
	else
	{
		normal_max_len = 155;
		long_max_len = 149;
	}
    for(i=0; i<str.length; i++)
    {
        var charLen = 1;
        char_i = str.charAt(i);
        char_i_code = char_i.charCodeAt();
        for(charLen=1,k = 0;k< ext_tab.length;k++)
        {
            if(char_i_code == ext_tab[k][1])
            {
                charLen = 2;
                break;
            }
        }
        if(1 == charLen)
        {
            extension_ascii_num++;
        }
        else
        {
            if(1 == charLenAtFirstSMSEnd)
            {
                if( (long_max_len-1) == extension_ascii_num )
                {
                    extension_ascii_num+=2;
                    charLenAtFirstSMSEnd=2;
                }
                else if(( (long_max_len*2-1) == extension_ascii_num)
                    || ( (long_max_len*3-1) == extension_ascii_num )
                    || ( (long_max_len*4-1) == extension_ascii_num))
                {
                    extension_ascii_num+=3;
                }
                else
                {
                    extension_ascii_num+=2;
                }
            }
            else
            {
                if(( (long_max_len-1)*2 == extension_ascii_num)
                    || (((long_max_len-1)*3+1) == extension_ascii_num)
                    || (((long_max_len-1)*4+2) == extension_ascii_num))
                {
                    extension_ascii_num+=3;
                }
                else
                {
                    extension_ascii_num+=2;
                }
            }
        } 
    }
    if(extension_ascii_num > normal_max_len && 2 == charLenAtFirstSMSEnd)
    {
        extension_ascii_num++;
    } 
    return extension_ascii_num;
}


function sms_number_check(str)
{
    var sms_left_length;
    var sms_num;
    var temp_length;
    var temp_enter_number;
    var normal_max_len = 160;
	var long_max_len = 153;
	
    with(document.forms[0])
    {
        temp_length = str.length;
        //numWarning.style.display="none";

        temp_enter_number = check_enter_number_in_sms_content(str);
        temp_length += temp_enter_number;

        if(SMS_TEXT_MODE_UCS2 == g_text_mode)
        {
 		    normal_max_len = 70;
			long_max_len = 67;
        }
        else //7bit;
        {
            if( 0 == FEATURE_SMS_LANG || null == FEATURE_SMS_LANG )
			{
				normal_max_len = 160;
				long_max_len = 153;
			}
			else
			{
				normal_max_len = 155;
				long_max_len = 149;
			}

            temp_length = check_extension_ascii_for_char_number(str);
            //temp_length = temp_length+add_num;
							
        }

	    if( temp_length <= normal_max_len )
		{
		    document.getElementById("count").innerHTML = normal_max_len - temp_length + "(" + 1 + ")";
		    sms_num = 1;
			if(temp_length <= 0)
			{
				g_content = str.substring(0);
			}
		}
		else if( (temp_length > normal_max_len ) && (temp_length <= long_max_len*4) )
		{
			sms_num = parseInt(temp_length/long_max_len)+1;
			
			if( 0 == (temp_length%long_max_len) )
			{
				sms_num -= 1;
			}
			
		    document.getElementById("count").innerHTML = long_max_len*sms_num - temp_length + "(" + sms_num + ")";		
		}
		else
		{
		    var tmp =  parseInt((temp_length - long_max_len*4)/long_max_len);
		    var tmp2 = Math.floor(tmp);
		    var tmp3 = (long_max_len*4 +(tmp2+1)*long_max_len) - temp_length;
		    document.getElementById("count").innerHTML =tmp3 + "(" + (tmp2+4+1)+ ")";
		}
    }
    g_sms_num = sms_num;
}

function is_sms_send_number(str) {    
    var bRet = true;

    
    var rgExp = /^[+]{0,1}[*#0123456789]{1,20}$/;
    if (!(str.match(rgExp))) 
    {
        bRet = false;
    }
    
    return bRet;
}

function send_numbers_check()
{
    var i;
    var numbers;
    with(document.forms[0])
    {
        var strPhoneNumber = phone_numbers.value;

        // if last chacracter o phone number is ';', remove it
        if (strPhoneNumber.length > 0) {
            if (strPhoneNumber.lastIndexOf(";") == (strPhoneNumber.length - 1)) {
                strPhoneNumber = strPhoneNumber.substring(0, strPhoneNumber.length - 1);
                phone_numbers.value = strPhoneNumber;
            }
        }
        
        numbers = phone_numbers.value.split(';');
        if(FEATURE_SMS_MAXPHONE < numbers.length)
        {
            sms_hint_maximum_number = sms_hint_maximum_number.replace("%d",FEATURE_SMS_MAXPHONE);
            showErr("sms_hint_maximum_number");//numbers more than 10;
            return false;
        }
        for(i = 0;i<numbers.length;i++)
        {
            numbers[i] = $.trim(numbers[i]);
            if(false == is_sms_send_number(numbers[i]))
            {
                showErr("sms_hint_mobile_number_format");
                return false;
            }
        }
    }
}

function sms_content_check(str,isfirst)
{
    var sms_left_length;
    var sms_num;
    var temp_length;
    var n = 0;

    g_station = new Array(SMS_STR_NUM);
    with(document.forms[0])
    {
        temp_length = str.length;

        if (isfirst == true)
        {
            g_ucs2_num = ucs2_number_check(str);
        }
        
        if( g_ucs2_num > 0)
        {
            g_text_mode = SMS_TEXT_MODE_UCS2;
            g_sms_length = temp_length;
            g_content = str;
        }
        else //7bit;
        {
            var temp_length = check_extension_ascii_for_char_number(str);
            //temp_length = temp_length+add_num;
            g_sms_length = temp_length;
            g_text_mode = SMS_TEXT_MODE_7BIT;
            g_content = str;
        }
    }
}

function hoardiv(){
    document.getElementById("coverUpDiv").style.visibility="visible";
    //var div_height=document.getElementById("allContent").offsetHeight;
    var div_width=document.body.clientWidth;
    //var div_top=document.getElementById("allContent").offsetTop;
    //var div_left=document.getElementById("allContent").offsetLeft;
    document.getElementById("coverUpDiv").style.height="150px";
    document.getElementById("coverUpDiv").style.width=div_width;
    //document.getElementById("coverUpDiv").style.top=div_top;
    //document.getElementById("coverUpDiv").style.left=div_left;
    //document.getElementById("coverUpDiv").style.filter="progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=50,finishOpacity=50";
    //document.getElementById("coverUpDiv").style.opacity="0.5"; 

}

function get_send_status()
{
    var smsReadData = getAjaxData("api/sms/send-status", "");
    var sendTotalCount = parseInt(getNode(smsReadData, "TotalCount"));
    var successCount = getCount(getNode(smsReadData, "SucPhone"));
    var failCount = getCount(getNode(smsReadData, "FailPhone"));
    var sendCurrentIndex = getNode(smsReadData, "CurIndex");
    var currentSentPhone = getNode(smsReadData, "Phone");
    setTextValue("process_message", dj('sms_hint_sending') +sendCurrentIndex + "/" + sendTotalCount);
    if ("" != currentSentPhone)
    {
        setTimeout("get_send_status()", 1000);
    }
    else
    {
        ///refresh("success.htm?page=smsnew&smsok="+successCount+"&smsfail="+failCount);
        document.getElementById("coverUpDiv").style.visibility="hidden";
        alert(successCount + " " + common_succeed+ common_comma 
                + failCount + " " + common_failed);
        successThenBack();
    }
}
function getCount(arrayStr)
{
    var count = 0;
    if (isEmpty(arrayStr))
    {
         return count;
    }

    var array = arrayStr.split(",");
    if (arrayStr.charAt(arrayStr.length - 1) == ",")
    {
        count = array.length - 1;
    }
    else
    {
        count = array.length;
    }

    return count;
}
function cancel_process_message()
{
    document.getElementById("coverUpDiv").style.visibility="hidden";
}
//
function cancel_sms_send()
{
    var submitData = "1";
    submitData = formatSubmitData(submitData);
    saveAjaxData("api/sms/cancel-send", submitData);
    
    var smsReadData = getAjaxData("api/sms/send-status", "");
    var successCount = getCount(getNode(smsReadData, "SucPhone"));
    var failCount = getCount(getNode(smsReadData, "FailPhone"));
	
    cancel_process_message();
    refresh("success.htm?page=smsnew&id=1&smsok="+successCount+"&smsfail="+failCount);
}

function sms_save()
{
    if(isButtonSaveDisable)
    {
        return;
    }
    var numbers;
    with(document.forms[0])
    {
        if((0 == iflag_local_sim)&&(ispace_sim < g_sms_num))
        {
            showErr("sms_hint_sim_card_full"); /*res.res  The sim card has not enough space to send local sms!*/
            return;
        }

        if("" == $.trim(sms_content.value) || "" != $.trim(phone_numbers.value))
        {
            if(false == send_numbers_check())
            {
                return;    
            }
        }
        
        if(SMS_TEXT_MODE_UCS2 == g_text_mode)
        {
            sms_content_check(sms_content.value,false);
            if(g_sms_length > SMS_UCS2_MAX_SIZE)
            {
                showErr("sms_hint_max_ucs2_characters_268"); /*The max UCS2 characters of SMS message is 268 */
                sms_content.select();
                return;
            }
        }
        else
        {
            g_text_mode =  SMS_TEXT_MODE_7BIT;
            sms_content_check(sms_content.value,false);
            if( 0 == FEATURE_SMS_LANG || null == FEATURE_SMS_LANG )
			{
	            if(g_sms_length > SMS_7BIT_MAX_SIZE)
	            {
	                showErr("sms_hint_max_ascii_characters_612");/*The max ASCII characters of SMS message is 612 */
	                sms_content.select();
	                return;
	            }
			}
			else
			{
	            if(g_sms_length > 149*4)
	            {
	                showErr("sms_hint_max_ascii_characters_596");
	                sms_content.select();
	                return;
	            }
			}	

        }
        numbers = phone_numbers.value.split(';');
    }

    var now = new Date().Format("yyyy-MM-dd hh:mm:ss");
    var submitData = "";
    if("" != sms_index && "smssdrafts" == page_history)
    {
        submitData = "<Index>" + sms_index + "</Index>";    
    }
    else
    {
        submitData = "<Index>-1</Index>";    
    }
    submitData += "<Phones>";
    for(i = 0;i<numbers.length;i++)
    {
        submitData = submitData +  "<Phone>"+$.trim(numbers[i])+"</Phone>";
    }

    g_content = g_content.replace(/&/g,"&amp;");
    g_content = g_content.replace(/</g,"&lt;");
    g_content = g_content.replace(/>/g,"&gt;");
    g_content = g_content.replace(/"/g,"&quot;");
    g_content = g_content.replace(/'/g,"&apos;");
    submitData +=  "</Phones>"
    + "<Sca></Sca>"
    + "<Content>" + g_content + "</Content>"
    + "<Length>" + g_sms_length + "</Length>"
    + "<Reserved>" + g_text_mode + "</Reserved>"
    + "<Date>" + now + "</Date>";
    submitData = formatSubmitData(submitData);
    saveAjaxData("api/sms/save-sms", submitData,function(xml){
    var ret = xml;
    if(ret.indexOf("<code>") > 0)
    {
        var id = getNode(ret, "code");
        //refresh("success.htm?page=smsnew&id="+id);
        if("113002" == id)
        {
            alert(sms_label_hint_message_full);
        }
        else
        {
            alert(common_failed);
        }
    }
    else
    {
        //refresh("success.htm?page=smsnew");
        alert(common_succeed);
        back();
    }
    });
}

//
var dataArray = new Array();

function getDetailContent(index, nBoxType, pageIndex)
{
    var initSubmitData = formatSmsListXml(pageIndex, nBoxType);
    var detailsContent = saveAjaxData("api/sms/sms-list",initSubmitData);
    var curSms = null;
    xml_to_array(detailsContent);
    for(var i = 0;i<dataArray.length;i++)
    {
        if(dataArray[i].Index == index)
        {
            curSms = dataArray[i];
            return curSms;
        }
    }
}
function showSmsDetail()
{
	var id = getParameter("id");
	if(isNaN(id)||id.length<1)
	return;
	var sms_para = getDetailContent(id);
	
	document.getElementById("phone_numbers").value= sms_para.Phone;
	//document.getElementById("date").value= sms_para[4];
	document.getElementById("sms_content").value= sms_para.Content;
}
//
function home()
{
    top.location.replace("indexs.htm");
}

//
function xml_to_array(objXmlData)
{
    var xml = "";
    if (typeof objXmlData == 'string') {
        
        if (!window.ActiveXObject) {
            var parser = new DOMParser();
            xml = parser.parseFromString(objXmlData, 'text/xml');
        }
        else {
            //IE
            xml = new ActiveXObject('Microsoft.XMLDOM');
            xml.async = false;
            xml.loadXML(objXmlData);
        }
    }
    else {
        xml = data;
    }
    var ret = xml2object($(xml));
    
    var index = 0;
    var dataXml = objXmlData;
    if (ret.type == "response") {
        if(ret.response.Messages.Message) {
            dataArray = new Array();
            if($.isArray(ret.response.Messages.Message)) {
                dataArray = ret.response.Messages.Message;
            } else {
                dataArray.push(ret.response.Messages.Message);
            }
        } else {
            // showInfoDialog(common_failed);
            log.error("SMS: get api/sms/sms-list data error");
        }
    } else {
        // showInfoDialog(common_failed);
        //log.error("SMS: get api/sms/sms-list data error");
    }
   
}

function formatSmsListXml(pageIndex, nBoxType)
{
    var requestXml  = '<?xml version="1.0" encoding="UTF-8"?>'
                            + '<request>'
                            + '<PageIndex>' + pageIndex + '</PageIndex>'
                            + '<ReadCount>' + readCount + '</ReadCount>'
                            + '<BoxType>' + nBoxType + '</BoxType>'
                            + '<SortType>0</SortType>'
                            + '<Ascending>0</Ascending>'
                            + '<UnreadPreferred>0</UnreadPreferred>'
                            + '</request>';
    return requestXml;
}

// $xml, which is an jQuery xml object.
function xml2object($xml) {
    var obj = new Object();
    if ($xml.find('response').size() > 0) {
        var _response = _recursiveXml2Object($xml.find('response'));
        obj.type = 'response';
        obj.response = _response;
    }
    else if ($xml.find('error').size() > 0) {
        var _code = $xml.find('code').text();
        var _message = $xml.find('message').text();
        log.warn('MAIN : error code = ' + _code);
        log.warn('MAIN : error msg = ' + _message);
        obj.type = 'error';
        obj.error = {
            code: _code,
            message: _message
        };
    }
    else if ($xml.find('config').size() > 0) {
        var _config = _recursiveXml2Object($xml.find('config'));
        obj.type = 'config';
        obj.config = _config;
    }
    else {
        obj.type = 'unknown';
    }
    return obj;
}

// internal use only
function _recursiveXml2Object($xml) {
    if ($xml.children().size() > 0) {
        var _obj = {};
        $xml.children().each(function() {
            var _childObj = ($(this).children().size() > 0) ? _recursiveXml2Object($(this)) : $(this).text();
            if ($(this).siblings().size() > 0 && $(this).siblings().get(0).tagName == this.tagName) {
                if (_obj[this.tagName] == null) {
                    _obj[this.tagName] = [];
                }
                _obj[this.tagName].push(_childObj);
            }
            else {
                _obj[this.tagName] = _childObj;
            }
        });
        return _obj;
    }
    else {
        return $xml.text();
    }
}

function sms_logout()
{
    if(islogoutDisable)
    {
        return;
    }
    
   return onLogout();
}
