$(document).ready(function(){
    formload();
    $(".sms_inboxlist_table tr:nth-child(even)").addClass("oddTrBg");
});

var smsUrl = window.location.href;
smsUrl = smsUrl.substring(0, smsUrl.lastIndexOf("."));
smsUrl = smsUrl.substring(smsUrl.lastIndexOf("/")+1);

var smsPageVar= {
    LocalUnread: SMS_COUNT_DEFAULT,
    LocalInbox: SMS_COUNT_DEFAULT,
    LocalOutbox: SMS_COUNT_DEFAULT,
    LocalDraft: SMS_COUNT_DEFAULT,
    LocalDeleted: SMS_COUNT_DEFAULT,
    SimUnread: SMS_COUNT_DEFAULT,
    SimInbox: SMS_COUNT_DEFAULT,
    SimOutbox: SMS_COUNT_DEFAULT,
    SimDraft: SMS_COUNT_DEFAULT,
    LocalMax: SMS_COUNT_DEFAULT,
    SimMax: SMS_COUNT_DEFAULT
};
var smsCountData = getAjaxData("/api/sms/sms-count","");
initPageVariable(smsCountData, "smsPageVar");	

var smsPageVar_CurrentCount = SMS_COUNT_DEFAULT;
var smsPageVar_UserCount = SMS_COUNT_DEFAULT;
var smsPageVar_TotalCount = SMS_COUNT_DEFAULT;
var smsPageVar_UnreadCount = SMS_COUNT_DEFAULT;
var sms_current_record = 0;
var apiName = "/api/sms/sms-list";
var apiSubmitData = "";
/*sms msg parameters start*/
var BOX_TYPE_ALL_INBOX = 1;
var BOX_TYPE_ALL_DRAFT = 3;
var BOX_TYPE_ALL_OUTBOX = 2;
var SORT_TYPE_DATE = 0;
var SORT_TYPE_NUMBER = 1;
var SORT_TYPE_NAME = 2;
var ASCENDING_ASC = 0;
var ASCENDING_DES = 1;
var UNREAD_PREFERRED_YES = 0;
var UNREAD_PREFERRED_NO = 1;
var SMS_SAVE_MODE_LOCAL = "0";
var SMS_SAVE_MODE_SIM = "1";
var SMS_SAVE_MODE_ALL = "2";
var SMS_ITEM_SIZE = 9;

var pageIndex = 1;
var readCount = 10;
var boxType = BOX_TYPE_ALL_INBOX;
var sortType = SORT_TYPE_DATE;
var asc = ASCENDING_DES;
var unreadPreferred = UNREAD_PREFERRED_YES;

var smsSaveMode = SMS_SAVE_MODE_ALL;
var totalSMSPage = 0;	
var SMS_READ_STATE = "1";    
var SMS_UNREAD_STATE = "0";
var smsListArray;

/*sms msg parameters end*/
initPage();

var smsSettingsData = getAjaxData("/api/sms/config", "");
smsSaveMode = getNode(smsSettingsData, "SaveMode");
var smsListData = saveAjaxData(apiName, apiSubmitData);
initSMSData(smsListData);

function getUnreadCount()
{
    saveSmsData("/api/sms/sms-count", "", function(smsCountData){
        initPageVariable(smsCountData, "smsPageVar");
        smsPageVar_UnreadCount = parseInt(smsPageVar["LocalUnread"]);
        initSmsMenu(smsPageVar_UnreadCount);
    });
    setTimeout("getUnreadCount()", 3000);
}
setTimeout("getUnreadCount()", 3000);

function formatSmsListXml()
{
    var requestXml  = '<?xml version="1.0" encoding="UTF-8"?>'
                            + '<request>'
                            + '<PageIndex>' + pageIndex + '</PageIndex>'
                            + '<ReadCount>' + readCount + '</ReadCount>'
                            + '<BoxType>' + boxType + '</BoxType>'
                            + '<SortType>' + sortType + '</SortType>'
                            + '<Ascending>' + asc + '</Ascending>'
                            + '<UnreadPreferred>' + unreadPreferred + '</UnreadPreferred>'
                            + '</request>';
    return requestXml;
}
function initPage()
{
    if("smssent" == smsUrl)
    {
        smsPageVar_CurrentCount =  parseInt(smsPageVar["LocalOutbox"]) + parseInt(smsPageVar["SimOutbox"]);
        boxType = BOX_TYPE_ALL_OUTBOX;
    }
    else if("smsdrafts" == smsUrl) 
    {
        smsPageVar_CurrentCount =  parseInt(smsPageVar["LocalDraft"]) + parseInt(smsPageVar["SimDraft"]);
        boxType = BOX_TYPE_ALL_DRAFT;
    }
    else
    {
        smsPageVar_CurrentCount =  parseInt(smsPageVar["LocalInbox"]) + parseInt(smsPageVar["SimInbox"]);
        boxType = BOX_TYPE_ALL_INBOX;
    }

    smsPageVar_UserCount = parseInt(smsPageVar["LocalOutbox"]) + parseInt(smsPageVar["SimOutbox"])
                                        + parseInt(smsPageVar["LocalDraft"]) + parseInt(smsPageVar["SimDraft"])
                                        + parseInt(smsPageVar["LocalInbox"]) + parseInt(smsPageVar["SimInbox"]);
    smsPageVar_TotalCount = parseInt(smsPageVar["LocalMax"]) + parseInt(smsPageVar["SimMax"]);
    smsPageVar_UnreadCount = parseInt(smsPageVar["LocalUnread"]) + parseInt(smsPageVar["SimUnread"]);

    var lastNum = getParameter("num");
    if (!isEmpty(lastNum))
    {
        pageIndex = parseInt(lastNum);
    }
    apiSubmitData = formatSmsListXml();
}
function onMark()
{
	$(":checkbox").attr("checked","true");
}
function onUnmarkAll()
{
	$(":checkbox").removeAttr("checked");
}

function initSmsMenu(unreadCount)
{
    setTextValue("label_sms_inbox", dj('sms_label_inbox') + "(" + unreadCount + ")");
}

function initSMSData(objData)
{
    if (smsPageVar_CurrentCount % readCount > 0)
    {
        totalSMSPage = parseInt(smsPageVar_CurrentCount / readCount) + 1;
    }
    else
    {
        totalSMSPage = parseInt(smsPageVar_CurrentCount / readCount);
        if(0 == totalSMSPage)
        {
            totalSMSPage = 1;
        }
    }

    var smsTmpData = objData;
    smsListArray = new Array();
    while(smsTmpData.indexOf("<Message>") != -1)
    {
        var smsItems = new Array(SMS_ITEM_SIZE);
        var startIndex = smsTmpData.indexOf("<Message>") + 9;
        var endIndex = smsTmpData.indexOf("</Message>");
        var tempSmsItem = smsTmpData.substring(startIndex, endIndex);
        smsItems[0] = getNode(tempSmsItem, "Smstat");
        smsItems[1] = getNode(tempSmsItem, "Index");
        smsItems[2] = getNode(tempSmsItem, "Phone");
        smsItems[3] = getNode(tempSmsItem, "Content");
        smsItems[4] = getNode(tempSmsItem, "Date");
        smsItems[5] = getNode(tempSmsItem, "Sca");
        smsItems[6] = getNode(tempSmsItem, "SaveType");
        smsItems[7] = getNode(tempSmsItem, "Priority");
        smsItems[8] = getNode(tempSmsItem, "SmsType");
        smsListArray.push(smsItems);
        smsTmpData = smsTmpData.substring(endIndex + 10);
    }
}

function formload()
{
    initSmsMenu(smsPageVar_UnreadCount);
    var page_tmp = "";
    
    setControlDisable("button_next", false);
    setControlDisable("button_pervious", false);
    setControlDisable("button_markall", false);
    setControlDisable("button_unmarkall", false);
    setControlDisable("button_delete", false);
    if((totalSMSPage == pageIndex) && (totalSMSPage > -1))
    {
        setControlDisable("button_next", true);
    }
    if(1 == pageIndex)
    {
        setControlDisable("button_pervious", true);
    }
    if (smsPageVar_CurrentCount == 0)
    {
        setControlDisable("button_markall", true);
        setControlDisable("button_unmarkall", true);
        setControlDisable("button_delete", true);
    }
    
    if(totalSMSPage >= 0)
    {
        page_tmp = dj("sms_label_page") + dj("common_colon") + pageIndex + "/" + totalSMSPage;
    }

    document.getElementById("sms_page").innerHTML = page_tmp;
    if((smsPageVar_CurrentCount >= 0) && (smsPageVar_TotalCount >= 0))
    {
        var mem_tmp = dj("sms_label_sms_storage_status")+ dj("common_colon") + smsPageVar_UserCount + "/" + smsPageVar_TotalCount;
        document.getElementById("label_sms_inbox_total").innerHTML = mem_tmp;
    }
    var num = parseInt(pageIndex);
    setSelected("select_page", num);
}

function perviousPage()
{
    pageIndex--;
    if (pageIndex <= 0)
    {
        pageIndex = 1;
    }
    apiSubmitData = formatSmsListXml();
    var newData = "";
    newData = saveAjaxData(apiName, apiSubmitData);
    initSMSData(newData);
    showItemList();
    formload();
}

function nextPage()
{
    pageIndex++;
    if (pageIndex > totalSMSPage)
    {
        pageIndex = totalSMSPage;
    }

    apiSubmitData = formatSmsListXml();
    var newData = "";
    newData = saveAjaxData(apiName, apiSubmitData);
    initSMSData(newData);
    showItemList();
    formload();
}

function pageChange()
{
    var selectPage = getSelected("select_page");
    if (isEmpty(selectPage))
    {
        pageIndex = 1;
    }
    else
    {
        pageIndex = parseInt(selectPage);
    }
    apiSubmitData = formatSmsListXml();
    var newData = "";
    newData = saveAjaxData(apiName, apiSubmitData);
    initSMSData(newData);
    showItemList();
    formload();
}

function smsDelete()
{
    var i;
    var box_id = "";
    var index_num= 0;
    var delete_index = "";
    var box_element = "";
    var checkbox_num = 0;

    checkbox_num = $(":checkbox").size(); 

    for (i=0;i< checkbox_num; i++)
    {
        box_id = "box"+i;
        box_element = document.getElementById(box_id);
        if(box_element.checked == true)
        {
            delete_index = delete_index+box_element.value+",";
            index_num++;
        }
    }
    if(0 == index_num)
    {
        showErr("sms_hint_select_deleted_sms_item");
        return;
    }
    var submitData = "<Index>" + delete_index + "</Index>";
    submitData = formatSubmitData(submitData);
    saveAjaxData("/api/sms/delete-sms", submitData); 
}

function showPageList()
{
    var max_length = totalSMSPage;
    for(var num = 1; num <= max_length; num++)
    {
        addSelectChild("select_page", num, num);
    }
}

function showItemList()
{
    var smsList = "";
    for (var i = 0; i < smsListArray.length; i++)
    {
        if (isEmpty(smsListArray[i][0]))
        {
            return;
        }
        var smsReadGif = '<img src = "../res/lit_read.gif">';
        if (smsListArray[i][0] == SMS_READ_STATE)
        {
            smsReadGif = '<img src = "../res/lit_read.gif">';
        }
        else if(smsListArray[i][0] == SMS_UNREAD_STATE)
        {
            smsReadGif = '<img src = "../res/lit_unread.gif">';
        }
            
        smsList += '<tr class="unread_td">';
        if(BOX_TYPE_ALL_INBOX == boxType)
        {
            smsList += '<td style="width: 50px"><label id="labicon' + i + '">' + smsReadGif + '</label></td>';
            smsList += '<td style="width: 135px"><a href="#" onclick="readOneSms(' +i+","+ smsListArray[i][1] + ')">' + smsListArray[i][4] + '</a></td>'; //date
        }
        smsList += '<td style="width: 125px"><a href="#" onclick="readOneSms('+i+","+ smsListArray[i][1] + ')">' + smsListArray[i][2] + '</a></td>';//phone
        if(smsListArray[i][3].length > 16)
        {
            smsList += '<td style="width: 330px"><a href="#" onclick="readOneSms('+i+","+ smsListArray[i][1] + ')">' + replaceStr(smsListArray[i][3].substr(0,16)+"...") + '</a></td>';//content
        }
        else
        {
            smsList += '<td style="width: 330px"><a href="#" onclick="readOneSms('+i+","+ smsListArray[i][1] + ')">' + replaceStr(smsListArray[i][3].substr(0,16)) + '</a></td>';//content
        }
        smsList += '<td style="width: 50px"><input id="box' + i + '" style="width: 15px" type="checkbox" value="' + smsListArray[i][1] + '" name="tdreaded' + i + '"></td>';
        smsList += '</tr>';
    }
    innerHTML("table_sms_inboxlist", smsList);
}

function replaceStr(objStr)
{
	var result = objStr;
	result = result.replace(/</g, "&lt;");
	return result;
}

/*read sms start*/
var readSmsIndex;
function readOneSms(index, smsIndex)
{
    if (BOX_TYPE_ALL_INBOX == boxType)
    {
        if (isEmpty(index))
        {
            index = 0;
        }
        else
        {
            index = parseInt(index);
        }

        setTextValue("sms_phone", smsListArray[index][2]);
        setTextValue("sms_date", smsListArray[index][4]);
        setTextValue("sms_content", smsListArray[index][3]);
        readSmsIndex = index;
        
        hide("div_sms_list");
        show("div_read_sms");

        var submitData = "<Index>" + smsListArray[index][1] + "</Index>";
        submitData = formatSubmitData(submitData);
        saveAjaxData("/api/sms/set-read", submitData);
        $("#labicon"+index+" image").attr("src", "../res/lit_read.gif");
        smsPageVar_UnreadCount--;
        smsPageVar_UnreadCount = smsPageVar_UnreadCount < 0 ? 0 : smsPageVar_UnreadCount; 
        initSmsMenu(smsPageVar_UnreadCount);
    }
    else
    {
        var smsJumpStr = "smsnew.htm?id=" + smsListArray[index][1] + "&page=" + smsUrl + "&num=" + pageIndex;
        refresh(smsJumpStr);
    }
}

function onBack()
{
    show("div_sms_list");
    hide("div_read_sms");
    setTextValue("sms_phone", "");
    setTextValue("sms_date", "");
    setTextValue("sms_content", "");
    readSmsIndex = -1;
}
function onReply()
{
    var index = readSmsIndex == -1 ? 0 : readSmsIndex;
    var smsJumpStr = "smsnew.htm?id=" + smsListArray[index][1] + "&page=" + smsUrl + "&num=" + pageIndex+"&type=r";
    refresh(smsJumpStr);
}
function onForward()
{
    var index = readSmsIndex == -1 ? 0 : readSmsIndex;
    var smsJumpStr = "smsnew.htm?id=" + smsListArray[index][1] + "&page=" + smsUrl + "&num=" + pageIndex + "&type=f";
    refresh(smsJumpStr);
}
function onDelete()
{
    var submitData = "<<Index>" + smsListArray[readSmsIndex][1] + "</Index>";
    submitData = formatSubmitData(submitData);
    saveAjaxData("/api/sms/delete-sms", submitData);
}
/*read sms end*/
