$(document).ready(function(){
    formLoad();
});
var SMS_INIT_OK = "0";
var SMS_INIT_FAIL = "-1";
var smsPageVar = {
    SimState: SIM_STATUS_DEFAULT,
    SimPINTimes: SIM_PIN_TIMES_DEFAULT,
    SimPUKTimes: SIM_PUK_TIMES_DEFAULT,
    SimLockEnable: SIM_LOCK_ENABLE,
    SimLockRemainTimes: SIM_LOCK_TIMES,
    SMSInit: SMS_INIT_OK
};
var simData = getAjaxData("/api/pin/status", "");
initPageVariable(simData, "smsPageVar");
var pinData = getAjaxData("/api/pin/save-pin", "");
var simLockData = getAjaxData("/api/pin/simlock", "");
initPageVariable(simLockData, "smsPageVar");
var smsData = getAjaxData("/api/sms/sms-count", "");
initSmsData();

function initSmsData()
{
    if (isEmpty(smsData) || smsData.indexOf("<Code>") > 0)
    {
        smsPageVar["SMSInit"] = SMS_INIT_FAIL;
    }
}

function formLoad()
{
    var displayPinFlag = false;
    setCheck("checkbox_save_pin", true);
    setTextValue("label_pin_remain_time", smsPageVar["SimPINTimes"]);
    setTextValue("label_puk_remain_times", smsPageVar["SimPUKTimes"]);


    unLockFormLoad();
    
    if(MACRO_CPIN_FAIL == smsPageVar["SimState"])
    {
        show("div_no_card");
    }
    else if(MACRO_PIN_REQ == smsPageVar["SimState"])
    {
        show("div_pin_req");
        displayPinFlag = true;
        if(true == displayPinFlag)
        {
            try
            {
                document.getElementById("input_CurrentPIN").onkeydown = isEnterPressedPin;
            }
            catch(e)
            {
            }
            focus("input_CurrentPIN");
        }
    }
    else if(MACRO_PUK_REQ == smsPageVar["SimState"])
    {
        show("div_puk_req");

        try
        {
            document.getElementById("input_PUK").onkeydown = isEnterPressedPuk ;
            document.getElementById("input_NewPIN").onkeydown = isEnterPressedPuk ;
            document.getElementById("input_ConfirmPIN").onkeydown = isEnterPressedPuk ;
        }
        catch(e)
        {
        }
        focus("input_PUK");
    }
    //else if ((sysinfo[5] == MACRO_SIM_LOCK_ENABLE) || (sysinfo[5] == MACRO_SIM_PLOCK_ENABLE))
    else if ((MACRO_SIM_LOCK_ENABLE == smsPageVar["SimLockEnable"]) || (MACRO_SIM_PLOCK_ENABLE == smsPageVar["SimLockEnable"]))
    {
        show("div_sim_unlock");
    }
    else if (MACRO_NO_SIM_CARD == smsPageVar["SimState"])
    {   
        show("div_no_card");
    }
    else if (MACRO_PIN_READY == smsPageVar["SimState"])
   {
        smsInition();
    }
    else
    {
        show("div_no_card");
    }
}

function unLockFormLoad()
{
    try
    {
        document.getElementById("input_CurrentSIMCode").onkeydown = isEnterPressed;
    }
    catch(e)
    {
    }
    if (SIM_LOCK_ENABLE == smsPageVar["SimLockEnable"])
    {
        setTextValue("label_simlock_remain_times", smsPageVar["SimLockRemainTimes"]);
        /* already locked */
        if ("0" == smsPageVar["SimLockRemainTimes"])
        {
            hide("tr_normal");
            hide("tr_permanent");
            hide("table_unlock_info");
        }
        else
        {
            hide("tr_normal");
            hide("tr_locked");
        }
    }
    else
    {
        //$("#simlock_remain_times").html(simlockinfo[1]);
        setTextValue("label_simlock_remain_times", smsPageVar["SimLockRemainTimes"]);
        hide("tr_permanent");
        hide("tr_locked");
    }
}

function btnSIMlockHandle()
{   
    var validateResult = validateSIMLock();
    if (true == validateResult)
    {
        var simCode = getTextValue("input_CurrentSIMCode");
        var submitData = "<CurrentSimCode>" + simCode + "</CurrentSimCode>";
        submitData = formatSubmitData(submitData);
        var result = saveAjaxData("simunlock", submitData);
        if (true == result)
        {
            refresh("sms.htm");
        }
    }
}
function validateSIMLock()
{
    var simCode = getTextValue("input_CurrentSIMCode");
    if ("" == simCode)
    {
        showErr("dialup_hint_password_empty");
        focus("input_CurrentSIMCode");
        return;
    }
    else if (false == isNumber(simCode))
    {
        showErr("dialup_hint_simlock_code_valid_type");
        focus("input_CurrentSIMCode");
        return;
    }
    else if ((simCode.length < 6) ||(simCode.length > 9))
    {
        showErr("dialup_hint_simlock_code_valid_type");
        focus("input_CurrentSIMCode");
        return false;
    }
    
    return true;
}
function isEnterPressed( evt )
{
    try{
            var evt = window.event ? window.event : evt;
            /* Check if enter is pressed down */
            switch( evt.keyCode )
            {
                case 13:  /* key code of "enter" */
                    btnPinHandle();
                    return false;
                default:
                    return true;
                    break;
            }
        }
    catch(e)
        {
            return true;
        }
}

function smsInition()
{
    if(SMS_INIT_FAIL == smsPageVar["SMSInit"])
    {
        showErr("sms_hint_sms_initializing");
        refresh("status.htm");
    }
    else
    {
        refresh("smsinbox.htm");
    }
}

function smsPageInit()
{
    if(MACRO_PIN_READY == smsPageVar["SimState"])
    {
        smsInition();
    }
}
smsPageInit();
	
function isEnterPressedPin( evt )
{
    try
    {
        var evt = window.event ? window.event : evt;
        /* Check if enter is pressed down */
        switch( evt.keyCode )
        {
            case 13:  /* key code of "enter" */
                btnPin();
                return false;
            default:
                return true;
                break;
        }
    }
    catch(e)
    {
        return true;
    }
}

function isEnterPressedPuk( evt )
{
    try
    {
        var evt = window.event ? window.event : evt;
        /* Check if enter is pressed down */
        switch( evt.keyCode )
        {
            case 13:  /* key code of "enter" */
                btnPuk();
                return false;
            default:
                return true;
                break;
        }
    }
    catch(e)
    {
        return true;
    }
}

function btnPuk()
{
    var validateResult = validatePuk();
    if (true == validateResult)
    {
        var pukCode = getTextValue("input_PUK");
        var newPin = getTextValue("input_NewPIN");
        var submitData = "<PUKCode>" + pukCode + "</PUKCode>"
                       + "<NewPIN>" + newPin + "</NewPIN>";
        submitData = formatSubmitData(submitData);
        var result = saveAjaxData("puk", submitData);
        if (false == result)
        {
            refresh("sms.htm");
        }
    }
}

function validatePuk()
{
    var pukCode = getTextValue("input_PUK");
    var newPin = getTextValue("input_NewPIN");
    var confirmPin = getTextValue("input_ConfirmPIN");
    if ("" == pukCode)
    {
        showErr("dialup_hint_puk_code_empty");
        focus("input_PUK");
        return false;
    }
    else if (8 != pukCode.length)
    {
        showErr("dialup_hint_puk_code_valid_type");
        focus("input_PUK");
        return false;
    }
    else if (false == isNumber(pukCode))
    {
        showErr("dialup_hint_puk_code_valid_type");
        focus("input_PUK");
        return false;
    }
    else if (newPin == '')
    {
        showErr("dialup_hint_new_pin_empty");
        focus("input_NewPIN");
        return false;
    }
    else if (((newPin.length < 4) || (newPin.length > 8)) )
    {
        showErr("dialup_hint_new_pin_valid_type");
        focus("input_NewPIN");
        return false;
    }
    else if (isNumber(newPin) == false)
    {
        showErr("dialup_hint_new_pin_valid_type");
        focus("input_NewPIN");
        return false;
    }
    else if (confirmPin == '')
    {
        showErr("dialup_hint_confirm_code_empty");
        focus("input_ConfirmPIN");
        return false;
    }
    else if (((confirmPin.length < 4) || (confirmPin.length > 8)))
    {
        showErr("dialup_hint_confirm_pin_valid_type");
        focus("input_ConfirmPIN");
        return false;
    }
    else if (isNumber(confirmPin) == false)
    {
        showErr("dialup_hint_confirm_pin_valid_type");
        focus("input_ConfirmPIN");
        return false;
    }
    else if (confirmPin != newPin)
    {
        showErr("dialup_hint_confirm_and_new_same");
        focus("input_ConfirmPIN");
        return false;
    }
    
    return true;
}

function btnPin()
{
    var pinCode = getTextValue("input_CurrentPIN");
    var simSavepinStatus = getCheck("checkbox_save_pin") == true ? MACRO_SAVE_PIN_ENABLED : MACRO_SAVE_PIN_DISABLED;
    var validateResult = validatePin();
    if (true == validateResult)
    {
        var submitData = pinData;
        
        submitData = setNode(submitData, "SimSavepinPIN", pinCode);
        submitData = setNode(submitData, "SimSavepinStatus", pinCode);
        submitData = formatSubmitData(submitData, "savepin");
        
        var result = saveAjaxData("savepin", submitData);
        if (true == result)
        {
            refresh("sms.htm");
        }
    }
}

function validatePin()
{
    var pinCode = getTextValue("input_CurrentPIN");
    /*Current PIN*/
    if ('' == pinCode)
    {
        showErr("dialup_hint_current_pin_empty");
        focus("input_CurrentPIN");
        return false;
    }
    else if ((pinCode.length < 4) || (pinCode.length > 8))
    {
        showErr("dialup_hint_pin_code_valid_type");
        focus("input_CurrentPIN");
        return false;
    }
    else if (isNumber(pinCode) == false)
    {
        showErr("dialup_hint_pin_code_valid_type");
        focus("input_CurrentPIN");
        return false;
    }
    
    return true;
}

