// JavaScript Document
//
var AP_STATION_CONNECTED = 2;

addStatusListener('getStatusFromUpdatingIcon()');

//Neither ap-station nor 3g or 2g.
function setBandWidthAndServiceStatusWhenNoServer() {
    $('#dbandwidth').html(common_unknown);
    $('#dservice_status').html(common_unknown);
}

//Switch bandwidth and seervice status when network type is 3g or 2g
function setBandWidthAndServiceStatus(monitring_obj) {
    if (typeof(monitring_obj.CurrentNetworkTypeEx) != 'undefined' &&
    monitring_obj.CurrentNetworkTypeEx != '') 
    {
        switch (monitring_obj.CurrentNetworkTypeEx) {
            case '0':
                $('#dbandwidth').html(common_unknown);
                break;
            case '1':
                $('#dbandwidth').html('14.4 Kbps DL / 14.4 Kbps UL');
                break;
            case '2':
                $('#dbandwidth').html('53.6 Kbps DL / 53.6 Kbps UL');
                break;
            case '3':
                $('#dbandwidth').html('236.8 Kbps DL / 236.8 Kbps UL');
                break;
            case '41':
                $('#dbandwidth').html('384 Kbps DL / 384 Kbps UL');
                break;
            case '42':
                $('#dbandwidth').html('7.2 Mbps DL / 384 Kbps UL');
                break;
            case '43':
                $('#dbandwidth').html('384 Kbps DL / 5.76 Mbps UL');
                break;
            case '44':
                $('#dbandwidth').html('7.2 Mbps DL / 5.76 Mbps UL');
                break;
            case '45':
                $('#dbandwidth').html('21 Mbps DL / 5.76 Mbps UL');
                break;
            default:
                $('#dbandwidth').html(common_unknown);
                break;
        }
    }
    else
    {
        switch (monitring_obj.CurrentNetworkType) {
            case '0':
                $('#dbandwidth').html(common_unknown);
                break;
            case '1':
                $('#dbandwidth').html('14.4 Kbps DL / 14.4 Kbps UL');
                break;
            case '2':
                $('#dbandwidth').html('53.6 Kbps DL / 53.6 Kbps UL');
                break;
            case '3':
                $('#dbandwidth').html('236.8 Kbps DL / 236.8 Kbps UL');
                break;
            case '4':
                $('#dbandwidth').html('384 Kbps DL / 384 Kbps UL');
                break;
            case '5':
                $('#dbandwidth').html('7.2 Mbps DL / 384 Kbps UL');
                break;
            case '6':
                $('#dbandwidth').html('384 Kbps DL / 5.76 Mbps UL');
                break;
            case '7':
                $('#dbandwidth').html('7.2 Mbps DL / 5.76 Mbps UL');
                break;
            case '9':
                $('#dbandwidth').html('21 Mbps DL / 5.76 Mbps UL');
                break;
            default:
                $('#dbandwidth').html(common_unknown);
                break;
        }
    }

    switch (monitring_obj.CurrentServiceDomain) {
        case '0':
            $('#dservice_status').html(common_no_service);
            break;
        case '1':
            $('#dservice_status').html(system_label_circuit_switched_capable);
            break;
        case '2':
            $('#dservice_status').html(system_label_packet_switch_capable);
            break;
        case '3':
            $('#dservice_status').html(system_label_circuit_packet_switched_capable);
            break;
        case '4':
            $('#dservice_status').html(common_searching);
            break;
        case '255':
            $('#dservice_status').html(common_unknown);
            break;
        default:
            $('#dservice_status').html(common_unknown);
            break;
    }
}

//When currently network type is Ap-station
function showApStationBandWidthAndServiceStatus() {
    $('#dbandwidth').html('72 Mbps');
    $('#dservice_status').html(dialup_label_wifi);
}

function getStatusFromUpdatingIcon() {
    var monitoring_ret = G_MonitoringStatus;
    var diagnosis_ret = G_StationStatus;
    if (g_module.ap_station_enabled && AP_STATION_CONNECTED == diagnosis_ret.response.ConnectStatus) {
        showApStationBandWidthAndServiceStatus();
    }
    else {
        if (2 != monitoring_ret.response.ServiceStatus) {
            setBandWidthAndServiceStatusWhenNoServer();
        }
        else {
            setBandWidthAndServiceStatus(monitoring_ret.response);
        }
    }
}

$(document).ready(function() {
    getAjaxData('api/dhcp/settings', function($xml) {
        var diagnosis_ret = xml2object($xml);
        if ('response' === diagnosis_ret.type) {
            $('#dip_address').html((diagnosis_ret.response.DhcpIPAddress == '' ? common_unknown : diagnosis_ret.response.DhcpIPAddress));
            $('#dsubnet_mask').html((diagnosis_ret.response.DhcpLanNetmask == '' ? common_unknown : diagnosis_ret.response.DhcpLanNetmask));
        }
        else {
            log.debug(diagnosis_ret.type);
        }
    });
});