//Signal status
var MACRO_EVDO_LEVEL_ZERO = "0";
var MACRO_EVDO_LEVEL_ONE = "1";
var MACRO_EVDO_LEVEL_TWO = "2";
var MACRO_EVDO_LEVEL_THREE = "3";
var MACRO_EVDO_LEVEL_FOUR = "4";
var MACRO_EVDO_LEVEL_FIVE = "5";

var LENGHT_OF_INDEX = 8;

var ERROR_WRONG_PASSWORD = '10002';

var SECURITY_MODE_NONE = "NONE";

var DIAD_CONNECT = '1';
var DIAD_DISCONNECT = '0';

var SECURITY_MODE_OPEN = 'OPEN';
var SECURITY_MODE_WEP = 'WEP';
var SECURITY_MODE_WPA_PSK = 'WPA-PSK';
var SECURITY_MODE_WPA2_PSK = 'WPA2-PSK';
var SECURITY_MODE_WPA_WPA2_PSK = 'WPA/WPA2-PSK';
var SECURITY_MODE_WPA_EAP = 'WPA-EAP';
var SECURITY_MODE_WPA2_EAP = 'WPA2-EAP';
var SECURITY_MODE_WPA_WPA2_EAP = 'WPA/WPA2-EAP';
var SECURITY_MODE_WPA_ENTERPRISE = 'WPA_ENTERPRISE';
var SECURITY_MODE_WPA2_ENTERPRISE = 'WPA2_ENTERPRISE';

var g_wifi_ap_info_list = [];
var g_wifiscanresult = [];
var g_isConnecting = false;

var WIFI_Not_CONNECTED = '-1';
var WIFI_CONNECTING = '900';
var WIFI_CONNECTED = '901';
var WIFI_DISCONNECTED = '902';
var WIFI_DISCONNECTING = '903';
var WIFI_CONNECT_ERROR = '904';

var WIFI_PREFER = 2;
var WIFI_SCAN_END = '0';
var WIFI_SCANING = '1';

var WIFI_MODE_AUTO = '0';
var WIFI_MODE_MANUAL = '1';

var g_WifiConnectionStatus = -1;

var g_ap_info = {
    WifiSsid : null,
    WifiSignal : null,
    WifiAuthMode : null,
    WifiSecMode : null,
    WifiNeedPassword : null,
    WifiConnectStatue : WIFI_Not_CONNECTED
};

var g_handover_setting = {
    Handover : '1'
};

var g_wifiscan = {
    Wifiscan : '0'
};

var g_current_ssid = '';

var g_current_id = null;

var g_isNewProfile = false;
var g_isWrongPassWord = false;
var g_current_index = -1;

$(document).ready(function() {

    $(".wifi_ap").live("mousemove", function() {
        g_current_id = this.id;

        if(!g_isConnecting) {
            $("#" + this.id + " .wifi_connect_button").show();
        }
        else {
            $("#" + this.id + " .wifi_connect_button").show();
            button_enable('wifi_connect', '0');
            button_enable(this.id + " .wifi_connect_button", '0');

        }

    });

    $(".wifi_ap").live("mouseout", function() {
        $(".wifi_connect_button").hide();

    });
    addStatusListener('CheckWiFiConnectStaute()');

    getHandoverSetting();
    
    //getWiFiAPinfo();

    $('#turnOff_button').live('click', function() {
        if(!isButtonEnable('turnOff_button')) {
            return;
        }
        g_handover_setting.Handover = '0';
        $('#turnOff_button').removeClass('mouse_on');
        button_enable('turnOff_button', '0');
        setHandoverSetting();

    });
    $('#turnOn_button').live('click', function() {
        if(!isButtonEnable('turnOn_button')) {
            return;
        }
        g_handover_setting.Handover = '2';
        $('#turnOn_button').removeClass('mouse_on');
        button_enable('turnOn_button', '0');
        setHandoverSetting();

    });

    $('#pop_cancel').live('click', function() {
        if(!isButtonEnable('cancel_btn')) {
            return;
        }
        promag_cancel();
    });

    $('#pop_authmode').live('change', function() {
        if(SECURITY_MODE_NONE == this.value || SECURITY_MODE_WPA_WPA2_EAP == this.value) {
            $('#password_wrapper').hide();
            $('.addwifi_dialog_table').css({
                height : '160px'
            });

        }
        else {
            $('#password_wrapper').show();
            $('.addwifi_dialog_table').css({
                height : '220px'
            });
        }
    });

    $('#check_wpa_psk').live('click', function() {
        showPassword();
    });

    $('#pop_save').live('click', function() {
        if(!isButtonEnable('cancel_btn')) {
            return;
        }
        var wifissid = $('#ssid_input').val();
        var wifiAuthMode = $('#pop_authmode').val();
        var WifiAuthSecret = $('#wifi_password').val();
        if(wifiProfile_validation_checkName(wifissid, WifiAuthSecret, wifiAuthMode)) {
            disconnectConnectedWiFi();
            var wifiProfile = {
                WifiSsid : wifissid,
                WifiAuthMode : '',
                WifiSecMode : wifiAuthMode,
                WifiAuthSecret : WifiAuthSecret
            };

            var g_ap_info = {
                WifiSsid : wifissid,
                WifiSignal : '1',
                WifiAuthMode : null,
                WifiSecMode : wifiAuthMode,
                WifiNeedPassword : false,
                WifiConnectStatue : WIFI_CONNECTING
            };
            g_isNewProfile = true;
            addToApinfoList(g_ap_info);
            g_current_index = 0;
            setProfileSetting(wifiProfile, 0);
            $('#wifi_scan').hide();
            $('#wifi_no_ap').hide();
            $('#wifioffload_setting').show();
            promag_cancel();
        }
    });

    $('#wifi_connect').live('click', function() {
        if(!isButtonEnable('wifi_connect')) {
            return;
        }
        g_current_index = getWiFiIndex(g_current_id);
        if(g_wifi_ap_info_list[g_current_index].WifiNeedPassword) {
            showPasswrodDiag();
        }
        else {
            disconnectConnectedWiFi();
            var wifiProfile = {
                WifiSsid : g_wifi_ap_info_list[g_current_index].WifiSsid,
                WifiAuthMode : g_wifi_ap_info_list[g_current_index].WifiAuthMode,
                WifiSecMode : g_wifi_ap_info_list[g_current_index].WifiSecMode,
                WifiAuthSecret : ''
            };
            g_isNewProfile = false;
            setProfileSetting(wifiProfile, g_current_index);
        }

    });

    $('#wifi_disconnect').live('click', function() {
        if(!isButtonEnable('wifi_disconnect')) {
            return;
        }
        disconnectWiFi(0);
    });

    $('#intput_save').live('click', function() {
        if(!isButtonEnable('intput_save')) {
            return;
        }
        var WifiAuthSecret = $('#password_input').val();
        if(checkWifiSecurity(WifiAuthSecret, g_wifi_ap_info_list[g_current_index].WifiSecMode, 'password_input')) {
            disconnectConnectedWiFi();
            g_wifi_ap_info_list[g_current_index].WifiAuthSecret = WifiAuthSecret;
            var wifiProfile = {
                WifiSsid : g_wifi_ap_info_list[g_current_index].WifiSsid,
                WifiAuthMode : g_wifi_ap_info_list[g_current_index].WifiAuthMode,
                WifiSecMode : g_wifi_ap_info_list[g_current_index].WifiSecMode,
                WifiAuthSecret : g_wifi_ap_info_list[g_current_index].WifiAuthSecret
            };
            //g_isNewProfile = false;
            g_isWrongPassWord = false;
            setProfileSetting(wifiProfile, g_current_index);
            promag_cancel();
        }
    });

    $('#intput_cancel').live('click', function() {
        if(g_isNewProfile) {
            removeFromApinfoList(0);
            g_isNewProfile = false;
        }
        g_isWrongPassWord = false;
        promag_cancel();
    });

    $('#scan_button').live('click', function() {
        if(!isButtonEnable('scan_button')) {
            return;
        }
        scanWifi();
    });

    $('.dialog_close_btn, .pop_Cancel').live('click', function() {
        if(g_isNewProfile) {
            removeFromApinfoList(0);
            g_isNewProfile = false;
        }
        g_isWrongPassWord = false;

    });

    $('.dialog_close_btn').live('click', function() {
        if(g_isNewProfile) {
            removeFromApinfoList(0);
            g_isNewProfile = false;
        }
    });
});
function disconnectConnectedWiFi() {
    if(g_wifi_ap_info_list.length > 0) {
        if(WIFI_CONNECTING == g_wifi_ap_info_list[0].WifiConnectStatue || WIFI_CONNECTED == g_wifi_ap_info_list[0].WifiConnectStatue) {
            g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_Not_CONNECTED;
            //disconnectWiFi(0);
        }    
    }
    
}

function promag_cancel() {
    $('#div_wrapper').remove();
    $('.dialog').remove();
    $('.login_dialog').remove();
}

function disconnectWiFi(index) {
    var wifiDial = {
        DialAction : DIAD_DISCONNECT,
        WifiSsid : g_wifi_ap_info_list[index].WifiSsid,
        WifiSecMode : g_wifi_ap_info_list[index].WifiSecMode
    };
    var isAddNewAP = false;
    if(WIFI_Not_CONNECTED == g_wifi_ap_info_list[index].WifiConnectStatue) {
        isAddNewAP = true;
    }
    var dial_xml = object2xml('request', wifiDial);
    saveAjaxData('api/wlan/wifidial', dial_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
            log.debug('api/wlan/wifidial ok');
            if(!isAddNewAP) {
                g_wifi_ap_info_list[index].WifiConnectStatue = WIFI_DISCONNECTING;
                moveToTopOfApLsit(g_wifi_ap_info_list[index].WifiSsid);
                creatWifiList();
            }

        }
        else {
            log.debug('api/wlan/wifidial error');
        }
    });
}

function connectWiFi(index) {
    var wifiDial = {
        DialAction : DIAD_CONNECT,
        WifiSsid : g_wifi_ap_info_list[index].WifiSsid,
        WifiSecMode : g_wifi_ap_info_list[index].WifiSecMode
    };
    var dial_xml = object2xml('request', wifiDial);
    saveAjaxData('api/wlan/wifidial', dial_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
            log.debug('api/wlan/wifidial ok');
            g_wifi_ap_info_list[index].WifiConnectStatue = WIFI_CONNECTING;
            moveToTopOfApLsit(g_wifi_ap_info_list[index].WifiSsid);
            creatWifiList();
        }
        else {
            log.debug('api/wlan/wifidial error');
        }
    }, {
        sync : true
    });

    getAjaxData('api/monitoring/status', function($xml) {
        var ret = xml2object($xml);
        if (ret.type == 'response') {
            G_MonitoringStatus = ret;
        }
    }, {
        sync : true
    });
}

function setProfileSetting(wifiProfile, index) {

    var profile_xml = object2xml('request', wifiProfile);
    saveAjaxData('api/wlan/wifiaddprofile', profile_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
            log.debug('api/wlan/wifiaddprofile ok');
            connectWiFi(index);
        }
        else {
            log.debug('api/wlan/wifiaddprofile error');
        }
    });
}

function getWiFiIndex(current_id) {
    var index = current_id.substring(LENGHT_OF_INDEX, current_id.length);
    return parseInt(index, 10);
}

function showPassword() {
    var cbValue = $('#check_wpa_psk').attr('checked');
    var strType = cbValue ? 'text' : 'password';
    var a = $('#wifi_password').attr('type');
    $("<input id='wifi_password' type='" + strType + "' class='input'  value='" + $('#wifi_password').val() + "' />").replaceAll($('#wifi_password'));

}

//Button connection or disconnection click effect
function index_clickTrunOnBtn() {

    scanWifi();
    $('#wifi_switch_button').html(create_button_html(common_turn_off, "turnOff_button"));

}

function index_clickTurnOffBtn() {

    $('#wifi_switch_button').html(create_button_html(common_turn_on, "turnOn_button"));
    $('#wifi_content').hide();
    $('#scan_button').hide();

}

function getHandoverSetting() {
    getAjaxData("api/wlan/handover-setting", function($xml) {
        var ret = xml2object($xml);
        if(ret.type == "response") {
            if(WIFI_PREFER == ret.response.Handover) {
                index_clickTrunOnBtn();
            }
            else {
                index_clickTurnOffBtn();
            }
        }
        else {
            log.error("WiFi network: get api/wlan/handover-setting data error");
        }
    });
}

function setHandoverSetting() {
    var handDover_xml = object2xml('request', g_handover_setting);
    saveAjaxData('api/wlan/handover-setting', handDover_xml, function($xml) {
        var ret = xml2object($xml);
        if(isAjaxReturnOK(ret)) {
            log.debug('api/wlan/handover-setting ok');

            if(WIFI_PREFER == g_handover_setting.Handover) {
                index_clickTrunOnBtn();
            }
            else {
                index_clickTurnOffBtn();
            }
        }
        else {
            log.debug('api/wlan/handover-setting error');
        }
    });
}

function scanWifi() {
    $('#scan_button').show();
    $('#wifi_scan').show();

    $('#wifi_content').show();
    $('#wifioffload_setting').hide();
    $('#wifi_no_ap').hide();

    button_enable('addWiFI_button', '0');
    button_enable('scan_button', '0');
    var sacn_xml = object2xml('request', g_wifiscan);
    saveAjaxData('api/wlan/wifiscan', sacn_xml, function($xml) {
        var sacn_ret = xml2object($xml);
        if(isAjaxReturnOK(sacn_ret)) {
            g_wifi_ap_info_list = [];
            checkWifiScanStaute();
        }
        else {
            log.debug('WiFi network: post api/wlan/wifiscan error');
        }
    });
}

function checkWifiScanStaute() {
    getAjaxData("api/wlan/wifiscan", function($xml) {
        var ret = xml2object($xml);
        if(ret.type == "response") {
            if(WIFI_SCAN_END == ret.response.Wifiscan) {
                getWiFiAPinfo();
            }
            else if(WIFI_SCANING == ret.response.Wifiscan) {
                setTimeout(function() {
                    checkWifiScanStaute();
                }, 1000);
            }
        }
        else {
           
            $('#wifi_scan').hide();
            $('#wifi_no_ap').show();
            $('#wifioffload_setting').hide();
            g_wifiscanresult = [];

            button_enable('addWiFI_button', '1');
            button_enable('scan_button', '1');
            log.error("WiFi network: get api/wlan/wifiscan  data error");
        }
    });
}

function getWiFiAPinfo() {
    getAjaxData("api/wlan/wifiscanresult", function($xml) {
        var ret = xml2object($xml);
        if(ret.type == "response") {
            g_wifiscanresult = ret.response.SsidLists.SsidList;
            if($.isArray(g_wifiscanresult) || 
               ((typeof (g_wifiscanresult) != 'undefined') && g_wifiscanresult != null && g_wifiscanresult != '')) {
                setWiFiList();
                CheckWiFiConnectStaute();
                $('#wifi_scan').hide();
                $('#wifi_no_ap').hide();
                $('#wifioffload_setting').show();
            } else {
                 $('#wifi_scan').hide();
                 $('#wifi_no_ap').show();
                 $('#wifioffload_setting').hide();
            }

        }
        else {
            $('#wifi_scan').hide();
            $('#wifi_no_ap').show();
            $('#wifioffload_setting').hide();
            g_wifiscanresult = [];

        button_enable('addWiFI_button', '1');
        button_enable('scan_button', '1');
            log.error("WiFi network: get api/wlan/wifiscanresult data error");
        }
    });
}

function CheckWiFiConnectStaute() {
    /* if (G_MonitoringStatus.response.WifiConnectionStatus == WIFI_CONNECTED ||
    G_MonitoringStatus.response.WifiConnectionStatus == WIFI_CONNECTING ||
    G_MonitoringStatus.response.WifiConnectionStatus == WIFI_DISCONNECTING )
    {*/
    //getAjaxData("api/wlan/station-information", function($xml) {
    var ret = G_StationStatus;
    if(ret.type == "response") {

        //g_WifiConnectionStatus =
        // G_MonitoringStatus.response.WifiConnectionStatus;
        if(g_wifi_ap_info_list.length > 0) {

            if(ret.response.NetworkName == '' || ret.response.NetworkName == null) {
                g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_Not_CONNECTED;
            }
            else if(G_MonitoringStatus.response.WifiConnectionStatus == WIFI_CONNECTED && g_wifi_ap_info_list[0].WifiSsid == ret.response.NetworkName) {
                g_wifi_ap_info_list[0].WifiSignal = ret.response.SignalStrength;
            }
            else if(ret.response.NetworkName != g_wifi_ap_info_list[0].WifiSsid) {
                g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_Not_CONNECTED;
                moveToTopOfApLsit(ret.response.NetworkName);
                if(G_MonitoringStatus.response.WifiConnectionStatus == WIFI_CONNECTED) {
                    g_wifi_ap_info_list[0].WifiSignal = ret.response.SignalStrength;
                }

            }
            
            if(g_isNewProfile && 
                (WIFI_CONNECTING != G_MonitoringStatus.response.WifiConnectionStatus && 
                 WIFI_CONNECTED != G_MonitoringStatus.response.WifiConnectionStatus)) {
                    g_isNewProfile = false;
                    removeFromApinfoList(0);
                    if(g_wifi_ap_info_list.length <= 0) {
                        $('#wifi_no_ap').show();
                        $('#wifioffload_setting').hide();
                    }
            }
        }

        changeWiFiList(ret.response.NetworkName);
    }
    else {
        g_current_ssid = '';
        if(ret.type == 'error') {
            if(ERROR_WRONG_PASSWORD == ret.error.code) {
                g_isWrongPassWord = true;
                showPasswrodDiag();
            }
        }
        log.error("WiFi network: get api/wlan/station-information data error");
    }
    //  });
    /* }
     else {
     changeWiFiList(ret.response.NetworkName);
     }*/
}

function setWiFiList() {
    g_wifi_ap_info_list = [];
    if($.isArray(g_wifiscanresult)) {
        $.each(g_wifiscanresult, function(i) {
            var ap_info = {
                WifiSsid : g_wifiscanresult[i].WifiSsid,
                WifiSignal : g_wifiscanresult[i].WifiSignal,
                WifiAuthMode : g_wifiscanresult[i].WifiAuthMode,
                WifiSecMode : g_wifiscanresult[i].WifiSecMode,
                WifiNeedPassword : ('1' == g_wifiscanresult[i].WifiNeedPassword ? true : false),
                WifiConnectStatue : WIFI_Not_CONNECTED
            };
            g_wifi_ap_info_list.push(ap_info);
        });
    }
    else {
        var ap_info = {
            WifiSsid : g_wifiscanresult.WifiSsid,
            WifiSignal : g_wifiscanresult.WifiSignal,
            WifiAuthMode : g_wifiscanresult.WifiAuthMode,
            WifiSecMode : g_wifiscanresult.WifiSecMode,
            WifiNeedPassword : ('1' == g_wifiscanresult.WifiNeedPassword ? true : false),
            WifiConnectStatue : WIFI_Not_CONNECTED
        };
        g_wifi_ap_info_list.push(ap_info);
    }

}

function addToApinfoList(ap_info) {
    g_wifi_ap_info_list.unshift(ap_info);
}

function removeFromApinfoList(index) {
    g_wifi_ap_info_list.splice(index, 1);
}

function moveToTopOfApLsit(NetworkName) {
    var i = 0;
    var index = -1;
    for(i; i < g_wifi_ap_info_list.length; i++) {
        if(NetworkName == g_wifi_ap_info_list[i].WifiSsid) {
            index = i;
            break;
        }
    }
    if(-1 != index && 0 != index) {
        var wifi_ap_info = g_wifi_ap_info_list.splice(index, 1);
        g_wifi_ap_info_list.unshift(wifi_ap_info[0]);
    }
}

function changeWiFiList(NetworkName) {
    var index = 0;
    if(g_wifi_ap_info_list.length > 0) {
         moveToTopOfApLsit(NetworkName);
         g_wifi_ap_info_list[0].WifiConnectStatue = G_MonitoringStatus.response.WifiConnectionStatus;
        /*switch(g_wifi_ap_info_list[0].WifiConnectStatue) {
            case WIFI_Not_CONNECTED:

                
                 g_wifi_ap_info_list[0].WifiConnectStatue = G_MonitoringStatus.response.WifiConnectionStatus;
                break;
            case WIFI_CONNECTING:
                    g_wifi_ap_info_list[0].WifiConnectStatue = G_MonitoringStatus.response.WifiConnectionStatus;

                break;
            case WIFI_DISCONNECTING:
                if(WIFI_DISCONNECTED == G_MonitoringStatus.response.WifiConnectionStatus) {
                    g_wifi_ap_info_list[0].WifiConnectStatue = G_MonitoringStatus.response.WifiConnectionStatus;
                }
                break;
            case WIFI_CONNECTED:
                if(WIFI_DISCONNECTED == G_MonitoringStatus.response.WifiConnectionStatus) {
                    g_wifi_ap_info_list[0].WifiConnectStatue = WIFI_Not_CONNECTED;
                }
                break;
            case WIFI_DISCONNECTED:
                if(WIFI_CONNECTED == G_MonitoringStatus.response.WifiConnectionStatus) {
                    g_wifi_ap_info_list[0].WifiConnectStatue = G_MonitoringStatus.response.WifiConnectionStatus;
                }
                break;
            default:
                break;
        }*/

        creatWifiList();
        g_WifiConnectionStatus = G_MonitoringStatus.response.WifiConnectionStatus;
    }

}

function creatWifiList() {
    var wifiTableHtml = "";
    var i = 0;
    var wifiSignal = "";

    var isConnecting = false;

    for(i; i < g_wifi_ap_info_list.length; i++) {
        wifiSignal = setWifiSignal(g_wifi_ap_info_list[i].WifiSignal);
        var wifiTrId = "wifi_ap_" + i;
        var wifiSignalId = "wifi_signal_" + i;
        var SecurityMode = "";

        /* if(g_wifi_ap_info_list[0].WifiConnectStatue == WIFI_Not_CONNECTED) {

         }
         else {*/
        switch(g_wifi_ap_info_list[i].WifiConnectStatue) {
            case WIFI_CONNECTING:
                SecurityMode = dialup_label_connecting;
                break;
            case WIFI_CONNECTED:
                SecurityMode = dialup_label_connected;
                break;
            /*case WIFI_DISCONNECTING:
            case WIFI_DISCONNECTED:
            case WIFI_Not_CONNECTED:
                if(SECURITY_MODE_NONE == g_wifi_ap_info_list[i].WifiSecMode) {
                    SecurityMode = wlan_label_open;
                }
                else {
                    SecurityMode = wifi_label_Secure_mode.replace('%s', g_wifi_ap_info_list[i].WifiSecMode);
                }
                break;*/
            default:
                if(SECURITY_MODE_NONE == g_wifi_ap_info_list[i].WifiSecMode) {
                    SecurityMode = wlan_label_open;
                }
                else {
                    SecurityMode = wifi_label_Secure_mode.replace('%s', g_wifi_ap_info_list[i].WifiSecMode);
                }
                break;
        }
        // }

        var signal_photo = '';
        if(g_wifi_ap_info_list[i].WifiNeedPassword) {
            signal_photo = "../res/stationkey_" + wifiSignal + ".gif";
        }
        else {
            signal_photo = "../res/station_" + wifiSignal + ".gif";
        }
        wifiTableHtml += "<tr class='wifi_ap' id='" + wifiTrId + "'>";
        wifiTableHtml += "<td width='180'>";
        wifiTableHtml += "<div class='wifiName'><span>" + replaceSpace(g_wifi_ap_info_list[i].WifiSsid) + "</span></div>";
        wifiTableHtml += "<div>" + SecurityMode + "</div>";
        wifiTableHtml += "</td>";
        wifiTableHtml += "<td><div class='wifi_signal'  style='background: url(" + signal_photo + ") 0 0 no-repeat' ></div>";
        wifiTableHtml += "</td>";
        wifiTableHtml += "<td width='140'>";
        wifiTableHtml += "<label class='wifi_connect_button' style='display:none'>";
        if(WIFI_CONNECTING != g_wifi_ap_info_list[i].WifiConnectStatue && WIFI_CONNECTED != g_wifi_ap_info_list[i].WifiConnectStatue) {
            wifiTableHtml += create_button_html(common_connect, 'wifi_connect');
        }
        /*else if(WIFI_CONNECTED == g_wifi_ap_info_list[i].WifiConnectStatue) {
         wifiTableHtml +=
        create_button_html(common_disconnect,'wifi_disconnect');
         }*/
        wifiTableHtml += "</label>";
        wifiTableHtml += "</td>";
        wifiTableHtml += "</tr>";

        /*$('.wifi_signal').css({
         background: 'url(' + signal_photo + ') 0 0 no-repeat'
             'float':'left',
         width:'134px',
         'padding-top': '30px',
         "text-align":'left'

         });*/

    }
    $('.wifioffload_settings').html(wifiTableHtml);

    if(g_wifi_ap_info_list.length > 0 && WIFI_CONNECTING == g_wifi_ap_info_list[0].WifiConnectStatue) {
        g_isConnecting = true;
        $('#scan_button').removeClass('mouse_on');
        button_enable('scan_button', '0');
        $('#addWiFI_button').removeClass('mouse_on');
        button_enable('addWiFI_button', '0');

        button_enable('wifi_connect', '0');

    }
    else {
        g_isConnecting = false;
        button_enable('scan_button', '1');
        button_enable('addWiFI_button', '1');

        button_enable('wifi_connect', '1');
    }
}

function addNewWifi() {
    if(!isButtonEnable('addWiFI_button')) {
        return;
    }
    //call_dialog(common_edit, g_promag_dialogContent, common_save, 'pop_Save',
    // common_cancel, 'pop_Cancel');
    showAddWiFiDialog();
}

function showAddWiFiDialog() {
    $('#div_wrapper').remove();
    $('.login_dialog').remove();

    var dialogHtml = '';
    if($('#div_wrapper').size() < 1) {
        dialogHtml += "<div id='div_wrapper'><iframe   id='ifream_dialog'  src= '' frameborder= '0' style= 'background:#bcbcbc; position:absolute; width:100%; height:100%; z-index:-1; display: block;'> </iframe></div>";
    }
    dialogHtml += "<div class='login_dialog' id='dialog'>";
    dialogHtml += "    <div class='login_dialog_top'></div>";
    dialogHtml += "    <div class='login_dialog_content'>";
    dialogHtml += "        <div class='login_dialog_header'>";
    dialogHtml += "            <span class='dialog_header_left'>" + wifi_label_addwifi_network + '</span>';
    dialogHtml += "            <span class='dialog_header_right'><a class='dialog_close_btn' title='' href='javascript:void(0);'><img src='../res/dialog_close_btn.gif' title='' alt='' /></a></span>";
    dialogHtml += '        </div>';
    dialogHtml += "        <div class='addwifi_dialog_table'>";
    dialogHtml += "               <div class='login'>";
    dialogHtml += "               <div id='ssid_div'>";
    dialogHtml += '                   <p>' + wlan_label_ssid + common_colon + '</p>';
    dialogHtml += "                   <span><input type='text' class='input' id='ssid_input' maxlength='32'/></span>";
    dialogHtml += '               </div>';
    dialogHtml += "               <div id='authentication_div'>";
    dialogHtml += '               <p>' + wlan_label_authentication + common_colon + '</p>';
    dialogHtml += "                   <span>";
    dialogHtml += "                       <select name='authentication_mode' id='pop_authmode'>";
    dialogHtml += "                       <option value='" + SECURITY_MODE_NONE + "'>" + wlan_label_open + '</option>';
    dialogHtml += "                        <option value='" + SECURITY_MODE_WEP + "'>" + wlan_label_wep + '</option>';
    dialogHtml += "                        <option value='" + SECURITY_MODE_WPA_WPA2_PSK + "'>" + wlan_label_wpa_wpa2_psk + '</option>';
    dialogHtml += '                       </select>';
    dialogHtml += "                   </span>";
    dialogHtml += '               </div>';
    dialogHtml += "               <div id='password_wrapper'>";
    dialogHtml += '                  <p>' + common_password + common_colon + '</p>';
    dialogHtml += "                   <span><input type='password'  class='input' id='wifi_password' /></span>";
    dialogHtml += '               </div>';
    dialogHtml += '           </div>';
    dialogHtml += '        </div>';
    dialogHtml += "        <div class='login_dialog_table_bottom'>";
    dialogHtml += "              <span class='button_wrapper pop_save' id='pop_save'>";
    dialogHtml += "                  <span class='button_left'>";
    dialogHtml += "                      <span class='button_right'>";
    dialogHtml += "                            <span class='button_center'><a href='javascript:void(0);' title=''>" + common_save + '</a></span>';
    dialogHtml += '                      </span></span></span>';
    dialogHtml += "              <span class='button_wrapper' id='pop_cancel'>";
    dialogHtml += "                  <span class='button_left'>";
    dialogHtml += "                      <span class='button_right'>";
    dialogHtml += "                            <span class='button_center'><a href='javascript:void(0);' title=''>" + common_cancel + '</a></span>';
    dialogHtml += '                      </span></span></span>';
    dialogHtml += '        </div>';
    dialogHtml += '    </div>';
    dialogHtml += "    <div class='login_dialog_bottom'></div>";
    dialogHtml += '</div>';

    $('.body_bg').before(dialogHtml);

    reputPosition($('#dialog'), $('#div_wrapper'));
    g_main_displayingPromptStack.push('pop_save');

    $('#password_wrapper').hide();
    $('#ssid_input').focus();

    $('.addwifi_dialog_table').css({
        height : '160px'
    });

    disableTabKey();
}

function wifiProfile_validation_checkName(wifissid, WifiAuthSecret, wifiAuthMode) {
    clearAllErrorLabel();
    var errMsg = common_ok;
    var i = 0;
    if(0 == wifissid.length) {
        errMsg = wlan_hint_ssid_empty;
    }
    else if(hasSpaceOrTabAtHead(wifissid)) {
        errMsg = input_cannot_begin_with_space;
    }
    else if(32 < wifissid.length) {
        errMsg = wizard_help_name_ssid;
    }
    else {
        for( i = 0; i < wifissid.length; i++) {
            var c = wifissid.charCodeAt(i);
            if((c >= CHARCODE_0 && c <= CHARCODE_9) || (c >= CHARCODE_A && c <= CHARCODE_Z) || (c >= CHARCODE_a && c <= CHARCODE_z) || c == CHARCODE_DASH || c == CHARCODE_UNDERLINE || c == CHARCODE_DOT || c == CHARCODE_SPACE) {
               errMsg = common_ok;
            }
            else {
                errMsg = wlan_hint_ssid_valid_char;
                break;
            }
        }
    }

    if(common_ok != errMsg) {
        showErrorUnderTextbox('ssid_input', errMsg);
        $('#ssid_input').focus();
        $('#ssid_input').select();
        return false;
    }
    else if(!checkWifiSecurity(WifiAuthSecret, wifiAuthMode, 'wifi_password')) {
        return false;
     
    }

    return true;
}

function checkWifiSecurity(WifiAuthSecret, wifiAuthMode, id) {
    var strNetworkKey = WifiAuthSecret;
    var authMethod = wifiAuthMode;
    
    clearAllErrorLabel();
	
    if(SECURITY_MODE_WPA_PSK == authMethod || SECURITY_MODE_WPA2_PSK == authMethod || SECURITY_MODE_WPA_WPA2_PSK == authMethod) {
        return checkWpaPwd(WifiAuthSecret, id);
    }
    else if(SECURITY_MODE_WEP == authMethod) {
        return checkNWepKeyPwd(WifiAuthSecret, id);
    }
    else {
        return true;
    }
}

function checkNWepKeyPwd(password, id) {
    var pwdVal = password;
    var errMsg = null;
    var ret = false;
	
    if(0 == pwdVal.length) {
        errMsg = dialup_hint_password_empty;
    }
    else if(hasSpaceOrTabAtHead(pwdVal)) {
        errMsg = input_cannot_begin_with_space;
    }
    else if(10 == pwdVal.length || 26 == pwdVal.length) {
        if(!isHexString(pwdVal)) {
            errMsg = wlan_hint_64_or_128_bit_key;
        }
        else {
            ret = true;
        }
    }
    else if(5 == pwdVal.length || 13 == pwdVal.length) {
        if(!checkInputChar(pwdVal)) {
            errMsg = wlan_hint_wep_key_valid_type;
        }
        else {
            ret = true;
        }
    }
    else {
        errMsg = wlan_hint_64_or_128_bit_key;
    }

    if(!ret) {
        showErrorUnderTextbox(id, errMsg);
        $('#' + id).focus();
        $('#' + id).select();
    }
    return ret;
}

function checkWpaPwd(password, id) {
    var pwdVal = password;
    var errMsg = null;
    var ret = false;
    if(0 == pwdVal.length) {
        errMsg = dialup_hint_password_empty;
    }
    else if(hasSpaceOrTabAtHead(pwdVal)) {
        errMsg = input_cannot_begin_with_space;
    }
    else if(64 == pwdVal.length) {
        if(!isHexString(pwdVal)) {
            errMsg = wlan_hint_wps_psk_valid_type;
        }
        else {
            ret = true;
        }
    }
    else if(pwdVal.length >= 8 && pwdVal.length <= 63) {
        if(!checkInputChar(pwdVal)) {
            errMsg = wlan_hint_wps_psk_valid_char;
        }
        else {
            ret = true;
        }
    }
    else {
        errMsg = wlan_hint_wps_psk_valid_type;
    }

    if(!ret) {
        showErrorUnderTextbox(id, errMsg);
        $('#' + id).focus();
        $('#' + id).select();
    }

    return ret;
}

function showPasswrodDiag() {
    $('#div_wrapper').remove();
    $('.login_dialog').remove();

    var dialogHtml = '';
    var dialogInfo = '';

    if(g_isWrongPassWord) {
        dialogInfo = wifi_label_wrong_passwrod_notice;
    }
    else {
        dialogInfo = wifi_label_passwrod_notice;
    }

    if($('#div_wrapper').size() < 1) {
        dialogHtml += "<div id='div_wrapper'><iframe   id='ifream_dialog'  src= '' frameborder= '0' style= 'background:#bcbcbc; position:absolute; width:100%; height:100%; z-index:-1; display: block;'> </iframe></div>";
    }
    dialogHtml += "<div class='login_dialog' id='dialog'>";
    dialogHtml += "    <div class='login_dialog_top'></div>";
    dialogHtml += "    <div class='login_dialog_content'>";
    dialogHtml += "        <div class='login_dialog_header'>";
    dialogHtml += "            <span class='dialog_header_left'>" + wlan_lable_notice + '</span>';
    dialogHtml += "            <span class='dialog_header_right'><a class='dialog_close_btn' title='' href='javascript:void(0);'><img src='../res/dialog_close_btn.gif' title='' alt='' /></a></span>";
    dialogHtml += '        </div>';
    dialogHtml += "        <div class='password_dialog_table'>";
    dialogHtml += "               <div id='intput_password_wrapper'>";
    dialogHtml += '                  <p>' + dialogInfo + '</p>';
    dialogHtml += "                   <p><span><input type='password'  class='input' id='password_input' /></span></p>";
    dialogHtml += '               </div>';
    dialogHtml += '        </div>';
    dialogHtml += "        <div class='login_dialog_table_bottom'>";
    dialogHtml += "              <span class='button_wrapper pop_save' id='intput_save'>";
    dialogHtml += "                  <span class='button_left'>";
    dialogHtml += "                      <span class='button_right'>";
    dialogHtml += "                            <span class='button_center'><a href='javascript:void(0);' title=''>" + common_connect + '</a></span>';
    dialogHtml += '                      </span></span></span>';
    if(g_isWrongPassWord) {
        dialogHtml += "              <span class='button_wrapper' id='intput_cancel'>";
        dialogHtml += "                  <span class='button_left'>";
        dialogHtml += "                      <span class='button_right'>";
        dialogHtml += "                            <span class='button_center'><a href='javascript:void(0);' title=''>" + common_cancel + '</a></span>';
        dialogHtml += '                      </span></span></span>';
    }
    dialogHtml += '        </div>';
    dialogHtml += '    </div>';
    dialogHtml += "    <div class='login_dialog_bottom'></div>";
    dialogHtml += '</div>';

    $('.body_bg').before(dialogHtml);

    reputPosition($('#dialog'), $('#div_wrapper'));
    g_main_displayingPromptStack.push('intput_save');

    $('#password_input').focus();

    disableTabKey();
}