<html>
<head>
<title>ZTE Gateway - webGUI MF30</title>
<link rel="stylesheet" href="../style/normal_ws.css" type="text/css">
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<!--<script language="JavaScript" src="../js/prompt.js"></script>-->
<script language="JavaScript" src="../js/lang.js"></script>
<script language="JavaScript" src="../js/toptip.js"></script>
<script language="JavaScript" src="../js/overlib.js"></script>
<script language="JavaScript" src="../js/wlan.js"></script>
<script language="JavaScript" src="../js/protect.js"></script>
<script language="JavaScript" type="text/javascript">
Butterlate.setTextDomain("firewall");

var MAX_RULES = 10;
var rules_num = '<% getPortForwardRuleNumsASP(); %>' ;
var rules = '<% getPortForwardRulesASP(); %>';
var ruleArray = new Array();

function splitRulesToArray()
{
	ruleArray = rules.split(";");
}

function isRuleExist(rule)
{
	for (var i = 0; i < ruleArray.length; i++)
	{
		if (ruleArray[i] == "")
			continue;
			
		if (ruleArray[i] == rule)
		{
			return true;
		}
	}
	return false;
}

function getProtocolType(proto)
{
	var type;
	if ("TCP" == proto)
		type = "1";
	else if ("UDP" == proto)
		type = "2";
	else if ("TCP&UDP" == proto)
		type = "3";
		
	return type;
}

function isCharacterValid(value)
{
	var   reg   =   /[\u4E00-\u9FA5]|[\uFE30-\uFFA0]/gi;   
    if (reg.test(value))
	{
      //alert('Invalid character!');   
      return   false;   
    }   
    return   true;   
}

function deleteClick()
{
	//delRule0
	var isCheck = false;
	for (var i = 0; i < 10; i++)
	{
		//alert("delRule" + i + "  slected! [" + document.getElementById("delRule" + i) +"]");
		if (document.getElementById("delRule" + i) && document.getElementById("delRule" + i).checked)
		{
			//alert("delRule" + i + "  slected!");
			isCheck = true;
			break;
		}
	}

	if (!isCheck)
	{
		return false;
	}
	
    return true;
}

function checkRange(str, num, min, max)
{
    d = atoi(str,num);
    if(d > max || d < min)
        return false;
    return true;
}

function checkIpAddr(field)
{
	if(field.value == ""){
        //alert("Error. IP address is empty.");
        //field.value = field.defaultValue;
		ShowError(field, 'ip addr empty');
        //field.focus();
        return false;
    }
	
	var fields = field.value.split('.');
	if (fields.length != 4)
	{
		ShowError(field, 'IP format error');
        return false;
	}

    if ( isAllNum(field.value) == 0) {
       // alert('It should be a [0-9] number.');
        //field.value = field.defaultValue;
		ShowError(field, 'It should be under10');
        //field.focus();
        return false;
    }

    if( (!checkRange(field.value,1,1,223)) ||
        (!checkRange(field.value,2,0,255)) ||
        (!checkRange(field.value,3,0,255)) ||
        (!checkRange(field.value,4,1,254)) ){
        //alert('IP format error.');
        //field.value = field.defaultValue;
		ShowError(field, 'IP format error');
        //field.focus();
        return false;
    }

   return true;
}


function atoi(str, num)
{
	i=1;
	if(num != 1 ){
		while (i != num && str.length != 0){
			if(str.charAt(0) == '.'){
				i++;
			}
			str = str.substring(1);
		}
	  	if(i != num )
			return -1;
	}
	
	for(i=0; i<str.length; i++){
		if(str.charAt(i) == '.'){
			str = str.substring(0, i);
			break;
		}
	}
	if(str.length == 0)
		return -1;
    if(('0' == str.charAt(0)) && (1 != str.length))
	    return -1;
		
	return parseInt(str, 10);
}

function isAllNum(str)
{
	var LastChar='.';
	for (var i=0; i<str.length; i++)
	{
		if((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.' ))
		{
			if( ('.' == LastChar) && ('0' == str.charAt(i)) )
			{
				if( (i!=0) && (i < str.length-1)  )
				{
					if('.' == str.charAt(i+1))
					{
					}						
					else return 0;
				}
				else return 0;
			}
			LastChar = str.charAt(i);
			continue;
		}
		return 0;
	}
	return 1;
}

function formCheck()
{
	if(!document.portForward.portForwardEnabled.options.selectedIndex){
		// user choose disable
		return true;
	}else
	{
		if(document.getElementById("comment").value==""
		&&document.portForward.ip_address.value == ""
		&&document.portForward.fromPort.value == ""
		&&document.portForward.toPort.value == "" )
			return true;
	}
	
	if(rules_num >= (MAX_RULES) ){
		alert(Get_string("The rule number is exceeded")+" "+ MAX_RULES +".");
		return false;
	}

	if( document.getElementById("comment").value == "")
	{
		ShowError(document.portForward.comment, 'Please enter comment');
		return false;
	}
	
	/*
	if (!isCharacterValid(document.getElementById("comment").value))
	{
		ShowError(document.portForward.comment, 'comment invalid character');
		return false;
	}
	
	if (checkASC(document.portForward.comment.value, "comment") == false) 
	{
		ShowError(document.portForward.comment, "WIFI Basic Invalid Err");
		return false;
	}
	*/
	
	if ( checkinvalidkey(document.portForward.comment.value) == false )
	{
		ShowError(document.portForward.comment, "WIFI KEY Char Err");
		return false;
	}

	// exam IP address
    if(document.portForward.ip_address.value == ""){
        //alert("Not set a ip address.");
        //document.portForward.ip_address.focus();
		ShowError(document.portForward.ip_address, 'Not set IP addr');
        return false;
    }

    if(! checkIpAddr(document.portForward.ip_address) ){
        //alert("IP address format error.");
        //document.portForward.ip_address.focus();
		//ShowError(document.portForward.ip_address, 'IP format error');
        return false;
    }

    if(isAllNum(document.portForward.ip_address.value) == 0){
        //alert("Invalid ip address.");
        //document.portForward.ip_address.focus();
		ShowError(document.portForward.ip_address, 'ip not valid');
        return false;
    }

	// exam Port
	if(document.portForward.fromPort.value == ""){
		//alert("Not set a port range.");
		//document.portForward.fromPort.focus();
		ShowError(document.portForward.fromPort, 'Not set port range');
		return false;
	}
	
	if(document.portForward.toPort.value == ""){
		ShowError(document.portForward.toPort, 'Not set port range');
		return false;
	}

	if(isAllNum( document.portForward.fromPort.value ) == 0){
		//alert("Invalid port number.");
		//document.portForward.fromPort.focus();
		ShowError(document.portForward.fromPort, 'Invalid port number');
		return false;
	}

	d1 = atoi(document.portForward.fromPort.value, 1);
	if(d1 > 65535 || d1 < 1){
		//alert("Invalid port number!");
		//document.portForward.fromPort.focus();
		ShowError(document.portForward.fromPort, 'Invalid port number');
		return false;
	}
	
	if(document.portForward.toPort.value != ""){
		if(isAllNum( document.portForward.toPort.value ) == 0){
			//alert("Invalid port number.");
			//document.portForward.toPort.focus();
			ShowError(document.portForward.toPort, 'Invalid port number');
			return false;
		}
		d2 = atoi(document.portForward.toPort.value, 1);
		if(d2 > 65535 || d2 < 1){
			//alert("Invalid port number.");
			//document.portForward.toPort.focus();
			ShowError(document.portForward.toPort, 'Invalid port number');
			return false;
		}
		if(d1 > d2){	
			//alert("Invalid port range setting.");
			//document.portForward.fromPort.focus();
			ShowError(document.portForward.fromPort, 'Invalid port range');
			return false;
		}
   }
   
	// check whether the rule has existed
	var rule = document.portForward.ip_address.value + "," 
				+ document.portForward.fromPort.value + "," 
				+ document.portForward.toPort.value + ","
				+ getProtocolType(document.portForward.protocol.value) + ","
				+ document.portForward.comment.value;
	if (isRuleExist(rule))
	{
		ShowError(document.portForward.comment, 'Rule has existed');
		return false;
	}
   
   document.getElementById('forwardVirtualSrvApply').disabled = true;
   document.getElementById('forwardVirtualSrvApply').className = "disableBtn";
   return true;
}


function display_on()
{
  if(window.XMLHttpRequest){ // Mozilla, Firefox, Safari,...
    return "table-row";
  } else if(window.ActiveXObject){ // IE
    return "block";
  }
}

function disableTextField (field)
{
  if(document.all || document.getElementById)
    field.disabled = true;
  else {
    field.oldOnFocus = field.onfocus;
    field.onfocus = skip;
  }
}

function enableTextField (field)
{
  if(document.all || document.getElementById)
    field.disabled = false;
  else {
    field.onfocus = field.oldOnFocus;
  }
}

function initTranslation()
{

	var e = document.getElementById("forwardTitle");
	e.innerHTML = Get_string("forward title");
	//tab-page
	e = document.getElementById("firewallTitlePortFilter");
	e.innerHTML = Get_string("firewall Title PortFilter");
	e = document.getElementById("firewallTitlePortForward");
	e.innerHTML = Get_string("firewall Title PortForward");
	e = document.getElementById("firewallTitleSys");
	e.innerHTML = Get_string("firewall Title Sys");
	
	e = document.getElementById("forwardVirtualSrv");
	e.innerHTML = Get_string("forward virtual servers");
	e = document.getElementById("forwardVirtualSrvSet");
	e.innerHTML = Get_string("forward virtual server setting");
	e = document.getElementById("forwardVirtualSrvDisable");
	e.innerHTML = Get_string("firewall disable");
	e = document.getElementById("forwardVirtualSrvEnable");
	e.innerHTML = Get_string("firewall enable");
	e = document.getElementById("forwardVirtualSrvIPAddr");
	e.innerHTML = Get_string("forward virtual server ipaddr");
	e = document.getElementById("forwardVirtualSrvPortRange");
	e.innerHTML = Get_string("forward virtual server port range");
	e = document.getElementById("forwardVirtualSrvProtocol");
	e.innerHTML = Get_string("firewall protocol");
	e = document.getElementById("forwardVirtualSrvComment");
	e.innerHTML = Get_string("firewall comment");
	e = document.getElementById("forwardVirtualSrvApply");
	e.value = Get_string("firewall apply");

	e = document.getElementById("forwardCurrentVirtualSrv");
	e.innerHTML = Get_string("forward current virtual server");
	e = document.getElementById("forwardCurrentVirtualSrvNo");
	e.innerHTML = Get_string("firewall no");
	e = document.getElementById("forwardCurrentVirtualSrvIP");
	e.innerHTML = Get_string("forward virtual server ipaddr");
	e = document.getElementById("forwardCurrentVirtualSrvPort");
	e.innerHTML = Get_string("forward virtual server port range");
	e = document.getElementById("forwardCurrentVirtualSrvProtocol");
	e.innerHTML = Get_string("firewall protocol");
	e = document.getElementById("forwardCurrentVirtualSrvComment");
	e.innerHTML = Get_string("firewall comment");
	e = document.getElementById("forwardCurrentVirtualSrvDel");
	e.value = Get_string("firewall del select");
	e = document.getElementById("forwardCurrentVirtualSrvReset");
	e.value = Get_string("firewall reset");
	e = document.getElementById("port_forward_IP");
	e.innerHTML = Get_string("example IP");
	e = document.getElementById("maximum_desc");
	e.innerHTML = Get_string("maximum desc");
}

function updateState()
{
	initTranslation();
    if(! rules_num ){
 		disableTextField(document.portForwardDelete.deleteSelPortForward);
 		disableTextField(document.portForwardDelete.reset);
	}else{
        enableTextField(document.portForwardDelete.deleteSelPortForward);
        enableTextField(document.portForwardDelete.reset);
	}

	if(document.portForward.portForwardEnabled.options.selectedIndex == 1){
		enableTextField(document.portForward.ip_address);
		enableTextField(document.portForward.fromPort);
		enableTextField(document.portForward.toPort);
		enableTextField(document.portForward.protocol);
		enableTextField(document.portForward.comment);
		document.getElementById("tmp1").style.display="";
		document.getElementById("tmp2").style.display="";
		document.portForwardDelete.style.display="";
		
	}else{
		disableTextField(document.portForward.ip_address);
		disableTextField(document.portForward.fromPort);
		disableTextField(document.portForward.toPort);
		disableTextField(document.portForward.protocol);
		disableTextField(document.portForward.comment);
		document.getElementById("tmp1").style.display="none";
		document.getElementById("tmp2").style.display="none";
		document.portForwardDelete.style.display="none";
	}
}

</script>
</head>


<body style="overflow-x:hidden" onLoad="updateState();splitRulesToArray()">
<form method=post name="portForward" action=/goform/portForward onSubmit="return formCheck()">
		<table cellspacing="0" cellpadding="10" width="100%" border="0" bgcolor="#FFFFFF" height="100%">
		<tr>
			<td valign="top">
		<table cellspacing=0 cellpadding=0 width=100% border=0>  
            <tr>                                                                    
                <td id="forwardTitle" name="forwardTitle" class=listtopic colspan=2>Firewall--&gt;Port Forwarding</td>
            </tr>
			
			<tr>                                                                    
                <td colspan=2>&nbsp;</td>
            </tr>			      
			<tr>                                                                    
                <td colspan=2>&nbsp;</td>
            </tr>                                                          
        </table>
		                                                                  
		<table cellspacing="0" cellpadding="0" width="100%" border="0">
	 	<TD  align="center" width="150px" height="20" bgcolor="#CCCCCC"><A href="port_filtering.asp"><font color="#000000" face="Arial"><strong><span name="firewallTitlePortFilter" id="firewallTitlePortFilter">&#8226; Mac/Ip/Port Filtering<span></strong>&nbsp;</font></A></TD>
		<!--<TD align="center" width=120 height="20" bgcolor="#CCCCCC"><A href="content_filtering.asp"><font color="#000000" face="Arial"><strong><span name="firewallTitleURLFilter" id="firewallTitleURLFilter" >&#8226;URL Filtering</span></strong></font></A></TD>-->   
    <TD align="center" width="150px" height="20" bgcolor="#8B1618"><font color="#FFFFFF" face="Arial"><strong><span name="firewallTitlePortForward" id="firewallTitlePortForward" >&#8226;Port Forwarding</span></strong></font></TD>
		<!--<TD  align="center" width=70 height="20" bgcolor="#CCCCCC"><A href="DMZ.asp"><font color="#000000" face="Arial"><strong><span name="firewallTitleDMZ" id="firewallTitleDMZ">&#8226;DMZ</span></strong></font></A></TD>--> 
		<TD  align="center" width="150px" height="20" bgcolor="#CCCCCC"><A href="system_firewall.asp"><font color="#000000" face="Arial"><strong><span name="firewallTitleSys" id="firewallTitleSys">&#8226;System Security</span></strong></font></A></TD>
		         
       <TD width=500></TD>
	</table>
	
	    <br>
	
<table width="100%" border="0" cellspacing="0" cellpadding="0">

<tr>
  <td class="title" colspan="2" id="forwardVirtualSrv" onMouseOver="PORT_FORWAR_toptip();" onMouseOut="return nd();">Virtual Server Settings</td>
</tr>
<tr>
	<td class="head_top" id="forwardVirtualSrvSet"  width="40%">Virtual Server Settings</td>
	<td class="tail_top" width="60%">
	<select onChange="updateState()" name="portForwardEnabled" style="width:100px">
	<option id="forwardVirtualSrvDisable" value=0 <% getPortForwardEnableASP(0); %> >Disable</option>
    <option id="forwardVirtualSrvEnable" value=1 <% getPortForwardEnableASP(1); %> >Enable</option>
    </select>
    </td>
</tr>
</table>

<table width="100%" border="0" cellspacing="0" cellpadding="10" name="tmp1" id ="tmp1">
<tr>
	<td class="head" id="forwardVirtualSrvIPAddr" width="40%">
		IP Address
	</td>
	<td class="tail" >
  		<input type="text" size="16" name="ip_address"><span id="port_forward_IP">&nbsp;( XXX.XXX.XXX.XXX, eg: 192.168.5.101)</span>
	</td>
</tr>

<tr>
	<td class="head" id="forwardVirtualSrvPortRange">
		Port Range
	</td>
	<td class="tail">
  		<input type="text" size="5" name="fromPort">-<input type="text" size="5" name="toPort"> &nbsp;&nbsp;&nbsp;( 1~65535)
	</td>
</tr>

<tr>
	<td class="head" id="forwardVirtualSrvProtocol">
		Protocol
	</td>
	<td class="tail">
		<select name="protocol">
   		<option select value="TCP&UDP">TCP+UDP</option>
		<option value="TCP">TCP</option>
   		<option value="UDP">UDP</option>
   		</select>&nbsp;&nbsp;
	</td>
</tr>

<tr>
	<td class="head" id="forwardVirtualSrvComment">
		Comment
	</td>
	<td class="tail">
		<input type="text" name="comment" id= "comment" size="16" maxlength="32">
	</td>
</tr>
</table> 

<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%" name="tmp2" id ="tmp2"> 
	<tr>
	  <td id="maximum_desc" colspan="2">The maximum rule count is 10 .</td>
	</tr>
</table> 

<br>
<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr align="right">
    <td>
	<input class="btn" type="submit" value="Apply" id="forwardVirtualSrvApply" name="forwardVirtualSrvApply"> &nbsp;&nbsp;
    </td>
  </tr>
</table>

</form>

<br>

<!--  delete rules -->
<form action=/goform/portForwardDelete method=POST name="portForwardDelete" id="portForwardDelete">

<table cellSpacing=0 cellPadding=10 width="100%" border=0>
	<tr>
		<td class="title" colspan="5" id="forwardCurrentVirtualSrv">Current Virtual Servers in system: </td>
	</tr>

	<tr>
		<td id="forwardCurrentVirtualSrvNo" class="head1_top"> No.</td>
		<td align=center id="forwardCurrentVirtualSrvIP" class="head2_top"> IP Address</td>
		<td align=center id="forwardCurrentVirtualSrvPort" class="head2_top"> Port Range</td>
		<td align=center id="forwardCurrentVirtualSrvProtocol" class="head2_top"> Protocol</td>
		<td align=center id="forwardCurrentVirtualSrvComment" class="head2_top"> Comment</td>
	</tr>

	<% showPortForwardRulesASP(); %>
</table>
<br>
<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr align="right">
    <td>
<input class="btn" type="submit" value="Delete" id="forwardCurrentVirtualSrvDel" name="deleteSelPortForward" onClick="return deleteClick()">&nbsp;&nbsp;
<input class="btn" type="reset" value="Reset" id="forwardCurrentVirtualSrvReset" name="reset">    </td>
  </tr>
</table>


</form>


</body>
</html>
