<html>
<head>
<title>ZTE Gateway - webGUI MF30</title>
<link rel="stylesheet" href="../style/normal_ws.css" type="text/css">
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<!--<script language="JavaScript" src="../js/prompt.js"></script>-->
<script language="JavaScript" src="../js/overlib.js"></script>
<script language="JavaScript" src="../js/toptip.js"></script>
<script language="JavaScript" src="../js/lang.js"></script>
<script language="JavaScript" src="../js/wlan.js"></script>
<script language="JavaScript" src="../js/protect.js"></script>
<script language="JavaScript" type="text/javascript">
Butterlate.setTextDomain("firewall");


var MAX_RULES = 10;

var secs;
var timerID = null;
var timerRunning = false;
var timeout = 3;
var delay = 1000;

var rules_num = '<% getIPPortRuleNumsASP(); %>';
var rules = '<% getIPPortRulesASP(); %>';
var ruleArray = new Array();

function splitRulesToArray()
{
	ruleArray = rules.split(";");
}

function isRuleExist(rule)
{
	for (var i = 0; i < ruleArray.length; i++)
	{
		if (ruleArray[i] == "")
			continue;

		if (ruleArray[i] == rule)
		{
			return true;
		}
	}
	return false;
}

function getProtocolType(proto)
{
	var type;
	if ("TCP" == proto)
		type = "1";
	else if ("UDP" == proto)
		type = "2";
	else if ("TCP&UDP" ==proto)
		type = "3";
	else if ("None" == proto)
		type = "5";
	else if ("ICMP" == proto)
		type = "4";
		
	return type;
}

function getActionType(action)
{
	var type;
	if ("Accept" == action)
		type = "1";
	else if ("Drop" == action)
		type = "0";
		
	return type;
}

function getIpAddress(ip)
{
	if (ip == "")
		return "any/0";
	else
		return ip;
}

function getPort(port)
{
	if (port == "")
		return "0";
	else
		return port;
}

function isCharacterValid(value)
{
	var   reg   =   /[\u4E00-\u9FA5]|[\uFE30-\uFFA0]/gi;   
    if (reg.test(value))
	{
      //alert('Invalid character!');   
      return   false;   
    }   
    return   true;   
}

function InitializeTimer(){
	// Set the length of the timer, in seconds
	secs = timeout
	StopTheClock()
	StartTheTimer()
}

function StopTheClock(){
	if(timerRunning)
		clearTimeout(timerID)
	timerRunning = false
}

function StartTheTimer(){
	if (secs==0){
		StopTheClock()

		timerHandler();

		secs = timeout
		StartTheTimer()
    }else{
		self.status = secs
		secs = secs - 1
		timerRunning = true
		timerID = self.setTimeout("StartTheTimer()", delay)
	}
}

var http_request = false;
function makeRequest(url, content) {
    http_request = false;
    if (window.XMLHttpRequest) { // Mozilla, Safari,...
        http_request = new XMLHttpRequest();
        if (http_request.overrideMimeType) {
            http_request.overrideMimeType('text/xml');
        }
    } else if (window.ActiveXObject) { // IE
        try {
            http_request = new ActiveXObject("Msxml2.XMLHTTP");
        } catch (e) {
            try {
            http_request = new ActiveXObject("Microsoft.XMLHTTP");
            } catch (e) {}
        }
    }
    if (!http_request) {
        alert('Giving up :( Cannot create an XMLHTTP instance');
        return false;
    }
    http_request.onreadystatechange = alertContents;
    http_request.open('POST', url, true);
    http_request.send(content);
}

function alertContents() {
	if (http_request.readyState == 4) {
		if (http_request.status == 200) {
			updatePacketCount( http_request.responseText);
		} else {
			//alert('There was a problem with the request.');
		}
	}
}

function updatePacketCount(str){
	var pc = new Array();
	pc = str.split(" ");
	for(i=0; i < pc.length; i++){
		e = document.getElementById("pktCnt" + i);
		e.innerHTML = pc[i];
	}
}

function timerHandler(){
	//makeRequest("/goform/getRulesPacketCount", "n/a");
}

function deleteClick()
{
	//delRule0
	var isCheck = false;
	for (var i = 0; i < 10; i++)
	{
		//alert("delRule" + i + "  slected! [" + document.getElementById("delRule" + i) +"]");
		if (document.getElementById("delRule" + i) && document.getElementById("delRule" + i).checked)
		{
			//alert("delRule" + i + "  slected!");
			isCheck = true;
			break;
		}
	}

	if (!isCheck)
	{
		return false;
	}
	
    return true;
}

function checkRange(str, num, min, max)
{
    d = atoi(str,num);
    if(d > max || d < min)
        return false;
    return true;
}

function checkIpAddr(field)
{
	if(field.value == "")
		return false;

	if (isAllNumAndSlash(field.value) == 0){
		return false;
	}
	
	var fields = field.value.split('.');
	if (fields.length != 4)
	{
        return false;
	}

	var ip_pair = new Array();
	ip_pair = field.value.split("/");

	if(ip_pair.length > 2){
		return false;
	}

	if(ip_pair.length == 2){
		// sub mask
		if(!ip_pair[1].length)
			return false;
		if(!isNumOnly(ip_pair[1])){
			return false;
		}
		tmp = parseInt(ip_pair[1], 10);
		if(tmp < 0 || tmp > 32){
			return false;
		}
	}

    if( (!checkRange(ip_pair[0],1,1,223)) ||
		(!checkRange(ip_pair[0],2,0,255)) ||
		(!checkRange(ip_pair[0],3,0,255)) ||
		(!checkRange(ip_pair[0],4,1,254)) ){
		return false;
    }
	return true;
}

function atoi(str, num)
{
	i=1;
	if(num != 1 ){
		while (i != num && str.length != 0){
			if(str.charAt(0) == '.'){
				i++;
			}
			str = str.substring(1);
		}
	  	if(i != num )
			return -1;
	}
	
	for(i=0; i<str.length; i++){
		if(str.charAt(i) == '.'){
			str = str.substring(0, i);
			break;
		}
	}
	if(str.length == 0)
		return -1;
	if(('0' == str.charAt(0)) && (1 != str.length))
	    return -1;
		
	return parseInt(str, 10);
}

function isAllNum(str)
{
	var LastChar='.';
	for (var i=0; i<str.length; i++)
	{
		if((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.' ))
		{
			if( ('.' == LastChar) && ('0' == str.charAt(i)) )
			{
				if( (i!=0) && (i < str.length-1)  )
				{
					if('.' == str.charAt(i+1))
					{
					}						
					else return 0;
				}
				else return 0;
			}
			LastChar = str.charAt(i);
			continue;
		}
		return 0;
	}
	return 1;
}

function isAllNumAndSlash(str)
{
	for (var i=0; i<str.length; i++){
	    if( (str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.') || (str.charAt(i) == '/'))
			continue;
		return 0;
	}
	return 1;
}



function isNumOnly(str)
{
	for (var i=0; i<str.length; i++){
	    if((str.charAt(i) >= '0' && str.charAt(i) <= '9') )
			continue;
		return 0;
	}
	return 1;
}

function formCheck()
{
	document.getElementById('portBasicApply').disabled = true;
	document.getElementById('portBasicApply').className = "disableBtn";
	return true;
}


function zte_validateMac(val,which){
   var i;
   var sval=String(val);
	
	if (sval.length == 0)
	{
		//alert("MAC address can\'t be null!");	
		//ShowError(document.getElementById(which),"MAC address can\'t be null!" );
		return false;
	}

   if (sval.length>0 && sval.length!=17)
   {  
	   //alert('Invalid Length!');
	   //ShowError(document.getElementById(which),"Invalid Length!" );
      return false;
   }

   for (i=0; i<sval.length; i++)
   {  if ((i % 3)==2)
      {  if (sval.charAt(i)!=':')
         {  //alert('Invalid Format at position '+(i+1)+'! Must be xx:xx:xx:xx:xx:xx.');
			 //ShowError(document.getElementById(which),'Invalid Format at position '+(i+1)+'! Must be xx:xx:xx:xx:xx:xx.');
            return false;
         }
      }
      else if (!((sval.charAt(i)>='0' && sval.charAt(i)<='9') ||
                (sval.charAt(i)>='A' && sval.charAt(i)<='F')  ||
                (sval.charAt(i)>='a' && sval.charAt(i)<='f')))
      {  
         //alert('Invalid Character['+sval.charAt(i)+'] at Position '+(i+1)+'! Must be 0123456789ABCDEFabcdef.');
		 //ShowError(document.getElementById(which),'Invalid Character! It Must be 0123456789ABCDEFabcdef.' );
         return false;
      }
   }
   var sub1=val.substring(0,2);
   var sub2=val.substring(3,5);
   var sub3=val.substring(6,8);
   var sub4=val.substring(9,11);
   var sub5=val.substring(12,14);
   var sub6=val.substring(15);

   if (sub1=='ff' && sub2=='ff' && sub3=='ff' && sub4=='ff' && sub5=='ff' && sub6=='ff')
   {
	//alert('Invalid MAC address, it is a broadcast address.');
	//ShowError(document.getElementById(which),'Invalid MAC address, it is a broadcast address.' );
	return false;
   }
   if (sub1=='00' && sub2=='00' && sub3=='00' && sub4=='00' && sub5=='00' && sub6=='00')
   {
	//alert('Invalid MAC address, it is a null address.');
	//ShowError(document.getElementById(which),'Invalid MAC address, it is a null address.' );
	return false;
   }
   sub1='0x'+sub1;
   if((sub1 & 1)==1)
   {
	//alert('Invalid MAC address, it is a mutlicast address.');
	//ShowError(document.getElementById(which),'Invalid MAC address, it is a mutlicast address.');
	return false;
   }
   return true;
}

function ipportFormCheck()
{
	if( document.BasicSettings.portFilterEnabled.options.selectedIndex == 0)
	{
		return true;
	}

	if(rules_num >= (MAX_RULES) ){
		alert(Get_string("The rule number is exceeded")+" "+ MAX_RULES +".");
		return false;
	}

	if( document.getElementById("sip_address").value == "" && 
		document.getElementById("dip_address").value == "" &&
		document.getElementById("sFromPort").value == "" &&
		document.getElementById("dFromPort").value == "" &&
		document.getElementById("mac_address").value == ""){
		//alert("Please input any IP or/and port value.");
		ShowError(document.ipportFilter.mac_address, 'Please enter IP MAC');
		return false;
	}
	
	if( document.getElementById("comment").value == "")
	{
		ShowError(document.ipportFilter.comment, 'Please enter comment');
		return false;
	}
	
	/*
	if (!isCharacterValid(document.ipportFilter.comment.value))
	{
		ShowError(document.ipportFilter.comment, 'comment invalid character');
		return false;
	}
	
	if (checkASC(document.ipportFilter.comment.value, "comment") == false) 
	{
		ShowError(document.ipportFilter.comment, "WIFI Basic Invalid Err");
		return false;
	}
	*/
	
	if ( checkinvalidkey(document.ipportFilter.comment.value) == false )
	{
		ShowError(document.ipportFilter.comment, "WIFI KEY Char Err");
		return false;
	}

	if (zte_validateMac(document.ipportFilter.mac_address.value,document.ipportFilter.mac_address) == false
	&& document.ipportFilter.mac_address.value != "")
		{
			   // document.filter_form.elements[i].focus();
			   ShowError(document.ipportFilter.mac_address,"Invalid MAC addr");
				return false;
		}
		
	document.ipportFilter.mac_address.value = document.ipportFilter.mac_address.value.toUpperCase();
		
	// check ip address format
	if(document.ipportFilter.sip_address.value != ""){
		if(! checkIpAddr(document.ipportFilter.sip_address) ){
			ShowError(document.ipportFilter.sip_address, 'IP format error');
			return false;
		}
    }
	
	if(document.ipportFilter.dip_address.value != ""){
		if(! checkIpAddr(document.ipportFilter.dip_address) ){
			ShowError(document.ipportFilter.dip_address, 'IP format error');
			return false;
		}
    }
		
	// check the port
	var protocol = document.ipportFilter.protocol.value;
	if ("TCP" == protocol || "UDP" == protocol)
	{
		
		if (document.ipportFilter.dFromPort.value == "")
		{
			ShowError(document.ipportFilter.dFromPort, 'Not set port range');
			return false;
		}
		if (document.ipportFilter.dToPort.value == "")
		{
			ShowError(document.ipportFilter.dToPort, 'Not set port range');
			return false;
		}
		
		if (document.ipportFilter.sFromPort.value == "")
		{
			ShowError(document.ipportFilter.sFromPort, 'Not set port range');
			return false;
		}
		if (document.ipportFilter.sToPort.value == "")
		{
			ShowError(document.ipportFilter.sToPort, 'Not set port range');
			return false;
		}
	}
					
	if(document.ipportFilter.sFromPort.value != ""){
		d1 = atoi(document.ipportFilter.sFromPort.value, 1);
		if(isAllNum( document.ipportFilter.sFromPort.value ) == 0){
			//alert("Invalid port number: source port.");
			ShowError(document.ipportFilter.sFromPort, 'Invalid source port');
			//document.ipportFilter.sFromPort.focus();
			return false;
		}
		if(d1 > 65535 || d1 < 1){
			//alert("Invalid port number: source port.");
			ShowError(document.ipportFilter.sFromPort, 'Invalid source port');
			//document.ipportFilter.sFromPort.focus();
			return false;
		}
		
		if(document.ipportFilter.sToPort.value == "")
		{
			ShowError(document.ipportFilter.sToPort, 'Not set port range');
			return false;
		}
		
		if(document.ipportFilter.sToPort.value != ""){
			if(isAllNum( document.ipportFilter.sToPort.value ) == 0){
				//alert("Invalid port number: source port.");
				ShowError(document.ipportFilter.sToPort, 'Invalid source port');
				return false;
			}		
			d2 = atoi(document.ipportFilter.sToPort.value, 1);
			if(d2 > 65535 || d2 < 1){
				//alert("Invalid source port number.");
				ShowError(document.ipportFilter.sToPort, 'Invalid source port');
				return false;
			}
			if(d1 > d2){
			//alert("Invalid source port range setting.");
			ShowError(document.ipportFilter.sToPort, 'Invalid source port range');
			return false;
			}
		}
	}

	if(document.ipportFilter.dFromPort.value != ""){
		d1 = atoi(document.ipportFilter.dFromPort.value, 1);
		if(isAllNum( document.ipportFilter.dFromPort.value ) == 0){
			//alert("Invalid port number: dest port.");
			ShowError(document.ipportFilter.dFromPort, 'Invalid dest port');
			return false;
		}
		if(d1 > 65535 || d1 < 1){
			//alert("Invalid port number: dest port.");
			ShowError(document.ipportFilter.dFromPort, 'Invalid dest port');
			return false;
		}
		
		if(document.ipportFilter.dToPort.value == "")
		{
			ShowError(document.ipportFilter.dToPort, 'Not set port range');
			return false;
		}
		
		if(document.ipportFilter.dToPort.value != ""){
			if(isAllNum( document.ipportFilter.dToPort.value ) == 0){
				//alert("Invalid port number: dest port.");
				ShowError(document.ipportFilter.dToPort, 'Invalid dest port');
				return false;
			}		
			d2 = atoi(document.ipportFilter.dToPort.value, 1);
			if(d2 > 65535 || d2 < 1){
				//alert("Invalid dest port number.");
				ShowError(document.ipportFilter.dToPort, 'Invalid dest port');
				return false;
			}
			if(d1 > d2){
			//alert("Invalid dest port range setting.");
			ShowError(document.ipportFilter.dToPort, 'Invalid dest port range');
			return false;
			}
		}
	}
	
	// check whether the rule has existed
	var rule = getIpAddress(document.ipportFilter.sip_address.value) + ",0," 
				+ getPort(document.ipportFilter.sFromPort.value) + "," 
				+ getPort(document.ipportFilter.sToPort.value) + ","
				+ getIpAddress(document.ipportFilter.dip_address.value) + ",0,"
				+ getPort(document.ipportFilter.dFromPort.value) + "," 
				+ getPort(document.ipportFilter.dToPort.value) + ","
				+ getProtocolType(document.ipportFilter.protocol.value) + ","
				+ getActionType(document.ipportFilter.action.value) + ","
				+ document.ipportFilter.comment.value + ","
				+ document.ipportFilter.mac_address.value;
	if (isRuleExist(rule))
	{
		ShowError(document.ipportFilter.comment, 'Rule has existed');
		return false;
	}
	
	document.getElementById('portFilterApply').disabled = true;
	document.getElementById('portFilterApply').className = "disableBtn";
	return true;
}


function display_on()
{
  if(window.XMLHttpRequest){ // Mozilla, Firefox, Safari,...
    return "table-row";
  } else if(window.ActiveXObject){ // IE
    return "block";
  }
}

function disableTextField (field)
{
  if(document.all || document.getElementById)
    field.disabled = true;
  else {
    field.oldOnFocus = field.onfocus;
    field.onfocus = skip;
  }
}

function enableTextField (field)
{
  if(document.all || document.getElementById)
    field.disabled = false;
  else {
    field.onfocus = field.oldOnFocus;
  }
}

function initTranslation()
{

	var e = document.getElementById("portTitle"); 
	e.innerHTML = Get_string("port title");
	
	//tab-page
	e = document.getElementById("firewallTitlePortFilter");
	e.innerHTML = Get_string("firewall Title PortFilter");
	e = document.getElementById("firewallTitlePortForward");
	e.innerHTML = Get_string("firewall Title PortForward");
	e = document.getElementById("firewallTitleSys");
	e.innerHTML = Get_string("firewall Title Sys");
	

	e = document.getElementById("portBasicSet");
	e.innerHTML = Get_string("port basic settings");
	e = document.getElementById("portBasicFilter");
	e.innerHTML = Get_string("port basic filter");
	e = document.getElementById("portBasicDisable");
	e.innerHTML = Get_string("firewall disable");
	e = document.getElementById("portBasicEnable");
	e.innerHTML = Get_string("firewall enable");
	e = document.getElementById("portBasicDefaultPolicy");
	e.innerHTML = Get_string("port basic default policy");
	
	e = document.getElementById("portBasicDefaultPolicyAccept");
	e.innerHTML = Get_string("port basic default policy accepted");
	e = document.getElementById("portBasicDefaultPolicyDrop");
	e.innerHTML = Get_string("port basic default policy dropped");
	e = document.getElementById("portBasicApply");
	e.value = Get_string("firewall apply");

	e = document.getElementById("portFilterSet");
	e.innerHTML = Get_string("port filter setting");
	e = document.getElementById("portFilterMac");
	e.innerHTML = Get_string("port filter macaddr");
	e = document.getElementById("portFilterSIPAddr");
	e.innerHTML = Get_string("port filter source ipaddr");
	e = document.getElementById("portFilterSPortRange");
	e.innerHTML = Get_string("port filter source port range");
	e = document.getElementById("portFilterDIPAddr");
	e.innerHTML = Get_string("port filter dest ipaddr");
	e = document.getElementById("portFilterDPortRange");
	e.innerHTML = Get_string("port filter dest port range");
	e = document.getElementById("portFilterProtocol");
	e.innerHTML = Get_string("firewall protocol");
	e = document.getElementById("portFilterAction");
	e.innerHTML = Get_string("port filter action");
	e = document.getElementById("portFilterActionDrop");
	e.innerHTML = Get_string("port filter action drop");
	e = document.getElementById("portFilterActionAccept");
	e.innerHTML = Get_string("port filter action accept");
	e = document.getElementById("portFilterComment");
	e.innerHTML = Get_string("firewall comment");
	e = document.getElementById("portFilterApply");
	e.value = Get_string("firewall apply");
	e = document.getElementById("portFilterReset");
	e.value = Get_string("firewall reset");

	e = document.getElementById("portCurrentFilter");
	e.innerHTML = Get_string("port current filter");
	e = document.getElementById("portCurrentFilterNo");
	e.innerHTML = Get_string("firewall no");
	e = document.getElementById("portCurrentFilterSIP");
	e.innerHTML = Get_string("port filter source ipaddr");
	e = document.getElementById("portCurrentFilterSPort");
	e.innerHTML = Get_string("port filter source port range");
	e = document.getElementById("portCurrentFilterDIP");
	e.innerHTML = Get_string("port filter dest ipaddr");
	e = document.getElementById("portCurrentFilterMac");
	e.innerHTML = Get_string("port filter macaddr");
	e = document.getElementById("portCurrentFilterDPort");
	e.innerHTML = Get_string("port filter dest port range");
	e = document.getElementById("portCurrentFilterProtocol");
	e.innerHTML = Get_string("firewall protocol");
	e = document.getElementById("portCurrentFilterAction");
	e.innerHTML = Get_string("port filter action");
	e = document.getElementById("portCurrentFilterComment");
	e.innerHTML = Get_string("firewall comment");
	e = document.getElementById("portCurrentFilterDel");
	e.value = Get_string("firewall del select");
	e = document.getElementById("portCurrentFilterReset");
	e.value = Get_string("firewall reset");

	e = document.getElementById("example_MAC");
	e.innerHTML = Get_string("example MAC");
	e = document.getElementById("example_IP");
	e.innerHTML = Get_string("example IP");
	e = document.getElementById("maximum_desc");
	e.innerHTML = Get_string("maximum desc");


	if(document.getElementById("portCurrentFilterDefaultDrop")){
		e = document.getElementById("portCurrentFilterDefaultDrop");
		e.innerHTML = Get_string("firewall default drop");
	}
	if(document.getElementById("portCurrentFilterDefaultAccept")){
		e = document.getElementById("portCurrentFilterDefaultAccept");
		e.innerHTML = Get_string("firewall default accept");
	}



	var i=0;
	while( document.getElementById("portFilterActionDrop"+i) ||
			document.getElementById("portFilterActionAccept"+i) ){
		if(document.getElementById("portFilterActionDrop"+i)){
			e = document.getElementById("portFilterActionDrop"+i);
			e.innerHTML = Get_string("port filter action drop");
		}

		if(document.getElementById("portFilterActionAccept"+i)){
			e = document.getElementById("portFilterActionAccept"+i);
			e.innerHTML = Get_string("port filter action accept");
		}

		i++;
	}
}


function defaultPolicyChanged()
{
	/*
	if( document.BasicSettings.defaultFirewallPolicy.options.selectedIndex == 0){
		document.ipportFilter.action.options.selectedIndex = 0;
	}else
		document.ipportFilter.action.options.selectedIndex = 1;
	*/
		
	if( document.BasicSettings.defaultFirewallPolicy.options.selectedIndex == 0)
	{
		
		document.ipportFilter.action.options.selectedIndex = 0;
		document.getElementById("portFilterActionDrop").value = "Drop";
		document.getElementById("portFilterActionDrop").innerHTML = Get_string("port filter action drop");
		document.getElementById("portFilterActionAccept").value = "Accept";
		document.getElementById("portFilterActionAccept").innerHTML = Get_string("port filter action accept");
	}
	else
	{
		//document.ipportFilter.action.options.selectedIndex = 1;
		document.ipportFilter.action.options.selectedIndex = 0;
		document.getElementById("portFilterActionDrop").value = "Accept";
		document.getElementById("portFilterActionDrop").innerHTML = Get_string("port filter action accept");
		document.getElementById("portFilterActionAccept").value = "Drop";
		document.getElementById("portFilterActionAccept").innerHTML = Get_string("port filter action drop");
	}
}
	
function updateState()
{
	initTranslation();
    if(! rules_num ){
 		disableTextField(document.ipportFilterDelete.deleteSelFilterPort);
 		disableTextField(document.ipportFilterDelete.reset);
	}else{
        enableTextField(document.ipportFilterDelete.deleteSelFilterPort);
        enableTextField(document.ipportFilterDelete.reset);
	}
	

	if( document.BasicSettings.defaultFirewallPolicy.options.selectedIndex == 0){
		document.ipportFilter.action.options.selectedIndex = 0;
	}else
	{
		document.ipportFilter.action.options.selectedIndex = 1;
		}

	protocolChange();

		//change by maxl
		if( document.BasicSettings.portFilterEnabled.options.selectedIndex == 1)
		{
			document.ipportFilter.style.display="";
			document.ipportFilterDelete.style.display="";
			//document.BasicSettings.defaultFirewallPolicy.disabled= false;
			document.getElementById("tmp1").style.display="";
			
			//InitializeTimer();	// update packet count
		}
		else
		{
			document.ipportFilter.style.display="none";
			document.ipportFilterDelete.style.display="none";
			//document.BasicSettings.defaultFirewallPolicy.disabled= true;
			document.getElementById("tmp1").style.display="none";
			
		}
}

function actionChanged()
{
	if( document.BasicSettings.defaultFirewallPolicy.options.selectedIndex != 
		document.ipportFilter.action.options.selectedIndex)
		{
			//alert(Get_string("rule same with default") + " ");
		}
}

function protocolChange()
{
	if( document.ipportFilter.protocol.options.selectedIndex == 1 
	   || document.ipportFilter.protocol.options.selectedIndex == 2
	   || document.ipportFilter.protocol.options.selectedIndex == 3){
		document.ipportFilter.dFromPort.disabled = false;
		document.ipportFilter.dFromPort.value = 1;
		document.ipportFilter.dToPort.disabled = false;
		document.ipportFilter.dToPort.value = 65535;
		document.ipportFilter.sFromPort.disabled = false;
		document.ipportFilter.sFromPort.value = 1;
		document.ipportFilter.sToPort.disabled = false;
		document.ipportFilter.sToPort.value = 65535;
	}else{
		document.ipportFilter.dFromPort.disabled = true;
		document.ipportFilter.dToPort.disabled = true;
		document.ipportFilter.sFromPort.disabled = true;
		document.ipportFilter.sToPort.disabled = true;

		document.ipportFilter.dFromPort.value = "";
			document.ipportFilter.dToPort.value = "";
			document.ipportFilter.sFromPort.value = "";
			document.ipportFilter.sToPort.value = "";
	}
}

function resetItems()
{
	document.ipportFilter.dFromPort.disabled = true;
	document.ipportFilter.dToPort.disabled = true;
	document.ipportFilter.sFromPort.disabled = true;
	document.ipportFilter.sToPort.disabled = true;
	defaultPolicyChanged();
}

</script>
</head>

                         <!--     body      -->
<body style="overflow-x:hidden" onLoad="updateState();splitRulesToArray()">
<!-- ====================   BASIC  form  ==================== -->
<form method=post name="BasicSettings" action=/goform/BasicSettings onSubmit="return formCheck()">
	<table cellspacing="0" cellpadding="10" width="100%" border="0" bgcolor="#FFFFFF" height="100%">
		<tr>
			<td valign="top">
		<table cellspacing=0 cellpadding=0 width=100% border=0>  
            <tr>                                                                    
                <td name="portTitle" id="portTitle" class=listtopic colspan=2>Firewall--&gt;Mac/Ip/Port Filtering</td>
            </tr>
			
			<tr>                                                                    
                <td colspan=2>&nbsp;</td>
            </tr>		
			<tr>                                                                    
                <td colspan=2>&nbsp;</td>
            </tr>	                                                                
        </table>
		                                                                  
		<table cellspacing="0" cellpadding="0" width="100%" border="0">
	 	<TD  align="center" width="150px" height="20" bgcolor="#8B1618"><font color="#FFFFFF" face="Arial"><strong><span name="firewallTitlePortFilter" id="firewallTitlePortFilter">&#8226; MAC/Ip/Port Filtering</span></strong>&nbsp;</font></TD>
		<!--<TD  align="center" width=120 height="20" bgcolor="#CCCCCC"><A href="content_filtering.asp"><font color="#000000" face="Arial"><strong><span name="firewallTitleURLFilter" id="firewallTitleURLFilter">&#8226;URL Filtering</span></strong></font></A></TD>-->  
    <TD align="center" width="150px" height="20" bgcolor="#CCCCCC"><A href="port_forward.asp"><font color="#000000" face="Arial"><strong><span name="firewallTitlePortForward" id="firewallTitlePortForward" >&#8226;Port Forwarding</span></strong></font></A></TD>
		<!--<TD align="center" width=70 height="20" bgcolor="#CCCCCC"><A href="DMZ.asp"><font color="#000000" face="Arial"><strong><span name="firewallTitleDMZ" id="firewallTitleDMZ" >&#8226;DMZ</span></strong></font></A></TD>--> 
		<TD  align="center" width="150px" height="20" bgcolor="#CCCCCC"><A href="system_firewall.asp"><font color="#000000" face="Arial"><strong><span name="firewallTitleSys" id="firewallTitleSys">&#8226;System Security</span></strong></font></A></TD>
       <TD width=500></TD>
	</table>
	
	    <br>	
<table width="100%" border="0" cellspacing="0" cellpadding="0">

<tr>
	<td class="title" colspan="2" id="portBasicSet" onMouseOver="MAC_IP_PORT_filter_toptip();" onMouseOut="return nd();">Basic Settings</td>
</tr>

<tr>
	<td class="head_top" id="portBasicFilter"  width="40%">
		MAC/IP/Port Filtering
	</td>
	<td class="tail_top" width="60%">
	<select onChange="updateState()" name="portFilterEnabled" style="width:100px">
	<option id="portBasicDisable" value=0 <% getIPPortFilterEnableASP(0); %> >Disable</option>
    <option id="portBasicEnable" value=1 <% getIPPortFilterEnableASP(1); %> >Enable</option>
    </select>
    </td>
</tr>

<tr name = "tmp1" id="tmp1">
	<td class="head" id="portBasicDefaultPolicy">
		Default Policy -- The packet that doesn't match with any rules would be:
	</td>
	<td class="tail"><select onChange="defaultPolicyChanged()" name="defaultFirewallPolicy" style="width:100px">
	  <option id="portBasicDefaultPolicyAccept" value=0 <% getDefaultFirewallPolicyASP(0); %> >Accepted</option>
	  <option id="portBasicDefaultPolicyDrop" value=1 <% getDefaultFirewallPolicyASP(1); %> >Dropped</option>
	  </select></td>
</tr>
</table>
<br>
<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr align="right">
    <td>
	<input class="btn" type="submit" value="Apply" id="portBasicApply" name="portBasicApply"> &nbsp;&nbsp;
    </td>
  </tr>
</table>

</form>

<!-- ====================   MAC/IP/Port form   ==================== -->
<form method=post name="ipportFilter" action=/goform/ipportFilter onSubmit="return ipportFormCheck()">
<table cellSpacing=0 cellPadding=10 width="100%" border=0>
<tr>
	<td class="title" colspan="4" id="portFilterSet">IP/Port Filter Settings</td>
</tr>

<tr>
	<td class="head_top" colspan="2" id="portFilterMac" width="40%">
		MAC Address
	</td>
	<td colspan="2" class="tail_top" width="60%">
		 <input id="mac_address" name="mac_address" type="text" size="18" > 
		 <span id="example_MAC">&nbsp;(XX:XX:XX:XX:XX:XX,&nbsp;&nbsp;eg:&nbsp;00:1E:90:FF:FF:FF)</span>	</td>
</tr>

<tr>
	<td class="head" colspan="2" id="portFilterDIPAddr">
		Dest IP Address
	</td>
	<td colspan="2" class="tail">
		<input type="text" size="16" name="dip_address" id="dip_address">
		<span id="example_IP">&nbsp;( XXX.XXX.XXX.XXX, eg: 192.168.5.101)</span>
		<!-- we dont support ip range in kernel 2.4.30 
		-<input type="text" size="16" name="dip_address2">
		-->	</td>
</tr>

<tr>
	<td class="head" colspan="2" id="portFilterSIPAddr">
		Source IP Address
	</td>
	<td colspan="2" class="tail">
  		<input type="text" size="16" name="sip_address" id="sip_address">
		<!-- we dont support ip range in kernel 2.4.30 
		-<input type="text" size="16" name="sip_address2">
		-->
	</td>
</tr>

<tr>
	<td class="head" colspan="2" id="portFilterProtocol">
		Protocol
	</td>
	<td colspan="2" class="tail">
		<select onChange="protocolChange()" name="protocol" id="procotol">
		<option value="None">None</option>
		<option value="TCP">TCP</option>
		<option value="UDP">UDP</option>
        <option value="TCP&UDP">TCP+UDP</option>
		<option value="ICMP">ICMP</option>
		</select>&nbsp;&nbsp;
	</td>
</tr>

<tr>
	<td class="head" colspan="2" id="portFilterDPortRange">
		Dest. Port Range
	</td>
	<td colspan="2"  class="tail">
  		<input type="text" size="5" name="dFromPort" id="dFromPort">-
		<input type="text" size="5" name="dToPort" id="dToPort">&nbsp;( 1~65535)
	</td>
</tr>


<tr>
	<td class="head" colspan="2" id="portFilterSPortRange">
		Src Port Range
	</td>
	<td colspan="2" class="tail">
  		<input type="text" size="5" name="sFromPort" id="sFromPort">-
		<input type="text" size="5" name="sToPort" id="sToPort">&nbsp;( 1~65535)
	</td>
</tr>

<tr>
	<td class="head" colspan="2" id="portFilterAction">
		Action
	</td>
	<td colspan="2" class="tail">
		<select onChange="actionChanged()" name="action" style="width:100px">
   		<option value="Drop" id="portFilterActionDrop">Drop</option>
		<option value="Accept" id="portFilterActionAccept">Accept</option>
   		</select>
	</td>
</tr>

<tr>
	<td class="head" colspan="2" id="portFilterComment">
		Comment
	</td>
	<td colspan="2" class="tail">
		<input type="text" name="comment" id="comment" size="16" maxlength="32">
	</td>
</tr>
</table>
<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%" name="tmp2" id ="tmp2"> 
	<tr>
	  <td id="maximum_desc" colspan="2" >The maximum rule count is 10.</td> 
	</tr>
</table> 


<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr align="right">
    <td>
	<input class="btn" type="submit" value="Apply" id="portFilterApply" name="portFilterApply"> &nbsp;&nbsp;
	<input class="btn" type="reset" value="Reset" id="portFilterReset" name="reset" onClick="resetItems()">
    </td>
  </tr>
</table>

</form>

<br>


<!-- =========================  delete rules  ========================= -->
<form action=/goform/ipportFilterDelete method=POST name="ipportFilterDelete">

<table cellSpacing=0 cellPadding=10 width="100%" border=0>
	<tr>
		<td class="title" colspan="10" id="portCurrentFilter">Current IP/Port filtering rules in system: </td>
	</tr>

	<tr>
		<td id="portCurrentFilterNo" class="head1_top"> No.</td>
		<td align=center id="portCurrentFilterMac" class="head2_top"> MAC Address </td>
		<td align=center id="portCurrentFilterDIP" class="head2_top"> Dest IP Address </td>
		<td align=center id="portCurrentFilterSIP" class="head2_top"> Source IP Address </td>
		<td align=center id="portCurrentFilterProtocol" class="head2_top"> Protocol</td>
		<td align=center id="portCurrentFilterDPort" class="head2_top"> Dest Port Range</td>
		<td align=center id="portCurrentFilterSPort" class="head2_top"> Source Port Range</td>
		<td align=center id="portCurrentFilterAction" class="head2_top"> Action</td>
		<td align=center id="portCurrentFilterComment" class="head2_top"> Comment</td>
	</tr>

	<% showIPPortFilterRulesASP(); %>
</table>
<br>

<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr align="right">
    <td>
<input class="btn" type="submit" value="Delete" id="portCurrentFilterDel" name="deleteSelFilterPort" onClick="return deleteClick()">&nbsp;&nbsp;
<input class="btn" type="reset" value="Reset" id="portCurrentFilterReset" name="reset">    </td>
  </tr>
</table>


</form>


</body>
</html>
