#
# The script is used to control the vpn pass-through
# Created by LiuWei184577 2010-03-10
#

# switch: 1 means allow vpn pass-through; 0 means not allow
vpn_pass=`nvio_get_item 0 vpnPass`

# iptables -t filter -N vpn_filter
# iptables -t filter -I FORWARD 2 -j vpn_filter  // The first rule is macipport_filter

# clear all rules in vpn_filter
iptables -t filter -F vpn_filter

# open the vpn pass-through
if [ "$vpn_pass" = "1" ]; then
	# PPTP:  GRE/47   TCP Port: 1723
	iptables -t filter -A vpn_filter -p 47 -j ACCEPT
	iptables -t filter -A vpn_filter -p tcp --dport 1723 -j ACCEPT
	iptables -t filter -A vpn_filter -p tcp --sport 1723 -j ACCEPT
	
	# IPsec:  ESP/50  AH/51  UDP Port: 500 | 4500
	iptables -t filter -A vpn_filter -p 50 -j ACCEPT
	iptables -t filter -A vpn_filter -p 51 -j ACCEPT
	iptables -t filter -A vpn_filter -p udp --dport 500 -j ACCEPT
	iptables -t filter -A vpn_filter -p udp --sport 500 -j ACCEPT
	iptables -t filter -A vpn_filter -p udp --dport 4500 -j ACCEPT
	iptables -t filter -A vpn_filter -p udp --sport 4500 -j ACCEPT
	
	# L2TP:  UDP Port: 1701
	iptables -t filter -A vpn_filter -p udp --dport 1701 -j ACCEPT
	iptables -t filter -A vpn_filter -p udp --sport 1701 -j ACCEPT
fi

# close the vpn pass-through
if [ "$vpn_pass" = "0" ]; then
	# PPTP:  GRE/47   TCP Port: 1723
	iptables -t filter -A vpn_filter -p 47 -j DROP
	iptables -t filter -A vpn_filter -p tcp --dport 1723 -j DROP
	
	# IPsec:  ESP/50  AH/51  UDP Port: 500
	iptables -t filter -A vpn_filter -p 50 -j DROP
	iptables -t filter -A vpn_filter -p 51 -j DROP
	iptables -t filter -A vpn_filter -p udp --dport 500 -j DROP
	iptables -t filter -A vpn_filter -p udp --dport 4500 -j DROP
	
	# L2TP:  UDP Port: 1701
	iptables -t filter -A vpn_filter -p udp --dport 1701 -j DROP
fi
