#!/bin/sh
dns_mode=$(nvio_get_item 0 dns_mode)
if [ "$dns_mode" = "manual" ];then
prim=$(nvio_get_item 0 prefer_dns_manual)
echo prim_dns $prim
echo nameserver $prim > /etc/resolv.conf
sec=$(nvio_get_item 0 standby_dns_manual)
echo sec_dns=$sec
echo nameserver $sec >> /etc/resolv.conf
else
echo "auto mode"
fi

#ip:
ip_addr=$(ifconfig rmnet0 | grep "inet addr" | sed "s/[ ]*inet addr://g" |sed "s/  B[a-zA-Z0-9. :]*//g")
nvio_write_item 0 wan_ipaddr "$ip_addr" 0
echo "wan_ipaddr :$ip_addr"

#p-dns:
p_dns=$(grep -m 1 "nameserver" /etc/resolv.conf | cut -c12-26)
nvio_write_item 0 prefer_dns_auto "$p_dns" 0
echo "prefer_dns_auto :$p_dns"

#s-dns:
s_dns=$(grep "nameserver" /etc/resolv.conf |awk 'NR==2'|cut -c12-26)
nvio_write_item 0 standby_dns_auto "$s_dns" 0
echo "standby_dns_auto :$s_dns"






