#!/bin/sh
# Syslog mode control script by qianying

CACHE_DIR=/cache
DEFAULT_SYSLOG_PATH_1=$CACHE_DIR/zte_log
DEFAULT_SYSLOG_PATH_2=/usr/zte_web/web/zte_log
SYSLOG_FILENAME=syslog
ENMERGE_LEVEL=1
INFO_LEVEL=7
DEFAULT_SYSLOG_SIZE=1024
SYSLOG_CONFIG_FILE=/usr/zte/zte_conf/scripts/zte_syslog.conf

#Set syslog default location
if [ -d $CACHE_DIR ]
then
      if [ -d $DEFAULT_SYSLOG_PATH_1 ]
      then 
        path=$DEFAULT_SYSLOG_PATH_1
      else
        mkdir $DEFAULT_SYSLOG_PATH_1
        path=$DEFAULT_SYSLOG_PATH_1 
      fi
else
      path=$DEFAULT_SYSLOG_PATH_2
fi

#Set syslog default level
level=$ENMERGE_LEVEL

#Set syslog default size
size=$DEFAULT_SYSLOG_SIZE

para1=$1

if [ "$para1" = "-L" -o "$para1" = "-R" ]
then
  echo "Start syslog setting"
else
  echo "Comand usage:"
  echo "./zte_syslog.sh -L -o <Path> -l Level <Level> -s <Size>"
  echo "                -R <HostIP>"
  exit 1
fi

if [ "$para1" = "-L" ]
then
  shift 
  if [ $# = 0 ]
  then
     echo "syslog_mode=0" > $SYSLOG_CONFIG_FILE
     echo "syslog_path=$path" >> $SYSLOG_CONFIG_FILE
     echo "syslog_level=$level" >> $SYSLOG_CONFIG_FILE
     echo "syslog_size=$size" >> $SYSLOG_CONFIG_FILE
     
     killall -9 syslogd
     usleep 100
     syslogd -O $path/$SYSLOG_FILENAME  -l $level -s $size  
     exit 0
  fi
  
  while getopts "o:l:s:" arg
  do
     case $arg in
        o)
          if [ -d $OPTARG ]
          then   
             path=$OPTARG
          else
             echo "Wrong path=$OPTARG"
             exit 1   
          fi
          ;;
        l)
          if [ $OPTARG = $ENMERGE_LEVEL -o $OPTARG = $INFO_LEVEL ]
          then   
             echo $OPTARG 
             level=$OPTARG
          else
             echo "Wrong level=$OPTARG"
             exit 1   
          fi
          ;;   
        s)      
          if [ $OPTARG -gt 0 ]
          then
          #echo $OPTARG   
             size=$OPTARG
          else
             echo "Wrong size=$OPTARG"
             exit 1   
          fi
          ;;            
        *)
           echo $OPTARG 
           echo "Comand usage:"
           echo "./zte_syslog.sh -L -o <Path> -l Level <Level> -s <Size>"
          exit 1   
        esac
      
    done
    
    echo "syslog_mode=0" > $SYSLOG_CONFIG_FILE
    echo "syslog_path=$path" >> $SYSLOG_CONFIG_FILE
    echo "syslog_level=$level" >> $SYSLOG_CONFIG_FILE
    echo "syslog_size=$size" >> $SYSLOG_CONFIG_FILE

    killall -9 syslogd
    usleep 100
    syslogd -O $path/$SYSLOG_FILENAME  -l $level -s $size 
    exit 0    
fi

if [ "$para1" = "-R" ]
then
    echo "Start sylog remote setting"
    if [ $# = 1 ]
    then
        echo "Comand usage:"
        echo "./zte_syslog.sh -R <Hostip>"
        exit 1   
   fi
fi 
   
  hostip=$2
  echo "Enable remote syslog hostip=$hostip"
  
  echo "syslog_mode=1" > $SYSLOG_CONFIG_FILE
  echo "syslog_host_ip=$hostip" >> $SYSLOG_CONFIG_FILE
     
  killall -9 syslogd
  usleep 100
  syslogd -R $hostip 
  exit 0
fi

 