#!/bin/sh 
## 
# $Id: zte_ipv6.sh,v 0.0.0.1 2012.05.07 liuweipeng Exp $ 
# 
# usage: zte_ipv6.sh 
# 

echo "input param is $1"

RESOLV_CONF="/etc/resolv.conf" #soft link to /mnt/zte/zte_conf/config/resolv.conf

CONIFG_PATH_READ="/usr/zte/zte_conf/config"
CONIFG_PATH="/mnt/zte/zte_conf/config"

wan_addr_temp=`cfg get ipv6_wan_ipaddr`
wan_addr=`echo $wan_addr_temp | sed 's/\/64//'`

cfg set wan_name=ccmni0
echo "wan_name is `cfg get wan_name`"
echo "wan_addr:$wan_addr"
total_zero_addr="0000:0000:0000:0000:0000:0000:0000:0000"


#############linkup  radvd set############
linkup_radvd_set() 
{
	echo  "enter linkup_radvd_set "
	
	rm -f $CONIFG_PATH/radvd.conf
	cp $CONIFG_PATH_READ/radvd_template.conf $CONIFG_PATH/radvd.conf
	
	sed  -i -e s/#ipv6_wan_addr#/$wan_addr/g $CONIFG_PATH/radvd.conf 
	sed  -i -e s/#adv_switch#/on/g $CONIFG_PATH/radvd.conf 

	killall radvd
	radvd -d 3 -C $CONIFG_PATH/radvd.conf  &
	
	echo  "leave linkup_radvd_set "
}


#############linkup resolve config set############
linkup_resolve_config_set() 
{
    # ipv4 dns set
    dns_mode=`cfg get dns_mode`
    echo "ipv4 dns_mode:$dns_mode"
    
    echo -e "\n" > $RESOLV_CONF
    
    if [ "$dns_mode" = "auto" ];then
     
		  prefer_dns_auto=`cfg get prefer_dns_auto`
			standby_dns_auto=`cfg get standby_dns_auto`
			echo nameserver $prefer_dns_auto >> $RESOLV_CONF
			echo nameserver $standby_dns_auto >> $RESOLV_CONF
			
    elif [ "$dns_mode" = "manual" ];then
    
			prefer_dns_manual=`cfg get prefer_dns_manual`
			standby_dns_manual=`cfg get standby_dns_manual`
			echo nameserver $prefer_dns_manual >> $RESOLV_CONF
			echo nameserver $standby_dns_manual >> $RESOLV_CONF 
	  fi
    
    # ipv6 dns set
    ipv6_dns_mode=`cfg get ipv6_dns_mode`
    echo "ipv6_dns_mode:$ipv6_dns_mode"
    
    if [ "$ipv6_dns_mode" = "auto" ];then
     
		  ipv6_prefer_dns_auto=`cfg get ipv6_prefer_dns_auto`
			ipv6_standby_dns_auto=`cfg get ipv6_standby_dns_auto`
			
			if [ -n "$ipv6_prefer_dns_auto" ] && [ "$ipv6_prefer_dns_auto" != "::" && $ipv6_prefer_dns_auto!="$total_zero_addr" ];then
				echo nameserver $ipv6_prefer_dns_auto >> $RESOLV_CONF
			fi
			
			if [ -n "$ipv6_standby_dns_auto" ] && [ "$ipv6_standby_dns_auto" != "::" && $ipv6_standby_dns_auto!="$total_zero_addr" ];then
				echo nameserver $ipv6_standby_dns_auto >> $RESOLV_CONF
			fi
    elif [ "$ipv6_dns_mode" = "manual" ];then
    
			ipv6_prefer_dns_manual=`cfg get ipv6_prefer_dns_manual`
			ipv6_standby_dns_manual=`cfg get ipv6_standby_dns_manual`
			
			if [ -n "$ipv6_prefer_dns_manual" ] && [ "$ipv6_prefer_dns_manual" != "::" && $ipv6_standby_dns_auto!="$total_zero_addr" ];then
				echo nameserver $ipv6_prefer_dns_manual >> $RESOLV_CONF
			fi
			
			if [ -n "$ipv6_standby_dns_manual" ] && [ "$ipv6_standby_dns_manual" != "::" && $ipv6_standby_dns_manual!="$total_zero_addr" ];then
				echo nameserver $ipv6_standby_dns_manual >> $RESOLV_CONF 
			fi
			
	  fi
	  
	  
	  #restart dnsmasq
	  #killall dnsmasq
	  #dnsmasq -i br0 -r /etc/resolv.conf &
	  
}

#############linkup wan addr route config set############
linkup_wanaddr_route_set() 
{
	wan_name_info=`cfg get wan_name`
	
	echo "wan_name_info = $wan_name_info"
	
	#echo 0 > /proc/sys/net/ipv6/conf/all/forwarding 
    echo 1 > /proc/sys/net/ipv6/conf/all/forwarding 

  if [ "$wan_name_info" = "ccmni0" ];then
   	echo 0 > /proc/sys/net/ipv6/conf/ccmni0/accept_ra 
	  #ifconfig ccmni0 down
		#ifconfig ccmni0 up
		
		#sleep 1
		#ip -6 addr flush label "ccmni0" # delete ccmni0 all ipv6 address
		ip -6 addr add  $wan_addr/126 dev ccmni0	
		ip -6 route add default dev ccmni0 
  elif [ "$wan_name_info" = "usb0" ];then
  	echo 0 > /proc/sys/net/ipv6/conf/ppp0/accept_ra 
	  ifconfig ppp0 down
		ifconfig ppp0 up
		
		sleep 1
		ip -6 addr add  $wan_addr/126 dev ppp0	
		ip -6 route add default dev ppp0
		
	elif [ "$wan_name_info" = "usb0" ];then
	
	  echo 0 > /proc/sys/net/ipv6/conf/usb0/accept_ra 
	  ifconfig usb0 down
		ifconfig usb0 up
		
		sleep 1
		ip -6 addr add  $wan_addr/126 dev usb0		
		ip -6 route add default dev usb0
		
	elif [ "$wan_name_info" = "ecm0" ];then
		echo 0 > /proc/sys/net/ipv6/conf/ecm0/accept_ra 
	  ifconfig ecm0 down
		ifconfig ecm0 up
		
		sleep 1
		ip -6 addr add  $wan_addr/126 dev ecm0	
		ip -6 route add default dev ecm0
		
  elif [ "$wan_name_info" = "eth2.2" ];then
  	echo 0 > /proc/sys/net/ipv6/conf/eth2.2/accept_ra 
	  ifconfig eth2.2 down
		ifconfig eth2.2 up
		
		sleep 1
		ip -6 addr add  $wan_addr/126 dev eth2.2	
		ip -6 route add default dev eth2.2
	fi	
		
	
	cfg set ipv6_br0_addr="::"
	
	ipv6_addr_conver "$wan_addr"
	
	ipv6_br0_addr_tmp=`cfg get ipv6_br0_addr`
	echo "ipv6_br0_addr_tmp = $ipv6_br0_addr_tmp"
	
    #ip -6 addr flush label "br0" # delete ccmni0 all ipv6 address	
	ip -6 addr add  $ipv6_br0_addr_tmp/64 dev br0	
	
}


#############linkup forward proxy set############
linkup_forward_proxy_set() 
{
	#enable ipv6 neigh discovery proxy
	echo 1 > /proc/sys/net/ipv6/conf/all/proxy_ndp
	
	killall -9 zte_ndp
	zte_ndp -a -s br0 -d "$wan_name_info" -l $CONIFG_PATH/ndp.log &
	
	#add addr of wan0 to br0 for visit wan0 
	ip -6 neigh add proxy $wan_addr  dev br0
	#/sbin/ip -6 neigh add proxy $wan_addr  dev br0
	
	#sleep 2
	echo 1 > /proc/sys/net/ipv6/conf/all/forwarding 
}



#############linkdown radvd set############
linkdown_radvd_set() 
{
		sed  -i -e s/AdvValidLifetime.*/'AdvValidLifetime 30;'/g $CONIFG_PATH/radvd.conf
		sed  -i -e s/AdvPreferredLifetime.*/'AdvPreferredLifetime 1;'/g $CONIFG_PATH/radvd.conf
		
		killall radvd
		radvd -d 3  -C $CONIFG_PATH/radvd.conf -s &
}


#############linkdown wanaddr route set############
linkdown_wanaddr_route_set() 
{
	wan_name_info=`cfg get wan_name`
	echo "wan_name_info = $wan_name_info"
	
	if [ "$wan_name_info" = "ppp0" ];then
		ip -6 addr del  $wan_addr/126 dev ppp0
    elif [ "$wan_name_info" = "ccmni0" ];then
		ip -6 addr del  $wan_addr/126 dev ccmni0		
	elif [ "$wan_name_info" = "usb0" ];then
		ip -6 addr del  $wan_addr/126 dev usb0
	elif [ "$wan_name_info" = "ecm0" ];then
		ip -6 addr del  $wan_addr/126 dev ecm0	
	elif [ "$wan_name_info" = "eth2.2" ];then
		ip -6 addr del  $wan_addr/126 dev eth2.2		
	fi	
		
	cfg set ipv6_br0_addr="::"
	ipv6_addr_conver $wan_addr
	ipv6_br0_addr_tmp=`cfg get ipv6_br0_addr`
	ip -6 addr del  $ipv6_br0_addr_tmp/64 dev br0	
	#ip -6 addr flush label "br0" # delete ccmni0 all ipv6 address
	#ip -6 addr flush label "ccmni0" # delete ccmni0 all ipv6 address
	
	#reset wan'nv 
	cfg set ipv6_wan_ipaddr="::"
	#cfg set ipv6_prefer_dns_auto="::"
	#cfg set ipv6_standby_dns_auto="::"
	
	
    #del addr of wan0 to br0 for visit wan0 
    ip -6 neigh del proxy $wan_addr dev br0
	
}


############ipv6 shell entry#################

case $1 in 
 "linkup") 
 	linkup_wanaddr_route_set
 	linkup_forward_proxy_set
	linkup_resolve_config_set
	linkup_radvd_set
	;;
 
 "linkdown") 
	linkdown_radvd_set
	linkdown_wanaddr_route_set
	
	;;

esac

