#!/bin/sh
# $Id: miniupnpd.init.d.script,v 1.7 2012-04-17 11:23:40 mtk02469 Exp $
# MiniUPnP project
# author: Thomas Bernard
# website: http://miniupnp.free.fr/ or http://miniupnp.tuxfamily.org/
#
# Modify by MediaTek
#	@author Shane Chang
#

MINIUPNPD=/usr/sbin/miniupnpd
MINIUPNPD_CONF=/tmp/miniupnpd.conf
ARGS='-f /tmp/miniupnpd.conf -P /var/run/miniupnpd.pid'

IPTABLES_CREATE=/usr/zte/zte_conf/miniupnpd/iptables_init.sh
IPTABLES_REMOVE=/usr/zte/zte_conf/miniupnpd/iptables_removeall.sh
IPTABLES_FLUSH=/usr/zte/zte_conf/miniupnpd/iptables_flush.sh

test -f $MINIUPNPD || exit 0

trans() {
        if [ -e /usr/zte/zte_conf/miniupnpd/miniupnpd.trans ] ; then
		/usr/zte/zte_conf/miniupnpd/miniupnpd.trans
#		/etc/init.d/netfilter_svc
        fi
}

need_trans() {
        if [ -e $MINIUPNPD_CONF ] ; then
		echo
	else
		trans
        fi
}

start() {
	if [ -f /var/run/miniupnpd.pid ]; then
		echo -n " --- UPnP is running, start to restart"
		stop
		sleep 1
	fi	
	$MINIUPNPD $ARGS
}

stop() {
	if [ -f /var/run/miniupnpd.pid ]; then
		kill -9 `cat /var/run/miniupnpd.pid` > /dev/null 2>&1
		rm /var/run/miniupnpd.pid
	else
		echo -n " --- UPnP is not running"
	fi
}

case "$1" in
start|ipup)  echo -n "Starting miniupnpd"
	trans
	$IPTABLES_REMOVE > /dev/null 2>&1
	$IPTABLES_CREATE > /dev/null 2>&1
	start
        echo "."
        ;;
stop|ipdown)   echo -n "Stopping miniupnpd"
	stop
        echo "."
	$IPTABLES_REMOVE > /dev/null 2>&1
        ;;
restart|reload|force-reload|ipchg)
        echo -n "Restarting miniupnpd"
#	trans
	stop
#	$IPTABLES_FLUSH > /dev/null 2>&1
	start
        echo "."
        ;;
trans)	echo -n "Translate miniupnpd configuration"
	trans
        echo "."
        ;;
*)      echo "Usage: /etc/init.d/miniupnpd {start|stop|restart|reload|force-reload|trans|ipup|ipdown|ipchg}"
        exit 2
        ;;
esac
exit 0
