#! /bin/sh --
LOG_LEVEL=$1
LOG_MODE=$2
LOG_PATH=`cfg get syslog_path`
if [ "$LOG_PATH" == "" ]
then
	echo LOG_PATH is NULL set default path "/logfs"
	LOG_PATH="/logfs"
fi
do_syslog_filter()
{   	
	if [ "$LOG_LEVEL" == "4" ]
	then
		cp $syslog_file $tbox_filter_log
	elif [ "$LOG_LEVEL" == "3" ]
	then
		cat $syslog_file | grep -nE 'user.emerg | user.notice | user.err' > $tbox_filter_log
	elif [ "$LOG_LEVEL" == "2" ]
	then
		cat $syslog_file | grep -nE 'user.emerg | user.warn' > $tbox_filter_log
	else
		cat $syslog_file | grep -nE 'user.emerg' > $tbox_filter_log
	fi
}

if [ "$LOG_MODE" == "upload_now" ] ;then
	syslog_file=$LOG_PATH/syslog.0
	tbox_filter_log=$LOG_PATH/tbox_filter_log.0
	if [ -f $syslog_file ];then
		syslog_modify_time_now=`stat $syslog_file | grep -i Modify | awk -F. '{print $1}' | awk '{print $2$3}'| awk -F- '{print $1$2$3}' | awk -F: '{print $1$2$3}'`
		syslog_modify_time_old=`cfg get log_last_modify_time`
		if [ "$syslog_modify_time_old" != "$syslog_modify_time_now" ];then
			do_syslog_filter 
			cfg set log_last_modify_time=$syslog_modify_time_now
		fi
	fi
	syslog_file=$LOG_PATH/syslog
	tbox_filter_log=$LOG_PATH/tbox_filter_log
	do_syslog_filter
elif [ "$LOG_MODE" == "upload_cycle" ] ;then
	tbox_filter_log=$LOG_PATH/tbox_filter_log.0
	syslog_file=$LOG_PATH/syslog.0
	do_syslog_filter
else
	echo "unknow tbox log filter mode " >> /logfs/syslog
fi