# create by zhangzhen for zte_get_flow_by_ip

#!/bin/sh
echo "zte_get_flow_by_ip.sh"

ip_version=$1
ip=$2

if [ "$ip" == "" ]
then
  echo "$0: no ip in, exit!"
  exit 1
fi

if [ "$ip_version" == "" ]
then
  echo "$0: no ip_version in, exit!"
  exit 1
fi

cfg set current_dl_flow=""
cfg set current_ul_flow=""

if [ "$ip_version" == "4" ]
then
	dl=`iptables -n -v -L -t mangle -x | grep $ip | awk 'NR==1 {print $2}'`
	ul=`iptables -n -v -L -t mangle -x | grep $ip | awk 'NR==2 {print $2}'`
fi

if [ "$ip_version" == "6" ]
then
	dl=`ip6tables -n -v -L -t mangle -x | grep $ip | awk 'NR==1 {print $2}'`
	ul=`ip6tables -n -v -L -t mangle -x | grep $ip | awk 'NR==2 {print $2}'`
fi

if [ "$dl" != "" -a "$ul" != "" ]
then
	cfg set current_dl_flow=$dl
	cfg set current_ul_flow=$ul
	cfg save
fi