/**
 * @module dmz setting
 * @class dmz setting
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

function($, ko, config, service, _) {

    /**
     * system dmz setting VM
     * @class DmzSettingVM
     */
	function DmzSettingVM() {
        var self = this;
        var info = getDmzSetting();

        self.dmzSetting = ko.observable(info.dmzSetting);
        self.ipAddress = ko.observable(info.ipAddress);

        self.clear = function() {
            init();
        };

        self.save = function() {
			if(!checkIPIsSameSubNet(self.ipAddress(),info.gatewaySubnetMask,info.gatewayIpAddress,info.gatewaySubnetMask)){//在一个网段内
					showLoading();
					var params = {};
					params.dmzSetting = self.dmzSetting();
					params.ipAddress = self.ipAddress();
					service.setDmzSetting(params, function(result) {
						if (result.result == "success") {
							self.clear();
							successOverlay();
						} else {
							errorOverlay();
						}
					});  
                }else{//不在一个网段内
                    showAlert("dmz_address_check");
                }
				
            
        };
    }
	
	/**
     * 判断两个ip是否在同一个网段内
	 * @params ip1:第一个ip,netmaskIp1:第一个子网掩码,ip2:第二个ip,netmaskIp2:第二个子网掩码
     * @method getDmzSetting
	 * @auth ccl
     */
	function checkIPIsSameSubNet(ip1, netmaskIp1,ip2,netmaskIp2) {
            var i1,i2,i3, wip, nip, gip,gnip;

            i1=ip1.indexOf('.');
            i2=ip1.indexOf('.',(i1+1));
            i3=ip1.indexOf('.',(i2+1));
            wip = hex(ip1.substring(0,i1)) + hex(ip1.substring((i1+1),i2)) +hex(ip1.substring((i2+1),i3))+hex(ip1.substring((i3+1),ip1.length));
            wip = '0x'+wip;

            i1=netmaskIp1.indexOf('.');
            i2=netmaskIp1.indexOf('.',(i1+1));
            i3=netmaskIp1.indexOf('.',(i2+1));
            nip = hex(netmaskIp1.substring(0,i1)) + hex(netmaskIp1.substring((i1+1),i2)) +hex(netmaskIp1.substring((i2+1),i3)) +hex(netmaskIp1.substring((i3+1),netmaskIp1.length));
            nip = '0x'+nip;

            i1=ip2.indexOf('.');
            i2=ip2.indexOf('.',(i1+1));
            i3=ip2.indexOf('.',(i2+1));
            gip = hex(ip2.substring(0,i1)) + hex(ip2.substring((i1+1),i2)) +hex(ip2.substring((i2+1),i3)) +hex(ip2.substring((i3+1),ip2.length));
            gip = '0x'+gip;

            i1=netmaskIp2.indexOf('.');
            i2=netmaskIp2.indexOf('.',(i1+1));
            i3=netmaskIp2.indexOf('.',(i2+1));
            gnip = hex(netmaskIp2.substring(0,i1)) + hex(netmaskIp2.substring((i1+1),i2)) +hex(netmaskIp2.substring((i2+1),i3)) +hex(netmaskIp2.substring((i3+1),netmaskIp2.length));
            gnip = '0x'+gnip;

            if(Op_AND_4Byte(wip, nip) == Op_AND_4Byte(gip, gnip)) {
                return false;
            }else {
                return true;
            }
        }
		
		function hex(val) {
            var h = (val-0).toString(16);
            if(h.length==1) h='0'+h;
            return h.toUpperCase();
        }

        function Op_AND_4Byte(v1, v2) {
            var i;
            var var1 = [];
            var var2 = [];
            var result='0x';

            for (i=2,j=0;i<10;i+=2,j++) {
                var1[j]='0x'+v1.substring(i,i+2);
                var2[j]='0x'+v2.substring(i,i+2);
            }

            for (i=0;i<4;i++) {
                result = result + hex(var1[i]&var2[i]);
            }

            return result - 0;
        }
    /**
     * 获取dmz 信息
     * @method getDmzSetting
     */
    function getDmzSetting() {
        return service.getDmzSetting();
    }

    /**
     * 初始化DmzSettingVM model
     * @method init
     */
	function init() {
		var container = $('#container');
		ko.cleanNode(container[0]);
		var vm = new DmzSettingVM();
		ko.applyBindings(vm, container[0]);
        $('#dmzSettingForm').validate({
            submitHandler : function() {
                vm.save();
            },
            rules: {
                txtIpAddress: 'dmz_ip_check'
            }
        });
	}

	return {
		init : init
	};
});