#!/bin/sh
# ===========================================================
# usage: nat.sh
# just for rmnet_data0 up call

mss_del_path="/tmp/mss_del.sh"
trigger_del_patch="/tmp/trigger_del.sh"
cone_nat_del_patch="/tmp/cone_nat_del.sh"
port_trigger_switch=`cfg get port_trigger_enable`
wan_if=$1
nat_mode_switch=`cfg get nat_mode`
mtu=`cfg get mtu`
tcp_mss=`cfg get tcp_mss`
current_wan_ip=`cfg get wan_ipaddr`
current_lan_ip=`cfg get lan_ipaddr_for_current`
if [ "$wan_if" = "" ]
then
	wan_if=rmnet_data0
fi

if [ "$mtu" = "" ]
then
	mtu=1500
fi

if [ "$tcp_mss" = "" ]
then
#    tcp_mss=1460
    let tcp_mss=mtu-40
fi

echo "nat.sh: wan if name is [$wan_if]"

echo 1 > /proc/sys/net/ipv4/ip_forward
echo 1 > /proc/sys/net/ipv4/conf/$wan_if/proxy_arp
iptables -t filter -D FORWARD -i bridge0 -p tcp -m state --state INVALID -j DROP
iptables -t filter -A FORWARD -i bridge0 -p tcp -m state --state INVALID -j DROP

conntrack -D -n
conntrack -D -g

iptables -t nat -D POSTROUTING 1
iptables -t nat -D POSTROUTING 1

#1 Full Cone NAT ;2 Port Restricted Cone NAT ;3 Restricted Cone NAT ;

if [ "1" == "$nat_mode_switch" ]
then
    sh $cone_nat_del_patch 
	iptables -t nat -A POSTROUTING -o $wan_if -j SNAT --to-source $current_wan_ip
	iptables -t nat -A PREROUTING -i $wan_if -j DNAT --to-destination $current_lan_ip
	echo iptables -t nat -D PREROUTING -i $wan_if -j DNAT --to-destination $current_lan_ip > $cone_nat_del_patch
elif [ "2" == "$nat_mode_switch" ]	
then
    sh $cone_nat_del_patch
	iptables -t nat -A POSTROUTING -o $wan_if -j SNAT --to-source $current_wan_ip
elif [ "3" == "$nat_mode_switch" ]
then
    sh $cone_nat_del_patch 
	iptables -t nat -A POSTROUTING -o $wan_if -j MASQUERADE --random
	iptables -t nat -A PREROUTING -i $wan_if -j NATTYPE --mode dnat --type 2
	echo iptables -t nat -D PREROUTING -i $wan_if -j NATTYPE --mode dnat --type 2 > $cone_nat_del_patch
	iptables -t nat -A POSTROUTING -o $wan_if -j NATTYPE --mode forward_out --type 2
else
	iptables -t nat -A POSTROUTING -o $wan_if -j MASQUERADE
fi

#add by tianshixin for port trigger start
if [ -f $trigger_del_patch ]
then
sh $trigger_del_patch
fi

if [ "1" = "$port_trigger_switch" ]
then
iptables -t nat -I PREROUTING 1 -i $wan_if -j TRIGGER --trigger-type dnat
echo iptables -t nat -D PREROUTING -i $wan_if -j TRIGGER --trigger-type dnat > $trigger_del_patch
fi

#add by tianshixin for port trigger end

#busybox ifconfig $wan_if mtu $mtu
#iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss
sh $mss_del_path

if echo $wan_if | grep -q rmnet
then
    echo "$0: set mtu, wan=[$wan_if], mtu=[$mtu], tcp_mss=[$tcp_mss]"
    busybox ifconfig $wan_if mtu $mtu
    #iptables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu
    #iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu
    if [ "$tcp_mss" != 1460 ]
    then
       iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss
       echo iptables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss > $mss_del_path
    fi
else
    echo "$0: not rmnet*, dont set mtu"
fi
