#!/bin/sh
# if /var/log/syslog > 1G, backup and clean
# take care of awk

file_size_check()
{
	echo "$0: file-[$file] size-[$size] unit-[$unit]"
	if [ "$file" == "" -o "$size" == "" -o "$unit" == "" ]
	then
	  echo "$0:null in return"
	  return
	else
	  echo "$0:go"
	fi

	if ! [ -f $file ] 
	then 
	  echo "$0: [$file] not exist!" 
	  return
	fi 

	if ! [ "$unit" == "k" -o "$unit" == "m" ] 
	then 
	  echo "$0: [$unit] unit unknown!" 
	  return
	fi

	if [ "$unit" == "k" ] 
	then 
	  sizeline=$(($size*1024))
	fi

	if [ "$unit" == "m" ] 
	then 
	  sizeline=$(($size*1024*1024))
	fi

	echo "$0: size dead line [$sizeline],[$size$unit]" 

	echo "$0: [$file] size-[`ls -l $file|awk '{print $5}'`]"

	if [ `ls -l $file|awk '{print $5}'` -gt $(($sizeline)) ] 
	then 
	  echo "$0: [$file] > [$size$unit] !"
	  rm -fr $file
	else
	  echo "$0: [$file] < [$size$unit]"
	fi
}

syslog_size_check()
{
    syslog_path=`cfg get syslog_path`
    syslog_file=$syslog_path/syslog
    syslog_file2=$syslog_path/syslog.0

    file=$syslog_file
    size=4
    unit=m
    file_size_check

	file=$syslog_file2
	file_size_check
}

syslog_size_check

# do other file check

